/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.remote;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.healthmarketscience.rmiio.RemoteInputStreamServer;
import com.healthmarketscience.rmiio.RemoteOutputStreamServer;
import com.healthmarketscience.rmiio.SimpleRemoteInputStream;
import com.healthmarketscience.rmiio.SimpleRemoteOutputStream;
import com.mimvista.ExternallyVisible;
import com.mimvista.archive.Archiver;
import com.mimvista.archive.remote.MIMRemoteInputStreamImpl;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.archive.remote.RemoteInputStreamProxy;
import com.mimvista.archive.remote.RemoteObjectInfo;
import com.mimvista.archive.remote.RemoteOutputStreamProxy;
import com.mimvista.archive.remote.RemotePatientListInfo;
import com.mimvista.archive.remote.RemoteQueryServer;
import com.mimvista.archive.remote.SeriesContainerImpl;
import com.mimvista.archive.remote.a.b;
import com.mimvista.archive.remote.g;
import com.mimvista.archive.remote.sockets.e;
import com.mimvista.archive.remote.sockets.f;
import com.mimvista.archive.remote.sockets.i;
import com.mimvista.archive.remote.sockets.k;
import com.mimvista.archive.remote.sockets.m;
import com.mimvista.cloud.shared.common.mim.UploadOptions;
import com.mimvista.cloud.shared.common.version.VersionNumberComparator;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.LocalMetabaseSeries;
import com.mimvista.dicom.MIMDcmUrl;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.factories.DcmSeriesFactory;
import com.mimvista.dicom.factories.SuperDcmSeriesFactory;
import com.mimvista.dicom.network.DcmSnd;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.reffinder.StudyFinder;
import com.mimvista.file.PathUtils;
import com.mimvista.metabase.ArtAssistConfigQuery;
import com.mimvista.metabase.DbWriteResult;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.n;
import com.mimvista.mimcloud.commands.a;
import com.mimvista.mimcloud.connection.CloudResponseException;
import com.mimvista.mimcloud.connection.CloudType;
import com.mimvista.mimcloud.connection.d;
import com.mimvista.mimcloud.uploader.SeriesUploadItem;
import com.mimvista.mimcloud.uploader.h;
import com.mimvista.mimcloud.uploader.j;
import com.mimvista.numerics.MathUtils;
import com.mimvista.preferencesNew.DicomLocationsPrefs;
import com.mimvista.preferencesNew.MetabasePrefs;
import com.mimvista.preferencesNew.MimpacsPrefs;
import com.mimvista.properties.af;
import com.mimvista.report.cbct.FractionAuthorizer;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ClientArtConfigFilesRetrieveRequestHandler;
import com.mimvista.report.cbct.config.ClientArtConfigFilesStoreRequestHandler;
import com.mimvista.report.cbct.config.FractionUpdate;
import com.mimvista.rmi.a;
import com.mimvista.update.VersionNumber;
import com.mimvista.user.Cookie;
import com.mimvista.user.CookieBox;
import com.mimvista.user.NullCookieBox;
import com.mimvista.util.MIMDateFormat;
import com.mimvista.util.aq;
import com.mimvista.util.ay;
import com.mimvista.util.ce;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.v;
import com.mimvista.util.r;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.dcm4che2.data.DicomObject;
import sun.rmi.server.UnicastServerRef;

@ExternallyVisible
public abstract class RemoteQueryServerImpl
implements RemoteQueryServer {
    private static final long i = 1L;
    protected RemotePatientListInfo[] c;
    private String j;
    protected UnicastServerRef d = null;
    protected int e = 0;
    private v k;
    private j l;
    protected static final int f = 10;
    protected static final int g = 10000;
    protected Semaphore h = new Semaphore(10, true);
    private static boolean m = false;
    private Timer n;

    public static void initSSL() {
        if (!m) {
            ay.b((Object)"Initializing Server SSL", RemoteQueryServerImpl.class);
            aq aq2 = new aq();
            if (aq2.a("certification", "Server_Keystore")) {
                String string = aq2.a();
                System.setProperty("javax.net.ssl.keyStore", string);
                System.setProperty("javax.net.ssl.keyStorePassword", "carbon14");
                m = true;
                ay.b((Object)("Successfully wrote server keyStore to " + string), RemoteQueryServerImpl.class);
            } else {
                ay.d((Object)"Unable to retrieve and save keyStore. ", RemoteQueryServerImpl.class);
            }
        }
    }

    public static String getRemoteLogPrefix(CookieBox cookieBox) {
        String string = "Host: ";
        try {
            string = string + RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException serverNotActiveException) {
            string = "(IP not found, check exception)";
            ay.d((Object)serverNotActiveException, "auditlog");
        }
        String string2 = "User: ";
        string2 = cookieBox != null && cookieBox.d() != null && !cn.g(cookieBox.d().f()) ? string2 + cookieBox.d().f() : string2 + "[none]";
        return string2 + ", " + string + "| ";
    }

    protected static String a(CookieBox cookieBox) {
        String string = "LOCAL";
        try {
            string = RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException serverNotActiveException) {
            string = "[ERROR: IP ADDRESS NOT FOUND]";
            ay.d((Object)serverNotActiveException, "auditlog");
        }
        String string2 = "";
        if (cookieBox != null && cookieBox.d() != null && !cn.g(cookieBox.d().f())) {
            string2 = cookieBox.d().f() + " at ";
        }
        return string2 + string;
    }

    public RemoteObjectInfo getRemoteObjectInfo() {
        return new RemoteObjectInfo().a(a.a(this.d)).a(this.e).b(SslRMIClientSocketFactory.class.getName()).a(RemoteQueryServerImpl.class.getName());
    }

    protected RemoteQueryServerImpl(int n2) throws RemoteException {
        this.e = n2;
        ay.b((Object)"Exporting Remote Query server ...", this);
        this.d = ce.a(17192, n2, this);
        ay.b((Object)("Server is exported on port " + n2 + " with ID " + 17192), this);
        this.a();
    }

    @Override
    public void hello() {
    }

    @Override
    public String getVersion() {
        return VersionNumber.getSimpleVersionString();
    }

    @Override
    public String getHostAddress() {
        try {
            return RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException serverNotActiveException) {
            ay.d((Object)"Could not get client host address: ", (Throwable)serverNotActiveException, this);
            return "LOCAL";
        }
    }

    @Override
    public String getServerName() {
        return this.j;
    }

    @Override
    public boolean isEnforcingLocalStorageRestrictions() {
        return MimpacsPrefs.noLocalStorage.getValue();
    }

    @Override
    public RemotePatientListInfo[] getPatientLists(CookieBox cookieBox) throws RemoteException {
        return this.c;
    }

    @Override
    public String getCloudClientTypeName() throws RemoteException {
        return ((CloudType)com.mimvista.mimcloud.connection.d.m().x).getTypeName();
    }

    @Override
    public List<QueryResult> searchArchive(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, CookieBox cookieBox) throws AccessException {
        cookieBox = this.b(cookieBox);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " queried the following patient list: " + string8), "auditlog");
        RemotePatientListInfo remotePatientListInfo = this.b(Permission.a, string8, cookieBox);
        if (remotePatientListInfo == null) {
            return Collections.emptyList();
        }
        ay.e((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "queried from patient list " + string8 + "\nKeyword=" + string + "\nPatient Name=" + string2 + "\nPatient ID=" + string3 + "\nModality=" + string4 + "\nStart Date=" + string5 + "\nEnd Date=" + string6 + "\nDescription=" + string7), this);
        long l2 = System.currentTimeMillis();
        List<QueryResult> list = this.a(string, string2, string3, string4, string5, string6, string7, remotePatientListInfo, cookieBox);
        long l3 = System.currentTimeMillis() - l2;
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Finished query from patient list " + string8 + " in " + DurationFormatUtils.formatDuration((long)l3, (String)"H'h':m'm':s.S's'")), "auditlog");
        return list;
    }

    @Override
    public List<QueryResult> searchArchiveLastAccessedBetween(Date date, Date date2, String string, CookieBox cookieBox) throws AccessException {
        cookieBox = this.b(cookieBox);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " has requested a query based on series' last access time in patient list " + string), "auditlog");
        RemotePatientListInfo remotePatientListInfo = this.b(Permission.a, string, cookieBox);
        if (remotePatientListInfo == null) {
            return Collections.emptyList();
        }
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Query series based on last access time from " + date + " to " + date2 + " from " + string), "auditlog");
        long l2 = System.currentTimeMillis();
        List<QueryResult> list = this.a(date, date2, remotePatientListInfo, cookieBox);
        long l3 = System.currentTimeMillis() - l2;
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Finished query from patient list " + string + " in " + DurationFormatUtils.formatDuration((long)l3, (String)"H'h':m'm':s.S's'")), "auditlog");
        return list;
    }

    @Override
    public List<QueryResult> searchNewlyReceived(String string, int n2, CookieBox cookieBox) throws AccessException {
        cookieBox = this.b(cookieBox);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " has requested query of at most " + n2 + " newly received series in patient list " + string), "auditlog");
        RemotePatientListInfo remotePatientListInfo = this.b(Permission.a, string, cookieBox);
        if (remotePatientListInfo == null) {
            return new ArrayList<QueryResult>();
        }
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Starting query of newly received in patient list " + string), "auditlog");
        long l2 = System.currentTimeMillis();
        List<QueryResult> list = this.a(remotePatientListInfo, n2, cookieBox);
        long l3 = System.currentTimeMillis() - l2;
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Finished query of newly received in patient list " + string + " in " + DurationFormatUtils.formatDuration((long)l3, (String)"H'h':m'm':s.S's'")), "auditlog");
        return list;
    }

    @Override
    public List<QueryResult> searchNewlyReceived(String string, Date date, CookieBox cookieBox) throws AccessException {
        cookieBox = this.b(cookieBox);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " has requested query of newly received series in patient list " + string + " newer than " + date), "auditlog");
        RemotePatientListInfo remotePatientListInfo = this.b(Permission.a, string, cookieBox);
        if (remotePatientListInfo == null) {
            ay.c((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " has requested query of newly received series in invalid patient list " + string), "auditlog");
            return new ArrayList<QueryResult>();
        }
        long l2 = System.currentTimeMillis();
        List<QueryResult> list = this.a(remotePatientListInfo, date, cookieBox);
        long l3 = System.currentTimeMillis() - l2;
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Finished query of newly received in patient list " + string + " in " + DurationFormatUtils.formatDuration((long)l3, (String)"H'h':m'm':s.S's'")), "auditlog");
        return list;
    }

    @Override
    public List<QueryResult> findSeries(SeriesParameters seriesParameters, String string, CookieBox cookieBox) throws AccessException {
        cookieBox = this.b(cookieBox);
        List<QueryResult> list = new ArrayList<QueryResult>();
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " is attempting to find series in Patient List " + string + " ..."), "auditlog");
        RemotePatientListInfo remotePatientListInfo = this.b(Permission.a, string, cookieBox);
        if (remotePatientListInfo == null) {
            return list;
        }
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Searching archive " + remotePatientListInfo.n() + " for " + seriesParameters.uidList.get(0)), "auditlog");
        StudyFinder studyFinder = new StudyFinder();
        studyFinder.setNullNotifier();
        studyFinder.applyParams(seriesParameters);
        studyFinder.setArchivePath(remotePatientListInfo.n());
        list = studyFinder.search();
        for (QueryResult queryResult : list) {
            queryResult.path = new File(queryResult.path).getParent();
        }
        return list;
    }

    @Override
    public TreeMap<Integer, String> dicomDump(String string, String string2, CookieBox cookieBox) throws AccessException {
        cookieBox = this.b(cookieBox);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " is requesting DICOM information of series " + string2 + " in patient list " + string), "auditlog");
        if (this.b(Permission.a, string, cookieBox) == null) {
            ay.d((Object)("Access to this patient list is not allowed for user " + RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + ": " + string), "auditlog");
            throw new AccessException(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Access to this patient list is not allowed.");
        }
        DcmSeries dcmSeries = SuperDcmSeriesFactory.getDcmSeriesFromArchiveDirectoryUseMetabase(string2);
        if (dcmSeries == null) {
            return DcmSeriesFactory.dicomDump(string2);
        }
        String string3 = Archiver.getDirContainingSeriesFiles(dcmSeries);
        TreeMap<Integer, String> treeMap = DcmSeriesFactory.dicomDump(string3);
        Archiver.cleanTempDirForEmbeddedSeries(string3);
        return treeMap;
    }

    @Override
    public Map<Integer, String[]> getValuesForDicomTags(String string, int[] nArray) throws RemoteException {
        try {
            String string2 = RemoteServer.getClientHost();
            ay.b((Object)(string2 + " is attempting to insecurely acquire DICOM tag values of series " + string + " ..."), "auditlog");
            if (MimpacsPrefs.disallowUnsecureMethods.getValue().booleanValue()) {
                ay.c((Object)(string2 + "| Insecure acquiring DICOM tag values is not allowed"), this);
                return new HashMap<Integer, String[]>();
            }
            return this.a(string, nArray, (CookieBox)new NullCookieBox());
        }
        catch (ServerNotActiveException serverNotActiveException) {
            ay.d((Object)"Unable to obtain host name of site attempting to insecurely acquire DICOM tag values: ", (Throwable)serverNotActiveException, "auditlog");
            return new HashMap<Integer, String[]>();
        }
    }

    @Override
    public Map<Integer, String[]> getValuesForDicomTags(String string, String string2, int[] nArray, CookieBox cookieBox) throws RemoteException {
        cookieBox = this.b(cookieBox);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " is attempting to acquire DICOM tag values of series " + string2 + " in patient list " + string + " ..."), "auditlog");
        if (this.b(Permission.a, string, cookieBox) == null) {
            return new HashMap<Integer, String[]>();
        }
        return this.a(string2, nArray, cookieBox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, String[]> a(String string, int[] nArray, CookieBox cookieBox) throws RemoteException {
        cookieBox = this.b(cookieBox);
        MetabaseQuery metabaseQuery = null;
        metabaseQuery = string.matches("\\d+") ? com.mimvista.metabase.n.a(Long.valueOf(string)) : com.mimvista.metabase.n.a().c("mimdata.folders", (Object)string);
        List<? extends Series> list = metabaseQuery.a(com.mimvista.metabase.j.a());
        if (list.size() < 1) {
            ay.d((Object)("No series with identifier: " + string), this);
            throw new RemoteException("The series identifier is not valid");
        }
        DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesFromMetabaseSeries(list.get(0));
        dcmSeries.setLocalDir(dcmSeries.getArchiveDir());
        String string2 = Archiver.getDirContainingSeriesFiles(dcmSeries);
        try {
            ay.b((Object)("Reading DICOM tag values from " + string2), this);
            DicomObject dicomObject = DicomReader.getFirstDicomObjectFromSeriesFolder(string2, MathUtils.h(nArray) + 1);
            if (dicomObject == null) {
                ay.d((Object)("Can't find a valid DICOM file for series " + string + " - unable to read DICOM tag values"), this);
                throw new RemoteException("Failed to read dicom tag values");
            }
            HashMap hashMap = Maps.newHashMap();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                String[] stringArray;
                block8: {
                    stringArray = null;
                    try {
                        stringArray = dicomObject.getStrings(nArray[i2], (String[])null);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        String string3 = dicomObject.getString(nArray[i2], (String)null);
                        if (string3 == null) break block8;
                        stringArray = new String[]{string3};
                    }
                }
                if (stringArray == null) continue;
                hashMap.put(nArray[i2], stringArray);
            }
            HashMap hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            Archiver.cleanTempDirForEmbeddedSeries(string2);
        }
    }

    @Override
    public RemoteQueryServer.MIMRawSocketStreamInfo retrieveUsingRawSocket(String string, String string2, CookieBox cookieBox) throws Exception {
        try (g.a a2 = com.mimvista.archive.remote.g.a("RQSI.retrieveUsingRawSocket");){
            cookieBox = this.b(cookieBox);
            String string3 = RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox);
            LocalMetabaseSeries localMetabaseSeries = SuperDcmSeriesFactory.getSeriesFromArchiveDirectoryUsingLocalMetabase(string2);
            if (localMetabaseSeries == null) {
                ay.d((Object)(string3 + "Series does not exist: " + string2), this);
                throw new IOException(string3 + "Series does not exist");
            }
            this.a(localMetabaseSeries, cookieBox);
            this.a(string2);
            ay.b((Object)(string3 + "Client requested a socket to retrieve: " + string2), "auditlog");
            f f2 = new f(localMetabaseSeries.dcmSeries, cookieBox);
            f2.b(string3 + " (" + string2 + ")");
            com.mimvista.archive.remote.sockets.e.a.a(new i(f2));
            RemoteQueryServer.MIMRawSocketStreamInfo mIMRawSocketStreamInfo = new RemoteQueryServer.MIMRawSocketStreamInfo(f2.f(), f2.a());
            return mIMRawSocketStreamInfo;
        }
    }

    @Override
    @Deprecated
    public RemoteObjectInfo retrieveSeries(String string, String string2, boolean bl2, CookieBox cookieBox) throws Exception {
        cookieBox = this.b(cookieBox);
        LocalMetabaseSeries localMetabaseSeries = SuperDcmSeriesFactory.getSeriesFromArchiveDirectoryUsingLocalMetabase(string2);
        if (localMetabaseSeries == null) {
            ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Series does not exist: " + string2), this);
            throw new FileNotFoundException(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Series does not exist");
        }
        this.a(localMetabaseSeries, cookieBox);
        this.a(string2);
        boolean bl3 = true;
        if (bl2 && MIMpacsConfig.i) {
            bl3 = false;
        }
        if (MimpacsPrefs.forceCompressionOnServer.getValue().booleanValue()) {
            bl3 = MimpacsPrefs.forcedCompression.getValue();
        }
        bl3 = false;
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Use " + (bl3 ? "compressed" : "uncompressed") + " mode to retrieve series"), "auditlog");
        MIMRemoteInputStreamImpl mIMRemoteInputStreamImpl = new MIMRemoteInputStreamImpl(localMetabaseSeries.dcmSeries, bl3);
        return mIMRemoteInputStreamImpl.a();
    }

    @Override
    public RemoteQueryServer.MIMRawSocketStreamInfo sendUsingRawSocket(String string, CookieBox cookieBox) throws RemoteException, ServerNotActiveException, Exception {
        RemotePatientListInfo remotePatientListInfo = this.b(Permission.b, string, cookieBox = this.b(cookieBox));
        if (remotePatientListInfo == null) {
            return null;
        }
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Client requested a socket to send a series"), "auditlog");
        m m2 = new m(this.a(remotePatientListInfo, cookieBox), cookieBox);
        com.mimvista.archive.remote.sockets.e.a.a(new k(m2));
        return new RemoteQueryServer.MIMRawSocketStreamInfo(m2.f());
    }

    @Override
    @Deprecated
    public RemoteObjectInfo storeSeries(String string, CookieBox cookieBox) throws RemoteException {
        cookieBox = this.b(cookieBox);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " is attempting to push to patient list " + string), "auditlog");
        RemotePatientListInfo remotePatientListInfo = this.b(Permission.b, string, cookieBox);
        if (remotePatientListInfo == null) {
            return null;
        }
        SeriesContainerImpl seriesContainerImpl = new SeriesContainerImpl(this.a(remotePatientListInfo, cookieBox));
        return seriesContainerImpl.getRemoteObjectInfo();
    }

    @Override
    public long getSeriesSizeInBytes(String string) {
        DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesFromArchiveDirectory(string);
        try {
            return dcmSeries.getSizeInBytes();
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public void deleteSeries(String string, String string2, CookieBox cookieBox) throws RemoteException {
        cookieBox = this.b(cookieBox);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "is attempting to delete series " + string2 + " from patient list " + string), "auditlog");
        if (this.b(Permission.b, string, cookieBox) == null) {
            return;
        }
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "is deleting " + string2 + " from patient list " + string), "auditlog");
        this.a(string, string2, cookieBox);
    }

    @Override
    public List<QueryResult> searchArchiveLastAccessedNotBetween(Date date, Date date2, String string, CookieBox cookieBox) throws AccessException {
        cookieBox = this.b(cookieBox);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " has requested a query based on series' last access time in patient list " + string), "auditlog");
        RemotePatientListInfo remotePatientListInfo = this.b(Permission.a, string, cookieBox);
        if (remotePatientListInfo == null) {
            return Collections.emptyList();
        }
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Query series based on last access time from " + date + " to " + date2 + " from " + string), "auditlog");
        long l2 = System.currentTimeMillis();
        List<QueryResult> list = this.b(date, date2, remotePatientListInfo, cookieBox);
        long l3 = System.currentTimeMillis() - l2;
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Finished query from patient list " + string + " in " + DurationFormatUtils.formatDuration((long)l3, (String)"H'h':m'm':s.S's'")), "auditlog");
        return list;
    }

    @Override
    public boolean exportToAnotherRemotePatientList(String string, String string2, String string3, String string4, CookieBox cookieBox) throws RemoteException {
        return this.exportToAnotherRemotePatientList(string, string2, string3, string4, cookieBox, cookieBox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exportToAnotherRemotePatientList(String string, String string2, String string3, String string4, CookieBox cookieBox, CookieBox cookieBox2) throws RemoteException {
        CookieBox cookieBox3 = this.b(cookieBox2);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox3) + " is attempting to copy series " + string2 + " in source patient list " + string + " to " + string4 + " on " + string3), "auditlog");
        RemotePatientListInfo remotePatientListInfo = this.b(Permission.a, string, cookieBox3);
        if (remotePatientListInfo == null) {
            return false;
        }
        String string5 = string2;
        DcmSeries dcmSeries = SuperDcmSeriesFactory.getDcmSeriesFromArchiveDirectoryUseMetabase(string2);
        if (dcmSeries != null) {
            string5 = Archiver.getDirContainingSeriesFiles(dcmSeries);
        }
        if (!new File(string5).isDirectory()) {
            ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox3) + "Series does not exist: " + string5), this);
            return false;
        }
        this.a(string5);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox3) + "Push series to Patient List " + string4 + " on " + string3 + ": " + string5), "auditlog");
        try {
            b b2 = new b();
            if (!b2.a(string5, string4, string3, MIMpacsConfig.f, cookieBox, string2)) {
                ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox3) + "Can not push series: " + string5), "auditlog");
                boolean bl2 = false;
                return bl2;
            }
            ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox3) + " pushed series to destination patient list " + string4 + ": " + string5), "auditlog");
            boolean bl3 = true;
            return bl3;
        }
        finally {
            if (dcmSeries != null && dcmSeries.isEmbedded()) {
                Archiver.cleanTempDirForEmbeddedSeries(string5);
            }
        }
    }

    @Override
    public boolean exportToRemotePatientList(String string, String string2, String string3, String string4, CookieBox cookieBox) throws RemoteException {
        return this.exportToRemotePatientList(string, string2, string3, string4, cookieBox, cookieBox);
    }

    @Override
    public boolean exportToRemotePatientList(String string, String string2, String string3, String string4, CookieBox cookieBox, CookieBox cookieBox2) throws RemoteException {
        if ("localhost".equals(string3) || "127.0.0.1".equals(string3)) {
            try {
                string3 = RemoteServer.getClientHost();
            }
            catch (ServerNotActiveException serverNotActiveException) {
                ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox2) + "Couldn't determine client's host address"), this);
                return false;
            }
        }
        return this.exportToAnotherRemotePatientList(string, string2, string3, string4, cookieBox, cookieBox2);
    }

    @Override
    public boolean exportToDcmServer(String string, String string2, String string3) throws RemoteException {
        try {
            String string4 = RemoteServer.getClientHost();
            ay.b((Object)(string4 + " is attempting to insecurely DICOM send series " + string2 + " in source patient list " + string + " ..."), "auditlog");
            if (MimpacsPrefs.disallowUnsecureMethods.getValue().booleanValue()) {
                ay.c((Object)("Insecure DICOM sending is not allowed.  Rejecting connection from " + string4), "auditlog");
                return false;
            }
            return this.a(string, string2, string3, null);
        }
        catch (ServerNotActiveException serverNotActiveException) {
            ay.d((Object)"Unable to obtain host name of site attempting to insecurely DICOM send series: ", (Throwable)serverNotActiveException, "auditlog");
            return false;
        }
    }

    @Override
    public boolean exportToDcmServer(String string, String string2, String string3, CookieBox cookieBox) throws RemoteException {
        cookieBox = this.b(cookieBox);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " is attempting to DICOM send series " + string2 + " in source patient list " + string + " ..."), "auditlog");
        if (this.b(Permission.a, string, cookieBox) == null) {
            return false;
        }
        return this.a(string, string2, string3, cookieBox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(String string, String string2, String string3, CookieBox cookieBox) throws RemoteException {
        RemotePatientListInfo remotePatientListInfo = this.a(string, cookieBox);
        if (remotePatientListInfo == null) {
            ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Cannot find series in Patient List " + string), this);
            return false;
        }
        String string4 = string2;
        DcmSeries dcmSeries = SuperDcmSeriesFactory.getDcmSeriesFromArchiveDirectoryUseMetabase(string2);
        if (dcmSeries != null) {
            string4 = Archiver.getDirContainingSeriesFiles(dcmSeries);
        }
        if (!new File(string4).isDirectory()) {
            ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Series does not exist: " + string4), this);
            return false;
        }
        this.a(string4);
        try {
            MIMDcmUrl mIMDcmUrl = new MIMDcmUrl(string3);
            mIMDcmUrl = new MIMDcmUrl(mIMDcmUrl.getCalledAET(), DicomLocationsPrefs.a.getServerHost().getAeTitle(), mIMDcmUrl.getHost(), mIMDcmUrl.getPort());
            ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Sending series " + string4 + " to DICOM Server on " + mIMDcmUrl.toString() + "..."), "auditlog");
            DcmSnd dcmSnd = new DcmSnd(mIMDcmUrl);
            dcmSnd.send(new String[]{string4});
            if (dcmSnd.isCongested()) {
                ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Congested when sending files to " + mIMDcmUrl.getCalledAET()), "auditlog");
                boolean bl2 = false;
                return bl2;
            }
            if (!cn.g(dcmSnd.getErrorMsg()) && !"COULD NOT PARSE DICOM FILES".equalsIgnoreCase(dcmSnd.getErrorMsg())) {
                ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Error occured when sending files to " + string3 + ": " + dcmSnd.getErrorMsg()), "auditlog");
                boolean bl3 = false;
                return bl3;
            }
            ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Finished sending files to " + mIMDcmUrl.getCalledAET() + "\nTotal size: " + dcmSnd.getSentBytes() + " Bytes\nTransfer time: " + dcmSnd.getTransferTime() + "milliseconds"), "auditlog");
            boolean bl4 = true;
            return bl4;
        }
        finally {
            if (dcmSeries != null && dcmSeries.isEmbedded()) {
                Archiver.cleanTempDirForEmbeddedSeries(string4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exportToCloud(String string, byte[] byArray, String[] stringArray, UploadOptions uploadOptions) throws RemoteException, CloudResponseException, CloudResponseException.NoCredentialsProvidedException {
        com.mimvista.mimcloud.connection.a a2;
        a.v.a(true);
        this.k = new v();
        com.mimvista.mimcloud.connection.k k2 = new com.mimvista.mimcloud.connection.k(string, byArray);
        com.mimvista.mimcloud.connection.i.a(k2, com.mimvista.mimcloud.connection.d.m());
        try {
            a2 = com.mimvista.mimcloud.connection.i.a(k2.a());
            a2.c();
        }
        catch (CloudResponseException.BadCredentialsException badCredentialsException) {
            ay.d((Object)badCredentialsException, this);
            this.k.k();
            throw badCredentialsException;
        }
        com.mimvista.mimcloud.uploader.i i2 = new com.mimvista.mimcloud.uploader.i();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            DcmSeries object = SuperDcmSeriesFactory.getDcmSeriesFromArchiveDirectoryUseMetabase(string2);
            String string3 = null;
            if (object != null) {
                string3 = Archiver.getDirContainingSeriesFiles(object);
                if (object.isEmbedded()) {
                    arrayList.add(string3);
                }
            } else {
                string3 = string2;
            }
            this.a(string3);
            i2.a(new File(string3), (Progress)this.k);
        }
        try {
            int n2;
            try {
                this.l = new j(a2, uploadOptions);
            }
            catch (CloudResponseException cloudResponseException) {
                ay.d((Object)cloudResponseException, this);
                throw cloudResponseException;
            }
            com.mimvista.mimcloud.h h2 = new com.mimvista.mimcloud.h(this.l, i2);
            h2.setNotifier(this.k);
            h2.doTransfer();
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    int n3 = 0;
                    for (String string4 : arrayList) {
                        Archiver.cleanTempDirForEmbeddedSeries(string4);
                    }
                    return n3 != 0;
                }
                if (this.k.n() != Progress.Status.c) continue;
                n2 = 1;
                return n2 != 0;
            } while (this.k.n() != Progress.Status.e && this.k.n() != Progress.Status.d);
            n2 = 0;
            return n2 != 0;
        }
        finally {
            for (String string5 : arrayList) {
                Archiver.cleanTempDirForEmbeddedSeries(string5);
            }
        }
    }

    @Override
    public int getCloudUploadProgress() throws RemoteException {
        if (this.k == null) {
            return 0;
        }
        return this.k.ah_();
    }

    @Override
    public String getCurrentSeriesName() throws RemoteException {
        SeriesUploadItem seriesUploadItem = this.l.g();
        return seriesUploadItem.f().d() + " - " + ((h)seriesUploadItem.c()).g().a();
    }

    @Override
    public RemoteObjectInfo getFileInputStream(String string, String string2, boolean bl2, CookieBox cookieBox) throws AccessException {
        cookieBox = this.b(cookieBox);
        ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " is attempting to obtain input stream for DICOM file " + string2 + " in Patient List " + string + " ..."), "auditlog");
        if (this.b(Permission.a, string, cookieBox) == null) {
            return null;
        }
        File file = new File(string2);
        bl2 = bl2 && MIMpacsConfig.i;
        SimpleRemoteInputStream simpleRemoteInputStream = null;
        try {
            InputStream inputStream = new FileInputStream(file);
            if (!bl2) {
                inputStream = new r(inputStream);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 131072);
            simpleRemoteInputStream = new SimpleRemoteInputStream((InputStream)bufferedInputStream, RemoteInputStreamServer.DUMMY_MONITOR, 131072);
            RemoteInputStreamProxy remoteInputStreamProxy = new RemoteInputStreamProxy((RemoteInputStreamServer)simpleRemoteInputStream);
            RemoteObjectInfo remoteObjectInfo = remoteInputStreamProxy.a();
            remoteObjectInfo.a(!bl2);
            return remoteObjectInfo;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "DICOM file " + string2 + " is not found"), (Throwable)fileNotFoundException, "auditlog");
        }
        catch (RemoteException remoteException) {
            ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Couldn't export remote stream object"), (Throwable)remoteException, "auditlog");
            if (simpleRemoteInputStream != null) {
                simpleRemoteInputStream.close();
            }
        }
        catch (IOException iOException) {
            ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Couldn't export data for " + string2), (Throwable)iOException, "auditlog");
        }
        return null;
    }

    @Override
    public RemoteObjectInfo getFileOutputStream(String string, String string2, CookieBox cookieBox) throws RemoteException {
        block4: {
            cookieBox = this.b(cookieBox);
            ay.b((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + " is attempting to obtain output stream for DICOM file " + string2 + " in Patient List " + string + " ..."), "auditlog");
            if (this.b(Permission.b, string, cookieBox) == null) {
                return null;
            }
            File file = new File(string2);
            SimpleRemoteOutputStream simpleRemoteOutputStream = null;
            try {
                simpleRemoteOutputStream = new SimpleRemoteOutputStream((OutputStream)new FileOutputStream(file));
                RemoteOutputStreamProxy remoteOutputStreamProxy = new RemoteOutputStreamProxy((RemoteOutputStreamServer)simpleRemoteOutputStream);
                return remoteOutputStreamProxy.a();
            }
            catch (FileNotFoundException fileNotFoundException) {
                ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "DICOM file " + string2 + " is not found"), (Throwable)fileNotFoundException, "auditlog");
            }
            catch (RemoteException remoteException) {
                ay.d((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Couldn't export remote stream object"), (Throwable)remoteException, "auditlog");
                if (simpleRemoteOutputStream == null) break block4;
                simpleRemoteOutputStream.close();
            }
        }
        return null;
    }

    @Override
    public void reloadConfiguration() {
        this.a();
    }

    public List<RemotePatientListInfo> getAllPermittedPatientLists(Permission permission, CookieBox cookieBox) {
        return Lists.newArrayList((Object[])this.c);
    }

    public void stop() {
        ce.a(this, 3, 50L);
    }

    public int getPort() {
        return this.e;
    }

    protected void a(String string) {
        com.mimvista.metabase.n.a().c("mimdata.folders", (Object)PathUtils.getCanonicalOrAbsolutePath(string)).e(com.mimvista.metabase.j.a());
    }

    protected abstract RemotePatientListInfo[] a(af var1);

    protected abstract List<QueryResult> a(RemotePatientListInfo var1, int var2, CookieBox var3);

    protected abstract List<QueryResult> a(RemotePatientListInfo var1, Date var2, CookieBox var3);

    protected abstract List<QueryResult> a(String var1, String var2, String var3, String var4, String var5, String var6, String var7, RemotePatientListInfo var8, CookieBox var9);

    protected abstract List<QueryResult> a(Date var1, Date var2, RemotePatientListInfo var3, CookieBox var4);

    protected abstract List<QueryResult> b(Date var1, Date var2, RemotePatientListInfo var3, CookieBox var4);

    protected abstract RemotePatientListInfo a(RemotePatientListInfo var1, CookieBox var2) throws RemoteException;

    protected abstract void a(String var1, String var2, CookieBox var3) throws RemoteException;

    protected abstract void a(LocalMetabaseSeries var1, CookieBox var2) throws AccessException;

    protected abstract RemotePatientListInfo b(Permission var1, String var2, CookieBox var3) throws AccessException;

    protected RemotePatientListInfo a(String string, CookieBox cookieBox) {
        for (RemotePatientListInfo remotePatientListInfo : this.c) {
            if (!remotePatientListInfo.k().equalsIgnoreCase(string)) continue;
            return remotePatientListInfo;
        }
        ay.c((Object)(RemoteQueryServerImpl.getRemoteLogPrefix(cookieBox) + "Could not find patient list: " + string), "auditlog");
        return null;
    }

    private void a() {
        ay.b((Object)"Loading configuration ...", this);
        af.clearCache();
        com.mimvista.preferencesNew.h.a().l();
        this.j = MimpacsPrefs.name.getValue();
        ay.b((Object)("Server's name is " + this.j), this);
        ay.b((Object)(MimpacsPrefs.disallowUnsecureMethods.getValue() != false ? "Not supporting old unsecure clients" : "Supporting old unsecure clients"), this);
        for (RemotePatientListInfo remotePatientListInfo : this.c = this.a((af)null)) {
            File file = new File(remotePatientListInfo.n());
            if (!file.exists()) {
                if (file.mkdirs()) {
                    ay.b((Object)("Created the archive directory of remote patient list " + remotePatientListInfo.k() + " : " + file.getAbsolutePath()), "auditlog");
                    continue;
                }
                ay.d((Object)("Failed to create the archive directory of remote patient list " + remotePatientListInfo.k() + " : " + file.getAbsolutePath()), "auditlog");
                continue;
            }
            if (file.isDirectory()) continue;
            ay.d((Object)("The specified archive path of remote patient list " + remotePatientListInfo.k() + " is not a valid directory : " + file.getAbsolutePath()), "auditlog");
        }
        this.c();
        if (MetabasePrefs.metabaseEnableBackups.getValue().booleanValue()) {
            this.b();
        }
    }

    protected CookieBox b(CookieBox cookieBox) throws AccessException {
        this.d(cookieBox);
        return this.c(cookieBox);
    }

    private void d(CookieBox cookieBox) throws AccessException {
        if (!MimpacsPrefs.noLocalStorage.getValue().booleanValue()) {
            return;
        }
        if (!(cookieBox != null && cookieBox.h() || MimpacsPrefs.allowOldClients.getValue().booleanValue())) {
            throw new AccessException("Clients must be able to enforce the 'no local storage' restriction to access this server");
        }
    }

    protected CookieBox c(CookieBox cookieBox) throws AccessException {
        Cookie cookie = cookieBox.d();
        String string = cookie.a();
        if (!com.mimvista.user.k.a(string, cookie.f())) {
            VersionNumber versionNumber;
            boolean bl2;
            cookieBox = cookieBox.f() != null && (bl2 = VersionNumberComparator.c.c(versionNumber = cookieBox.f(), new VersionNumber(6, 5, 0, ""))) ? new NullCookieBox.ReplacementNullCookieBox(cookieBox, "Client's cookiebox from server is version <6.5, but this server requiresa 6.5+ cookiebox to enforce authentication groups (to fix, upgrade client's login server to 6.5+)") : new NullCookieBox.ReplacementNullCookieBox(cookieBox, "Client's credentials are not valid against this server (Wrong authentication group): " + string);
        }
        return cookieBox;
    }

    private void b() {
        int n2 = MetabasePrefs.backupPeriodInDays.getValue();
        String string = MetabasePrefs.backupTime.getValue();
        Date date = null;
        try {
            date = new MIMDateFormat("HH:mm").parse(string);
        }
        catch (ParseException parseException) {
            ay.d((Object)("Invalid metabase backup time in metabase.txt (" + string + ") - unable to schedule a backup task"), this);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(11, date.getHours());
        calendar2.set(12, date.getMinutes());
        calendar2.set(13, 0);
        calendar2.set(14, 0);
        while (calendar2.before(calendar)) {
            calendar2.add(6, 1);
        }
        ay.b((Object)("Scheduling the next metabase backup to run at: " + DateFormat.getDateTimeInstance().format(calendar2.getTime())), this);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ay.b((Object)"Running metabase backup task", this);
                try {
                    com.mimvista.metabase.f f2 = com.mimvista.metabase.j.a().d();
                    f2.a();
                    f2.c();
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error during metabase backup task", throwable, this);
                }
            }
        };
        this.n = new Timer("Metabase Backup Thread", true);
        this.n.scheduleAtFixedRate(timerTask, calendar2.getTime(), TimeUnit.DAYS.toMillis(n2));
    }

    private void c() {
        if (this.n != null) {
            this.n.cancel();
            this.n = null;
        }
    }

    @Override
    public boolean exportToIdms(String string, String string2, CookieBox cookieBox) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArtAssistConfigQuery createArtConfigQuery(RemotePatientListInfo remotePatientListInfo) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<LinkedHashMap<String, Object>> queryArtConfigs(ArtAssistConfigQuery artAssistConfigQuery, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DbWriteResult updateArtConfig(LinkedHashMap<String, Object> linkedHashMap, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClientArtConfigFilesStoreRequestHandler saveArtConfigWithFiles(LinkedHashMap<String, Object> linkedHashMap, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClientArtConfigFilesRetrieveRequestHandler fetchArtConfigFiles(ArtAssistConfigQuery artAssistConfigQuery, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DbWriteResult removeArtConfig(LinkedHashMap<String, Object> linkedHashMap, FractionAuthorizer fractionAuthorizer, boolean bl2, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DbWriteResult updateArtConfigFraction(LinkedHashMap<String, Object> linkedHashMap, FractionUpdate fractionUpdate, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FractionInformation> stopArtConfigFraction(LinkedHashMap<String, Object> linkedHashMap, FractionInformation fractionInformation, boolean bl2, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) throws RemoteException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public static enum Permission {
        a,
        b;


        public static Permission[] a() {
            return new Permission[]{a, b};
        }
    }
}

