/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.remote;

import com.google.common.collect.Lists;
import com.mimvista.ExternallyVisible;
import com.mimvista.archive.e;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.archive.remote.RemoteObjectInfo;
import com.mimvista.archive.remote.RemoteObjectManager;
import com.mimvista.archive.remote.RemotePatientListInfo;
import com.mimvista.archive.remote.SeriesContainer;
import com.mimvista.archive.remote.d;
import com.mimvista.archive.remote.e;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.rmi.a;
import com.mimvista.util.ay;
import com.mimvista.util.bq;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Calendar;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import sun.rmi.server.UnicastRef;

@ExternallyVisible
public class SeriesContainerImpl
extends UnicastRemoteObject
implements SeriesContainer,
e {
    public static final int SERIES_CONTAINER_PORT = "true".equals(System.getProperty("junit.test")) ? bq.a() : MIMpacsConfig.f + 1;
    private static final long serialVersionUID = 1L;
    private boolean cancelled = false;
    private File tempDirectory = new File(Path.getTempPath("mimStore", true, true));
    private FileOutputStream outStream = null;
    private int DECOMP_BUFF_SIZE = 131072;
    private RemotePatientListInfo archive;
    private long lastAccessTime = 0L;

    public SeriesContainerImpl(RemotePatientListInfo remotePatientListInfo) throws RemoteException {
        super(SERIES_CONTAINER_PORT, new SslRMIClientSocketFactory(), new d());
        this.archive = remotePatientListInfo;
        RemoteObjectManager.a().a(this);
    }

    public RemoteObjectInfo getRemoteObjectInfo() {
        return new RemoteObjectInfo().a(a.a((UnicastRef)this.getRef())).a(SERIES_CONTAINER_PORT).b(SslRMIClientSocketFactory.class.getName()).a(SeriesContainerImpl.class.getName());
    }

    @Override
    public void retrieveSuccessful() throws RemoteException {
        RemoteObjectManager.a().b(this);
        if (this.cancelled) {
            return;
        }
        try {
            if (this.outStream != null) {
                this.outStream.close();
                ay.b((Object)"Closed output stream", this);
            }
        }
        catch (IOException iOException) {
            ay.d((Object)"Error closing output stream", (Throwable)iOException, this);
        }
        this.outStream = null;
    }

    @Override
    public void addDataToSeries(byte[] byArray, int n2) throws RemoteException {
        RemoteObjectManager.a().b(this);
        if (this.cancelled) {
            return;
        }
        this.a();
        try {
            this.outStream.write(byArray);
        }
        catch (IOException iOException) {
            ay.d((Object)"Error writing to temp", (Throwable)iOException, this);
            this.cancelled = true;
            throw new RemoteException("Error writing to temp");
        }
        this.setProgress(n2);
    }

    private void a() throws RemoteException {
        if (this.outStream != null) {
            return;
        }
        File file = new File(this.tempDirectory, "mimReceive" + Calendar.getInstance().getTimeInMillis() + ".zip");
        ay.b((Object)("Opening file " + file.getAbsolutePath() + " for writing"), this);
        try {
            this.outStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            ay.d((Object)("Error opening file " + file.getAbsolutePath()), (Throwable)iOException, this);
            this.cancelled = true;
            throw new RemoteException("Error opening file " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean b() {
        int n2;
        File file = null;
        for (File object2 : this.tempDirectory.listFiles()) {
            if (!object2.getName().endsWith(".zip")) continue;
            file = object2;
            break;
        }
        if (file == null) {
            ay.d((Object)"Failed to find zip file", this);
            return false;
        }
        Object object = null;
        try {
            ZipEntry zipEntry;
            object = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            while ((zipEntry = ((ZipInputStream)object).getNextEntry()) != null) {
                BufferedOutputStream bufferedOutputStream;
                if (zipEntry.isDirectory()) continue;
                String string = new File(zipEntry.getName()).getName();
                FilterOutputStream iOException = null;
                try {
                    int n3;
                    byte[] byArray = new byte[this.DECOMP_BUFF_SIZE];
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(this.tempDirectory, string)), this.DECOMP_BUFF_SIZE);
                    while ((n3 = ((ZipInputStream)object).read(byArray, 0, this.DECOMP_BUFF_SIZE)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n3);
                    }
                    bufferedOutputStream.flush();
                    if (bufferedOutputStream == null) continue;
                }
                catch (Throwable throwable) {
                    if (iOException != null) {
                        try {
                            iOException.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    bufferedOutputStream.close();
                }
                catch (IOException iOException3) {}
            }
            n2 = 1;
            return n2 != 0;
        }
        catch (IOException iOException) {
            ay.d((Object)("Error decompressing series retrieved from query server: file to decompress was" + this.tempDirectory.getAbsolutePath()), (Throwable)iOException, this);
            n2 = 0;
            return n2 != 0;
        }
        catch (Exception exception) {
            ay.d((Object)("Other error decompressing: " + this.tempDirectory.getAbsolutePath()), (Throwable)exception, this);
            n2 = 0;
            return n2 != 0;
        }
        finally {
            if (object != null) {
                try {
                    ((ZipInputStream)object).close();
                }
                catch (IOException iOException) {}
            }
            ay.b((Object)("Deleting zippedFile: " + file.getAbsolutePath()), this);
            ay.b((Object)("Deletion successful: " + file.delete()), this);
        }
    }

    @Override
    public void createDirectoryForSeries() throws RemoteException {
        RemoteObjectManager.a().b(this);
        if (this.cancelled) {
            return;
        }
        if (!this.tempDirectory.exists() && !this.tempDirectory.mkdirs()) {
            ay.d((Object)("Error creating temporary directory to write data retrieved: " + this.tempDirectory.getAbsolutePath()), this);
            this.cancelled = true;
            throw new RemoteException("Error creating temporary directory to write data retrieved: " + this.tempDirectory.getAbsolutePath());
        }
    }

    @Override
    public void finishedRetrieving() throws RemoteException {
        try {
            if (this.outStream != null) {
                try {
                    this.outStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.outStream = null;
            if (this.cancelled) {
                return;
            }
            ay.b((Object)"finished retrieving", this);
            ay.b((Object)"Decompressing ...", this);
            if (!this.b()) {
                ay.d((Object)"Failed to decompress the zip file", this);
                throw new FileNotFoundException("Failed to decompress the zip file");
            }
            ay.b((Object)"Archiving...", this);
            try {
                com.mimvista.archive.e e2 = new e.c(this.tempDirectory, new File(this.archive.n())).setDeleteIncomingFolder(true);
                if (this.archive.l() != null) {
                    e2.setPacsPatientLists(Lists.newArrayList((Object[])new String[]{this.archive.l()}));
                }
                Set<File> set = e2.performAction().a();
                ay.b((Object)("Successfully stored to " + set), this);
            }
            catch (IOException iOException) {
                ay.d((Object)"Archiving series", (Throwable)iOException, this);
                throw new FileNotFoundException("Failed to archive series for reason: " + iOException.getMessage());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MissingResourceException(fileNotFoundException.getMessage(), "MIM_ArchiveSeries", "MIM_Failure");
        }
        finally {
            if (this.tempDirectory.exists() && !new MIMFile(this.tempDirectory).delete()) {
                ay.d((Object)("Failed to clean temporary folder " + this.tempDirectory.getAbsolutePath()), this);
            }
            RemoteObjectManager.a().c(this);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setProgressLabel(String string) throws RemoteException {
    }

    @Override
    public void setProgressTitle(String string) throws RemoteException {
    }

    @Override
    public void setProgress(int n2) throws RemoteException {
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void setLastAccessTime(long l2) {
        this.lastAccessTime = l2;
    }

    @Override
    public void purge() {
        if (this.outStream != null) {
            ay.c((Object)"Closing output stream due to revoking remote object server", this);
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                ay.d((Object)"Failed to close output stream", (Throwable)iOException, this);
            }
        }
        try {
            if (!UnicastRemoteObject.unexportObject(this, true)) {
                ay.d((Object)("Failed unexporting remote object server " + this), this);
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            ay.d((Object)("Failed unexporting remote object server " + this), (Throwable)noSuchObjectException, this);
        }
    }
}

