/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.remote;

import com.google.common.collect.Lists;
import com.mimvista.ExternallyVisible;
import com.mimvista.archive.search.DicomSearchSource;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.e;
import com.mimvista.archive.search.f;
import com.mimvista.archive.search.i;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.config.DcmConfigReader;
import com.mimvista.dicom.gui.DcmPullTransfer;
import com.mimvista.gui.a.b;
import com.mimvista.preferencesNew.DicomLocationsPrefs;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.progress.g;
import com.mimvista.util.progress.o;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

@ExternallyVisible
public class SeriesQuery {
    private SeriesParameters a = new SeriesParameters();
    private DicomLocationsPrefs.a b;
    private List<DcmSeries> c;
    private SearchSource d;
    private JFrame e = null;
    private ArrayList<Observer> f = new ArrayList();

    public SeriesQuery() {
    }

    public SeriesQuery(SeriesParameters seriesParameters) {
        this.applyParams(seriesParameters);
    }

    public SeriesQuery(SearchSource searchSource, SeriesParameters seriesParameters) {
        this.applyParams(seriesParameters);
        this.setSearchSource(searchSource);
    }

    public void applyParams(SeriesParameters seriesParameters) {
        if (seriesParameters.uidList != null) {
            this.a.uidList = seriesParameters.uidList;
        }
        if (seriesParameters.contentDate != null) {
            this.a.contentDate = seriesParameters.contentDate;
        }
        if (seriesParameters.studyDate != null) {
            this.a.studyDate = seriesParameters.studyDate;
        }
        if (seriesParameters.archivePath != null) {
            this.a.archivePath = seriesParameters.archivePath;
        }
        if (seriesParameters.name != null) {
            this.a.name = seriesParameters.name;
        }
        if (seriesParameters.modality != null) {
            this.a.modality = seriesParameters.modality;
        }
        if (seriesParameters.referencingFilePath != null) {
            this.a.referencingFilePath = seriesParameters.referencingFilePath;
        }
        if (seriesParameters.searchType != -1) {
            this.a.searchType = seriesParameters.searchType;
        }
    }

    public void setParent(JFrame jFrame) {
        this.e = jFrame;
    }

    public void setSearchType(int n2) {
        this.a.searchType = n2;
    }

    public void setSearchModality(String string) {
        this.a.modality = string;
    }

    public void setStudyDate(String string) {
        this.a.studyDate = string;
    }

    public void setContentDate(String string) {
        this.a.contentDate = string;
    }

    public void setUIDs(List<String> list) {
        this.a.uidList = list;
    }

    public void setName(String string) {
        this.a.name = string;
    }

    public void setArchivePath(String string) {
        this.a.archivePath = string;
    }

    public void setSearchSource(SearchSource searchSource) {
        this.d = searchSource;
        if (searchSource instanceof LocalSearchSource) {
            this.setArchivePath(((LocalSearchSource)searchSource).a());
        } else if (searchSource instanceof DicomSearchSource) {
            this.b = ((DicomSearchSource)searchSource).a();
        }
    }

    public void addObserver(Observer observer) {
        this.f.add(observer);
    }

    public void deleteObserver(Observer observer) {
        this.f.remove(observer);
    }

    public void deleteObservers() {
        this.f.clear();
    }

    public List<DcmSeries> search() {
        this.d.b(this.a, this.getSearchResultsListener()).run();
        return this.c;
    }

    public f<i> getSearchResultsListener() {
        return new e(){

            @Override
            public void setSearchResults(i i2) {
                ArrayList<DcmSeries> arrayList = new ArrayList<DcmSeries>();
                for (DcmSeries dcmSeries : i2.b()) {
                    arrayList.add(dcmSeries);
                    dcmSeries.setSearchSource(i2.c());
                }
                SeriesQuery.this.c = arrayList;
            }

            @Override
            public Progress getSearchProgress() {
                g g2 = o.o();
                if (SeriesQuery.this.e != null) {
                    g2 = new ProgressPanel();
                    ProgressQueueNotification.a(g2);
                    g2.a(3000);
                }
                return g2;
            }
        };
    }

    public void observableDicomPull(final List<DcmSeries> list) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DicomSearchSource.a a2 = new DicomSearchSource.a(list);
                DcmPullTransfer dcmPullTransfer = new DcmPullTransfer(a2, SeriesQuery.this.b, DcmConfigReader.getServerAETitle());
                for (Observer observer : SeriesQuery.this.f) {
                    dcmPullTransfer.addObserver(observer);
                }
                com.mimvista.gui.a.b.a(dcmPullTransfer);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    public List<DcmSeries> getSearchResults() {
        if (this.c == null) {
            return null;
        }
        return Lists.newArrayList(this.c);
    }

    public static void main(String[] stringArray) {
        SeriesQuery seriesQuery = new SeriesQuery();
        seriesQuery.setName("Sample".toUpperCase());
        seriesQuery.setSearchType(0);
        SearchSource searchSource = com.mimvista.archive.search.g.d();
        searchSource = com.mimvista.archive.search.g.f().get(0);
        searchSource = com.mimvista.archive.search.g.h().get(0);
        seriesQuery.setSearchSource(searchSource);
        List<DcmSeries> list = seriesQuery.search();
        ay.e(list.size());
        for (DcmSeries dcmSeries : list) {
            ay.e(dcmSeries.getSeriesInstanceUID());
        }
        System.exit(0);
    }
}

