/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.remote;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.mimvista.archive.Archiver;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.archive.remote.RemotePatientListInfo;
import com.mimvista.archive.remote.RemoteQueryServerImpl;
import com.mimvista.archive.remote.sockets.ClientMetabaseDumpRequestHandler;
import com.mimvista.archive.remote.sockets.ClientQueryRequestHandler;
import com.mimvista.archive.remote.sockets.c;
import com.mimvista.archive.remote.sockets.e;
import com.mimvista.archive.remote.sockets.l;
import com.mimvista.cloud.shared.common.version.VersionNumberComparator;
import com.mimvista.d;
import com.mimvista.dicom.LocalMetabaseSeries;
import com.mimvista.dicom.SeriesOwnerInfo;
import com.mimvista.dicom.SeriesReferenceExtractor;
import com.mimvista.dicom.SeriesStatusBundle;
import com.mimvista.dicom.SeriesStatusInfo;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.b;
import com.mimvista.metabase.indexing.ScanOptions;
import com.mimvista.metabase.indexing.client.MetabaseIndexingClient;
import com.mimvista.metabase.j;
import com.mimvista.metabase.mongo.MongoMetabaseQuery;
import com.mimvista.metabase.n;
import com.mimvista.metabase.o;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.MimpacsPrefs;
import com.mimvista.preferencesNew.g;
import com.mimvista.properties.af;
import com.mimvista.update.VersionNumber;
import com.mimvista.user.CookieBox;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.io.File;
import java.io.IOException;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SortOrder;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class SimpleRemotePatientList
extends RemoteQueryServerImpl {
    private static SimpleRemotePatientList i;
    private Thread j;

    public static SimpleRemotePatientList getInstance() throws RemoteException {
        if (i == null) {
            i = new SimpleRemotePatientList(MIMpacsConfig.f);
        }
        return i;
    }

    public static SimpleRemotePatientList findInstance() {
        return i;
    }

    public static SimpleRemotePatientList getInstanceForTest(int n2) throws RemoteException {
        i = new SimpleRemotePatientList(n2);
        return i;
    }

    private SimpleRemotePatientList(int n2) throws RemoteException {
        super(n2);
    }

    @Override
    public HashMap<String, Boolean> getPacsServerLicenses() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("SVC_AUTH", false);
        hashMap.put("SVC_PLUS", false);
        hashMap.put("SVC_PREM", false);
        return hashMap;
    }

    @Override
    public boolean isMetabaseRunning() {
        return false;
    }

    @Override
    public boolean isLockProhibitive() {
        return false;
    }

    @Override
    public boolean isAutoLockingEnabled() {
        return false;
    }

    @Override
    public boolean isRunningInStorageServerMode() {
        return false;
    }

    @Override
    public int getEventNotifierPort() {
        return 0;
    }

    @Override
    public void setStatus(String string, String string2, long l2, String string3, CookieBox cookieBox) {
    }

    @Override
    public void delStatus(String string, String string2, long l2, String string3, CookieBox cookieBox) {
    }

    @Override
    public boolean hasStatus(String string, String string2, long l2, String string3, CookieBox cookieBox) {
        return false;
    }

    @Override
    public List<SeriesStatusInfo> getStatuses(String string, String string2, long l2, String string3, CookieBox cookieBox) throws RemoteException {
        return new ArrayList<SeriesStatusInfo>();
    }

    @Override
    public List<SeriesStatusBundle> getViewAndWorkflowStatuses(String string, List<String> list, List<Long> list2, CookieBox cookieBox) throws RemoteException {
        ArrayList<SeriesStatusBundle> arrayList = new ArrayList<SeriesStatusBundle>();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            arrayList.add(null);
        }
        return arrayList;
    }

    @Override
    public boolean canSetStatus(String string, String[] stringArray) {
        return false;
    }

    @Override
    public boolean canDelStatus(String string, String[] stringArray) {
        return false;
    }

    @Override
    public List<String> listStatuses(String string) {
        return new ArrayList<String>();
    }

    @Override
    public List<String> listNextWorkflowStatuses(String string, String[] stringArray) {
        return new ArrayList<String>();
    }

    @Override
    public void setOwner(long l2, String string, CookieBox cookieBox) {
    }

    @Override
    public void clearOwnerHistory(long l2, CookieBox cookieBox) throws RemoteException {
    }

    @Override
    public SeriesOwnerInfo getOwner(long l2, CookieBox cookieBox) throws RemoteException {
        return null;
    }

    @Override
    public List<String> getAvailableUsers() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasOwnersEnabled() {
        return false;
    }

    @Override
    public synchronized void startMetabaseScan() {
        if (this.j == null) {
            this.j = new Thread("SimpleRPL Metabase Scanning Thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ArrayList arrayList = Lists.newArrayList();
                        for (Comparable<RemotePatientListInfo> comparable : SimpleRemotePatientList.this.c) {
                            File file = new File(comparable.n());
                            if (!file.exists()) {
                                ay.c((Object)("SimpleRPL: Can't find archive folder: " + comparable.n()), this);
                                continue;
                            }
                            arrayList.add(file);
                        }
                        if (arrayList.isEmpty()) {
                            ay.b((Object)"SimpleRPL: No archive folders to scan", this);
                            return;
                        }
                        MetabaseIndexingClient metabaseIndexingClient = new MetabaseIndexingClient();
                        ScanOptions scanOptions = ScanOptions.a();
                        try {
                            for (Comparable<RemotePatientListInfo> comparable : arrayList) {
                                try {
                                    metabaseIndexingClient.a((File)comparable, scanOptions);
                                }
                                catch (MetabaseIndexingClient.IndexingServiceConnectException indexingServiceConnectException) {
                                    throw indexingServiceConnectException;
                                }
                                catch (Throwable throwable) {
                                    ay.d((Object)("Error trying to schedule a Simple RPL archive folder to be scanned: " + comparable), throwable, this);
                                }
                            }
                            try {
                                metabaseIndexingClient.c();
                            }
                            catch (Throwable throwable) {
                                ay.d((Object)"Error trying to schedule index creation", throwable, this);
                            }
                        }
                        catch (MetabaseIndexingClient.IndexingServiceConnectException indexingServiceConnectException) {
                            ay.d((Object)"Can't connect to the indexing service - check the admin service logs, the admin service may need to be restarted or might be old", (Throwable)indexingServiceConnectException, this);
                        }
                    }
                    finally {
                        SimpleRemotePatientList.this.j = null;
                    }
                }
            };
            this.j.start();
        }
    }

    @Override
    protected RemotePatientListInfo[] a(@d af af2) {
        return SimpleRemotePatientList.loadRPLs(true);
    }

    public static RemotePatientListInfo[] loadRPLs(boolean bl2) {
        if (bl2) {
            ay.b((Object)"SimpleRPL: loading patient lists from the configuration...", SimpleRemotePatientList.class);
        }
        Object object = MimpacsPrefs.simpleRPLs.getValue();
        if (bl2) {
            ay.b((Object)("SimpleRPL: Number of patient lists: " + object.size()), SimpleRemotePatientList.class);
        }
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            g.b b2 = (g.b)iterator.next();
            RemotePatientListInfo remotePatientListInfo = new RemotePatientListInfo();
            remotePatientListInfo.a(VersionNumber.rawCurrentVersionNotAccountingForMIMviewer().getFullVersionString());
            String string = b2.getPatientListName();
            if (cn.h(string)) {
                if (!bl2) continue;
                ay.c((Object)"SimpleRPL: One of the configured patient lists doesn't have a proper archive alias", SimpleRemotePatientList.class);
                continue;
            }
            remotePatientListInfo.e(string);
            File file = b2.getPatientListPath();
            if (file == null) {
                if (!bl2) continue;
                ay.c((Object)("SimpleRPL: Patient list " + remotePatientListInfo + " doesn't have a proper path set"), SimpleRemotePatientList.class);
                continue;
            }
            remotePatientListInfo.g(file.getAbsolutePath());
            arrayList.add(remotePatientListInfo);
            if (!bl2) continue;
            ay.b((Object)("SimpleRPL: Patient list : " + remotePatientListInfo), SimpleRemotePatientList.class);
        }
        return arrayList.toArray(new RemotePatientListInfo[arrayList.size()]);
    }

    @Override
    public ClientQueryRequestHandler executeMetabaseQuery(MetabaseQuery metabaseQuery, String string, CookieBox cookieBox) throws AccessException, IOException {
        RemotePatientListInfo remotePatientListInfo = this.b(RemoteQueryServerImpl.Permission.a, string, cookieBox);
        if (remotePatientListInfo == null) {
            return null;
        }
        if (!MIMpacsConfig.c() && metabaseQuery.e() && metabaseQuery.d() <= 0) {
            throw new RuntimeException("Blank searches are not allowed");
        }
        b.b(metabaseQuery, remotePatientListInfo.n());
        VersionNumber versionNumber = new VersionNumber(6, 1, 0, "");
        VersionNumber versionNumber2 = cookieBox.g();
        if (versionNumber2 == null || VersionNumberComparator.b.c(versionNumber2, versionNumber)) {
            ((MongoMetabaseQuery)metabaseQuery).g();
        }
        c c2 = new c(metabaseQuery, remotePatientListInfo, cookieBox);
        l l2 = new l(c2, this);
        com.mimvista.archive.remote.sockets.e.a.a(l2);
        return c2.e();
    }

    @Override
    protected List<QueryResult> a(RemotePatientListInfo remotePatientListInfo, int n2, CookieBox cookieBox) {
        MetabaseQuery metabaseQuery = n.a();
        b.a(metabaseQuery, n2);
        return this.a(metabaseQuery, remotePatientListInfo, true);
    }

    @Override
    protected List<QueryResult> a(RemotePatientListInfo remotePatientListInfo, Date date, CookieBox cookieBox) {
        MetabaseQuery metabaseQuery = n.a();
        metabaseQuery.f("mimdata.dateAdded", date);
        metabaseQuery.a("mimdata.dateAdded", SortOrder.ASCENDING);
        return this.a(metabaseQuery, remotePatientListInfo, true);
    }

    @Override
    protected List<QueryResult> a(String string, String string2, String string3, String string4, String string5, String string6, String string7, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) {
        MetabaseQuery metabaseQuery = n.a();
        b.a(metabaseQuery, string, string2, string3, string4, string5, string6, string7, null);
        return this.a(metabaseQuery, remotePatientListInfo, false);
    }

    @Override
    protected List<QueryResult> a(Date date, Date date2, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) {
        MetabaseQuery metabaseQuery = n.a();
        b.b(metabaseQuery, date, date2);
        return this.a(metabaseQuery, remotePatientListInfo, false);
    }

    @Override
    protected List<QueryResult> b(Date date, Date date2, RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) {
        MetabaseQuery metabaseQuery = n.a();
        b.a(metabaseQuery, date, date2);
        return this.a(metabaseQuery, remotePatientListInfo, false);
    }

    @Override
    protected RemotePatientListInfo a(RemotePatientListInfo remotePatientListInfo, CookieBox cookieBox) {
        return remotePatientListInfo;
    }

    @Override
    protected void a(String string, String string2, CookieBox cookieBox) {
        MIMFile mIMFile = new MIMFile(string2);
        if (mIMFile.isDirectory()) {
            Archiver.deleteSeriesFolder(mIMFile);
            if (mIMFile.exists()) {
                ay.d((Object)(SimpleRemotePatientList.getRemoteLogPrefix(cookieBox) + "Couldn't delete series folder: " + string2), this);
            } else {
                ay.b((Object)(SimpleRemotePatientList.getRemoteLogPrefix(cookieBox) + "Deleted series folder: " + string2), this);
            }
        }
        com.mimvista.metabase.j.a().e(mIMFile.getAbsolutePath());
    }

    @Override
    protected void a(LocalMetabaseSeries localMetabaseSeries, CookieBox cookieBox) throws AccessException {
    }

    @Override
    protected RemotePatientListInfo b(RemoteQueryServerImpl.Permission permission, String string, CookieBox cookieBox) {
        if (string == null || string.length() == 0) {
            ay.d((Object)(SimpleRemotePatientList.getRemoteLogPrefix(cookieBox) + "Archive alias is illegal"), this);
            return null;
        }
        RemotePatientListInfo remotePatientListInfo = this.a(string, cookieBox);
        if (remotePatientListInfo == null) {
            ay.d((Object)(SimpleRemotePatientList.getRemoteLogPrefix(cookieBox) + "Patient list " + string + " is not found"), this);
            return null;
        }
        return remotePatientListInfo;
    }

    @Override
    protected CookieBox b(CookieBox cookieBox) {
        return cookieBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueryResult> a(MetabaseQuery metabaseQuery, final RemotePatientListInfo remotePatientListInfo, final boolean bl2) {
        metabaseQuery.c((Iterable<String>)b.b());
        if (!MIMpacsConfig.c() && metabaseQuery.e() && metabaseQuery.d() <= 0) {
            throw new RuntimeException("This remote patient list server does not allow blank searches");
        }
        int n2 = MIMpacsConfig.d();
        if (n2 > 0 && metabaseQuery.d() <= 0) {
            metabaseQuery.b(n2);
        }
        b.b(metabaseQuery, remotePatientListInfo.n());
        ay.a((Object)("SimpleRPL: Query object: " + metabaseQuery), this);
        final ArrayList arrayList = Lists.newArrayList();
        long l2 = System.currentTimeMillis();
        long l3 = metabaseQuery.d(com.mimvista.metabase.j.a());
        int n3 = (int)Math.min(10L, Math.round((double)l3 / 10000.0));
        try {
            this.h.acquireUninterruptibly(n3);
            int n4 = metabaseQuery.a(com.mimvista.metabase.j.a(), new FuncUtils.m<List<? extends Series>>(){

                public void a(List<? extends Series> list) {
                    o o2 = new o(com.mimvista.metabase.j.a(), new File(remotePatientListInfo.n()));
                    o2.a(list);
                    o2.a(new Function<MetabaseQuery, MetabaseQuery>(){

                        public MetabaseQuery a(MetabaseQuery metabaseQuery) {
                            b.b(metabaseQuery, remotePatientListInfo.n());
                            return metabaseQuery;
                        }

                        public /* synthetic */ Object apply(Object object) {
                            return this.a((MetabaseQuery)object);
                        }
                    });
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    for (Series series : list) {
                        QueryResult queryResult = series.asQueryResult();
                        SeriesReferenceExtractor.extractReferences(queryResult, series, o2);
                        if (bl2) {
                            queryResult.a("newlyreceived", simpleDateFormat.format(series.getDateAdded()));
                        }
                        queryResult.a("archivealias", remotePatientListInfo.k());
                        arrayList.add(queryResult);
                    }
                }

                @Override
                public /* synthetic */ void doIt(Object object) {
                    this.a((List)object);
                }
            });
            ay.a((Object)("SimpleRPL: Metabase query returned " + n4 + " results in: " + DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - l2), (String)"H'h':m'm':s.S's'")), this);
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.h.release(n3);
        }
    }

    public static boolean isSimpleRplFolder(File file) {
        file = PathUtils.getCanonicalOrAbsoluteFile(file);
        for (String string : SimpleRemotePatientList.getSimpleRplLocations()) {
            if (!file.equals(PathUtils.getCanonicalOrAbsoluteFile(string))) continue;
            return true;
        }
        return false;
    }

    public static List<String> getSimpleRplLocations() {
        ArrayList arrayList = Lists.newArrayList();
        Object object = MimpacsPrefs.simpleRPLs.getValue();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            g.b b2 = (g.b)iterator.next();
            File file = b2.getPatientListPath();
            if (file == null) continue;
            arrayList.add(file.getAbsolutePath());
        }
        return arrayList;
    }

    @Override
    public void renamePatientList(String string, String string2, CookieBox cookieBox) throws RemoteException {
    }

    @Override
    public ClientMetabaseDumpRequestHandler getMetabaseDump(CookieBox cookieBox) throws RemoteException, AccessException, IOException {
        return null;
    }
}

