/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.remote.sync;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.mimvista.archive.remote.sync.SyncFileType;
import com.mimvista.d;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.file.PathUtils;
import com.mimvista.file.f;
import com.mimvista.user.LoginChecker;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class SyncFileStub
implements Serializable,
Comparable<SyncFileStub> {
    private static final long serialVersionUID = 1L;
    private boolean isSiteDefault;
    private boolean isOverride;
    private String username;
    private File absolutePath;
    private File serverRelativePath;
    private long fileSize;
    private boolean isDeleted;
    private Date lastModified;
    private HashCode hash;

    public SyncFileStub(File file, File file2, String string, boolean bl2, boolean bl3) {
        MIMFile.k(file);
        Preconditions.checkArgument((!file2.isAbsolute() ? 1 : 0) != 0, (Object)"relativePath cannot be an absolute path");
        this.isSiteDefault = bl2;
        this.isDeleted = f.c(file);
        this.lastModified = new Date(file.lastModified());
        this.fileSize = file.length();
        file = PathUtils.getCanonicalOrAbsoluteFile(file);
        if (this.isDeleted) {
            file = new File(file.getParent(), Files.getNameWithoutExtension((String)file.getName()));
            file2 = new File(file2.getParent(), Files.getNameWithoutExtension((String)file2.getName()));
        }
        this.absolutePath = file;
        this.serverRelativePath = file2;
        this.isOverride = bl3;
        this.username = string;
    }

    @Deprecated
    public boolean a() {
        return this.isSiteDefault;
    }

    @Deprecated
    public boolean b() {
        return this.isOverride;
    }

    @Deprecated
    public String c() {
        return this.username;
    }

    @Deprecated
    public File d() {
        return this.absolutePath;
    }

    public File e() {
        return this.serverRelativePath;
    }

    public long f() {
        return this.fileSize;
    }

    public Date g() {
        return this.lastModified;
    }

    public boolean a(SyncFileStub syncFileStub) {
        return this.lastModified.after(syncFileStub.lastModified);
    }

    public boolean h() {
        return this.isDeleted;
    }

    @d
    public HashCode i() {
        return this.hash;
    }

    public void j() throws IOException {
        if (this.hash == null && !this.isDeleted) {
            this.hash = Files.hash((File)this.absolutePath, (HashFunction)Hashing.md5());
        }
    }

    @Deprecated
    public SyncFileType k() {
        for (SyncFileType syncFileType : SyncFileType.values()) {
            if (!Path.isParentOf(syncFileType.b(), this.serverRelativePath)) continue;
            return syncFileType;
        }
        return null;
    }

    public int b(SyncFileStub syncFileStub) {
        return this.e().getPath().compareToIgnoreCase(syncFileStub.e().getPath());
    }

    public boolean equals(Object object) {
        if (!(object instanceof SyncFileStub)) {
            return false;
        }
        SyncFileStub syncFileStub = (SyncFileStub)object;
        return this.e().getPath().equalsIgnoreCase(syncFileStub.e().getPath());
    }

    public int hashCode() {
        return this.e().getPath().toLowerCase().hashCode();
    }

    public String toString() {
        return this.a(0);
    }

    public String a(int n2) {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper((Object)this);
        toStringHelper.add("relativePath", (Object)StringUtils.rightPad((String)this.serverRelativePath.getPath(), (int)n2));
        toStringHelper.add("lastModified", (Object)this.lastModified.toGMTString());
        if (this.isSiteDefault) {
            toStringHelper.add("isSiteDefault", this.isSiteDefault);
        }
        if (this.isOverride) {
            toStringHelper.add("isOverride", this.isOverride);
        }
        if (this.isDeleted) {
            toStringHelper.add("isDeleted", this.isDeleted);
        }
        return toStringHelper.toString();
    }

    public static boolean a(File file) {
        if (file.isDirectory() || file.getName().endsWith(".deleted")) {
            return MIMFile.a(file);
        }
        if (LoginChecker.getInstance().isUserLoggedIn() && LoginChecker.getInstance().isUseNetworkUsers()) {
            return MIMFile.n(file);
        }
        return MIMFile.a(file);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.b((SyncFileStub)object);
    }
}

