/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.search;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.archive.search.DicomSearchSource;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.gui.DcmPullTransfer;
import com.mimvista.dicom.network.DcmQueryClient;
import com.mimvista.dicom.qrserver.CGetStorageDelegate;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.server.DcmRcvStatusNotifier;
import com.mimvista.rmi.DcmRcvStatus;
import com.mimvista.util.ay;
import com.mimvista.util.cm;
import com.mimvista.util.cn;
import com.mimvista.util.j;
import com.mimvista.util.work.m;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.axis.utils.ByteArrayOutputStream;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.PDVInputStream;

class DicomQueryDataProvider
extends LoaderDataProvider {
    private static final int a = 1000;
    private final DicomSearchSource b;
    private final DcmSeries c;
    private Map<String, byte[]> d = Maps.newHashMap();
    private List<String> e;
    private RetrieveState f = RetrieveState.a;
    private boolean g = false;
    private a h = null;

    DicomQueryDataProvider(DicomSearchSource dicomSearchSource, DcmSeries dcmSeries) {
        this.b = dicomSearchSource;
        this.c = dcmSeries;
    }

    @Override
    public List<String> getFilenames() {
        if (this.e == null || this.e.isEmpty()) {
            this.e = Lists.newArrayList();
            Integer n2 = (Integer)this.c.getTagValue(2101769);
            if (n2 == null) {
                try {
                    n2 = Integer.parseInt(this.c.getNumberOfImages());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (n2 == null) {
                n2 = this.c.getLastResortImageCount();
            }
            if (n2 == null) {
                ay.c((Object)("Unable to determine number of images in " + this.c.getSeriesInstanceUID() + " without pulling locally.  Initiating transfer."), this);
                this.a();
                n2 = this.d.size();
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                this.e.add("" + i2);
            }
        }
        return this.e;
    }

    private synchronized void a() {
        if (this.f == null || this.f == RetrieveState.a) {
            this.b();
        }
        while (this.f != RetrieveState.c && !this.g) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                ay.d((Object)"Error Message: ", (Throwable)interruptedException, DicomQueryDataProvider.class);
            }
        }
    }

    @Override
    public synchronized void destroy() {
        this.d = Maps.newHashMap();
        this.e = null;
        this.f = RetrieveState.a;
        this.g = true;
        if (this.h != null) {
            this.h.b();
            this.h = null;
        }
        this.notifyAll();
    }

    @Override
    public synchronized InputStream getStream(String string) {
        if (string.equals("mimfancycache.mim")) {
            return null;
        }
        if (this.f == null || this.f == RetrieveState.a) {
            this.b();
        }
        if (this.f == RetrieveState.c) {
            return this.a(string);
        }
        while (this.f == RetrieveState.b && !this.d.containsKey(string) && !this.g) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                ay.d((Object)"Error Message: ", (Throwable)interruptedException, DicomQueryDataProvider.class);
            }
        }
        return this.a(string);
    }

    private InputStream a(String string) {
        if ("0".equals(string)) {
            return this.a(this.d.get(string));
        }
        return this.a(this.d.remove(string));
    }

    private InputStream a(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    private void b() {
        this.g = false;
        this.a(RetrieveState.b);
        m.e.a(this::d, "DICOM QR Retrieve Data Thread");
    }

    private synchronized void a(RetrieveState retrieveState) {
        this.f = retrieveState;
    }

    private synchronized void a(boolean bl2) {
        this.g = bl2;
    }

    private synchronized boolean c() {
        return this.g;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d() {
        boolean bl2 = this.b.a().isRetrieveWithCGet();
        DcmQueryClient dcmQueryClient = new DcmQueryClient(this.b.a(), bl2);
        try {
            dcmQueryClient.open();
            if (bl2) {
                this.a(dcmQueryClient);
            } else {
                this.b(dcmQueryClient);
            }
        }
        catch (IOException | InterruptedException | NotBoundException | ConfigurationException throwable) {
            ay.d((Object)"Error Message: ", throwable, DicomQueryDataProvider.class);
            this.a(RetrieveState.c);
            DicomQueryDataProvider dicomQueryDataProvider = this;
            synchronized (dicomQueryDataProvider) {
                this.notifyAll();
            }
        }
        finally {
            try {
                dcmQueryClient.close();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void a(final DcmQueryClient dcmQueryClient) throws IOException, InterruptedException {
        dcmQueryClient.get(DcmPullTransfer.QueryRetrieveLevel.SERIES, DicomSearchSource.b(this.c), new CGetStorageDelegate(){
            int a = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void retrieveFinished(boolean bl2) {
                DicomQueryDataProvider.this.a(RetrieveState.c);
                DicomQueryDataProvider dicomQueryDataProvider = DicomQueryDataProvider.this;
                synchronized (dicomQueryDataProvider) {
                    DicomQueryDataProvider.this.notifyAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void imageReceived(String string, String string2, String string3, PDVInputStream pDVInputStream) {
                DicomQueryDataProvider dicomQueryDataProvider = DicomQueryDataProvider.this;
                synchronized (dicomQueryDataProvider) {
                    if (DicomQueryDataProvider.this.g) {
                        dcmQueryClient.cancel();
                        return;
                    }
                }
                try {
                    dicomQueryDataProvider = new ByteArrayOutputStream();
                    Throwable throwable = null;
                    try {
                        this.writeToStream((OutputStream)((Object)dicomQueryDataProvider), string, string2, string3, pDVInputStream);
                        DicomQueryDataProvider.this.d.put("" + this.a++, dicomQueryDataProvider.toByteArray());
                        DicomQueryDataProvider dicomQueryDataProvider2 = DicomQueryDataProvider.this;
                        synchronized (dicomQueryDataProvider2) {
                            DicomQueryDataProvider.this.notifyAll();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dicomQueryDataProvider != null) {
                            if (throwable != null) {
                                try {
                                    dicomQueryDataProvider.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                dicomQueryDataProvider.close();
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    ay.d((Object)"Error opening series via C-GET", (Throwable)iOException, this.getClass());
                }
            }
        });
    }

    private void b(DcmQueryClient dcmQueryClient) throws NotBoundException, IOException, InterruptedException {
        this.h = this.e != null && !this.e.isEmpty() ? new a(this, this.e.size()) : new a(this);
        dcmQueryClient.addObserver(this.h);
        this.h.a();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("StudyInstanceUID:" + this.c.getStudy().getStudyInstanceUID());
        arrayList.add("SeriesInstanceUID:" + this.c.getSeriesInstanceUID());
        dcmQueryClient.setDest(this.b.a().getRetrieveAETitleForOpening());
        dcmQueryClient.move(dcmQueryClient.query(DcmPullTransfer.QueryRetrieveLevel.SERIES, arrayList));
        if (dcmQueryClient.getStatus().a() > 0) {
            ay.c((Object)"Cancelling transfer due to failures", this);
            this.a(true);
            this.h.b();
        }
        dcmQueryClient.close();
    }

    @Override
    public synchronized void copyCachedStateTo(LoaderDataProvider loaderDataProvider) {
        super.copyCachedStateTo(loaderDataProvider);
        if (!(loaderDataProvider instanceof DicomQueryDataProvider)) {
            ay.e(this.getClass().getName() + " attempted to copy cached state from different data provider type: " + loaderDataProvider.getClass().getName());
            return;
        }
        DicomQueryDataProvider dicomQueryDataProvider = (DicomQueryDataProvider)loaderDataProvider;
        dicomQueryDataProvider.g = this.g;
        dicomQueryDataProvider.d = this.d;
        dicomQueryDataProvider.e = this.e;
        dicomQueryDataProvider.f = this.f;
        dicomQueryDataProvider.h = this.h;
    }

    private class a
    implements Runnable,
    Observer {
        private static final int d = -1;
        private static final int e = Integer.MAX_VALUE;
        private int f = -1;
        private final Object g;
        private ServerSocket h = null;
        DataInputStream a = null;
        DataOutputStream b = null;
        private String i = null;

        public a(Object object) {
            this.g = object;
        }

        public a(Object object, int n2) {
            this.g = object;
            this.f = n2;
        }

        public void a() throws IOException, NotBoundException {
            int n2 = this.c();
            DcmRcvStatus dcmRcvStatus = (DcmRcvStatus)Naming.lookup("//localhost:" + DcmRcvStatusNotifier.DCMRCV_STATUS_PORT + "/DcmRcvNotifier");
            dcmRcvStatus.redirectIncomingSeries(DicomQueryDataProvider.this.b.a().getRetrieveAETitleForOpening(), DicomQueryDataProvider.this.c.getSeriesInstanceUID(), this.d() ? this.f : Integer.MAX_VALUE, n2, this.i);
            m.e.a(this, "DICOM QR Open Listen Thread");
        }

        public void b() {
            cm.a((Closeable)this.h);
        }

        private int c() throws IOException {
            this.i = UUID.randomUUID().toString();
            this.h = new ServerSocket();
            this.h.bind(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0));
            return this.h.getLocalPort();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int n2 = (int)TimeUnit.SECONDS.toMillis(30L);
                this.h.setSoTimeout(n2);
                Socket socket = this.h.accept();
                socket.setSoTimeout(n2);
                socket.setTcpNoDelay(true);
                this.a = new DataInputStream(socket.getInputStream());
                String string = this.a.readUTF();
                if (!this.i.equals(string)) {
                    throw new IOException("Did not receive proper uniqueID '" + this.i + "' - instead got '" + string + "'");
                }
                this.b = new DataOutputStream(socket.getOutputStream());
                this.b.writeUTF(DicomQueryDataProvider.this.c.getSeriesInstanceUID());
                this.f();
            }
            catch (IOException iOException) {
                ay.d((Object)"Socket error: ", (Throwable)iOException, DicomQueryDataProvider.class);
                DicomQueryDataProvider.this.a(true);
            }
            finally {
                ay.e("CLOSING C-Move Socket!");
                DicomQueryDataProvider.this.a(RetrieveState.c);
                this.b();
                try {
                    if (this.a != null) {
                        this.a.close();
                    }
                    if (this.b != null) {
                        this.b.close();
                    }
                }
                catch (IOException iOException) {}
            }
            this.e();
        }

        private boolean d() {
            return this.f != -1;
        }

        @Override
        public void update(Observable observable, Object object) {
            if (!(observable instanceof DcmQueryClient)) {
                return;
            }
            DcmQueryClient dcmQueryClient = (DcmQueryClient)observable;
            this.f = dcmQueryClient.getNumberOfOperations();
            observable.deleteObserver(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void e() {
            Object object = this.g;
            synchronized (object) {
                this.g.notifyAll();
            }
        }

        private void f() throws IOException {
            int n2 = 0;
            this.a(n2++, -1);
            while (!this.d()) {
                if (DicomQueryDataProvider.this.c()) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    ay.d((Object)interruptedException, a.class);
                }
            }
            while (n2 < this.f) {
                if (DicomQueryDataProvider.this.c()) {
                    return;
                }
                this.a(n2, this.f);
                ++n2;
            }
        }

        private void a(int n2, int n3) throws IOException {
            String string = this.a.readUTF();
            if (cn.h(string)) {
                throw new IOException("Did not properly read the SOP instance UID - bailing");
            }
            ay.e((Object)("Receiving " + (n2 + 1) + "/" + (n3 == -1 ? "?" : Integer.valueOf(n3)) + ": " + string), this);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                cm.a((InputStream)new j(this.a), (OutputStream)byteArrayOutputStream);
                DicomQueryDataProvider.this.d.put("" + n2, byteArrayOutputStream.toByteArray());
                this.e();
            }
        }
    }

    private static enum RetrieveState {
        a,
        b,
        c;

    }
}

