/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.archive.search;

import com.google.common.collect.Lists;
import com.healthmarketscience.rmiio.RemoteInputStream;
import com.healthmarketscience.rmiio.RemoteInputStreamClient;
import com.healthmarketscience.rmiio.RemoteOutputStream;
import com.healthmarketscience.rmiio.RemoteOutputStreamClient;
import com.mimvista.archive.gui.AbstractSeriesPanel;
import com.mimvista.archive.gui.SeriesColumnEnum;
import com.mimvista.archive.gui.StudyGroupingType;
import com.mimvista.archive.gui.z;
import com.mimvista.archive.remote.MIMRemoteInputStream;
import com.mimvista.archive.remote.MIMpacsConfig;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.archive.remote.RemoteListId;
import com.mimvista.archive.remote.RemoteObjectInfo;
import com.mimvista.archive.remote.RemotePatientListInfo;
import com.mimvista.archive.remote.RemoteQueryServer;
import com.mimvista.archive.remote.RemoteServerId;
import com.mimvista.archive.remote.TransferedFile;
import com.mimvista.archive.remote.c;
import com.mimvista.archive.remote.j;
import com.mimvista.archive.search.AbstractRemoteSearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.d;
import com.mimvista.archive.search.f;
import com.mimvista.archive.search.i;
import com.mimvista.archive.search.pro.p;
import com.mimvista.automator.credentials.AutomatorCredentialsManager;
import com.mimvista.automator.credentials.b;
import com.mimvista.automator.message.SeriesDeleteHappenedMessage;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.factories.DcmSeriesFactory;
import com.mimvista.dicom.factories.DcmStudyFactory;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.license.g;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.metabase.n;
import com.mimvista.metabase.s;
import com.mimvista.preferencesNew.ArchivePrefs;
import com.mimvista.preferencesNew.MimpacsPrefs;
import com.mimvista.preferencesNew.TestingPrefs;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.update.VersionNumber;
import com.mimvista.user.CookieBox;
import com.mimvista.user.LoginChecker;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.bg;
import com.mimvista.util.cb;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.progress.o;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;

public class RemoteSearchSource
extends AbstractRemoteSearchSource {
    private static final long serialVersionUID = 3622187385364758055L;
    private String versionString;
    private CookieBox authServerCookie;
    RemotePatientListInfo remote;
    boolean useGetFileLegacy = Boolean.getBoolean("mimpacs.legacy");
    private Boolean cachedIsLocal = null;
    private String hostBackup;

    public RemoteSearchSource(RemotePatientListInfo remotePatientListInfo) {
        b b2;
        this.remote = remotePatientListInfo;
        this.sourceName = remotePatientListInfo.d() + " (" + remotePatientListInfo.k() + ")";
        this.type = 2;
        if (j.a() && (b2 = AutomatorCredentialsManager.a().c(this.i())) != null) {
            this.authServerCookie = AutomatorCredentialsManager.a(b2, remotePatientListInfo.h(), remotePatientListInfo.i());
        }
        this.h = new p(this, new RemoteListId(new RemoteServerId(remotePatientListInfo.h(), remotePatientListInfo.i()), remotePatientListInfo.k()), this.B());
    }

    @Override
    public String b() {
        if (this.versionString == null) {
            String string = this.remote.a();
            if (string != null && !string.isEmpty()) {
                string = new VersionNumber(string).toString();
            } else if (string != null) {
                string = "< 5.0.0";
            }
            if ("5.0.0".equals(string)) {
                string = "5.0.0 - 5.4.x";
            }
            this.versionString = string;
        }
        return super.b() + (this.versionString == null ? "" : " - " + this.versionString);
    }

    @Override
    public String t() {
        return this.y().k();
    }

    @Override
    public boolean w() {
        return super.w() && !this.remote.e();
    }

    @Override
    public boolean b_() {
        return true;
    }

    @Override
    public String x() {
        return this.remote.k();
    }

    public RemotePatientListInfo y() {
        return this.remote;
    }

    @Override
    public boolean z() {
        return this.remote.f();
    }

    public List<String> A() {
        return this.remote.g();
    }

    public void a(CookieBox cookieBox) {
        this.authServerCookie = cookieBox;
    }

    public CookieBox B() {
        if (this.authServerCookie != null) {
            return this.authServerCookie;
        }
        return LoginChecker.getInstance().currentCookieBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void a(final MetabaseQuery metabaseQuery, final f<i> f2, final Searchable.a a2) {
        Object object;
        RemoteServerId remoteServerId = new RemoteServerId(this.remote.h(), this.remote.i());
        j.c().a(remoteServerId, false);
        RemoteQueryServer remoteQueryServer = this.c(f2);
        if (a2.b() || remoteQueryServer == null) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                a2.a();
            }
        };
        final Progress progress = f2.getSearchProgress();
        progress.a(actionListener);
        final AtomicReference atomicReference = new AtomicReference();
        final AtomicReference atomicReference2 = new AtomicReference();
        try {
            object = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        atomicReference2.set(RemoteSearchSource.this.a(metabaseQuery, progress, (f<i>)f2));
                    }
                    catch (Throwable throwable) {
                        atomicReference.set(throwable);
                    }
                }
            }, "Advance Remote Archive Search");
            ((Thread)object).start();
            this.a((Thread)object, f2.getSearchTimeout(), progress, a2);
            if (a2.b()) {
                progress.j();
                return;
            }
            if (atomicReference.get() != null) {
                throw new RuntimeException((Throwable)atomicReference.get());
            }
            progress.b();
        }
        finally {
            progress.b_(actionListener);
        }
        if (atomicReference2.get() == null) {
            return;
        }
        object = f2.getSearchProgress();
        object.a(actionListener);
        try {
            object.a(Messages.a("PatientList", "GROUPING_RESULTS_BY") + " " + StudyGroupingType.f().b());
            bg.b("Group and sort advance remote search results");
            List<DcmStudy> list = DcmStudyFactory.getDcmStudiesFromDcmSeries((Collection)atomicReference2.get(), (Progress)object, true, a2);
            Collections.sort(list, new com.mimvista.compare.b(1));
            bg.e("Group and sort advance remote search results");
            if (a2.b()) {
                object.j();
                return;
            }
            f2.setSearchResults(new i(list, this, Searchable.SearchType.a));
            object.b();
        }
        finally {
            object.b_(actionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void a(final Map<String, String> map, f<i> f2, final Searchable.a a2) {
        Object object;
        RemoteServerId remoteServerId = new RemoteServerId(this.remote.h(), this.remote.i());
        j.c().a(remoteServerId, false);
        RemoteQueryServer remoteQueryServer = this.c(f2);
        if (a2.b() || remoteQueryServer == null) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                a2.a();
            }
        };
        final Progress progress = f2.getSearchProgress();
        progress.a(actionListener);
        final AtomicReference atomicReference = new AtomicReference();
        final AtomicReference atomicReference2 = new AtomicReference();
        try {
            object = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        atomicReference2.set(RemoteSearchSource.this.a((Map<String, String>)map, progress));
                    }
                    catch (Throwable throwable) {
                        atomicReference.set(throwable);
                    }
                }
            }, "Remote Archive Search");
            ((Thread)object).start();
            this.a((Thread)object, f2.getSearchTimeout(), progress, a2);
            if (a2.b()) {
                progress.j();
                return;
            }
            if (atomicReference.get() != null) {
                throw new RuntimeException((Throwable)atomicReference.get());
            }
        }
        finally {
            progress.b_(actionListener);
            progress.b();
        }
        if (atomicReference2.get() == null) {
            return;
        }
        object = f2.getSearchProgress();
        object.a(actionListener);
        try {
            object.a(Messages.a("PatientList", "GROUPING_RESULTS_BY") + " " + StudyGroupingType.f().b());
            bg.b("Group and sort remote search results");
            List<DcmStudy> list = DcmStudyFactory.getDcmStudiesFromDcmSeries((Collection)atomicReference2.get(), (Progress)object, true, a2);
            Collections.sort(list, new com.mimvista.compare.b(1));
            bg.e("Group and sort remote search results");
            if (a2.b()) {
                object.j();
                return;
            }
            f2.setSearchResults(new i(list, this, Searchable.SearchType.a));
            object.b();
        }
        finally {
            object.b_(actionListener);
        }
    }

    protected List<DcmSeries> a(MetabaseQuery metabaseQuery, Progress progress, f<i> f2) {
        throw new UnsupportedOperationException(this.getClass().getName() + " do not support advance searches.");
    }

    protected List<DcmSeries> a(Map<String, String> map, Progress progress) {
        bg.b("Old-style remote search");
        c c2 = new c(this.d_().a.serverId, progress);
        c2.setCookieBox(this.B());
        List<QueryResult> list = c2.a(map, this.x());
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        for (QueryResult queryResult : list) {
            arrayList.add(DcmSeriesFactory.getDcmSeriesWithInfoAdded(this, queryResult));
        }
        bg.e("Old-style remote search");
        return arrayList;
    }

    @Override
    protected List<DcmSeries> a(Searchable.a a2, f<i> f2) {
        RemoteServerId remoteServerId = new RemoteServerId(this.remote.h(), this.remote.i());
        j.c().a(remoteServerId, false);
        if (a2.b()) {
            return null;
        }
        RemoteQueryServer remoteQueryServer = this.c(f2);
        if (a2.b() || remoteQueryServer == null) {
            return null;
        }
        try {
            List<QueryResult> list = remoteQueryServer.searchNewlyReceived(this.remote.k(), ArchivePrefs.newlyReceivedLogLimit.getValue(), this.B());
            ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
            for (QueryResult queryResult : list) {
                DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesWithInfoAdded(this, queryResult);
                dcmSeries.setSearchSource(this);
                arrayList.add(dcmSeries);
            }
            return arrayList;
        }
        catch (RemoteException remoteException) {
            ay.d((Object)"failed to get newly received series: ", (Throwable)remoteException, this);
            if (a2.b()) {
                return null;
            }
            return null;
        }
    }

    private RemoteQueryServer c(f<i> f2) {
        RemoteQueryServer remoteQueryServer = null;
        try {
            remoteQueryServer = s.a(new RemoteServerId(this.a(), MIMpacsConfig.f));
        }
        catch (MalformedURLException | NotBoundException | RemoteException exception) {
            ay.d((Object)("failed to access remote source " + this.sourceName), (Throwable)exception, this);
            String string = Messages.a("Archive", "REMOTE_SEARCH_DISABLED_ERROR");
            if (exception != null && exception instanceof RemoteException && cb.a((RemoteException)exception)) {
                string = Messages.a("Archive", "REMOTE_NEWLY_RECEIVED_SEARCH_UNSUPPORTED");
            }
            f2.setStatusMessage(string, true);
        }
        return remoteQueryServer;
    }

    public boolean C() {
        if (this.remote == null) {
            return false;
        }
        return this.remote.c();
    }

    @Override
    public LoaderDataProvider a(DcmSeries dcmSeries) {
        boolean bl2;
        boolean bl3 = bl2 = MimpacsPrefs.alwaysTreatPacsAsRemote.getValue() != false || Boolean.getBoolean("PREVENT_LOCAL_FILE_MIMPACS_ACCESS");
        if (com.mimvista.license.g.a()) {
            bl2 |= TestingPrefs.alwaysTreatPacsAsRemote.getValue().booleanValue();
        }
        if (this.C() && !bl2) {
            try {
                File file = new File(dcmSeries.getRealParentDirectory());
                if (dcmSeries.getFiles() == null) {
                    Object[] objectArray = file.listFiles();
                    if (objectArray == null) {
                        throw new FileNotFoundException("Couldn't list contents of series folder when treating pacs as a local source");
                    }
                    dcmSeries.setFiles(Lists.newArrayList((Object[])objectArray));
                }
                int n2 = 5;
                boolean bl4 = false;
                List<File> list = dcmSeries.getFiles();
                for (int i2 = 0; i2 < list.size() && i2 < 5; ++i2) {
                    File file2 = list.get(i2);
                    if (MIMFile.e(file2)) continue;
                    ay.c((Object)("Treating pacs as a remote source because we don't have permission to read the file: " + file2), this);
                    bl4 = true;
                    break;
                }
                if (!bl4) {
                    n.a().c("mimdata.folders", (Object)PathUtils.getCanonicalOrAbsolutePath(dcmSeries.getArchiveDir())).e(com.mimvista.metabase.j.a());
                    return RemoteSearchSource.c(dcmSeries);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                ay.c((Object)(fileNotFoundException.getMessage() + " - probably a permissions issue; falling back to treating pacs as a remote source"), this);
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error trying to treat pacs as a local source - falling back to treating it as a remote source", throwable, this);
            }
        }
        return new d(this, dcmSeries.getArchiveDir());
    }

    @Override
    protected void a(final SeriesParameters seriesParameters, f<i> f2) {
        final ProgressPanel progressPanel = new ProgressPanel();
        progressPanel.a(true);
        progressPanel.a(Messages.a("Archive", "REFERENCED_REMOTESEARCH"));
        ProgressQueueNotification.a(progressPanel);
        final AtomicReference atomicReference = new AtomicReference();
        final AtomicReference atomicReference2 = new AtomicReference();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ay.b((Object)("Doing remote search for : " + seriesParameters.uidList + " reqd due to " + seriesParameters.referencingFilePath), this);
                    c c2 = new c(RemoteSearchSource.this.d_().a.serverId, progressPanel);
                    c2.setCookieBox(RemoteSearchSource.this.B());
                    atomicReference2.set(c2.a(seriesParameters, RemoteSearchSource.this.y().k()));
                }
                catch (Throwable throwable) {
                    atomicReference.set(throwable);
                }
            }
        }, "Remote Archive Params Search");
        thread.start();
        this.a(thread, f2.getSearchTimeout(), progressPanel);
        if (atomicReference.get() != null) {
            throw new RuntimeException((Throwable)atomicReference.get());
        }
        List<DcmStudy> list = DcmStudyFactory.getDcmStudiesFromArchiveResults((List)atomicReference2.get(), f2.getSearchProgress(), this, false);
        progressPanel.b();
        f2.setSearchResults(new i(list, this, null));
    }

    @Override
    public String f_() {
        return "MIM_logo_network";
    }

    @Override
    public String l() {
        return Messages.a("Archive", "REMOTE_SEARCH_KEYWORDS");
    }

    @Override
    public boolean c() {
        return true;
    }

    @Override
    public boolean e() {
        return true;
    }

    @Override
    public boolean f() {
        return true;
    }

    @Override
    public boolean g() {
        return true;
    }

    @Override
    public boolean h() {
        return true;
    }

    @Override
    public String a() {
        return this.remote.h();
    }

    @Override
    public int hashCode() {
        return this.remote.h().hashCode() ^ this.j().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof RemoteSearchSource)) {
            return false;
        }
        RemoteSearchSource remoteSearchSource = (RemoteSearchSource)object;
        String string = this.remote.h();
        String string2 = remoteSearchSource.remote.h();
        String string3 = this.j();
        String string4 = remoteSearchSource.j();
        return string.equals(string2) && string3.equals(string4);
    }

    boolean D() {
        return com.mimvista.archive.remote.c.a(this.d_().a.serverId);
    }

    @Override
    public boolean a(List<DcmSeries> list) {
        return this.a(list, true);
    }

    @Override
    public boolean a(List<DcmSeries> list, boolean bl2) {
        try {
            List<DcmSeries> list2 = z.a(null, this, list, new o(), bl2);
            if (bl2) {
                for (DcmSeries dcmSeries : list2) {
                    UniqueSeriesPointer uniqueSeriesPointer = new UniqueSeriesPointer(dcmSeries.getSeriesInstanceUID(), dcmSeries.getEqualityHash());
                    SeriesDeleteHappenedMessage seriesDeleteHappenedMessage = new SeriesDeleteHappenedMessage(this, uniqueSeriesPointer, (String)dcmSeries.getTagValue(0x20000D));
                    seriesDeleteHappenedMessage.sendAsync();
                }
            }
            return list2.size() == list.size();
        }
        catch (Exception exception) {
            ay.d((Object)("cannot delete files from search source " + this.j()), (Throwable)exception, this);
            return false;
        }
    }

    @Override
    public boolean q() {
        return true;
    }

    InputStream a(String string) throws PacsIsOldAndBustedException {
        if (this.useGetFileLegacy) {
            throw new PacsIsOldAndBustedException();
        }
        RemoteQueryServer remoteQueryServer = null;
        try {
            remoteQueryServer = s.a(this);
        }
        catch (MalformedURLException malformedURLException) {
            ay.d((Object)("Failed accessing remote source " + this.sourceName), (Throwable)malformedURLException, this);
        }
        catch (RemoteException remoteException) {
            ay.d((Object)("Failed accessing remote source " + this.sourceName), (Throwable)remoteException, this);
        }
        catch (NotBoundException notBoundException) {
            ay.d((Object)("Failed accessing remote source " + this.sourceName), (Throwable)notBoundException, this);
        }
        if (remoteQueryServer == null) {
            return null;
        }
        InputStream inputStream = null;
        RemoteInputStream remoteInputStream = null;
        try {
            RemoteObjectInfo remoteObjectInfo = remoteQueryServer.getFileInputStream(this.x(), string, this.D(), this.B());
            if (remoteObjectInfo == null) {
                InputStream inputStream2 = null;
                return inputStream2;
            }
            remoteInputStream = (RemoteInputStream)remoteObjectInfo.c(this.remote.h());
            inputStream = RemoteInputStreamClient.wrap((RemoteInputStream)remoteInputStream);
            Object object = remoteObjectInfo.e();
            if (object != null && ((Boolean)object).booleanValue()) {
                inputStream = new GZIPInputStream(inputStream);
            }
        }
        catch (ServerException serverException) {
            ay.d((Object)("Failed getting file (new methods): Remote source " + this.sourceName + " is an incompatible version. Will try legacy methods."), (Throwable)serverException, this);
            this.useGetFileLegacy = true;
            throw new PacsIsOldAndBustedException();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ay.d((Object)("Failed getting file (new methods) on remote source " + this.sourceName + ", trying legacy methods just in case. File: " + string), (Throwable)exception, this);
            throw new PacsIsOldAndBustedException();
        }
        finally {
            if (inputStream == null && remoteInputStream != null) {
                try {
                    remoteInputStream.close(false);
                }
                catch (IOException iOException) {
                    ay.d((Object)("Failed closing file (new methods) on remote source " + this.sourceName + ", File: " + string), (Throwable)iOException, this);
                }
            }
        }
        return inputStream;
    }

    public long b(String string) {
        try {
            RemoteQueryServer remoteQueryServer = s.a(this);
            return remoteQueryServer.getSeriesSizeInBytes(string);
        }
        catch (Exception exception) {
            ay.d((Object)("failed getting series size at " + string + " on remote source " + this.sourceName), this);
            return -1L;
        }
    }

    String[] c(String string) {
        try {
            RemoteQueryServer remoteQueryServer = s.a(this);
            RemoteObjectInfo remoteObjectInfo = remoteQueryServer.retrieveSeries(this.x(), string, false, this.B());
            MIMRemoteInputStream mIMRemoteInputStream = (MIMRemoteInputStream)remoteObjectInfo.c(this.remote.h());
            List<TransferedFile> list = mIMRemoteInputStream.getTransferedFileList();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TransferedFile transferedFile : list) {
                arrayList.add(transferedFile.a());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (Exception exception) {
            ay.d((Object)("failed listing files at " + string + " on remote source " + this.sourceName), (Throwable)exception, this);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OutputStream d(String string) {
        RemoteQueryServer remoteQueryServer = null;
        try {
            remoteQueryServer = s.a(this);
        }
        catch (Exception exception) {
            ay.d((Object)("failed accessing remote source " + this.sourceName), (Throwable)exception, this);
        }
        if (remoteQueryServer == null) {
            return null;
        }
        OutputStream outputStream = null;
        RemoteOutputStream remoteOutputStream = null;
        try {
            RemoteObjectInfo remoteObjectInfo = remoteQueryServer.getFileOutputStream(this.x(), string, this.B());
            if (remoteObjectInfo == null) {
                OutputStream outputStream2 = null;
                return outputStream2;
            }
            remoteOutputStream = (RemoteOutputStream)remoteObjectInfo.c(this.remote.h());
            outputStream = RemoteOutputStreamClient.wrap((RemoteOutputStream)remoteOutputStream);
        }
        catch (Exception exception) {
            if (exception instanceof RemoteException && exception.getCause() instanceof AccessException) {
                ay.c((Object)"Unable to create output stream - no write access for RPL", exception.getCause(), this);
            } else {
                ay.d((Object)("failed getting output stream at " + string + " on remote source " + this.sourceName), (Throwable)exception, this);
            }
        }
        finally {
            if (outputStream == null && remoteOutputStream != null) {
                try {
                    remoteOutputStream.close(false);
                }
                catch (IOException iOException) {
                    ay.d((Object)("failed closing output stream at " + string + " on remote source " + this.sourceName), (Throwable)iOException, this);
                }
            }
        }
        return outputStream;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.remote != null) {
            this.hostBackup = this.remote.h();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.remote != null) {
            this.remote.c(this.hostBackup);
        }
        if (this.h == null) {
            this.h = new p(this, new RemoteListId(new RemoteServerId(this.remote.h(), this.remote.i()), this.remote.k()), LoginChecker.getInstance().currentCookieBox());
        }
    }

    @Override
    public String i() {
        return this.remote.toString();
    }

    @Override
    public boolean a(Iterable<DcmSeries> iterable, SeriesColumnEnum seriesColumnEnum) {
        if (seriesColumnEnum == SeriesColumnEnum.d) {
            return false;
        }
        if (seriesColumnEnum == SeriesColumnEnum.b) {
            return AbstractSeriesPanel.a(iterable);
        }
        if (seriesColumnEnum == SeriesColumnEnum.a) {
            return AbstractSeriesPanel.b(iterable);
        }
        if (seriesColumnEnum == SeriesColumnEnum.n) {
            return true;
        }
        return super.a(iterable, seriesColumnEnum);
    }

    public String toString() {
        return this.i();
    }

    static class PacsIsOldAndBustedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        PacsIsOldAndBustedException() {
        }
    }
}

