/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.atlas.command;

import com.google.common.collect.Lists;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.atlas.gui.a;
import com.mimvista.atlas.management.AtlasDBManager;
import com.mimvista.atlas.management.TemplateFile;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.MIMFeatureType;
import com.mimvista.commands.e;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.file.MIMFile;
import com.mimvista.internals.AssistedAlignmentWrapper;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.ContrastState;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.s;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.Session;
import com.mimvista.mui.ak;
import com.mimvista.mui.ao;
import com.mimvista.mui.bm;
import com.mimvista.mui.br;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.bf;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.AtlasPropPrefs;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Messages;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.progress.g;
import com.mimvista.util.progress.o;
import com.mimvista.util.state.ViewLoadState;
import com.mimvista.util.w;
import com.mimvista.util.work.m;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.JOptionPane;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;

@e(e="savetoatlas", f="savetoatlas", h="save_to_atlas", b="save_to_atlas", a="Atlas", k=MIMFeatureCategory.CONTOURING, l={MIMFeatureType.InternalWorkflow}, j={LicenseOption.BASE})
public class SaveToAtlasCommand
extends WorkflowCommand {
    private ViewController a;
    private boolean b;
    private boolean c;
    private String d;
    private Map<String, String> e;
    private Map<AbstractContourOverlayish, String> f;
    private float[] g;
    private AtlasDBManager h;
    private String i;
    private g j = new ProgressPanel();

    public SaveToAtlasCommand(ViewController viewController) {
        this.a = viewController;
        this.p = viewController.g();
    }

    @Override
    public Object execute() {
        this.getUserInput();
        if (!this.b) {
            return null;
        }
        if (this.c) {
            com.mimvista.util.work.m.e.a(new Runnable(){

                @Override
                public void run() {
                    SaveToAtlasCommand.this.saveTemplate(SaveToAtlasCommand.this.a);
                }
            }, "Save atlas template");
        } else if (this.hasUsableContours()) {
            com.mimvista.util.work.m.e.a(new Runnable(){

                @Override
                public void run() {
                    SaveToAtlasCommand.this.saveSubject(SaveToAtlasCommand.this.a);
                }
            }, "Save atlas subject");
        } else {
            JOptionPane.showMessageDialog(ao.Q().O(), Messages.a("Atlas", "SAVETO_INVALID"), Messages.a("Atlas", "SAVETO_INVALID_TITLE"), 0);
        }
        return null;
    }

    private void saveTemplate(ViewController viewController) {
        Object object;
        ProgressQueueNotification.a(this.j);
        this.j.a(Messages.a("Atlas", "SAVETO_TEMPLATE_TITLE"));
        this.j.c(false);
        this.j.a(true);
        this.j.a();
        this.j.b_(Messages.a("Atlas", "SAVETO_TEMPLATE"));
        int[] nArray = viewController.ay();
        float[] fArray = viewController.ao_();
        ImageVolumeShort imageVolumeShort = (ImageVolumeShort)viewController.aw();
        ImageCube.ImageCubeShort imageCubeShort = (ImageCube.ImageCubeShort)imageVolumeShort.ad();
        if (!MathUtils.b(this.g, fArray, 0.001f)) {
            object = new bf(viewController.ay(), viewController.ao_(), this.g);
            imageCubeShort = bf.a(imageCubeShort, (bf)object);
            nArray = imageCubeShort.d();
            fArray = this.g;
        }
        object = new short[nArray[0]][nArray[1]][nArray[2]];
        for (int i2 = 0; i2 < nArray[0]; ++i2) {
            for (int i3 = 0; i3 < nArray[1]; ++i3) {
                for (int i4 = 0; i4 < nArray[2]; ++i4) {
                    object[i2][i3][i4] = (short)imageVolumeShort.b(imageCubeShort.b(i2, i3, i4));
                }
            }
        }
        TemplateFile templateFile = new TemplateFile(new File(this.d, "atlas_vol.dat").getAbsolutePath());
        templateFile.saveToTemplate(object, "0");
        templateFile.closeWritingStream();
        TemplateFile templateFile2 = new TemplateFile(new File(this.d, "atlas_vox.dat").getAbsolutePath());
        templateFile2.saveToTemplate(fArray, "0");
        templateFile2.closeWritingStream();
        ContrastState contrastState = viewController.av();
        TemplateFile templateFile3 = new TemplateFile(new File(this.d, "atlas_wl.dat").getAbsolutePath());
        templateFile3.saveToTemplate(new float[]{contrastState.h(), contrastState.c()}, "0");
        templateFile3.closeWritingStream();
        this.j.a(false);
        this.j.b_(Messages.a("Atlas", "SAVETO_REREGISTER"));
        this.h.c("maintemplate", "Modality", viewController.getModality());
        this.h.c("maintemplate", "Units", viewController.getUncopiedMutableInfo().u().y());
        this.reRegisterAtlasDB();
        this.j.b();
        JOptionPane.showMessageDialog(ao.Q().O(), Messages.a("Atlas", "SAVETO_SUCCESS"), Messages.a("Atlas", "SAVETO_COMPLETED"), 1);
    }

    private void reRegisterAtlasDB() {
        String[] stringArray = this.h.o();
        Session session = bm.g();
        if (stringArray != null && stringArray.length > 0) {
            this.j.a(stringArray.length);
            this.j.b(0);
            ViewController viewController = this.h.a(session);
            try {
                MIMFile.a(new MIMFile(this.d, "dbFeature.xml"), new MIMFile(this.d, "dbFeature_old.xml"));
                this.h.l();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            for (String string : stringArray) {
                ViewController viewController2 = this.h.a(string, session, false);
                s s2 = new s(viewController, viewController2);
                this.i = string;
                this.registerAndSaveSubject(s2, false);
                if (this.h.q()) {
                    ((ImageCube.ImageCubeShort)((SimpleImageVolume)((Object)viewController2.aw())).ad()).l();
                    this.registerAndSaveSubject(s2, true);
                    ((ImageCube.ImageCubeShort)((SimpleImageVolume)((Object)viewController2.aw())).ad()).l();
                }
                viewController.bO().b(viewController.bO().a(s2));
                viewController.bO().b(viewController.bO().a(viewController2));
                s2.ac();
                viewController2.ac();
                this.h.i(string);
                this.j.N_();
            }
            viewController.ac();
        }
    }

    private void saveSubject(ViewController viewController) {
        Object object;
        ProgressQueueNotification.a(this.j);
        this.j.a(Messages.a("Atlas", "SAVETO_TITLE"));
        this.j.b_(Messages.a("Atlas", "SAVETO_CONTOURS"));
        this.j.c(true);
        this.j.a(true);
        this.j.a();
        this.i = UIDGenerator.generateUID().replace('.', '_');
        int[] nArray = this.getLargestMultiplier();
        int[] nArray2 = new int[]{1, 1, 1};
        List<String[]> list = this.saveContourData(viewController, nArray);
        if (!Arrays.equals(nArray, nArray2)) {
            this.saveContourData(viewController, nArray2);
        }
        if (this.j.n() == Progress.Status.e) {
            this.h.f(this.i);
            return;
        }
        String[][] stringArray = new String[3][list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object = list.get(i2);
            stringArray[0][i2] = object[0];
            stringArray[1][i2] = object[1];
            stringArray[2][i2] = object[2];
        }
        this.j.b_(Messages.a("Atlas", "SAVETO_REGISTER_SAVE"));
        Session session = bm.a(viewController.g());
        object = this.h.a(session);
        ViewController3D viewController3D = w.a(session, (ViewController3D)viewController, false);
        s s2 = new s((ViewController)object, viewController3D);
        this.registerAndSaveSubject(s2, false);
        if (this.j.n() == Progress.Status.e) {
            this.h.f(this.i);
            return;
        }
        if (this.h.q()) {
            ((ImageCube.ImageCubeShort)viewController3D.cw().ad()).l();
            this.registerAndSaveSubject(s2, true);
            ((ImageCube.ImageCubeShort)viewController3D.cw().ad()).l();
            if (this.j.n() == Progress.Status.e) {
                this.h.f(this.i);
                return;
            }
        }
        this.saveOriginalVolumeData(viewController);
        this.j.b_(Messages.a("Atlas", "SAVETO_UPDATE"));
        this.h.b(this.i, stringArray);
        this.h.c(this.i, "Modality", viewController.getModality());
        this.h.c(this.i, "Units", viewController.getUncopiedMutableInfo().u().y());
        this.j.b();
        JOptionPane.showMessageDialog(ao.Q().O(), Messages.a("Atlas", "SAVETO_SUCCESS"), Messages.a("Atlas", "SAVETO_COMPLETED"), 1);
    }

    private int[] getLargestMultiplier() {
        int[] nArray = new int[]{1, 1, 1};
        for (AbstractContourOverlayish abstractContourOverlayish : this.f.keySet()) {
            if (!abstractContourOverlayish.bO_() || !abstractContourOverlayish.w()) continue;
            int[] nArray2 = abstractContourOverlayish.G().aq().v();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray2[i2] <= nArray[i2]) continue;
                nArray[i2] = nArray2[i2];
            }
        }
        return nArray;
    }

    private List<String[]> saveContourData(ViewController viewController, int[] nArray) {
        boolean bl2 = Arrays.equals(nArray, new int[]{1, 1, 1});
        int n2 = 0;
        int n3 = 0;
        final int[] nArray2 = MathUtils.c(viewController.ay(), nArray);
        short[][][] sArray = new short[nArray2[0]][nArray2[1]][nArray2[2]];
        ArrayList arrayList = Lists.newArrayList();
        for (AbstractContourOverlayish abstractContourOverlayish : this.f.keySet()) {
            if (this.j.n() == Progress.Status.e) {
                this.h.f(this.i);
                return arrayList;
            }
            final int n4 = 1 << n3;
            final short[][][] sArray2 = sArray;
            if (!abstractContourOverlayish.bO_() || !abstractContourOverlayish.w()) continue;
            String[] stringArray = new String[3];
            Contour contour = abstractContourOverlayish.G().aq().b(nArray);
            final Map<Integer, ContourSlice> map = contour.x();
            final ArrayList<Integer> arrayList2 = new ArrayList<Integer>(map.keySet());
            FuncUtils.a((ThreadPoolExecutor)com.mimvista.util.work.m.c, arrayList2.size(), new FuncUtils.aa(){

                @Override
                public void f(int n2, int n3) throws FuncUtils.MIMInterruptedException {
                    int n42 = (Integer)arrayList2.get(n2);
                    ContourSlice contourSlice = (ContourSlice)map.get(n42);
                    for (int i2 = 0; i2 < nArray2[1]; ++i2) {
                        ContourSlice.ScanLine scanLine = contourSlice.c((short)i2);
                        for (int i3 = 0; i3 < nArray2[0]; ++i3) {
                            if (!scanLine.a(i3)) continue;
                            sArray2[i3][i2][n42] = (short)(sArray2[i3][i2][n42] | n4);
                        }
                    }
                }
            });
            stringArray[0] = this.f.get(abstractContourOverlayish);
            stringArray[1] = String.valueOf(n2);
            stringArray[2] = String.valueOf(n3);
            arrayList.add(stringArray);
            if ((n3 = (n3 + 1) % 16) != 0) continue;
            TemplateFile templateFile = new TemplateFile(new File(this.d, this.i + "_roi_" + n2 + (bl2 ? ".dat" : "_hires.dat")).getAbsolutePath());
            templateFile.saveToTemplate(sArray, "0");
            templateFile.closeWritingStream();
            sArray = new short[nArray2[0]][nArray2[1]][nArray2[2]];
            ++n2;
        }
        if (n3 != 0) {
            TemplateFile templateFile = new TemplateFile(new File(this.d, this.i + "_roi_" + n2 + (bl2 ? ".dat" : "_hires.dat")).getAbsolutePath());
            templateFile.saveToTemplate(sArray, "0");
            templateFile.closeWritingStream();
        }
        return arrayList;
    }

    private void saveOriginalVolumeData(ViewController viewController) {
        int[] nArray = viewController.ay();
        this.j.b_(Messages.a("Atlas", "SAVETO_ORIGINAL"));
        TemplateFile templateFile = new TemplateFile(new File(this.d, this.i + "_origvol.dat").getAbsolutePath());
        templateFile.saveToTemplate(nArray, "size");
        ImageCube.ImageCubeShort imageCubeShort = (ImageCube.ImageCubeShort)((ViewController3D)viewController).cw().ad();
        for (int i2 = 0; i2 < nArray[2]; ++i2) {
            short[][] sArray = new short[nArray[0]][nArray[1]];
            for (int i3 = 0; i3 < nArray[0]; ++i3) {
                for (int i4 = 0; i4 < nArray[1]; ++i4) {
                    sArray[i3][i4] = (short)((SimpleImageVolume)((Object)viewController.aw())).b(imageCubeShort.b(i3, i4, i2));
                }
            }
            templateFile.saveToTemplate(sArray, String.valueOf(i2));
        }
        templateFile.closeWritingStream();
        if (this.j.n() == Progress.Status.e) {
            this.h.f(this.i);
            return;
        }
        TemplateFile templateFile2 = new TemplateFile(new File(this.d, this.i + "_origvox.dat").getAbsolutePath());
        templateFile2.saveToTemplate(viewController.ao_(), "0");
        templateFile2.closeWritingStream();
    }

    private void registerAndSaveSubject(s s2, boolean bl2) {
        Object object;
        Object object2;
        Matrix4f matrix4f = this.linearRegister(s2);
        matrix4f.invert();
        ImageVolumeShort imageVolumeShort = s2.cw();
        ImageVolumeShort imageVolumeShort2 = s2.C();
        int[] nArray = imageVolumeShort.a();
        short[][][] sArray = new short[nArray[0]][nArray[1]][nArray[2]];
        float f2 = s2.av().c();
        float f3 = s2.av().h();
        float f4 = f2 - f3 / 2.0f;
        float f5 = f2 + f3 / 2.0f;
        for (int i2 = 0; i2 < nArray[0]; ++i2) {
            for (int i3 = 0; i3 < nArray[1]; ++i3) {
                for (int i4 = 0; i4 < nArray[2]; ++i4) {
                    object2 = new VoxelIndexPoint3f((float)i2, (float)i3, (float)i4, imageVolumeShort).d();
                    matrix4f.transform((Point3f)object2);
                    object = ((MetricPoint3f)((Object)object2)).a(imageVolumeShort2);
                    float f6 = imageVolumeShort2.a(((VoxelPoint3f)((Object)object)).x, ((VoxelPoint3f)((Object)object)).y, ((VoxelPoint3f)((Object)object)).z, imageVolumeShort2.ah());
                    f6 = imageVolumeShort2.b((int)f6);
                    f6 = MathUtils.c(f6, f4, f5);
                    sArray[i2][i3][i4] = (short)((double)(f6 - f4) * 255.9999 / (double)f3);
                }
            }
        }
        object2 = bl2 ? ".mir" : "";
        object = new TemplateFile(new File(this.d, this.i + "_bytsclvol.dat" + (String)object2).getAbsolutePath());
        object.saveToTemplate(sArray, "0");
        object.closeWritingStream();
        TemplateFile templateFile = new TemplateFile(new File(this.d, this.i + "_bytsclvox.dat" + (String)object2).getAbsolutePath());
        templateFile.saveToTemplate(s2.cw().b(), "0");
        templateFile.closeWritingStream();
        TemplateFile templateFile2 = new TemplateFile(new File(this.d, this.i + "_bytsclwl.dat" + (String)object2).getAbsolutePath());
        templateFile2.saveToTemplate(new float[]{f3, f2}, "0");
        templateFile2.closeWritingStream();
        double[][] dArrayArray = new double[][]{{matrix4f.m00, matrix4f.m10, matrix4f.m20, matrix4f.m30}, {matrix4f.m01, matrix4f.m11, matrix4f.m21, matrix4f.m31}, {matrix4f.m02, matrix4f.m12, matrix4f.m22, matrix4f.m32}, {matrix4f.m03, matrix4f.m13, matrix4f.m23, matrix4f.m33}};
        TemplateFile templateFile3 = new TemplateFile(new File(this.d, this.i + "_bytsclmatrix.dat" + (String)object2).getAbsolutePath());
        templateFile3.saveToTemplate(dArrayArray, "0");
        templateFile3.closeWritingStream();
    }

    private Matrix4f linearRegister(s s2) {
        s2.V().g().a((ViewController)s2, (ViewLoadState)null);
        s2.a(true);
        s2.Z();
        Matrix4f matrix4f = AssistedAlignmentWrapper.a().a(s2, com.mimvista.util.progress.o.o(), AssistedAlignmentWrapper.StudyType.d);
        if (matrix4f != null) {
            s2.a(matrix4f);
        }
        if (AtlasPropPrefs.alwaysShowSaveSubjectStepin.getValue().booleanValue() && !MIMContext.P() && !this.a.g().T()) {
            br br2 = new br(this.a.g(), s2);
            final Matrix4f[] matrix4fArray = new Matrix4f[]{null};
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            FuncUtils.m<Matrix4f> m2 = new FuncUtils.m<Matrix4f>(){

                public void a(Matrix4f matrix4f) {
                    matrix4fArray[0] = matrix4f;
                    countDownLatch.countDown();
                }

                @Override
                public /* synthetic */ void doIt(Object object) {
                    this.a((Matrix4f)object);
                }
            };
            br2.a(m2, "Adding atlas subject");
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (matrix4fArray[0] != null) {
                matrix4f = matrix4fArray[0];
            }
        }
        return matrix4f;
    }

    private boolean hasUsableContours() {
        if (this.f != null) {
            for (AbstractContourOverlayish abstractContourOverlayish : this.f.keySet()) {
                if (!abstractContourOverlayish.bO_()) continue;
                return true;
            }
        }
        return false;
    }

    private void getUserInput() {
        a a2 = new a(ak.b().O(), this.a.aw());
        a2.g();
        this.b = a2.f();
        if (this.b) {
            this.c = a2.a();
            this.d = a2.d();
            this.h = new AtlasDBManager(this.d);
            if (this.c) {
                this.g = a2.e();
            } else {
                this.e = a2.b();
                this.f = a2.c();
                this.h.a(this.e);
            }
        }
    }
}

