/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.atlas.management;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mimvista.atlas.command.AtlasSegmentation;
import com.mimvista.atlas.gui.DBSetupDialog;
import com.mimvista.atlas.management.TemplateFile;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.file.FileChecksum;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.install.EulaDisplayer;
import com.mimvista.install.MimInstaller;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ContrastState;
import com.mimvista.internals.EditTargetInfo;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ViewControllerFactory;
import com.mimvista.internals.s;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.Session;
import com.mimvista.mui.ak;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.mui.overlays.f;
import com.mimvista.mui.overlays.h;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.bg;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.AtlasAgreementPrefs;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.preferencesNew.cascade.c;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.update.VersionNumber;
import com.mimvista.user.LoginChecker;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.XMLUtils;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import com.mimvista.util.state.ViewLoadState;
import com.mimvista.util.work.m;
import com.mimvista.viewer.ColorTableFactory;
import com.mimvista.viewer.SeriesInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.server.UID;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AtlasDBManager {
    public static Messages a = Messages.a("Atlas");
    public static final String b = "dbList.xml";
    public static final String c = "dbFeature.xml";
    public static final String d = "contourList.xml";
    private String e;
    private String[] f = null;
    private String g = "";
    private Document h;
    private boolean i = true;
    private Map<String, String> j = null;

    public static File a() {
        File file = com.mimvista.preferencesNew.cascade.c.e().a(CascadeSubfolder.a, "atlases.xml");
        if (file == null) {
            file = AtlasDBManager.b();
        }
        return file;
    }

    public static File b() {
        return com.mimvista.preferencesNew.cascade.c.e().b(CascadeSubfolder.a, "atlases.xml");
    }

    public static void main(String[] stringArray) {
        System.exit(0);
    }

    public static String a(File file, String string, String string2, String string3, String string4, String string5, String string6, boolean bl2, boolean bl3) throws Exception {
        try {
            Object object;
            Object object2;
            Document document;
            File file2 = new File(string2);
            if (!file2.exists()) {
                file2.mkdir();
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (bl3) {
                document = documentBuilder.newDocument();
                document.appendChild(document.createElement("contours"));
                XMLUtils.a(document, new File(string2, d).getAbsolutePath());
                document = documentBuilder.newDocument();
                document.appendChild(document.createElement("feature"));
                XMLUtils.a(document, new File(string2, c).getAbsolutePath());
                document = documentBuilder.newDocument();
                document.appendChild(document.createElement("list"));
                document.getDocumentElement().setAttribute("mirror", String.valueOf(bl2));
                object2 = document.getDocumentElement().appendChild(document.createElement("maintemplate"));
                object2.appendChild(document.createElement("filename")).setTextContent("atlas");
                XMLUtils.a(document, new File(string2, b).getAbsolutePath());
            }
            if (string3.equalsIgnoreCase("no template")) {
                object2 = new AtlasDBManager(string2);
                ((AtlasDBManager)object2).m("");
            } else if (string3.endsWith("(system)")) {
                object2 = string3.substring(0, string3.length() - 8).trim();
                object = new AtlasDBManager(string2);
                ((AtlasDBManager)object).m((String)object2);
            }
            document = documentBuilder.parse(file);
            object2 = (Element)document.getDocumentElement().appendChild(document.createElement("atlas"));
            object2.setAttribute("name", string);
            object2.setAttribute("location", string2);
            object2.setAttribute("created_by", string4);
            object2.setAttribute("create_time", string5);
            object2.setAttribute("notes", string6);
            object = new UID().toString();
            object2.setAttribute("uid", (String)object);
            XMLUtils.a(document, file.getAbsolutePath());
            return object;
        }
        catch (Exception exception) {
            ay.d((Object)exception, AtlasDBManager.class);
            throw exception;
        }
    }

    public static NamedNodeMap a(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(AtlasDBManager.a());
            String string2 = "//atlases/atlas[@uid=\"" + string + "\"]";
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string2);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                return nodeList.item(0).getAttributes();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        return null;
    }

    public static void a(String string, String string2, String string3) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(AtlasDBManager.a());
            String string4 = "//atlases/atlas[@uid=\"" + string + "\"]";
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string4);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                ((Element)nodeList.item(0)).setAttribute("name", string2);
                ((Element)nodeList.item(0)).setAttribute("notes", string3);
                XMLUtils.a(document, AtlasDBManager.b().getAbsolutePath());
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, AtlasDBManager.class);
        }
    }

    public static void b(String string) throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(AtlasDBManager.a());
            String string2 = "//atlases/atlas[@uid=\"" + string + "\"]";
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string2);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                document.getDocumentElement().removeChild(nodeList.item(0));
                XMLUtils.a(document, AtlasDBManager.b().getAbsolutePath());
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, AtlasDBManager.class);
            throw exception;
        }
    }

    public static boolean c() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.appendChild(document.createElement("atlases"));
            XMLUtils.a(document, AtlasDBManager.b().getAbsolutePath());
            return true;
        }
        catch (Exception exception) {
            ay.d((Object)exception, AtlasDBManager.class);
            return false;
        }
    }

    public static AtlasDBManager c(String string) {
        AtlasDBManager atlasDBManager = null;
        for (AtlasDBManager atlasDBManager2 : AtlasDBManager.d()) {
            if (!atlasDBManager2.g().contains(string)) continue;
            atlasDBManager = atlasDBManager2;
            break;
        }
        return atlasDBManager;
    }

    public static List<AtlasDBManager> d() {
        List<Map<String, String>> list = AtlasDBManager.e();
        ArrayList arrayList = Lists.newArrayList();
        for (Map<String, String> map : list) {
            arrayList.add(new AtlasDBManager(map.get("path")));
        }
        return arrayList;
    }

    public static List<Map<String, String>> e() {
        ArrayList<Map<String, String>> arrayList;
        block16: {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            arrayList = new ArrayList<Map<String, String>>();
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(AtlasDBManager.a());
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                XPathExpression xPathExpression = xPath.compile("//atlases/atlas");
                NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
                if (nodeList.getLength() <= 0) break block16;
                for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Node node;
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    NamedNodeMap namedNodeMap = nodeList.item(i2).getAttributes();
                    Node node2 = namedNodeMap.getNamedItem("name");
                    if (node2 != null) {
                        hashMap.put("name", node2.getNodeValue());
                    }
                    if ((node = namedNodeMap.getNamedItem("location")) != null) {
                        hashMap.put("path", node.getNodeValue());
                    }
                    if (node != null && AtlasDBManager.d(node.getNodeValue())) {
                        hashMap.put("subjects", "N/A");
                        hashMap.put("mirror", "N/A");
                        hashMap.put("editable", "N/A");
                        hashMap.put("version", "N/A");
                    } else {
                        try {
                            object4 = new AtlasDBManager((String)hashMap.get("path"));
                            hashMap.put("mirror", ((AtlasDBManager)object4).q() ? "Y" : "N");
                            object3 = ((AtlasDBManager)object4).o();
                            if (object3 == null) {
                                hashMap.put("subjects", "0");
                            } else {
                                hashMap.put("subjects", String.valueOf(((String[])object3).length));
                            }
                            hashMap.put("editable", ((AtlasDBManager)object4).t() ? "No" : "Yes");
                            hashMap.put("version", ((AtlasDBManager)object4).u());
                        }
                        catch (Exception exception) {
                            hashMap.put("subjects", "N/A");
                            hashMap.put("mirror", "N/A");
                            hashMap.put("editable", "N/A");
                            hashMap.put("version", "N/A");
                        }
                    }
                    object4 = namedNodeMap.getNamedItem("created_by");
                    if (object4 != null) {
                        hashMap.put("creator", object4.getNodeValue());
                    }
                    if (((File)(object3 = new File((String)hashMap.get("path")))).exists()) {
                        object2 = new SimpleDateFormat(DateUtils.b() + " 'at' HH:mm");
                        object = ((DateFormat)object2).format(new Date(((File)object3).lastModified()));
                        hashMap.put("date modified", object);
                    } else {
                        hashMap.put("date modified", "N/A");
                    }
                    object2 = namedNodeMap.getNamedItem("create_time");
                    if (object2 != null) {
                        object = object2.getNodeValue();
                        hashMap.put("date created", object);
                    }
                    if ((object = namedNodeMap.getNamedItem("uid")) != null) {
                        hashMap.put("uid", object.getNodeValue());
                    }
                    arrayList.add(hashMap);
                }
            }
            catch (Exception exception) {
                ay.d((Object)exception, AtlasDBManager.class);
            }
        }
        return arrayList;
    }

    public static List<NamedNodeMap> f() {
        ArrayList<NamedNodeMap> arrayList = new ArrayList<NamedNodeMap>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(AtlasDBManager.a());
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile("//atlases/atlas");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                arrayList.add(nodeList.item(i2).getAttributes());
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ay.d((Object)"Failed to acquire atlas information", (Throwable)parserConfigurationException, AtlasDBManager.class);
        }
        catch (SAXException sAXException) {
            ay.d((Object)"Failed to acquire atlas information", (Throwable)sAXException, AtlasDBManager.class);
        }
        catch (IOException iOException) {
            ay.d((Object)"Failed to acquire atlas information", (Throwable)iOException, AtlasDBManager.class);
        }
        catch (XPathExpressionException xPathExpressionException) {
            ay.d((Object)"Failed to acquire atlas information", (Throwable)xPathExpressionException, AtlasDBManager.class);
        }
        return arrayList;
    }

    public static boolean d(String string) {
        File file = new File(string);
        File file2 = new File(string, b);
        File file3 = new File(string, c);
        File file4 = new File(string, d);
        return !file.exists() || !file2.exists() || !file3.exists() || !file4.exists();
    }

    public static void a(ViewController viewController) {
        AtlasDBManager.a(viewController, "ATLASDBM_RESAVE_WARNING");
    }

    public static void b(ViewController viewController) {
        AtlasDBManager.a(viewController, "ATLASDBM_DERIVE_WARNING");
    }

    public static void c(ViewController viewController) {
        AtlasDBManager.a(viewController, "ATLASDBM_FUSION_WARNING");
    }

    private static void a(ViewController viewController, String string) {
        BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.a, a.b(string), new Notification.a(viewController), Notification.NotificationTimeoutType.b, 5000L);
        u.b().c(basicNotification);
    }

    public static boolean d(ViewController viewController) {
        if (viewController.aw() == null) {
            return false;
        }
        if (viewController instanceof ViewController3D) {
            if (viewController instanceof s) {
                ImageVolumeShort imageVolumeShort = ((s)viewController).cw();
                ImageVolumeShort imageVolumeShort2 = ((s)viewController).C();
                return imageVolumeShort.ak() || imageVolumeShort2.ak();
            }
            ImageVolumeShort imageVolumeShort = ((ViewController3D)viewController).cw();
            return imageVolumeShort.ak();
        }
        return false;
    }

    public static boolean e(ViewController viewController) {
        if (viewController instanceof ViewController3D) {
            if (viewController instanceof s) {
                ImageVolumeShort imageVolumeShort = ((s)viewController).cw();
                ImageVolumeShort imageVolumeShort2 = ((s)viewController).C();
                return imageVolumeShort.am() || imageVolumeShort2.am();
            }
            ImageVolumeShort imageVolumeShort = ((ViewController3D)viewController).cw();
            return imageVolumeShort.am();
        }
        return false;
    }

    public static boolean a(boolean bl2) {
        if (AtlasDBManager.b(bl2)) {
            return true;
        }
        EulaDisplayer eulaDisplayer = new EulaDisplayer();
        eulaDisplayer.setTitleString(a.getProperty("ATLAS_EULA"));
        if (eulaDisplayer.showLicenseFromResource(ak.b().O(), a.getProperty("ATLAS_DECLINE"), "/eulas/atlas_license.html", new FuncUtils.f())) {
            AtlasAgreementPrefs.mimVersion.setValue(MimInstaller.getVersion());
            if (LoginChecker.shouldTreatUserAndSystemConfigsTheSame() || LoginChecker.isCurrentUserAdmin()) {
                AtlasAgreementPrefs.assistantVersion.setValue(MimInstaller.getVersion());
            }
            return true;
        }
        return false;
    }

    public static boolean b(boolean bl2) {
        if (bl2) {
            return AtlasAgreementPrefs.assistantVersion.getValue().equalsIgnoreCase(MimInstaller.getVersion());
        }
        return AtlasAgreementPrefs.mimVersion.getValue().equalsIgnoreCase(MimInstaller.getVersion());
    }

    public AtlasDBManager(String string) {
        try {
            this.c(string, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public AtlasDBManager(String string, boolean bl2) throws IOException {
        this.c(string, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void c(String string, boolean bl2) throws IOException {
        System.out.println("Managing atlas at " + string);
        ay.b((Object)"AtlasDBManager is created.", this);
        this.e = string;
        if (!AtlasDBManager.d(string)) {
            File file = new File(string, b);
            this.a(file);
            return;
        }
        if (bl2) {
            String string2 = a.getProperty("ATLASDBM_DB_CORRUPT");
            String string3 = a.getProperty("ATLASDBM_DB_CORRUPT_TITLE");
            int n2 = JOptionPane.showOptionDialog(null, string2, string3, 0, 0, null, new String[]{"Yes", "No"}, "No");
            if (n2 != 0) return;
            this.h();
            return;
        }
        ay.d((Object)"AtlasDB is corrupted", this);
        throw new IOException("AtlasDB is corrupted");
    }

    public String g() {
        return this.e;
    }

    public void h() {
        DBSetupDialog dBSetupDialog = new DBSetupDialog(null);
        dBSetupDialog.showDialog("Setup Atlas Database", true);
    }

    public void a(Map<String, String> map) {
        this.j = map;
    }

    public boolean a(String string, String[] stringArray) {
        String[] stringArray2 = this.j(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        for (String string2 : stringArray2) {
            if (!arrayList.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public void a(String string, String string2, String string3, String[][] stringArray) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(string, b));
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String string4 = "//list/templatefile[filename=\"" + string2 + "\"]";
            XPathExpression xPathExpression = xPath.compile(string4);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                Object object;
                int n2;
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                ArrayList<String> arrayList3 = new ArrayList<String>();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    arrayList.add(stringArray[i2][0]);
                    arrayList2.add(stringArray[i2][1]);
                }
                Node node = nodeList.item(0).cloneNode(true);
                NodeList nodeList2 = node.getChildNodes();
                for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
                    if (nodeList2.item(n2).getNodeName().compareToIgnoreCase("filename") == 0) {
                        nodeList2.item(n2).setTextContent(string3);
                        continue;
                    }
                    if (nodeList2.item(n2).getNodeName().compareToIgnoreCase("roi") != 0) continue;
                    object = nodeList2.item(n2).getTextContent();
                    if (arrayList.contains(object)) {
                        int n3 = arrayList.indexOf(object);
                        nodeList2.item(n2).setTextContent((String)arrayList2.get(n3));
                        this.h((String)arrayList2.get(n3));
                        String string5 = nodeList2.item(n2).getAttributes().getNamedItem("file_num").getNodeValue();
                        if (arrayList3.contains(string5)) continue;
                        arrayList3.add(string5);
                        continue;
                    }
                    node.removeChild(nodeList2.item(n2));
                }
                for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                    object = new MIMFile(string, string2 + "_roi_" + String.valueOf(arrayList3.get(n2)) + "_hires.dat");
                    if (object.exists()) {
                        MIMFile.a((MIMFile)object, new MIMFile(this.e, string3 + "_roi_" + String.valueOf(arrayList3.get(n2)) + "_hires.dat"));
                    }
                    MIMFile.a(new MIMFile(string, string2 + "_roi_" + String.valueOf(arrayList3.get(n2)) + ".dat"), new MIMFile(this.e, string3 + "_roi_" + String.valueOf(arrayList3.get(n2)) + ".dat"));
                }
                this.h.getDocumentElement().appendChild(this.h.importNode(node, true));
                XMLUtils.a(this.h, new File(this.e, b).getAbsolutePath());
                n2 = this.f.length;
                object = new String[n2 + 1];
                System.arraycopy(this.f, 0, object, 0, n2);
                object[n2] = string3;
                this.f = object;
                this.i(string3);
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
    }

    public void i() {
        MIMFile mIMFile = new MIMFile(this.e, b);
        MIMFile mIMFile2 = new MIMFile(this.e, "dbList.xml.bk");
        MIMFile mIMFile3 = new MIMFile(this.e, c);
        MIMFile mIMFile4 = new MIMFile(this.e, "dbFeature.xml.bk");
        MIMFile mIMFile5 = new MIMFile(this.e, d);
        MIMFile mIMFile6 = new MIMFile(this.e, "contourList.xml.bk");
        try {
            MIMFile.a(mIMFile, mIMFile2);
            MIMFile.a(mIMFile3, mIMFile4);
            MIMFile.a(mIMFile5, mIMFile6);
        }
        catch (Exception exception) {
            ay.d((Object)exception.getMessage(), (Throwable)exception, this);
            mIMFile2.delete();
            mIMFile4.delete();
            mIMFile6.delete();
        }
    }

    public void e(String string) {
        MIMFile mIMFile = new MIMFile(this.e, b);
        MIMFile mIMFile2 = new MIMFile(this.e, "dbList.xml.bk");
        MIMFile mIMFile3 = new MIMFile(this.e, c);
        MIMFile mIMFile4 = new MIMFile(this.e, "dbFeature.xml.bk");
        MIMFile mIMFile5 = new MIMFile(this.e, d);
        MIMFile mIMFile6 = new MIMFile(this.e, "contourList.xml.bk");
        if (mIMFile2.exists() && mIMFile4.exists() && mIMFile6.exists()) {
            try {
                File[] fileArray;
                MIMFile.a(mIMFile2, mIMFile);
                MIMFile.a(mIMFile4, mIMFile3);
                MIMFile.a(mIMFile6, mIMFile5);
                final String string2 = string;
                File file = new File(this.e);
                for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.startsWith(string2);
                    }
                })) {
                    file2.delete();
                }
            }
            catch (Exception exception) {
                ay.d((Object)exception.getMessage(), this);
            }
        }
    }

    public String j() {
        File file = new File(this.e, this.g + "_vol.dat");
        if (file.exists()) {
            try {
                String string = FileChecksum.getMD5ChecksumPrintable(file.getAbsolutePath());
                return string;
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    public int[][] a(String string, List<String> list) {
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return this.b(string, stringArray);
    }

    public int[][] b(String string, String[] stringArray) {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            int[][] nArray = new int[stringArray.length][2];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = "//list/templatefile[filename=\"" + string + "\"]/roi[.=\"" + stringArray[i2] + "\"]";
                XPathExpression xPathExpression = xPath.compile(string2);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
                if (nodeList.getLength() > 0) {
                    NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
                    nArray[i2][0] = Integer.parseInt(namedNodeMap.getNamedItem("file_num").getNodeValue());
                    nArray[i2][1] = Integer.parseInt(namedNodeMap.getNamedItem("bit_num").getNodeValue());
                    continue;
                }
                nArray[i2][0] = -1;
                nArray[i2][1] = -1;
            }
            return nArray;
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
            return null;
        }
    }

    public int[][] a(String string, String[][] stringArray) {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String string2 = "//list/templatefile[filename=\"" + string + "\"]/roi";
            XPathExpression xPathExpression = xPath.compile(string2);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
            int n2 = 10;
            int n3 = 16;
            int[][] nArray = new int[10][16];
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                NamedNodeMap namedNodeMap = nodeList.item(i2).getAttributes();
                int n4 = Integer.parseInt(namedNodeMap.getNamedItem("file_num").getNodeValue());
                int n5 = Integer.parseInt(namedNodeMap.getNamedItem("bit_num").getNodeValue());
                nArray[n4][n5] = 1;
            }
            int[][] nArray2 = new int[stringArray.length][2];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (Boolean.parseBoolean(stringArray[i3][0])) {
                    int n6;
                    string2 = "//list/templatefile[filename=\"" + string + "\"]/roi[.=\"" + stringArray[i3][2] + "\"]";
                    xPathExpression = xPath.compile(string2);
                    NodeList nodeList2 = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
                    if (nodeList2.getLength() > 0) {
                        NamedNodeMap namedNodeMap = nodeList2.item(0).getAttributes();
                        n6 = Integer.parseInt(namedNodeMap.getNamedItem("file_num").getNodeValue());
                        int n7 = Integer.parseInt(namedNodeMap.getNamedItem("bit_num").getNodeValue());
                        nArray2[i3][0] = n6;
                        nArray2[i3][1] = n7;
                        continue;
                    }
                    for (int i4 = 0; i4 < 10; ++i4) {
                        for (n6 = 0; n6 < 16; ++n6) {
                            if (nArray[i4][n6] != 0) continue;
                            nArray[i4][n6] = 1;
                            nArray2[i3][0] = i4;
                            nArray2[i3][1] = n6;
                            i4 = 10;
                            n6 = 16;
                        }
                    }
                    continue;
                }
                nArray2[i3][0] = -1;
                nArray2[i3][1] = -1;
            }
            return nArray2;
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
            return null;
        }
    }

    public boolean b(String string, String[][] stringArray) {
        boolean bl2 = true;
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            File file = new File(this.e, b);
            File file2 = new File(file + ".lock");
            while (!file2.createNewFile()) {
                Thread.sleep(200L);
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.h = documentBuilder.parse(file);
            String string2 = "//list/templatefile[filename=\"" + string + "\"]";
            XPathExpression xPathExpression = xPath.compile(string2);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                Node node = nodeList.item(0);
                for (int i2 = 0; i2 < stringArray[0].length; ++i2) {
                    this.h(stringArray[0][i2]);
                    string2 = "//list/templatefile[filename=\"" + string + "\" and roi=\"" + stringArray[0][i2] + "\"]";
                    xPathExpression = xPath.compile(string2);
                    NodeList nodeList2 = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
                    if (nodeList2.getLength() > 0) {
                        ay.b((Object)(string + "'s contour \"" + stringArray[0][i2] + "\" has been overwritten"), this);
                        continue;
                    }
                    Node node2 = node.appendChild(this.h.createElement("roi"));
                    node2.appendChild(this.h.createTextNode(stringArray[0][i2]));
                    ((Element)node2).setAttribute("file_num", stringArray[1][i2]);
                    ((Element)node2).setAttribute("bit_num", stringArray[2][i2]);
                    ay.b((Object)("contour \"" + stringArray[0][i2] + "\" has been added to " + string), this);
                }
                XMLUtils.a(this.h, file.getAbsolutePath());
                file2.delete();
            } else {
                int n2;
                Element element = this.h.createElement("templatefile");
                Node node = element.appendChild(this.h.createElement("filename"));
                node.appendChild(this.h.createTextNode(string));
                ay.b((Object)("a new template " + string + " has been created."), this);
                ((Element)node).setAttribute("version", MimInstaller.getVersion());
                ((Element)node).setAttribute("atlas_id", this.j());
                ((Element)node).setAttribute("last_update", new Date().toString());
                Document document = documentBuilder.newDocument();
                Element element2 = document.createElement("subject_info");
                document.appendChild(element2);
                if (this.j != null) {
                    for (Map.Entry<String, String> stringArray22 : this.j.entrySet()) {
                        String string3 = stringArray22.getValue().trim();
                        while (string3.contains(", ")) {
                            string3 = string3.replace(", ", ",");
                        }
                        while (string3.contains(" ,")) {
                            string3 = string3.replace(" ,", ",");
                        }
                        Node node2 = element.appendChild(this.h.createElement(stringArray22.getKey().replace(' ', '_')));
                        node2.appendChild(this.h.createTextNode(string3));
                        node2 = element2.appendChild(document.createElement(stringArray22.getKey().replace(' ', '_')));
                        node2.appendChild(document.createTextNode(string3));
                    }
                }
                XMLUtils.a(document, new File(this.e, string + "_info.xml").getAbsolutePath());
                for (n2 = 0; n2 < stringArray[0].length; ++n2) {
                    this.h(stringArray[0][n2]);
                    Node node3 = element.appendChild(this.h.createElement("roi"));
                    node3.appendChild(this.h.createTextNode(stringArray[0][n2]));
                    ((Element)node3).setAttribute("file_num", stringArray[1][n2]);
                    ((Element)node3).setAttribute("bit_num", stringArray[2][n2]);
                    ay.b((Object)("contour \"" + stringArray[0][n2] + "\" has been added to " + string), this);
                }
                this.h.getDocumentElement().appendChild(element);
                XMLUtils.a(this.h, file.getAbsolutePath());
                file2.delete();
                this.i(string);
                n2 = this.f.length;
                String[] stringArray2 = new String[n2 + 1];
                System.arraycopy(this.f, 0, stringArray2, 0, n2);
                stringArray2[n2] = string;
                this.f = stringArray2;
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
            bl2 = false;
        }
        return bl2;
    }

    public void a(String string, String string2) {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String string3 = "//list/templatefile[filename=\"" + string + "\"]/roi[.=\"" + string2 + "\"]";
            XPathExpression xPathExpression = xPath.compile(string3);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                nodeList.item(i2).getParentNode().removeChild(nodeList.item(i2));
                ay.b((Object)("contour \"" + string2 + "\" has been removed from " + string), this);
                string3 = "//list/templatefile/roi[.=\"" + string2 + "\"]";
                xPathExpression = xPath.compile(string3);
                NodeList nodeList2 = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
                if (nodeList2.getLength() != 0) continue;
                this.g(string2);
            }
            String string4 = Path.getFullPath(this.e, b);
            XMLUtils.a(this.h, string4);
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
    }

    public void b(String string, String string2, String string3) {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String string4 = "//list/templatefile[filename=\"" + string + "\"]/roi[.=\"" + string2 + "\"]";
            XPathExpression xPathExpression = xPath.compile(string4);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                nodeList.item(i2).setTextContent(string3);
                ay.b((Object)("contour \"" + string2 + "\" has been changed to \"" + string3 + "\" for " + string), this);
                String string5 = Path.getFullPath(this.e, b);
                XMLUtils.a(this.h, string5);
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
    }

    public void f(String string) {
        try {
            int n2;
            Serializable serializable;
            int n3;
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String string2 = "//list/templatefile[filename=\"" + string + "\"]/roi/text()";
            XPathExpression xPathExpression = xPath.compile(string2);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
            for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
                this.a(string, nodeList.item(n3).getNodeValue());
            }
            string2 = "//list/templatefile[filename=\"" + string + "\"]";
            xPathExpression = xPath.compile(string2);
            nodeList = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
                    this.h.getDocumentElement().removeChild(nodeList.item(n3));
                }
            }
            File file = new File(this.e);
            String[] stringArray = file.list();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!stringArray[i2].startsWith(string)) continue;
                serializable = new File(this.e, stringArray[i2]);
                ((File)serializable).delete();
            }
            String string3 = Path.getFullPath(this.e, b);
            XMLUtils.a(this.h, string3);
            serializable = new ArrayList<String>(Arrays.asList(this.f));
            ((ArrayList)serializable).remove(string);
            this.f = ((ArrayList)serializable).toArray(new String[((ArrayList)serializable).size()]);
            File file2 = new File(this.e, c);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file2);
            string2 = "//template[@id=\"" + string + "\"]";
            xPathExpression = xPath.compile(string2);
            nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                    nodeList.item(n2).getParentNode().removeChild(nodeList.item(n2));
                }
            }
            if ((nodeList = (NodeList)(xPathExpression = xPath.compile(string2 = "//template/similiaritymetrics[@compareto=\"" + string + "\"]")).evaluate(document, XPathConstants.NODESET)).getLength() > 0) {
                for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                    nodeList.item(n2).getParentNode().removeChild(nodeList.item(n2));
                }
            }
            XMLUtils.a(document, file2.getAbsolutePath());
            ay.b((Object)("template " + string + " has been removed from the database."), this);
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
    }

    public boolean g(String string) {
        File file = new File(this.e, d);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile("//contours/roi[.=\"" + string + "\"]");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                    nodeList.item(i2).getParentNode().removeChild(nodeList.item(i2));
                }
                XMLUtils.a(document, file.getAbsolutePath());
            }
            return true;
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
            return false;
        }
    }

    public boolean h(String string) {
        boolean bl2 = false;
        string = string.toUpperCase().trim();
        File file = new File(this.e, d);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        File file2 = new File(file + ".lock");
        try {
            while (!file2.createNewFile()) {
                Thread.sleep(200L);
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile("//contours[roi=\"" + string + "\"]");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() == 0) {
                Node node = document.getDocumentElement().appendChild(document.createElement("roi"));
                node.appendChild(document.createTextNode(string));
                XMLUtils.a(document, file.getAbsolutePath());
                bl2 = true;
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
        file2.delete();
        return bl2;
    }

    public boolean k() {
        String string = this.p();
        return new File(this.e, string + "_vol.dat").exists() && new File(this.e, string + "_vox.dat").exists() && new File(this.e, string + "_wl.dat").exists();
    }

    public ViewController a(Session session) {
        Object object;
        String string;
        String string2 = this.p();
        short[][][] sArray = (short[][][])TemplateFile.loadFromTemplate(new File(this.e, string2 + "_vol.dat").getAbsolutePath(), "0");
        float[] fArray = (float[])TemplateFile.loadFromTemplate(new File(this.e, string2 + "_vox.dat").getAbsolutePath(), "0");
        float[] fArray2 = (float[])TemplateFile.loadFromTemplate(new File(this.e, string2 + "_wl.dat").getAbsolutePath(), "0");
        int[] nArray = new int[]{sArray.length, sArray[0].length, sArray[0][0].length};
        ImageVolumeShort imageVolumeShort = new ImageVolumeShort();
        imageVolumeShort.b(nArray);
        imageVolumeShort.a(nArray);
        imageVolumeShort.a(fArray);
        imageVolumeShort.getUncopiedMutableInfo().patientName = "Atlas Template";
        imageVolumeShort.getUncopiedMutableInfo().patientNameRaw = "Atlas Template";
        imageVolumeShort.getUncopiedMutableInfo().patientId = "Atlas Template";
        imageVolumeShort.getUncopiedMutableInfo().frameOfRefUID = UIDGenerator.generateUID();
        imageVolumeShort.getUncopiedMutableInfo().rescale.intercept = 0.0f;
        imageVolumeShort.getUncopiedMutableInfo().rescale.slope = 1.0f;
        String string3 = this.c("maintemplate", "Modality");
        if (cn.h(string3)) {
            string3 = "CT";
        }
        if ((string = this.c("maintemplate", "Units")) == null) {
            string = "CT".equals(string3) ? "HU" : "";
        }
        imageVolumeShort.getUncopiedMutableInfo().modality = string3;
        imageVolumeShort.getUncopiedMutableInfo().u().a(string);
        if (this.t()) {
            imageVolumeShort.ap();
        } else {
            imageVolumeShort.getUncopiedMutableInfo().j(UIDGenerator.generateUID());
            imageVolumeShort.an();
        }
        for (int i2 = 0; i2 < nArray[2]; ++i2) {
            object = new short[nArray[0] * nArray[1]];
            int n2 = 0;
            for (int i3 = 0; i3 < nArray[1]; ++i3) {
                for (int i4 = 0; i4 < nArray[0]; ++i4) {
                    object[n2++] = sArray[i4][i3][i2];
                }
            }
            ((ImageCube.ImageCubeShort)imageVolumeShort.ad()).a(object);
        }
        AtlasDBManager.a(imageVolumeShort);
        ViewControllerFactory.h h2 = new ViewControllerFactory.h(session, imageVolumeShort, null);
        object = ViewControllerFactory.a(h2);
        ContrastState contrastState = ((ViewController)object).av();
        contrastState.a(fArray2[0], fArray2[1], 1.0f);
        ((ViewController)object).a(contrastState, false, new EditTargetInfo(0, null, true));
        ((ViewController)object).e(false);
        try {
            ((ViewController)object).a(ColorTableFactory.a("B-W Linear"));
        }
        catch (Exception exception) {
            ay.d((Object)exception.getStackTrace(), this);
        }
        imageVolumeShort.D().c(true);
        return object;
    }

    private static void a(ImageVolumeShort imageVolumeShort) {
        ArrayList arrayList = Lists.newArrayList();
        SliceInfo.a(imageVolumeShort, (List<SliceInfo>)arrayList);
        ((SimpleImageVolume)imageVolumeShort).a(arrayList);
    }

    public ViewController a(String string, Session session, boolean bl2) {
        ImageVolumeShort imageVolumeShort = this.a(string, bl2);
        ViewControllerFactory.h h2 = new ViewControllerFactory.h(session, imageVolumeShort, null);
        ViewController3D viewController3D = ViewControllerFactory.a(h2);
        this.a(string, bl2, viewController3D);
        return viewController3D;
    }

    public List<VolumetricContourOverlayish> a(String string, ViewController viewController, List<String> list, boolean bl2, Progress progress, boolean bl3) {
        return this.a(string, viewController, list, bl2, progress, bl3, null);
    }

    public List<VolumetricContourOverlayish> a(String string, final ViewController viewController, List<String> list, final boolean bl2, final Progress progress, boolean bl3, Set<VolumetricContourOverlayish> set) {
        String[] stringArray = list.toArray(new String[0]);
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = bl2 ? AtlasSegmentation.a(stringArray[i2]) : stringArray[i2];
        }
        int[][] nArray = this.b(string, stringArray2);
        progress.N_();
        ArrayList arrayList = Lists.newArrayList();
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            arrayListMultimap.put((Object)nArray[i3][0], Pair.get(nArray[i3][1], stringArray[i3]));
        }
        ArrayList arrayList2 = Lists.newArrayList((Iterable)arrayListMultimap.keySet());
        Collections.sort(arrayList2);
        long l2 = System.nanoTime();
        for (Integer n2 : arrayList2) {
            if (progress.n() == Progress.Status.e) {
                return arrayList;
            }
            File file = new File(this.g(), string + "_roi_" + n2 + "_hires.dat");
            if (!file.exists()) {
                file = new File(this.g(), string + "_roi_" + n2 + ".dat");
            }
            final short[][][] sArray = (short[][][])TemplateFile.loadFromTemplate(file.getAbsolutePath(), "0");
            final List list2 = arrayListMultimap.get((Object)n2);
            final Contour[] contourArray = new Contour[list2.size()];
            FuncUtils.e e2 = new FuncUtils.e(){

                @Override
                public void f(int n2, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                    for (int i2 = n2; i2 < n3; ++i2) {
                        if (progress.n() == Progress.Status.e) {
                            return;
                        }
                        Pair pair = (Pair)list2.get(i2);
                        progress.b_(MIMFormat.a(a.getProperty("ATLASDBV_LOAD_CONTOUR"), pair.y));
                        contourArray[i2] = AtlasDBManager.this.a(bl2, viewController, (Integer)pair.x, sArray);
                        progress.N_();
                    }
                }
            };
            FuncUtils.a((ThreadPoolExecutor)m.d, list2.size(), e2, "Atlas Contour Loader");
            if (progress.n() == Progress.Status.e) {
                return arrayList;
            }
            int n3 = 0;
            while (n3 < contourArray.length) {
                int n4 = n3++;
                SwingUtilities.invokeLater(() -> {
                    VolumetricContourOverlay volumetricContourOverlay = com.mimvista.mui.overlays.f.a(viewController, contourArray[n4]);
                    volumetricContourOverlay.c((String)((Pair)list.get((int)n2)).y);
                    volumetricContourOverlay.n(true);
                    arrayList.add(volumetricContourOverlay);
                    if (set != null) {
                        set.add(volumetricContourOverlay);
                    }
                    if (bl3) {
                        viewController.ba().a((Overlayish)volumetricContourOverlay, true);
                    }
                });
            }
        }
        FuncUtils.a(l2, "Load atlas contours");
        MIMSwingUtils.b();
        return arrayList;
    }

    protected Contour a(boolean bl2, ViewController viewController, int n2, short[][][] sArray) {
        int[] nArray = new int[]{sArray.length, sArray[0].length, sArray[0][0].length};
        int[] nArray2 = MathUtils.d(nArray, viewController.aw().a());
        Contour contour = new Contour(viewController.aw());
        contour.d(nArray2);
        int[] nArray3 = contour.O();
        int n3 = 1 << n2;
        for (int i2 = 0; i2 < nArray3[0]; ++i2) {
            int n4 = i2;
            if (bl2) {
                n4 = nArray3[0] - i2 - 1;
            }
            short[][] sArray2 = sArray[n4];
            for (int i3 = 0; i3 < nArray3[1]; ++i3) {
                short[] sArray3 = sArray2[i3];
                for (int i4 = 0; i4 < nArray3[2]; ++i4) {
                    int n5 = sArray3[i4] & n3;
                    if (n5 == 0) continue;
                    contour.a(i2, i3, i4, true);
                }
            }
        }
        return contour.b(viewController.aw().C());
    }

    protected void a(String string, boolean bl2, ViewController viewController) {
        String string2 = bl2 ? ".mir" : "";
        float[] fArray = (float[])TemplateFile.loadFromTemplate(new File(this.e, string + "_bytsclwl.dat" + string2).getAbsolutePath(), "0");
        ContrastState contrastState = viewController.av();
        contrastState.a(fArray[0], fArray[1], 1.0f);
        viewController.a(contrastState, false, new EditTargetInfo(0, null, true));
    }

    protected ImageVolumeShort a(String string, boolean bl2) {
        String string2;
        int[] nArray = (int[])TemplateFile.loadFromTemplate(new File(this.e, string + "_origvol.dat").getAbsolutePath(), "size");
        float[] fArray = (float[])TemplateFile.loadFromTemplate(new File(this.e, string + "_origvox.dat").getAbsolutePath(), "0");
        ImageVolumeShort imageVolumeShort = new ImageVolumeShort();
        imageVolumeShort.b(nArray);
        imageVolumeShort.a(nArray);
        imageVolumeShort.a(fArray);
        SeriesInfo seriesInfo = imageVolumeShort.getUncopiedMutableInfo();
        seriesInfo.patientName = "Atlas Subject: " + this.b(string, "Name");
        seriesInfo.patientId = string;
        seriesInfo.sex = this.b(string, "Sex");
        seriesInfo.rescale.intercept = 0.0f;
        seriesInfo.rescale.slope = 1.0f;
        seriesInfo.samplesPerPix = 1;
        String string3 = this.c(string, "Modality");
        if (cn.h(string3)) {
            string3 = "CT";
        }
        if ((string2 = this.c(string, "Units")) == null) {
            string2 = "CT".equals(string3) ? "HU" : "";
        }
        seriesInfo.modality = string3;
        seriesInfo.u().a(string2);
        if (this.t()) {
            imageVolumeShort.ap();
        } else {
            imageVolumeShort.getUncopiedMutableInfo().j(UIDGenerator.generateUID());
            imageVolumeShort.an();
        }
        imageVolumeShort.D().c(true);
        for (int i2 = 0; i2 < nArray[2]; ++i2) {
            short[] sArray = new short[nArray[0] * nArray[1]];
            short[][] sArray2 = (short[][])TemplateFile.loadFromTemplate(new File(this.e, string + "_origvol.dat").getAbsolutePath(), String.valueOf(i2));
            int n2 = 0;
            for (int i3 = 0; i3 < nArray[1]; ++i3) {
                for (int i4 = 0; i4 < nArray[0]; ++i4) {
                    sArray[n2++] = sArray2[i4][i3];
                }
            }
            ((ImageCube.ImageCubeShort)imageVolumeShort.ad()).a(sArray);
        }
        AtlasDBManager.a(imageVolumeShort);
        if (bl2) {
            ((ImageCube.ImageCubeShort)imageVolumeShort.ad()).l();
        }
        return imageVolumeShort;
    }

    public void l() {
        File file = new File(this.e, c);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        File file2 = new File(file + ".lock");
        try {
            while (!file2.createNewFile()) {
                Thread.sleep(200L);
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile("//template");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                    document.getDocumentElement().removeChild(nodeList.item(i2));
                }
            }
            XMLUtils.a(document, file.getAbsolutePath());
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
        file2.delete();
    }

    public void i(String string) {
        File file = new File(this.e, c);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        File file2 = new File(file + ".lock");
        try {
            while (!file2.createNewFile()) {
                Thread.sleep(200L);
            }
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            Element element = document.createElement("template");
            element.setAttribute("id", string);
            XPathExpression xPathExpression = xPath.compile("//template");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                short[][][] sArray = (short[][][])TemplateFile.loadFromTemplate(Path.getFullPath(this.e, string + "_bytsclvol.dat"), "0");
                bg bg2 = bg.a();
                for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                    String string2 = nodeList.item(i2).getAttributes().getNamedItem("id").getNodeValue();
                    short[][][] sArray2 = (short[][][])TemplateFile.loadFromTemplate(Path.getFullPath(this.e, string2 + "_bytsclvol.dat"), "0");
                    double d2 = bg2.a(sArray, sArray2, (short[])null);
                    Element element2 = document.createElement("similiaritymetrics");
                    element2.setAttribute("compareto", string);
                    Node node = element2.appendChild(document.createElement("cor"));
                    node.appendChild(document.createTextNode(Double.toString(d2)));
                    nodeList.item(i2).appendChild(element2);
                    Element element3 = document.createElement("similiaritymetrics");
                    element3.setAttribute("compareto", string2);
                    Node node2 = element3.appendChild(document.createElement("cor"));
                    node2.appendChild(document.createTextNode(Double.toString(d2)));
                    element.appendChild(element3);
                }
            }
            document.getDocumentElement().appendChild(element);
            XMLUtils.a(document, file.getAbsolutePath());
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
        file2.delete();
    }

    public List<a> a(short[][][] sArray, short[] sArray2, String[] stringArray) {
        return this.a(sArray, sArray2, stringArray, o.o());
    }

    public List<a> a(short[][][] sArray, short[] sArray2, final String[] stringArray, final Progress progress) {
        final short[][][] sArray3 = sArray;
        final short[] sArray4 = sArray2;
        final ConcurrentLinkedQueue concurrentLinkedQueue = Queues.newConcurrentLinkedQueue();
        progress.a(stringArray.length);
        final bg bg2 = bg.a();
        FuncUtils.a((ThreadPoolExecutor)m.c, stringArray.length, new FuncUtils.aa(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void f(int n2, int n3) {
                try {
                    short[][][] sArray;
                    double d2;
                    Object object;
                    String string;
                    String string2 = stringArray[n2];
                    int n4 = string2.indexOf(".");
                    if (n4 > 0) {
                        string2 = string2.substring(0, n4);
                    }
                    double d3 = -1.0;
                    if (!stringArray[n2].endsWith(".mirror_only") && new File(string = Path.getFullPath(AtlasDBManager.this.e, string2 + "_bytsclvol.dat")).exists()) {
                        object = (short[][][])TemplateFile.loadFromTemplate(string, "0");
                        d3 = bg2.a(sArray3, (short[][][])object, sArray4);
                    }
                    boolean bl2 = false;
                    if (AtlasDBManager.this.q() && !AtlasDBManager.this.i && !stringArray[n2].endsWith(".orig_only") && new File((String)(object = (Object)Path.getFullPath(AtlasDBManager.this.e, string2 + "_bytsclvol.dat.mir"))).exists() && (d2 = bg2.a(sArray3, sArray = (short[][][])TemplateFile.loadFromTemplate((String)object, "0"), sArray4)) > d3) {
                        d3 = d2;
                        bl2 = true;
                    }
                    concurrentLinkedQueue.add(new a(string2 + (bl2 ? ".mirror" : ""), d3));
                }
                catch (Exception exception) {
                    ay.d((Object)"Error scoring atlas subject", (Throwable)exception, this);
                }
                finally {
                    progress.N_();
                }
            }
        });
        ArrayList arrayList = Lists.newArrayList((Iterable)concurrentLinkedQueue);
        Collections.sort(arrayList);
        for (a a2 : arrayList) {
            ay.e("Score for " + a2.b + " is " + String.valueOf(a2.a));
        }
        ay.e("The best matching subject ID is " + ((a)arrayList.get((int)0)).b);
        ay.e("The best correlation score is " + ((a)arrayList.get((int)0)).a);
        return arrayList;
    }

    public String b(short[][][] sArray, short[] sArray2, String[] stringArray) {
        return this.a((short[][][])sArray, (short[])sArray2, (String[])stringArray).get((int)0).b;
    }

    public String[] m() {
        Object[] objectArray = this.n();
        if (objectArray != null) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public String[] n() {
        File file = new File(this.e, d);
        if (!file.exists()) {
            return null;
        }
        String[] stringArray = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile("//contours/roi/text()");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            stringArray = new String[nodeList.getLength()];
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                stringArray[i2] = nodeList.item(i2).getNodeValue();
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
        return stringArray;
    }

    public String[] j(String string) {
        String[] stringArray = null;
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String string2 = "//list/templatefile[filename=\"" + string + "\"]";
            XPathExpression xPathExpression = xPath.compile(string2);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
            if (nodeList.getLength() > 0 && (nodeList = (NodeList)(xPathExpression = xPath.compile(string2 = "//list/templatefile[filename=\"" + string + "\"]/roi/text()")).evaluate(this.h, XPathConstants.NODESET)).getLength() > 0) {
                stringArray = new String[nodeList.getLength()];
                for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                    stringArray[i2] = nodeList.item(i2).getNodeValue();
                }
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
            stringArray = null;
        }
        if (stringArray != null) {
            Arrays.sort(stringArray);
        }
        return stringArray;
    }

    public String[] a(String[] stringArray, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        File file = new File(this.e, b);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            Object object;
            boolean bl2;
            String[] stringArray2;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String string8 = "//list/templatefile";
            string8 = string8 + "[true()";
            if (stringArray != null && stringArray.length > 0) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    string8 = string8 + " and roi=\"" + stringArray[i2] + "\"";
                }
            }
            String string9 = "'ABCDEFGHIJKLMNOPQRSTUVWXYZ'";
            String string10 = string9.toLowerCase();
            if (string != null && string.compareTo("") != 0) {
                stringArray2 = string.split(",");
                string8 = string8 + " and boolean(false()";
                for (String string11 : stringArray2) {
                    bl2 = false;
                    if (string11.startsWith("!")) {
                        if (string11.length() == 1) continue;
                        bl2 = true;
                        string11 = string11.substring(1);
                    }
                    string8 = string8 + " or translate(Name," + string9 + "," + string10 + (bl2 ? ")!=\"" : ")=\"") + string11.toLowerCase().trim() + "\"";
                }
                string8 = string8 + ")";
            }
            if (string2 != null && string2.compareTo("") != 0) {
                stringArray2 = string2.split(",");
                string8 = string8 + " and boolean(false()";
                for (String string11 : stringArray2) {
                    bl2 = false;
                    if (string11.startsWith("!")) {
                        if (string11.length() == 1) continue;
                        bl2 = true;
                        string11 = string11.substring(1);
                    }
                    string8 = string8 + " or translate(Cancer_Site," + string9 + "," + string10 + (bl2 ? ")!=\"" : ")=\"") + string11.toLowerCase().trim() + "\"";
                }
                string8 = string8 + ")";
            }
            if (string3 != null && string3.compareTo("") != 0) {
                stringArray2 = string3.split(",");
                string8 = string8 + " and boolean(false()";
                for (String string11 : stringArray2) {
                    bl2 = false;
                    if (string11.startsWith("!")) {
                        if (string11.length() == 1) continue;
                        bl2 = true;
                        string11 = string11.substring(1);
                    }
                    string8 = bl2 ? string8 + " or not(contains(translate(concat(',', Cancer_Subsite, ',')," + string9 + "," + string10 + "), '," + string11.toLowerCase().trim() + ",'))" : string8 + " or contains(translate(concat(',', Cancer_Subsite, ',')," + string9 + "," + string10 + "), '," + string11.toLowerCase().trim() + ",')";
                }
                string8 = string8 + ")";
            }
            stringArray2 = string4.split("AND");
            for (String string11 : stringArray2) {
                if ((string11 = string11.trim()) == null || string11.compareTo("") == 0) continue;
                String[] stringArray3 = string11.split(",");
                string8 = string8 + " and boolean(false()";
                for (String string12 : stringArray3) {
                    boolean bl3 = false;
                    if (string12.startsWith("!")) {
                        if (string12.length() == 1) continue;
                        bl3 = true;
                        string12 = string12.substring(1);
                    }
                    string8 = bl3 ? string8 + " or not(contains(translate(concat(',', Cancer_Stage, ',')," + string9 + "," + string10 + "), '," + string12.toLowerCase().trim() + ",'))" : string8 + " or contains(translate(concat(',', Cancer_Stage, ',')," + string9 + "," + string10 + "), '," + string12.toLowerCase().trim() + ",')";
                }
                string8 = string8 + ")";
            }
            if (string5 != null && string5.compareTo("") != 0) {
                string8 = string8 + " and translate(Cancer_Laterality," + string9 + "," + string10 + ")=\"" + string5.toLowerCase() + "\"";
            }
            if (string6 != null && string6.compareTo("") != 0) {
                object = string6.split(",");
                string8 = string8 + " and boolean(true()";
                for (String string13 : object) {
                    boolean bl4 = false;
                    if (string13.startsWith("!")) {
                        if (string13.length() == 1) continue;
                        bl4 = true;
                        string13 = string13.substring(1);
                    }
                    string8 = bl4 ? string8 + " and not(contains(translate(concat(',', Keywords, ',')," + string9 + "," + string10 + "), '," + string13.toLowerCase().trim() + ",'))" : string8 + " and contains(translate(concat(',', Keywords, ',')," + string9 + "," + string10 + "), '," + string13.toLowerCase().trim() + ",')";
                }
                string8 = string8 + ")";
            }
            if (string7 != null && string7.compareTo("") != 0) {
                object = string7.split(",");
                string8 = string8 + " and boolean(false()";
                for (String string14 : object) {
                    boolean bl5 = false;
                    if (string14.startsWith("!")) {
                        if (string14.length() == 1) continue;
                        bl5 = true;
                        string14 = string14.substring(1);
                    }
                    string8 = bl5 ? string8 + " or translate(Creator," + string9 + "," + string10 + ")!=\"" + string14.toLowerCase().trim() + "\"" : string8 + " or translate(Creator," + string9 + "," + string10 + ")=\"" + string14.toLowerCase().trim() + "\"";
                }
                string8 = string8 + ")";
            }
            string8 = string8 + "]";
            string8 = string8 + "/filename/text()";
            object = xPath.compile(string8);
            NodeList nodeList = (NodeList)object.evaluate(document, XPathConstants.NODESET);
            String[] stringArray4 = new String[nodeList.getLength()];
            for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
                stringArray4[i3] = nodeList.item(i3).getNodeValue();
            }
            return stringArray4;
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
            return null;
        }
    }

    public String[] k(String string) {
        return this.b(string, true);
    }

    public String[] b(String string, boolean bl2) {
        File file = new File(this.e, b);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String string2 = "//list/templatefile/" + string + "/text()";
            XPathExpression xPathExpression = xPath.compile(string2);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl2) {
                arrayList.add("All");
            }
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                String[] stringArray;
                String string3 = nodeList.item(i2).getNodeValue();
                for (String string4 : stringArray = string3.split(",")) {
                    String string5 = string4.trim();
                    if (cn.h(string5) || arrayList.contains(string5)) continue;
                    arrayList.add(string5);
                }
            }
            Object[] objectArray = new String[arrayList.size()];
            arrayList.toArray(objectArray);
            Arrays.sort(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
            return null;
        }
    }

    public String[] o() {
        if (this.f != null) {
            Arrays.sort(this.f);
        }
        return this.f;
    }

    public String l(String string) {
        String string2 = null;
        for (String string3 : this.o()) {
            if (!this.b(string3, "Name").equalsIgnoreCase(string)) continue;
            string2 = string3;
        }
        return string2;
    }

    public String p() {
        return this.g;
    }

    public void c(boolean bl2) {
        this.i = bl2;
    }

    public boolean q() {
        String string = this.h.getDocumentElement().getAttribute("mirror");
        return string.compareToIgnoreCase("true") == 0;
    }

    public String r() {
        return this.h.getDocumentElement().getAttribute("label_template");
    }

    public void m(String string) {
        try {
            this.h.getDocumentElement().setAttribute("label_template", string);
            XMLUtils.a(this.h, new File(this.e, b).getAbsolutePath());
            if (string.equals("")) {
                new File(this.e, "roi_template.xml").delete();
            } else {
                File file = com.mimvista.preferencesNew.cascade.c.d().a(CascadeSubfolder.d, com.mimvista.mui.overlays.h.b(string));
                MIMFile.a(file, new File(this.e, "roi_template.xml"));
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception.getMessage(), (Throwable)exception, this);
        }
    }

    public String b(String string, String string2) {
        String string3 = this.c(string, string2);
        if (string3 == null) {
            string3 = "";
        }
        return string3;
    }

    private String c(String string, String string2) {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String string3 = "maintemplate".equals(string) ? "//list/" + string + "/" + string2 : "//list/templatefile[filename=\"" + string + "\"]/" + string2;
            XPathExpression xPathExpression = xPath.compile(string3);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                String string4 = nodeList.item(0).getTextContent();
                if (string4 == null) {
                    string4 = "";
                }
                return string4;
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, AtlasDBManager.class);
        }
        return null;
    }

    public void c(String string, String string2, String string3) {
        try {
            Object object;
            Object object2;
            String string4;
            while (string3.contains(", ")) {
                string3 = string3.replace(", ", ",");
            }
            while (string3.contains(" ,")) {
                string3 = string3.replace(" ,", ",");
            }
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string4 = "maintemplate".equals(string) ? "//list/" + string : "//list/templatefile[filename=\"" + string + "\"]");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                object2 = nodeList.item(0);
                string4 = "maintemplate".equals(string) ? "//list/" + string + "/" + string2 : "//list/templatefile[filename=\"" + string + "\"]/" + string2;
                xPathExpression = xPath.compile(string4);
                object = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
                if (object.getLength() > 0) {
                    object.item(0).setTextContent(string3);
                } else {
                    object2.appendChild(this.h.createElement(string2)).setTextContent(string3);
                }
                XMLUtils.a(this.h, new File(this.e, b).getAbsolutePath());
            } else {
                ay.c((Object)("Failed to update dbList.xml for subject " + string), this);
            }
            object2 = new File(this.e, string + "_info.xml");
            if (((File)object2).exists()) {
                object = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)object).setNamespaceAware(true);
                DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
                Document document = documentBuilder.parse((File)object2);
                string4 = "//subject_info/" + string2;
                xPathExpression = xPath.compile(string4);
                NodeList nodeList2 = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
                if (nodeList2.getLength() > 0) {
                    nodeList2.item(0).setTextContent(string3);
                } else {
                    document.getDocumentElement().appendChild(document.createElement(string2)).setTextContent(string3);
                }
                XMLUtils.a(document, ((File)object2).getAbsolutePath());
            } else {
                ay.c((Object)("Failed to update info.xml for subject " + string), this);
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
    }

    public void s() {
        this.h.getDocumentElement().setAttribute("exporter_version", VersionNumber.getVersionString(true));
        String string = Path.getFullPath(this.e, b);
        XMLUtils.a(this.h, string);
    }

    public void d(boolean bl2) {
        this.h.getDocumentElement().setAttribute("lock", String.valueOf(bl2));
        String string = Path.getFullPath(this.e, b);
        XMLUtils.a(this.h, string);
    }

    public boolean t() {
        String string = this.h.getDocumentElement().getAttribute("lock");
        return string.compareToIgnoreCase("true") == 0;
    }

    public String u() {
        String string = this.h.getDocumentElement().getAttribute("version");
        if (string == null || string.trim().equals("")) {
            return "N/A";
        }
        return string.trim();
    }

    private void a(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.h = documentBuilder.parse(file);
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile("//maintemplate/filename/text()");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                this.g = nodeList.item(0).getNodeValue();
            }
            xPathExpression = xPath.compile("//templatefile/filename/text()");
            nodeList = (NodeList)xPathExpression.evaluate(this.h, XPathConstants.NODESET);
            this.f = new String[nodeList.getLength()];
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                this.f[i2] = nodeList.item(i2).getNodeValue();
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
    }

    public static class LoadPatientFromAtlasState
    extends ViewLoadState {
        boolean useMirror;
        private String subjectID;
        private AtlasDBManager db;
        public transient long a = -1L;

        public LoadPatientFromAtlasState(Session session, AtlasDBManager atlasDBManager, String string, boolean bl2) {
            this.session = session;
            this.db = atlasDBManager;
            this.subjectID = string;
            this.useMirror = bl2;
        }

        @Override
        public void doLoad(List<Long> list) {
            this.a = list.get(0);
            this.stamp();
        }

        @Override
        public List<Long> getCreatedIDs() {
            return Lists.newArrayList((Object[])new Long[]{this.a});
        }

        @Override
        public void stamp() {
            ImageVolumeShort imageVolumeShort = this.db.a(this.subjectID, this.useMirror);
            ViewControllerFactory.h h2 = new ViewControllerFactory.h(this.session, imageVolumeShort, (ViewLoadState)this);
            h2.e = this.a;
            ViewController3D viewController3D = ViewControllerFactory.a(h2);
            this.a = viewController3D.aV();
            this.db.a(this.subjectID, this.useMirror, viewController3D);
            imageVolumeShort.D().c(true);
            if (imageVolumeShort.getUncopiedMutableInfo().ag() == null) {
                imageVolumeShort.getUncopiedMutableInfo().j(UIDGenerator.generateUID());
            }
            for (SliceInfo sliceInfo : imageVolumeShort.ab()) {
                if (sliceInfo.sopInstanceUID != null) continue;
                sliceInfo.sopInstanceUID = UIDGenerator.generateUID();
            }
        }

        public long a() {
            return this.a;
        }
    }

    public static class a
    implements Comparable<a> {
        public double a;
        public String b;
        public boolean c = false;

        public a(String string, double d2) {
            if (string.endsWith(".mirror")) {
                this.c = true;
                string = string.substring(0, string.length() - 7);
            }
            this.a = d2;
            this.b = string;
        }

        public int a(a a2) {
            return -Double.compare(this.a, a2.a);
        }

        public String toString() {
            return "<" + this.b + ", " + this.a + ">";
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.a((a)object);
        }
    }
}

