/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator;

import com.google.common.collect.Maps;
import com.mimvista.archive.gui.ag;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.automator.Automator;
import com.mimvista.automator.credentials.AutomatorCredentialsManager;
import com.mimvista.automator.database.b;
import com.mimvista.automator.e;
import com.mimvista.automator.logging.AutomatorRecordKeeper;
import com.mimvista.automator.message.AbstractCloudStudyMessage;
import com.mimvista.automator.message.ArchiveHappenedMessage;
import com.mimvista.automator.message.AutomatedWorkflowFailedMessage;
import com.mimvista.automator.message.AutomatorConfigurationChangedMessage;
import com.mimvista.automator.message.AutomatorMessage;
import com.mimvista.automator.message.CancelRetryMessage;
import com.mimvista.automator.message.CancelRuleExecutionMessage;
import com.mimvista.automator.message.ClearJournalAndThreadPoolMessage;
import com.mimvista.automator.message.CloudStudyReceivedMessage;
import com.mimvista.automator.message.CloudStudyTrashedMessage;
import com.mimvista.automator.message.HL7MessageReceivedMessage;
import com.mimvista.automator.message.RetryRuleMessage;
import com.mimvista.automator.message.RunRuleWithParametersMessage;
import com.mimvista.automator.message.RunTimeBasedRuleNowMessage;
import com.mimvista.automator.message.TimerFiredMessage;
import com.mimvista.automator.rule.AutomatorAction;
import com.mimvista.automator.rule.AutomatorException;
import com.mimvista.automator.rule.AutomatorParameter;
import com.mimvista.automator.rule.AutomatorRule;
import com.mimvista.automator.rule.EventBasedRule;
import com.mimvista.automator.rule.StringWrapper;
import com.mimvista.automator.rule.d;
import com.mimvista.automator.scheduling.AutomatorCronScheduler;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.mimcloud.connection.i;
import com.mimvista.preferencesNew.AutomatorPrefs;
import com.mimvista.preferencesNew.h;
import com.mimvista.properties.af;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.az;
import com.mimvista.util.ca;
import com.mimvista.workflow.backend.WorkflowFactory;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientMessage;

public class c
extends com.mimvista.d.b {
    public static final String a = "automator.mainQueue";
    public static final String b = "Assistant Event Consumption Thread";
    public static final int c = 4;
    public static final NumberFormat d = NumberFormat.getInstance();
    private Map<UUID, a> e = Maps.newHashMap();
    private WeakHashMap<UUID, AutomatorRule> f = new WeakHashMap();
    private Map<UUID, TimerTask> g = new HashMap<UUID, TimerTask>();
    private ExecutorService h = this.i();
    private ExecutorService i = this.j();

    private ExecutorService i() {
        return Executors.newFixedThreadPool(this.f(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "Assistant General Execution Thread");
                thread.setPriority(5);
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable throwable) {
                        ay.d((Object)("Uncaught exception in " + thread.getName()), throwable, Automator.class);
                    }
                });
                return thread;
            }
        });
    }

    private ExecutorService j() {
        return Executors.newFixedThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "Assistant Workflow Execution Thread");
                thread.setPriority(5);
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable throwable) {
                        ay.d((Object)("Uncaught exception in " + thread.getName()), throwable, Automator.class);
                    }
                });
                return thread;
            }
        });
    }

    public c() {
        super(true);
    }

    @Override
    public String a() {
        return a;
    }

    @Override
    public String b() {
        return "defaultAutomatorEvents";
    }

    @Override
    public boolean a(ClientMessage clientMessage) {
        AutomatorMessage automatorMessage = AutomatorMessage.asAutomatorMessage(clientMessage);
        if (automatorMessage != null) {
            this.a(automatorMessage);
            return true;
        }
        ay.c((Object)"Recieved message is not actually an automator message, or there was an error parsing it", this);
        return false;
    }

    public void c() throws HornetQException {
        if (Automator.a) {
            super.a(true, b);
        } else {
            super.a(false, b);
        }
    }

    private void a(AutomatorMessage automatorMessage) {
        ay.b((Object)("Start processing message: " + automatorMessage.getPrettyPayloadString()), this);
        Set set = ca.b().getMethodsAnnotatedWith(e.class);
        boolean bl2 = false;
        for (Method method : set) {
            Class<? extends AutomatorMessage> clazz = method.getAnnotation(e.class).a();
            Class<?> clazz2 = method.getDeclaringClass();
            if (!clazz.isAssignableFrom(automatorMessage.getClass())) continue;
            try {
                if (this.getClass().equals(clazz2)) {
                    bl2 = true;
                    method.invoke((Object)this, automatorMessage);
                    continue;
                }
                if (com.mimvista.automator.c.b.class.isAssignableFrom(clazz2)) {
                    com.mimvista.automator.c.b b2 = Automator.instance.getPlugin(clazz2);
                    method.setAccessible(true);
                    method.invoke((Object)b2, automatorMessage.clone());
                    continue;
                }
                method.setAccessible(true);
                method.invoke(null, automatorMessage.clone());
            }
            catch (Exception exception) {
                ay.d((Object)("Error invoking message handler for " + clazz.getSimpleName()), (Throwable)exception, this);
            }
        }
        if (!bl2) {
            automatorMessage.acknowledgeMessage();
        }
    }

    @e(a=AutomatedWorkflowFailedMessage.class)
    private void a(AutomatedWorkflowFailedMessage automatedWorkflowFailedMessage) {
        AutomatorRecordKeeper.a(automatedWorkflowFailedMessage.getFailureMessage(), automatedWorkflowFailedMessage.getRuleInstanceId());
        automatedWorkflowFailedMessage.acknowledgeMessage();
    }

    @e(a=RunTimeBasedRuleNowMessage.class)
    private void a(RunTimeBasedRuleNowMessage runTimeBasedRuleNowMessage) {
        UUID uUID = runTimeBasedRuleNowMessage.getRuleID();
        AutomatorRule automatorRule = com.mimvista.automator.database.c.a().a(uUID);
        if (automatorRule.D()) {
            runTimeBasedRuleNowMessage.acknowledgeMessage();
            AutomatorRecordKeeper.b(automatorRule);
            AutomatorRecordKeeper.a(automatorRule, new AutomatorException(true, "", Messages.a("Automator", "AUTOMATOR_EXCEPTION_DESERIALIZE_ERROR")));
            return;
        }
        this.f.put(automatorRule.q(), automatorRule);
        AutomatorRecordKeeper.b(automatorRule);
        this.a(automatorRule, runTimeBasedRuleNowMessage);
    }

    @e(a=RunRuleWithParametersMessage.class)
    private void a(RunRuleWithParametersMessage runRuleWithParametersMessage) {
        UUID uUID = runRuleWithParametersMessage.getRuleId();
        AutomatorRule automatorRule = com.mimvista.automator.database.c.a().a(uUID);
        if (automatorRule != null) {
            Map<AutomatorParameter, Object> map = runRuleWithParametersMessage.getParametersToSet();
            if (runRuleWithParametersMessage.shouldRemapInitialParameters()) {
                Set<AutomatorParameter<?>> set = automatorRule.a(0);
                for (AutomatorParameter<?> automatorParameter : set) {
                    Class<?> clazz = automatorParameter.b();
                    for (AutomatorParameter automatorParameter2 : map.keySet()) {
                        if (!automatorParameter2.b().equals(clazz)) continue;
                        Object object = map.get(automatorParameter2);
                        if (!automatorParameter.b().isAssignableFrom(object.getClass())) continue;
                        automatorRule.a(automatorParameter, object);
                    }
                }
            } else {
                for (AutomatorParameter automatorParameter : map.keySet()) {
                    Object object = map.get(automatorParameter);
                    if (!automatorParameter.b().isAssignableFrom(object.getClass())) continue;
                    automatorRule.a(automatorParameter, object);
                }
            }
            AutomatorRecordKeeper.a(automatorRule);
            this.f.put(automatorRule.q(), automatorRule);
            this.a(automatorRule, runRuleWithParametersMessage);
        } else {
            runRuleWithParametersMessage.acknowledgeMessage();
            ay.c((Object)("Could not find rule for id: " + uUID + ", skipping message."), this);
        }
    }

    @e(a=RetryRuleMessage.class)
    protected void a(RetryRuleMessage retryRuleMessage) {
        AutomatorRecordKeeper.a a2 = AutomatorRecordKeeper.a(retryRuleMessage.getRuleInstanceId());
        if (a2 == null) {
            ay.c((Object)"Got a message to retry a rule that we don't have a record for", this);
            retryRuleMessage.acknowledgeMessage();
            return;
        }
        UUID uUID = UUID.fromString(retryRuleMessage.getRuleInstanceId());
        AutomatorRule automatorRule = com.mimvista.automator.database.c.a().a(a2.getRuleId());
        if (automatorRule == null) {
            ay.c((Object)"Got a message to retry a rule that we don't have in the db anymore", this);
            retryRuleMessage.acknowledgeMessage();
            AutomatorRecordKeeper.b(retryRuleMessage.getRuleInstanceId());
            return;
        }
        automatorRule.b(UUID.fromString(a2.getInstanceId()));
        automatorRule.a(a2.getAncestors());
        HashSet<DcmSeries> hashSet = new HashSet<DcmSeries>();
        SearchSource searchSource = null;
        if (automatorRule.u()) {
            String string = a2.getSourceIdentifier();
            searchSource = com.mimvista.automator.database.b.a(string, true, true);
            Set<UniqueSeriesPointer> set = a2.getSeriesPointers();
            if (!set.isEmpty()) {
                for (UniqueSeriesPointer uniqueSeriesPointer : set) {
                    Future<az<DcmSeries>> future = searchSource.a(uniqueSeriesPointer);
                    try {
                        az<DcmSeries> az2 = future.get();
                        if (az2.a()) {
                            hashSet.add(az2.b());
                            continue;
                        }
                        ay.c((Object)"Tried to retry a rule for a series we no longer have access to.", this);
                        retryRuleMessage.acknowledgeMessage();
                        AutomatorRecordKeeper.b(retryRuleMessage.getRuleInstanceId());
                        return;
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)("Cannot find series referenced by pointer " + uniqueSeriesPointer), throwable, this);
                    }
                }
            } else {
                for (String string2 : a2.getSeriesPaths()) {
                    DcmSeries dcmSeries = ArchiveHappenedMessage.getSingleSeriesFromPath(string2, searchSource);
                    hashSet.add(dcmSeries);
                }
            }
            ((EventBasedRule)automatorRule).a(searchSource, hashSet);
        } else if (automatorRule.v() == EventBasedRule.AutomatorEventSource.d) {
            // empty if block
        }
        AutomatorRecordKeeper.a(automatorRule, hashSet, searchSource, a2.getStudyKey());
        if (automatorRule.D()) {
            ay.d((Object)("Not retrying rule " + String.valueOf(automatorRule.j()) + "; it failed to deserialize properly"), this);
            retryRuleMessage.acknowledgeMessage();
            AutomatorRecordKeeper.a(automatorRule, new AutomatorException(true, "", Messages.a("Automator", "AUTOMATOR_EXCEPTION_DESERIALIZE_ERROR")));
            return;
        }
        this.f.put(automatorRule.q(), automatorRule);
        this.a(automatorRule, retryRuleMessage);
    }

    @e(a=CancelRetryMessage.class)
    protected void a(CancelRetryMessage cancelRetryMessage) {
        UUID uUID = cancelRetryMessage.getRuleInstanceID();
        a a2 = this.e.remove(uUID);
        if (a2 == null) {
            ay.c((Object)"Got a cancel auto-retry message but we don't appear to have that retry scheduled", this);
        } else {
            a2.a(true);
            AutomatorRule automatorRule = a2.a();
            if (automatorRule != null) {
                AutomatorRecordKeeper.a(automatorRule, new AutomatorException(true, "Auto-retry stopped via message.", Messages.a("Automator", "AUTO_RETRY_CANCELLED")));
            }
        }
        cancelRetryMessage.acknowledgeMessage();
    }

    @e(a=CancelRuleExecutionMessage.class)
    protected void a(CancelRuleExecutionMessage cancelRuleExecutionMessage) {
        a a2;
        UUID uUID = cancelRuleExecutionMessage.getRuleInstanceUID();
        AutomatorRule automatorRule = this.f.remove(uUID);
        if (automatorRule == null && (a2 = this.e.remove(uUID)) != null) {
            a2.a(true);
            automatorRule = a2.a();
        }
        if (automatorRule == null) {
            ay.c((Object)"Got a cancel message but we don't appear to have that rule running", this);
        } else {
            AutomatorRecordKeeper.a(uUID);
            automatorRule.w();
            this.g.remove(uUID);
        }
        cancelRuleExecutionMessage.acknowledgeMessage();
    }

    @e(a=HL7MessageReceivedMessage.class)
    protected void a(HL7MessageReceivedMessage hL7MessageReceivedMessage) {
        Serializable serializable;
        Map<UUID, Boolean> map = com.mimvista.automator.database.c.a().d();
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (UUID uUID : map.keySet()) {
            serializable = map.get(uUID);
            if (!((Boolean)serializable).booleanValue()) continue;
            hashSet.add(uUID);
        }
        if (hashSet.isEmpty()) {
            hL7MessageReceivedMessage.acknowledgeMessage();
            return;
        }
        hL7MessageReceivedMessage.setRequiredAcknowledgements(hashSet.size());
        for (UUID uUID : hashSet) {
            serializable = (EventBasedRule)com.mimvista.automator.database.c.a().a(uUID);
            if (((AutomatorRule)serializable).D()) {
                ay.d((Object)("Not running message-based rule " + String.valueOf(((AutomatorRule)serializable).j()) + "; it failed to deserialize properly"), this);
                hL7MessageReceivedMessage.acknowledgeMessage();
                AutomatorRecordKeeper.b((AutomatorRule)serializable);
                AutomatorRecordKeeper.a((AutomatorRule)serializable, new AutomatorException(true, "", Messages.a("Automator", "AUTOMATOR_EXCEPTION_DESERIALIZE_ERROR")));
                continue;
            }
            StringWrapper.HL7MessageWrapper hL7MessageWrapper = new StringWrapper.HL7MessageWrapper(hL7MessageReceivedMessage.getSerializedHL7InboundMessageLLP());
            ((EventBasedRule)serializable).a(hL7MessageWrapper);
            AutomatorRecordKeeper.a((AutomatorRule)serializable, new ArrayList<DcmSeries>(), null, hL7MessageReceivedMessage.getSerializedHL7InboundMessageLLP());
            this.f.put(((AutomatorRule)serializable).q(), (AutomatorRule)serializable);
            this.a((AutomatorRule)serializable, hL7MessageReceivedMessage);
        }
    }

    private void a(AbstractCloudStudyMessage abstractCloudStudyMessage, EventBasedRule.AutomatorEventSource automatorEventSource) {
        String string = com.mimvista.automator.database.c.a(abstractCloudStudyMessage.getTriggeringGroup());
        Set<EventBasedRule> set = com.mimvista.automator.database.c.a().b(string);
        if ((set = set.stream().filter(eventBasedRule -> eventBasedRule.v().equals((Object)automatorEventSource)).collect(Collectors.toSet())).isEmpty()) {
            abstractCloudStudyMessage.acknowledgeMessage();
            ay.a((Object)"Didn't find a rule to match message: ", abstractCloudStudyMessage.getPrettyPayloadString());
            return;
        }
        abstractCloudStudyMessage.setRequiredAcknowledgements(set.size());
        for (EventBasedRule eventBasedRule2 : set) {
            if (eventBasedRule2.D()) {
                ay.d((Object)("Not running cloud event-based rule: " + String.valueOf(eventBasedRule2.j()) + "; it failed to deserialize properly"), this);
                abstractCloudStudyMessage.acknowledgeMessage();
                AutomatorRecordKeeper.a((AutomatorRule)eventBasedRule2, abstractCloudStudyMessage.getCloudStudyKey());
                AutomatorRecordKeeper.a((AutomatorRule)eventBasedRule2, new AutomatorException(true, "", Messages.a("Automator", "AUTOMATOR_EXCEPTION_DESERIALIZE_ERROR")));
                continue;
            }
            eventBasedRule2.a(abstractCloudStudyMessage.getCloudStudyKey());
            AutomatorRecordKeeper.a((AutomatorRule)eventBasedRule2, abstractCloudStudyMessage.getCloudStudyKey());
            this.f.put(eventBasedRule2.q(), eventBasedRule2);
            this.a(eventBasedRule2, abstractCloudStudyMessage);
        }
    }

    @e(a=CloudStudyReceivedMessage.class)
    protected void a(CloudStudyReceivedMessage cloudStudyReceivedMessage) {
        this.a(cloudStudyReceivedMessage, EventBasedRule.AutomatorEventSource.d);
    }

    @e(a=CloudStudyTrashedMessage.class)
    protected void a(CloudStudyTrashedMessage cloudStudyTrashedMessage) {
        this.a(cloudStudyTrashedMessage, EventBasedRule.AutomatorEventSource.e);
    }

    @e(a=ArchiveHappenedMessage.class)
    protected void a(ArchiveHappenedMessage archiveHappenedMessage) {
        String string = archiveHappenedMessage.getDestinationIdentifierString();
        Set<EventBasedRule> set = com.mimvista.automator.database.c.a().b(string);
        if (set.isEmpty()) {
            archiveHappenedMessage.acknowledgeMessage();
            ay.a((Object)("Didn't find a rule to match message: " + archiveHappenedMessage.getPrettyPayloadString()), this);
            return;
        }
        archiveHappenedMessage.setRequiredAcknowledgements(set.size());
        boolean bl2 = archiveHappenedMessage instanceof ArchiveHappenedMessage.StudyArchiveCompleteMessage;
        for (EventBasedRule eventBasedRule : set) {
            if (eventBasedRule == null) {
                ay.c((Object)"Found null rule in list of scheduled archive rules", this);
                archiveHappenedMessage.acknowledgeMessage();
                continue;
            }
            if (eventBasedRule.D()) {
                ay.d((Object)("Not running event-based rule " + String.valueOf(eventBasedRule.j()) + "; it failed to deserialize properly"), this);
                archiveHappenedMessage.acknowledgeMessage();
                AutomatorRecordKeeper.a((AutomatorRule)eventBasedRule, archiveHappenedMessage.getSeries(), archiveHappenedMessage.getSearchSource(), archiveHappenedMessage.getStudyKey());
                AutomatorRecordKeeper.a((AutomatorRule)eventBasedRule, new AutomatorException(true, "", Messages.a("Automator", "AUTOMATOR_EXCEPTION_DESERIALIZE_ERROR")));
                continue;
            }
            if (bl2 && eventBasedRule.v() != EventBasedRule.AutomatorEventSource.b) {
                ay.a((Object)"Received a study message for a series based rule; don't need to do anything", this);
                archiveHappenedMessage.acknowledgeMessage();
                continue;
            }
            List<DcmSeries> list = archiveHappenedMessage.getSeries();
            String string2 = archiveHappenedMessage.getStudyKey();
            SearchSource searchSource = archiveHappenedMessage.getSearchSource();
            if (!bl2 && eventBasedRule.v() == EventBasedRule.AutomatorEventSource.b) {
                ay.a((Object)"Received a series message for a study based rule", this);
                AutomatorRecordKeeper.a(eventBasedRule, list.get(0), searchSource, string2);
                archiveHappenedMessage.acknowledgeMessage();
                continue;
            }
            this.f.put(eventBasedRule.q(), eventBasedRule);
            eventBasedRule.a(searchSource, list);
            AutomatorRecordKeeper.a((AutomatorRule)eventBasedRule, list, searchSource, string2);
            this.a(eventBasedRule, archiveHappenedMessage);
        }
    }

    @e(a=AutomatorConfigurationChangedMessage.class)
    private void a(final AutomatorConfigurationChangedMessage automatorConfigurationChangedMessage) {
        this.h.submit(new Runnable(){

            @Override
            public void run() {
                automatorConfigurationChangedMessage.acknowledgeMessage();
                c.this.k();
            }
        });
    }

    private void k() {
        ay.a((Object)"Refreshing automator configurations", this);
        af.clearCache();
        com.mimvista.preferencesNew.h.a().k();
        com.mimvista.preferencesNew.h.a().l();
        WorkflowFactory.a();
        com.mimvista.mui.layout.c.w();
        AutomatorCredentialsManager.a().g();
        Automator.doConfigSync();
        ag.j();
        com.mimvista.mimcloud.connection.i.a(new com.mimvista.automator.credentials.a(), com.mimvista.mimcloud.connection.d.m());
        com.mimvista.automator.database.c.e();
        AutomatorCronScheduler.c();
        AutomatorCronScheduler.a();
        AutomatorCronScheduler.b();
        com.mimvista.automator.logging.a.a().b();
    }

    @e(a=ClearJournalAndThreadPoolMessage.class)
    private void a(ClearJournalAndThreadPoolMessage clearJournalAndThreadPoolMessage) {
        ay.a((Object)"Reloading journal and threadpool", this);
        clearJournalAndThreadPoolMessage.acknowledgeMessage();
        this.h();
        for (AutomatorRule automatorRule : this.f.values()) {
            if (automatorRule == null || !automatorRule.z()) continue;
            automatorRule.w();
        }
        this.h.shutdownNow();
        this.i.shutdownNow();
        this.k();
        this.f.clear();
        this.g.clear();
        this.e.clear();
        AutomatorRecordKeeper.c();
        this.h = this.i();
        this.i = this.j();
        try {
            this.a(true, b);
        }
        catch (HornetQException hornetQException) {
            ay.d((Object)"error restarting the consumer after reoloading journal and threadpool", (Throwable)hornetQException, this);
        }
    }

    @e(a=TimerFiredMessage.class)
    private void a(TimerFiredMessage timerFiredMessage) {
        UUID uUID = timerFiredMessage.getRuleId();
        AutomatorRule automatorRule = com.mimvista.automator.database.c.a().a(uUID);
        if (automatorRule == null) {
            timerFiredMessage.acknowledgeMessage();
            ay.c((Object)("Didn't find a rule to match message: " + timerFiredMessage.getPrettyPayloadString()), this);
            return;
        }
        if (automatorRule.D()) {
            ay.d((Object)("Not running time-based rule " + String.valueOf(automatorRule.j()) + "; it failed to deserialize properly"), this);
            timerFiredMessage.acknowledgeMessage();
            AutomatorRecordKeeper.b(automatorRule);
            AutomatorRecordKeeper.a(automatorRule, new AutomatorException(true, "", Messages.a("Automator", "AUTOMATOR_EXCEPTION_DESERIALIZE_ERROR")));
            return;
        }
        this.f.put(automatorRule.q(), automatorRule);
        AutomatorRecordKeeper.b(automatorRule);
        this.a(automatorRule, timerFiredMessage);
    }

    private Future<?> a(final AutomatorRule automatorRule, final AutomatorMessage automatorMessage) {
        try {
            if (!automatorRule.c()) {
                ay.b((Object)"Rule instance not accepted; skipping", this);
                automatorMessage.acknowledgeMessage();
                automatorRule.i();
                AutomatorRecordKeeper.d(automatorRule);
                this.f.remove(automatorRule.q());
                return null;
            }
        }
        catch (Exception exception) {
            automatorMessage.acknowledgeMessage();
            AutomatorRecordKeeper.a(automatorRule, new AutomatorException(exception, true, "error while trying to determine if rule instance should be accepted", Messages.a("Automator", "ERROR_ON_FILTER")));
            this.f.remove(automatorRule.q());
            return null;
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                automatorRule.a(new d(){

                    @Override
                    public void a(AutomatorRule automatorRule, AutomatorException automatorException) {
                        AutomatorRecordKeeper.a(automatorRule, automatorException);
                        if (automatorRule.A()) {
                            AutomatorRecordKeeper.f(automatorRule);
                        }
                    }

                    @Override
                    public void a(AutomatorAction automatorAction) {
                        AutomatorRecordKeeper.a(automatorAction);
                    }

                    @Override
                    public void a(AutomatorRule automatorRule) {
                        AutomatorRecordKeeper.e(automatorRule);
                    }

                    @Override
                    public void b(AutomatorRule automatorRule) {
                        AutomatorRecordKeeper.a(automatorRule.q());
                    }
                });
                automatorRule.a(com.mimvista.automator.status.a.c().d());
                ay.b((Object)("Starting rule: " + automatorRule.j()), this);
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                c.this.b(automatorRule);
                try {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                automatorMessage.acknowledgeMessage();
                                AutomatorRecordKeeper.c(automatorRule);
                                automatorRule.b();
                            }
                            catch (Throwable throwable) {
                                ay.d((Object)"Error bubbled all the way out to worker thread: ", throwable, this);
                            }
                        }
                    });
                    thread.setDaemon(true);
                    thread.start();
                    while (thread.isAlive()) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            try {
                                thread.stop();
                            }
                            catch (Throwable throwable) {
                                ay.d((Object)"Error stopping worker thread... probably just leaked everywhere.", throwable, this);
                            }
                            break;
                        }
                    }
                }
                finally {
                    c.this.f.remove(automatorRule.q());
                }
            }
        };
        this.a(automatorRule);
        Future<?> future = automatorRule.n() ? this.i.submit(runnable) : this.h.submit(runnable);
        this.a(future, countDownLatch, automatorRule);
        return future;
    }

    private void a(AutomatorRule automatorRule) {
        if (automatorRule.A() && this.e.get(automatorRule.q()) == null) {
            a a2 = new a(automatorRule);
            this.e.put(automatorRule.q(), a2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(final Future<?> future, CountDownLatch countDownLatch, final AutomatorRule automatorRule) {
        if (!automatorRule.l()) {
            countDownLatch.countDown();
            return;
        }
        Map<UUID, TimerTask> map = this.g;
        synchronized (map) {
            try {
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        if (future.isDone()) {
                            return;
                        }
                        boolean bl2 = future.cancel(true);
                        if (bl2) {
                            d.setMaximumFractionDigits(2);
                            AutomatorRecordKeeper.a(automatorRule, new AutomatorException(true, "Rule (" + automatorRule.j() + ") timed out after " + automatorRule.k() + " minutes.", MessageFormat.format(Messages.a("Automator", "AUTOMATOR_EXCEPTION_TIMEOUT"), d.format(automatorRule.k()))));
                        } else {
                            ay.d((Object)("Tried to cancel rule: " + automatorRule.j() + " due to timeout but failed."), c.class);
                        }
                    }
                };
                this.g.put(automatorRule.q(), timerTask);
            }
            finally {
                countDownLatch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(AutomatorRule automatorRule) {
        if (!automatorRule.l()) {
            return;
        }
        Map<UUID, TimerTask> map = this.g;
        synchronized (map) {
            TimerTask timerTask = this.g.remove(automatorRule.q());
            if (timerTask != null) {
                long l2 = (long)(60000.0 * automatorRule.k());
                Timer timer = new Timer("Rule Timer: " + automatorRule.j(), true);
                timer.schedule(timerTask, l2);
            } else {
                ay.c((Object)("No timer task for rule with timeout... we won't be able to stop if this rule locks up: " + automatorRule.q()), this);
            }
        }
    }

    public synchronized void d() {
        try {
            super.e();
            this.h.shutdown();
            this.h.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (Exception exception) {
            ay.d((Object)"Could not close consumer...", (Throwable)exception, this);
        }
    }

    @Override
    public synchronized void e() {
        try {
            for (AutomatorRule automatorRule : this.f.values()) {
                automatorRule.w();
            }
            this.g.clear();
            super.e();
            this.h.shutdown();
            this.h.awaitTermination(15L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            ay.d((Object)"Could not close consumer...", (Throwable)exception, this);
        }
    }

    public int f() {
        int n2 = AutomatorPrefs.automatorThreadCount.getValue();
        if (n2 <= 1) {
            n2 = 2;
        }
        return n2 - 1;
    }

    private class a {
        private UUID b;
        private UUID c;

        public a(AutomatorRule automatorRule) {
            this.b = automatorRule.q();
            this.c = automatorRule.a(new d(){

                @Override
                public void a(AutomatorRule automatorRule, AutomatorException automatorException) {
                    if (!automatorRule.x()) {
                        a.this.a(automatorRule);
                    }
                }

                @Override
                public void a(AutomatorRule automatorRule) {
                    c.this.e.remove(automatorRule.q());
                }
            });
        }

        public void a(boolean bl2) {
            c.this.e.remove(this.b);
            AutomatorRule automatorRule = (AutomatorRule)c.this.f.get(this.b);
            if (automatorRule != null) {
                automatorRule.c(this.c);
                if (bl2) {
                    c.this.f.remove(this.b);
                    automatorRule.w();
                }
            }
        }

        private void a(AutomatorRule automatorRule) {
            new RetryRuleMessage(automatorRule).sendAsync();
            ay.b((Object)("Scheduling rule (" + automatorRule.j() + ") for auto-retry."), a.class);
        }

        public AutomatorRule a() {
            return (AutomatorRule)c.this.f.get(this.b);
        }
    }
}

