/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.database;

import com.google.common.collect.Lists;
import com.mimvista.automator.database.a;
import com.mimvista.automator.database.b;
import com.mimvista.automator.database.c;
import com.mimvista.automator.rule.AutomatorAction;
import com.mimvista.automator.rule.AutomatorParameter;
import com.mimvista.automator.rule.AutomatorRule;
import com.mimvista.automator.rule.EventBasedRule;
import com.mimvista.automator.rule.ListWrapper;
import com.mimvista.automator.rule.TimeBasedRule;
import com.mimvista.automator.rule.actions.TestAction;
import com.mimvista.automator.rule.f;
import com.mimvista.automator.scheduling.ScheduledRule;
import com.mimvista.util.ay;
import com.mimvista.util.ca;
import com.mimvista.util.cn;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;

public class AutomatorSerializationUtility {
    public static BasicDBObject a(AutomatorRule automatorRule) {
        BasicDBObject basicDBObject = new BasicDBObject();
        UUID uUID = automatorRule.m();
        String string = automatorRule.j();
        List<AutomatorParameter> list = automatorRule.e();
        List<AutomatorAction> list2 = automatorRule.f();
        basicDBObject.append("_id", (Object)uUID.toString());
        basicDBObject.append("name", (Object)string);
        basicDBObject.append("scheduled", (Object)automatorRule.t());
        basicDBObject.append("description", (Object)automatorRule.p());
        if (!automatorRule.t()) {
            basicDBObject.append("eventSource", (Object)automatorRule.v().toString());
        }
        basicDBObject.append("ruleCreator", (Object)automatorRule.C().toString());
        basicDBObject.append("timeout", (Object)automatorRule.k());
        basicDBObject.append("retryIndefinitely", (Object)automatorRule.A());
        basicDBObject.append("includeEmbedded", (Object)automatorRule.B());
        BasicDBList basicDBList = new BasicDBList();
        for (AutomatorParameter object : list) {
            basicDBList.add((Object)AutomatorSerializationUtility.a(object, automatorRule));
        }
        basicDBObject.append("parameters", (Object)basicDBList);
        BasicDBList basicDBList2 = new BasicDBList();
        for (AutomatorAction automatorAction : list2) {
            basicDBList2.add((Object)AutomatorSerializationUtility.a(automatorAction));
        }
        basicDBObject.append("actions", (Object)basicDBList2);
        if (automatorRule instanceof EventBasedRule) {
            basicDBObject.append("initialFilters", (Object)((EventBasedRule)automatorRule).I().a());
        }
        return basicDBObject;
    }

    private static BasicDBObject a(AutomatorParameter automatorParameter, AutomatorRule automatorRule) {
        BasicDBObject basicDBObject = new BasicDBObject();
        boolean bl2 = automatorParameter.d();
        String string = automatorParameter.a();
        Class clazz = automatorParameter.b();
        basicDBObject.append("isConstant", (Object)bl2);
        basicDBObject.append("simpleName", (Object)string);
        basicDBObject.append("type", (Object)clazz.getName());
        if (bl2) {
            basicDBObject.append("value", (Object)b.a().toJson(automatorParameter.a(automatorRule)));
        }
        return basicDBObject;
    }

    private static BasicDBObject a(AutomatorParameter automatorParameter) {
        BasicDBObject basicDBObject = new BasicDBObject();
        if (automatorParameter == null) {
            return null;
        }
        basicDBObject.append("type", (Object)automatorParameter.b().getName());
        basicDBObject.append("name", (Object)automatorParameter.a());
        return basicDBObject;
    }

    private static BasicDBObject a(AutomatorAction automatorAction) {
        BasicDBObject basicDBObject = new BasicDBObject();
        UUID uUID = automatorAction.a();
        basicDBObject.append("_id", (Object)uUID.toString());
        basicDBObject.append("actionType", (Object)automatorAction.n().a());
        Collection<Field> collection = ca.c(automatorAction.getClass());
        for (Field field : collection) {
            if (!field.isAnnotationPresent(com.mimvista.automator.rule.a.class) && !field.isAnnotationPresent(f.class)) continue;
            try {
                field.setAccessible(true);
                BasicDBObject basicDBObject2 = AutomatorSerializationUtility.a((AutomatorParameter)field.get(automatorAction));
                if (basicDBObject2 == null) continue;
                basicDBObject.append(field.getName(), (Object)basicDBObject2);
            }
            catch (Exception exception) {
                ay.c((Object)("Could not serialize field " + field.getName() + ", rule may not be complete."), (Throwable)exception, AutomatorSerializationUtility.class);
            }
        }
        return basicDBObject;
    }

    public static <T> AutomatorRule a(BasicDBObject basicDBObject) {
        AutomatorRule automatorRule = null;
        try {
            Object object;
            boolean bl2 = false;
            String string = basicDBObject.getString("_id");
            String string2 = basicDBObject.getString("name");
            String string3 = basicDBObject.getString("description");
            boolean bl3 = basicDBObject.getBoolean("scheduled");
            BasicDBList basicDBList = (BasicDBList)basicDBObject.get("parameters");
            BasicDBList basicDBList2 = (BasicDBList)basicDBObject.get("actions");
            String string4 = basicDBObject.getString("initialFilters");
            if (bl3) {
                automatorRule = new TimeBasedRule(string2, UUID.fromString(string));
            } else {
                try {
                    String string5 = basicDBObject.getString("eventSource");
                    object = EventBasedRule.AutomatorEventSource.valueOf(string5);
                }
                catch (Throwable throwable) {
                    boolean bl4 = basicDBObject.getBoolean("reactToStudy");
                    object = bl4 ? EventBasedRule.AutomatorEventSource.b : EventBasedRule.AutomatorEventSource.a;
                    bl2 = true;
                }
                automatorRule = new EventBasedRule((EventBasedRule.AutomatorEventSource)((Object)object), string2, UUID.fromString(string));
            }
            automatorRule.b(string3);
            for (String string5 : basicDBList) {
                BasicDBObject basicDBObject2 = (BasicDBObject)string5;
                try {
                    AutomatorSerializationUtility.a(basicDBObject2, automatorRule);
                }
                catch (Exception exception) {
                    automatorRule.c(true);
                    ay.d((Object)("Could not deserialize parameter " + basicDBObject2.getString("simpleName") + ", rule is not complete."), (Throwable)exception, AutomatorSerializationUtility.class);
                }
            }
            for (String string5 : basicDBList2) {
                BasicDBObject basicDBObject3 = (BasicDBObject)string5;
                try {
                    AutomatorAction automatorAction = AutomatorSerializationUtility.b(basicDBObject3, automatorRule);
                    automatorRule.a(automatorAction);
                }
                catch (Exception exception) {
                    automatorRule.c(true);
                    String string6 = basicDBObject3.getString("_id") + " - " + basicDBObject3.getString("actionType");
                    ay.d((Object)("Could not deserialize action " + string6 + ", rule is not complete."), (Throwable)exception, AutomatorSerializationUtility.class);
                }
            }
            if (!bl3 && !cn.h(string4)) {
                AutomatorSerializationUtility.a((EventBasedRule)automatorRule, string4);
            }
            try {
                object = basicDBObject.getString("ruleCreator");
                automatorRule.a(AutomatorRule.RuleCreator.valueOf((String)object));
            }
            catch (NullPointerException nullPointerException) {
                automatorRule.a(AutomatorRule.RuleCreator.a);
                bl2 = true;
            }
            try {
                double d2 = basicDBObject.getDouble("timeout");
                automatorRule.a(d2);
            }
            catch (NullPointerException nullPointerException) {
                automatorRule.a(-1.0);
                bl2 = true;
                ay.d((Object)"Deserialized a rule without a timeout parameter, setting to no timeout and resaving.", AutomatorSerializationUtility.class);
            }
            try {
                boolean bl5 = basicDBObject.getBoolean("retryIndefinitely");
                automatorRule.a(bl5);
            }
            catch (NullPointerException nullPointerException) {
                automatorRule.a(false);
                bl2 = true;
                ay.d((Object)"Deserialized a rule without a retry parameter, setting to false and resaving.", AutomatorSerializationUtility.class);
            }
            try {
                boolean bl6 = basicDBObject.getBoolean("includeEmbedded");
                automatorRule.b(bl6);
            }
            catch (NullPointerException nullPointerException) {
                automatorRule.b(false);
                bl2 = true;
            }
            if (bl2) {
                a a2 = a.a();
                a2.d(automatorRule.m());
                a2.a(Lists.newArrayList((Object[])new AutomatorRule[]{automatorRule}));
            }
        }
        catch (Throwable throwable) {
            if (automatorRule != null) {
                automatorRule.c(true);
            }
            ay.d((Object)"Error while deserializing rule", throwable, AutomatorSerializationUtility.class);
        }
        return automatorRule;
    }

    private static void a(EventBasedRule eventBasedRule, String string) {
        ListWrapper.SeriesFilterListWrapper seriesFilterListWrapper = (ListWrapper.SeriesFilterListWrapper)eventBasedRule.a(string, ListWrapper.SeriesFilterListWrapper.class);
        if (seriesFilterListWrapper != null && seriesFilterListWrapper.a() != null) {
            eventBasedRule.b(seriesFilterListWrapper.a());
        }
    }

    static <T> AutomatorParameter<T> a(BasicDBObject basicDBObject, AutomatorRule automatorRule) throws ClassNotFoundException {
        String string = basicDBObject.getString("simpleName");
        String string2 = basicDBObject.getString("type");
        boolean bl2 = basicDBObject.getBoolean("isConstant");
        Class<?> clazz = Class.forName(string2);
        AutomatorParameter automatorParameter = new AutomatorParameter(clazz, string);
        automatorParameter.a(bl2);
        if (bl2) {
            Object object = b.a().fromJson(basicDBObject.getString("value"), clazz);
            automatorParameter.a(automatorRule, object);
        }
        return automatorParameter;
    }

    private static <T> AutomatorAction b(BasicDBObject basicDBObject, AutomatorRule automatorRule) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, SecurityException, NoSuchMethodException {
        String string = basicDBObject.getString("_id");
        Class<? extends AutomatorAction> clazz = AutomatorAction.b(basicDBObject.getString("actionType"));
        Constructor<? extends AutomatorAction> constructor = clazz.getConstructor(AutomatorRule.class);
        AutomatorAction automatorAction = null;
        automatorAction = constructor.newInstance(automatorRule);
        Collection<Field> collection = ca.c(clazz);
        for (Field field : collection) {
            boolean bl2 = field.isAnnotationPresent(com.mimvista.automator.rule.a.class);
            boolean bl3 = field.isAnnotationPresent(f.class);
            if (bl2 || bl3) {
                field.setAccessible(true);
                BasicDBObject basicDBObject2 = (BasicDBObject)basicDBObject.get(field.getName());
                if (basicDBObject2 == null || basicDBObject2.isEmpty()) {
                    boolean bl4;
                    if (bl3) continue;
                    boolean bl5 = bl2 && automatorAction.a(field.getAnnotation(com.mimvista.automator.rule.a.class), field.getName());
                    boolean bl6 = bl4 = field.get(automatorAction) != null;
                    if (bl2 && (!bl5 || bl4)) continue;
                }
                String string2 = basicDBObject2.getString("name");
                Class<?> clazz2 = Class.forName(basicDBObject2.getString("type"));
                AutomatorParameter<?> automatorParameter = automatorRule.b(string2, clazz2);
                field.set(automatorAction, automatorParameter);
                continue;
            }
            if (field.getType() != UUID.class || !"id".equals(field.getName())) continue;
            field.setAccessible(true);
            field.set(automatorAction, UUID.fromString(string));
        }
        return automatorAction;
    }

    public static BasicDBObject a(ScheduledRule scheduledRule) {
        BasicDBObject basicDBObject = new BasicDBObject();
        if (scheduledRule.a() != null) {
            basicDBObject.append("cron4jTaskId", (Object)scheduledRule.a());
        }
        basicDBObject.append("cronPattern", (Object)scheduledRule.b());
        basicDBObject.append("ruleId", (Object)scheduledRule.c().toString());
        basicDBObject.append("_id", (Object)scheduledRule.d().toString());
        basicDBObject.append("description", (Object)scheduledRule.e());
        return basicDBObject;
    }

    public static ScheduledRule b(BasicDBObject basicDBObject) {
        String string = (String)basicDBObject.get("cronPattern");
        String string2 = (String)basicDBObject.get("ruleId");
        String string3 = (String)basicDBObject.get("_id");
        String string4 = (String)basicDBObject.get("description");
        UUID uUID = UUID.fromString(string2);
        UUID uUID2 = UUID.fromString(string3);
        return new ScheduledRule(string, uUID, uUID2, string4);
    }

    public static void main(String[] stringArray) {
        TimeBasedRule timeBasedRule = new TimeBasedRule();
        AutomatorParameter<String> automatorParameter = new AutomatorParameter<String>(String.class, "Test");
        automatorParameter.a(true);
        timeBasedRule.a(automatorParameter, "Awesome Test");
        TestAction testAction = new TestAction(timeBasedRule);
        LinkedHashMap<String, Class<?>> linkedHashMap = testAction.n().g();
        for (String string : linkedHashMap.keySet()) {
            testAction.a(string, automatorParameter);
        }
        timeBasedRule.a(testAction);
        c.a().b(timeBasedRule);
        AutomatorRule automatorRule = c.a().a(timeBasedRule.m());
        System.out.println("Rule 1 = Rule 2 : " + timeBasedRule.equals(automatorRule));
    }
}

