/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.filter;

import com.google.common.base.Function;
import com.mimvista.archive.search.pro.QueryParamGroup;
import com.mimvista.automator.filter.b;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.SeriesGroup;
import com.mimvista.dicom.util.DicomSeriesEvaluator;
import com.mimvista.dicom.util.Operator;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.dicom.util.TagPathComponent;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.dicom.util.VRUtils;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.BooleanCondition;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import java.io.Serializable;
import org.dcm4che2.data.VR;

public class SeriesFilter
implements b,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String a = "MMM d, yyyy";
    private final TagPath tag;
    private final Operator operator;
    private final String value;

    public SeriesFilter(int n2, Operator operator, String string) {
        this(new TagPath(n2), operator, string);
    }

    public SeriesFilter(TagPath tagPath, Operator operator, String string) {
        this.tag = tagPath;
        this.operator = operator;
        this.value = string;
    }

    public TagPath a() {
        return this.tag;
    }

    public TagPathComponent b() {
        return this.tag.getTag(this.tag.size() - 1);
    }

    public Operator c() {
        return this.operator;
    }

    public String d() {
        return this.value;
    }

    public String toString() {
        return this.f();
    }

    @Override
    public boolean a(DicomSeries dicomSeries) {
        return new DicomSeriesEvaluator(dicomSeries).evaluate(this.tag, this.operator, this.value);
    }

    public boolean a(SeriesGroup seriesGroup) {
        BooleanCondition booleanCondition = this.operator.isPositiveOperator() ? BooleanCondition.c : BooleanCondition.b;
        return FuncUtils.a(seriesGroup.getSeries(), booleanCondition, new Function<DcmSeries, Boolean>(){

            public Boolean a(DcmSeries dcmSeries) {
                return SeriesFilter.this.a(dcmSeries);
            }

            public /* synthetic */ Object apply(Object object) {
                return this.a((DcmSeries)object);
            }
        });
    }

    public MetabaseQuery a(MetabaseQuery metabaseQuery) {
        return this.operator.applyToMetabaseQuery(metabaseQuery, this.tag, this.value);
    }

    public QueryParamGroup a(QueryParamGroup queryParamGroup) {
        return this.operator.applyToNewStyleQuery(queryParamGroup, this.tag, this.value);
    }

    @Override
    public boolean e() {
        if (this.tag == null || this.tag.isEmpty()) {
            return false;
        }
        if (!this.operator.usesTwoOperands()) {
            return true;
        }
        if (cn.h(this.value)) {
            return false;
        }
        VR vR = null;
        for (int i2 = 0; i2 < this.tag.getTags().length; ++i2) {
            vR = TagUtils.vrOfTag(this.tag.getTag(i2));
            if (VR.UN != vR && (VR.SQ == vR || i2 >= this.tag.getTags().length - 1) && (VR.SQ != vR || i2 != this.tag.getTags().length - 1)) continue;
            return false;
        }
        try {
            if (VRUtils.parseUserInputValue(vR, this.value) == null) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.operator.validateValue(this.value);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.operator == null ? 0 : this.operator.hashCode());
        n3 = 31 * n3 + (this.tag == null ? 0 : this.tag.hashCode());
        n3 = 31 * n3 + (this.value == null ? 0 : this.value.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SeriesFilter seriesFilter = (SeriesFilter)object;
        if (this.operator != seriesFilter.operator) {
            return false;
        }
        if (this.tag == null ? seriesFilter.tag != null : !this.tag.equals(seriesFilter.tag)) {
            return false;
        }
        return !(this.value == null ? seriesFilter.value != null : !this.value.equals(seriesFilter.value));
    }

    public String f() {
        Messages messages = Messages.a("Automator");
        String string = this.value;
        if (VRUtils.isRelativeDateFormat(string)) {
            String string2;
            int n2 = VRUtils.getRelativeDateValue(string);
            boolean bl2 = n2 <= 0;
            n2 = Math.abs(n2);
            int n3 = VRUtils.getRelativeDateField(string);
            switch (n3) {
                case 1: {
                    string2 = "YEAR";
                    break;
                }
                case 2: {
                    string2 = "MONTH";
                    break;
                }
                default: {
                    string2 = "DAYS";
                }
            }
            String string3 = "DATE_SYNTAX_" + string2 + (bl2 ? "_AGO" : "_FROM_NOW") + (n2 == 1 ? "_SINGULAR" : "");
            String string4 = messages.getProperty(string3);
            String string5 = VRUtils.parseRelativeDateFormatTo(string, a);
            string = MIMFormat.a(string4, n2, string5);
        }
        return SeriesFilter.a(this.tag, this.operator, string, false);
    }

    static String a(TagPath tagPath, Operator operator, String string, boolean bl2) {
        if (tagPath.size() > 0) {
            boolean bl3;
            String string2;
            Messages messages = Messages.a("Automator");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < tagPath.size(); ++i2) {
                string2 = TagUtils.getTagName(tagPath.getTag(i2));
                stringBuilder.append(string2);
                if (i2 >= tagPath.size() - 1) continue;
                stringBuilder.append(".");
            }
            String string3 = null;
            string3 = bl2 && messages.d("OPERATOR_" + operator.name() + "_SIMILAR_PRETTY") ? "OPERATOR_" + operator.name() + "_SIMILAR_PRETTY" : "OPERATOR_" + operator.name() + "_PRETTY";
            string2 = TagUtils.vrOfTag(tagPath.getTag(tagPath.size() - 1));
            boolean bl4 = MetabaseKeys.isMIMFakeDicomTag(tagPath.getTag(tagPath.size() - 1)) || VRUtils.isAnyDateTypeVR((VR)string2);
            boolean bl5 = bl3 = VRUtils.isDecimalNumberTypeVR((VR)string2) || VRUtils.isIntOrLongTypeVR((VR)string2);
            if (bl4 && messages.d(string3 + "_DATE")) {
                string3 = string3 + "_DATE";
            } else if (!bl3 && !bl4 && messages.d(string3 + "_STRING")) {
                string3 = string3 + "_STRING";
            }
            String string4 = messages.getProperty(string3);
            return MIMFormat.a(string4, stringBuilder.toString(), string);
        }
        return "";
    }
}

