/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.gui;

import com.mimvista.automator.gui.ActionInputPanel;
import com.mimvista.automator.gui.ActionOutputPanel;
import com.mimvista.automator.gui.parameter.Lightboxable;
import com.mimvista.automator.rule.AutomatorAction;
import com.mimvista.automator.rule.AutomatorParameter;
import com.mimvista.automator.rule.AutomatorRule;
import com.mimvista.automator.rule.EventBasedRule;
import com.mimvista.automator.rule.actions.AutomatorProcessMessageAction;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.c;
import com.mimvista.swing.g;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ActionEditorPanel
extends Lightboxable {
    private static final long serialVersionUID = 1L;
    private JComboBox<AutomatorAction.b> actionTypeCombo;
    private DefaultComboBoxModel<AutomatorAction.b> actionTypeModel;
    private AutomatorAction currentAction;
    private AutomatorRule parentRule;
    private int positionInRule;
    private final boolean editExisting;
    private Lightboxable parentHolder;
    private JPanel inputsPanel;
    private JPanel outputsPanel;
    private JLabel infoLabel;
    private boolean isPopulatingInputs = false;

    public ActionEditorPanel(AutomatorRule automatorRule, int n2, Lightboxable lightboxable) {
        this.parentRule = automatorRule;
        this.positionInRule = n2;
        this.parentHolder = lightboxable;
        this.editExisting = false;
        this.g();
        this.h();
        this.f();
        this.i();
        if (n2 == 0 && automatorRule.v() == EventBasedRule.AutomatorEventSource.c) {
            this.actionTypeModel.setSelectedItem(AutomatorAction.a(AutomatorProcessMessageAction.class));
        }
    }

    public ActionEditorPanel(AutomatorAction automatorAction, Lightboxable lightboxable) {
        this.parentRule = automatorAction.b();
        this.positionInRule = this.parentRule.f().indexOf(automatorAction);
        this.currentAction = automatorAction.m();
        this.editExisting = true;
        this.parentHolder = lightboxable;
        this.g();
        this.h();
        this.a();
        this.i();
        this.f();
        this.actionTypeModel.setSelectedItem(this.currentAction.n());
        this.actionTypeCombo.setEnabled(false);
    }

    private void f() {
        this.setBounds(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
        this.pane.add((Component)this, JLayeredPane.DEFAULT_LAYER);
        this.pane.setPreferredSize(this.getPreferredSize());
    }

    private void g() {
        this.setPreferredSize(this.b(this.parentHolder).getSize());
        this.setBorder(Lightboxable.k());
        this.setLayout(new BorderLayout(0, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        Messages messages = Messages.a("Automator");
        JLabel jLabel = new JLabel(messages.getProperty("ACTION_EDITOR_ACTION_TYPE"));
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(5, 1)));
        this.actionTypeCombo = new JComboBox();
        this.actionTypeModel = new DefaultComboBoxModel();
        this.actionTypeCombo.setModel(this.actionTypeModel);
        this.actionTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionEditorPanel.this.a((AutomatorAction.b)ActionEditorPanel.this.actionTypeCombo.getSelectedItem());
            }
        });
        this.actionTypeCombo.setRenderer(new BasicComboBoxRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                AutomatorAction.b b2 = (AutomatorAction.b)object;
                String string = b2.d();
                Icon icon = b2.f();
                return new JLabel(string, icon, 2);
            }
        });
        this.infoLabel = new JLabel();
        this.infoLabel.setHorizontalAlignment(0);
        this.infoLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 5));
        Box box = Box.createHorizontalBox();
        box.add(this.infoLabel);
        jPanel.add(this.actionTypeCombo);
        jPanel.add(Box.createHorizontalGlue());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jPanel);
        jPanel2.add(box);
        this.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        this.add((Component)jPanel3, "Center");
        jPanel3.setLayout(new GridLayout(0, 1, 5, 5));
        this.inputsPanel = new JPanel();
        JLabel jLabel2 = new JLabel(messages.getProperty("ACTION_EDITOR_INPUTS"), ImageManipulator.a("input", 50), 2);
        jLabel2.setFont(jLabel2.getFont().deriveFont(18.0f));
        jLabel2.setOpaque(true);
        g g2 = new g(jLabel2, this.inputsPanel, BorderFactory.createTitledBorder(""));
        this.inputsPanel.setBorder(g2);
        jPanel3.add(this.inputsPanel);
        this.inputsPanel.setLayout(new GridLayout(0, 3, 5, 5));
        this.outputsPanel = new JPanel();
        jPanel3.add(this.outputsPanel);
        this.outputsPanel.setLayout(new GridLayout(0, 3, 5, 5));
        JLabel jLabel3 = new JLabel(messages.getProperty("ACTION_EDITOR_OUTPUTS"), ImageManipulator.a("output", 50), 2);
        jLabel3.setFont(jLabel3.getFont().deriveFont(18.0f));
        jLabel3.setOpaque(true);
        g g3 = new g(jLabel3, this.outputsPanel, BorderFactory.createTitledBorder(""));
        this.outputsPanel.setBorder(g3);
        JPanel jPanel4 = new JPanel();
        this.add((Component)jPanel4, "South");
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        Component component = Box.createHorizontalGlue();
        jPanel4.add(component);
        JButton jButton = c.b(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ActionEditorPanel.this.editExisting) {
                    ActionEditorPanel.this.parentRule.a(ActionEditorPanel.this.currentAction);
                } else {
                    ActionEditorPanel.this.parentRule.b(ActionEditorPanel.this.currentAction);
                }
                ActionEditorPanel.this.parentHolder.a(true);
            }
        }, "");
        jPanel4.add(jButton);
        jPanel4.add(Box.createHorizontalStrut(5));
        JButton jButton2 = c.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ActionEditorPanel.this.parentHolder.a(false);
            }
        }, "");
        jPanel4.add(jButton2);
    }

    private void h() {
        this.actionTypeModel.removeAllElements();
        for (AutomatorAction.b b2 : AutomatorAction.p()) {
            if (!b2.a(this.parentRule, this.positionInRule)) continue;
            this.actionTypeModel.addElement(b2);
        }
    }

    private void a(AutomatorAction.b b2) {
        if (this.editExisting || this.currentAction != null && this.currentAction.n().equals(b2)) {
            return;
        }
        try {
            Constructor<? extends AutomatorAction> constructor = b2.k().getConstructor(AutomatorRule.class);
            this.currentAction = constructor.newInstance(this.parentRule);
            this.a();
            this.i();
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
    }

    private void i() {
        this.infoLabel.setText(this.currentAction.n().e());
    }

    void a() {
        this.j();
        this.l();
    }

    private void j() {
        if (this.isPopulatingInputs) {
            return;
        }
        this.isPopulatingInputs = true;
        this.inputsPanel.removeAll();
        if (this.currentAction == null) {
            return;
        }
        LinkedHashMap<String, Class<?>> linkedHashMap = this.currentAction.n().g();
        for (String string : linkedHashMap.keySet()) {
            Class clazz;
            if (!this.currentAction.a(string, clazz = (Class)linkedHashMap.get(string))) continue;
            ActionInputPanel actionInputPanel = new ActionInputPanel(this.currentAction, this.positionInRule, string, clazz, this);
            this.inputsPanel.add(actionInputPanel);
        }
        this.inputsPanel.repaint();
        this.inputsPanel.revalidate();
        this.isPopulatingInputs = false;
    }

    private void l() {
        if (this.currentAction == null) {
            return;
        }
        this.outputsPanel.removeAll();
        List<AutomatorParameter<?>> list = this.currentAction.d();
        for (AutomatorParameter<?> automatorParameter : list) {
            if (automatorParameter == null) continue;
            this.outputsPanel.add(new ActionOutputPanel(this.currentAction, automatorParameter, this));
        }
        this.outputsPanel.repaint();
        this.outputsPanel.revalidate();
    }

    public AutomatorAction b() {
        return this.currentAction;
    }

    @Override
    public JComponent c() {
        return this.pane;
    }

    @Override
    public void a(Lightboxable lightboxable, boolean bl2) {
    }

    @Override
    public String d() {
        if (this.editExisting) {
            return MIMFormat.a(Messages.a("Automator", "EDIT_ACTION_TITLE"), this.currentAction.n().d());
        }
        return Messages.a("Automator", "ADD_ACTION_TITLE");
    }

    public boolean e() {
        return this.editExisting;
    }
}

