/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.gui;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.mimvista.automator.AutomatorFileImporterExporter;
import com.mimvista.automator.database.c;
import com.mimvista.automator.gui.AutomatorRuleList;
import com.mimvista.automator.gui.AutomatorRuleOverviewTable;
import com.mimvista.automator.gui.AutomatorStatusTable;
import com.mimvista.automator.logging.AutomatorRecordKeeper;
import com.mimvista.automator.message.CancelRetryMessage;
import com.mimvista.automator.message.CancelRuleExecutionMessage;
import com.mimvista.automator.message.RetryRuleMessage;
import com.mimvista.file.MIMFile;
import com.mimvista.gui.util.DynamicPopupMenu;
import com.mimvista.gui.util.DynamicPopupModel;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.gui.util.ac;
import com.mimvista.gui.util.e;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import net.tomahawk.ExtensionsFilter;
import org.jdesktop.swingx.JXTable;

public class AutomatorIntroPanel
extends JPanel {
    private static final long serialVersionUID = -1763288569703568177L;
    private AutomatorRuleList mainFrame;
    private AutomatorStatusTable tableModel;
    private AutomatorRuleOverviewTable tableModel2;
    private Timer timer;
    private final int TIMER_REFRESH = 30000;
    private JTable table;
    private final boolean hasPermissionToEdit;

    public AutomatorIntroPanel(AutomatorRuleList automatorRuleList, boolean bl2) {
        this.mainFrame = automatorRuleList;
        this.hasPermissionToEdit = bl2;
    }

    public void a() {
        if (this.timer == null) {
            this.timer = new Timer("The Assistant rule status refresh timer");
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    AutomatorIntroPanel.this.f();
                }
            };
            this.timer.scheduleAtFixedRate(timerTask, 30000L, 30000L);
        }
    }

    public void b() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void c() {
        JLabel jLabel;
        this.removeAll();
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.setLayout(new BoxLayout(this, 1));
        final Messages messages = Messages.a("Automator");
        JButton jButton = new JButton(messages.getProperty("IMPORT_AUTOMATOR_CONFIG"));
        JButton jButton2 = new JButton(messages.getProperty("EXPORT_AUTOMATOR_CONFIG"));
        JButton jButton3 = new JButton(messages.getProperty("AUTOMATOR_STATUS_TABLE_CLEAR_HISTORY"));
        JButton jButton4 = new JButton(messages.getProperty("AUTOMATOR_STATUS_TABLE_EXPORT_HISTORY"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MIMFileDialog mIMFileDialog = MIMFileDialog.a(((AutomatorIntroPanel)AutomatorIntroPanel.this).mainFrame.mainFrame, messages.getProperty("IMPORT_CHOOSE_FILE"), MIMFileDialog.FileDialogType.a);
                mIMFileDialog.a(ExtensionsFilter.getNoDescSingleExt("txt"));
                mIMFileDialog.a(true);
                if (mIMFileDialog.a() != null) {
                    final MIMFile mIMFile = new MIMFile(mIMFileDialog.a());
                    MIMSwingUtils.e(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                new AutomatorFileImporterExporter().c(mIMFile);
                                AutomatorIntroPanel.this.mainFrame.a();
                            }
                            catch (Exception exception) {
                                ay.d((Object)"error reading automator data from file", (Throwable)exception, AutomatorIntroPanel.this);
                                MIMSwingUtils.a(new Runnable(){

                                    @Override
                                    public void run() {
                                        MOptionPane.a((Component)AutomatorIntroPanel.this.mainFrame, (Object)messages.getProperty("IMPORT_ERROR_TEXT"), messages.getProperty("IMPORT_ERROR_TITLE"), -1, 0);
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MIMFile mIMFile = AutomatorIntroPanel.this.g();
                if (mIMFile != null) {
                    try {
                        new AutomatorFileImporterExporter().a(mIMFile);
                    }
                    catch (Exception exception) {
                        ay.d((Object)"error writing automator data to file", (Throwable)exception, AutomatorIntroPanel.this);
                        MOptionPane.a((Component)AutomatorIntroPanel.this.mainFrame, (Object)messages.getProperty("EXPORT_ERROR_TEXT"), messages.getProperty("EXPORT_ERROR_TITLE"), -1, 0);
                    }
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = MOptionPane.a((Component)AutomatorIntroPanel.this.mainFrame, (Object)messages.getProperty("RULE_HISTORY_CONFIRM_DELETE"), "", 0, 3);
                if (n2 == 0) {
                    MIMSwingUtils.e(new Runnable(){

                        @Override
                        public void run() {
                            AutomatorRecordKeeper.d();
                            AutomatorIntroPanel.this.f();
                        }
                    });
                }
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MIMSwingUtils.e(new Runnable(){

                    @Override
                    public void run() {
                        MIMFile mIMFile = AutomatorIntroPanel.this.g();
                        if (mIMFile != null) {
                            try {
                                AutomatorRecordKeeper.a(mIMFile);
                            }
                            catch (Exception exception) {
                                ay.d((Object)"error writing automator data to file", (Throwable)exception, AutomatorIntroPanel.this);
                                MOptionPane.a((Component)AutomatorIntroPanel.this.mainFrame, (Object)messages.getProperty("EXPORT_ERROR_TEXT"), messages.getProperty("EXPORT_ERROR_TITLE"), -1, 0);
                            }
                        }
                    }
                });
            }
        });
        this.tableModel = new AutomatorStatusTable();
        this.table = new JTable(this.tableModel);
        final DynamicPopupMenu dynamicPopupMenu = this.d();
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                dynamicPopupMenu.a();
                dynamicPopupMenu.contentsChanged(null);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                dynamicPopupMenu.a();
                dynamicPopupMenu.contentsChanged(null);
            }
        });
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
                if (component instanceof JLabel) {
                    JLabel jLabel = (JLabel)component;
                    jLabel.setToolTipText(jLabel.getText());
                }
                return component;
            }
        };
        for (int i2 = 0; i2 < this.table.getColumnCount(); ++i2) {
            this.table.getColumnModel().getColumn(i2).setCellRenderer(defaultTableCellRenderer);
        }
        DynamicPopupMenu.a(this.table, dynamicPopupMenu, null);
        this.tableModel2 = new AutomatorRuleOverviewTable();
        JXTable jXTable = new JXTable((TableModel)this.tableModel2);
        jXTable.setEditable(false);
        for (int i3 = 0; i3 < jXTable.getColumnCount(); ++i3) {
            jXTable.getColumnModel().getColumn(i3).setCellRenderer(defaultTableCellRenderer);
        }
        JButton jButton5 = new JButton(Messages.a("Automator", "AUTOMATOR_STATUS_TABLE_REFRESH"));
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutomatorIntroPanel.this.f();
            }
        });
        JLabel jLabel2 = new JLabel(ImageManipulator.c("assistant_logo_white", 50));
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(jLabel2);
        box.add(Box.createHorizontalGlue());
        Box box2 = null;
        if (!this.hasPermissionToEdit) {
            box2 = Box.createHorizontalBox();
            jLabel = new JLabel("<html>" + Messages.a("Automator", "MUST_LOGIN_AS_ASSISTANT") + "</html>");
            jLabel.setForeground(Color.red);
            jLabel.setAlignmentX(2.0f);
            box2.add(jLabel);
            box2.add(Box.createHorizontalGlue());
        }
        jLabel = new JLabel(messages.getProperty("AUTOMATOR_SUMMARY_TABLE_TITLE"));
        jLabel.setFont(jLabel.getFont().deriveFont(18.0f));
        jLabel.setAlignmentX(2.0f);
        Box box3 = Box.createHorizontalBox();
        box3.add(jLabel);
        box3.add(Box.createHorizontalGlue());
        if (!this.hasPermissionToEdit) {
            this.add(Box.createVerticalStrut(5));
            this.add(box2);
            this.add(Box.createVerticalStrut(5));
        }
        this.add(box);
        this.add(box3);
        this.add(new JScrollPane((Component)jXTable));
        this.add(Box.createVerticalStrut(5));
        JLabel jLabel3 = new JLabel(messages.getProperty("AUTOMATOR_TABLE_TITLE"));
        jLabel3.setFont(jLabel.getFont());
        Box box4 = Box.createHorizontalBox();
        box4.add(jLabel3);
        box4.add(Box.createHorizontalGlue());
        this.add(box4);
        this.add(new JScrollPane(this.table));
        Box box5 = Box.createHorizontalBox();
        if (this.hasPermissionToEdit) {
            box5.add(jButton);
        }
        box5.add(Box.createHorizontalStrut(5));
        box5.add(jButton2);
        if (this.hasPermissionToEdit) {
            box5.add(Box.createHorizontalGlue());
            box5.add(jButton3);
        }
        box5.add(Box.createHorizontalStrut(5));
        box5.add(jButton4);
        box5.add(Box.createHorizontalGlue());
        box5.add(jButton5);
        this.add(Box.createVerticalStrut(5));
        this.add(box5);
    }

    private DynamicPopupMenu d() {
        Messages messages = Messages.a("Automator");
        final e e2 = new e(messages.getProperty("AUTOMATOR_CANCEL_ACTION")){

            @Override
            public ActionListener getActionListener() {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        List list = AutomatorIntroPanel.this.e();
                        for (AutomatorRecordKeeper.a a2 : list) {
                            if (a2.getStatus() != AutomatorRecordKeeper.RuleStatus.RUNNING) continue;
                            Messages messages = Messages.a("Automator");
                            int n2 = MOptionPane.a((Component)AutomatorIntroPanel.this.mainFrame, (Object)messages.getProperty("AUTOMATOR_CANCEL_ACTION_CONFIRM"), messages.getProperty("AUTOMATOR_CANCEL_ACTION_CONFIRM_TITLE"), 0, 2);
                            if (n2 == 0) break;
                            return;
                        }
                        for (AutomatorRecordKeeper.a a2 : list) {
                            new CancelRuleExecutionMessage(a2).sendAsync();
                        }
                    }
                };
            }
        };
        final e e3 = new e(messages.getProperty("AUTOMATOR_RETRY_ACTION")){

            @Override
            public ActionListener getActionListener() {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        List list = AutomatorIntroPanel.this.e();
                        for (AutomatorRecordKeeper.a a2 : list) {
                            new RetryRuleMessage(a2).sendAsync();
                        }
                    }
                };
            }
        };
        final e e4 = new e(messages.getProperty("AUTOMATOR_CANCEL_AUTO_RETRY")){

            @Override
            public ActionListener getActionListener() {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        List list = AutomatorIntroPanel.this.e();
                        for (AutomatorRecordKeeper.a a2 : list) {
                            new CancelRetryMessage(a2).sendAsync();
                        }
                    }
                };
            }
        };
        final ac ac2 = new ac(messages.getProperty("AUTOMATOR_CANT_RETRY"), null);
        DynamicPopupModel dynamicPopupModel = new DynamicPopupModel(Lists.newArrayList((Object[])new e[]{e2, e4, e3, ac2})){

            @Override
            protected JMenuItem a(e e22) {
                JMenuItem jMenuItem = new JMenuItem(e22.getText());
                if (e22.getActionListener() != null) {
                    jMenuItem.addActionListener(e22.getActionListener());
                }
                if (e22 == ac2) {
                    jMenuItem.setEnabled(false);
                }
                return jMenuItem;
            }

            @Override
            protected Predicate<e> a() {
                return new Predicate<e>(){

                    public boolean a(e e2) {
                        List list = AutomatorIntroPanel.this.e();
                        if (list == null || list.isEmpty()) {
                            return false;
                        }
                        if (e2 == e2) {
                            for (AutomatorRecordKeeper.a a2 : list) {
                                if (a2 != null && (AutomatorRecordKeeper.RuleStatus.WAITING == a2.getStatus() || AutomatorRecordKeeper.RuleStatus.RUNNING == a2.getStatus())) continue;
                                return false;
                            }
                            return true;
                        }
                        if (e2 == e4) {
                            for (AutomatorRecordKeeper.a a3 : list) {
                                if (a3 != null && AutomatorRecordKeeper.RuleStatus.RETRY_ON_FAIL == a3.getStatus()) continue;
                                return false;
                            }
                            return true;
                        }
                        if (e2 == e3) {
                            for (AutomatorRecordKeeper.a a4 : list) {
                                if (a4 == null) {
                                    return false;
                                }
                                boolean bl2 = c.a().f(a4.getRuleId());
                                if (bl2 && AutomatorRecordKeeper.RuleStatus.WAITING != a4.getStatus() && AutomatorRecordKeeper.RuleStatus.RUNNING != a4.getStatus() && AutomatorRecordKeeper.RuleStatus.CANT_RETRY != a4.getStatus()) continue;
                                return false;
                            }
                            return true;
                        }
                        if (e2 == ac2) {
                            for (AutomatorRecordKeeper.a a5 : list) {
                                if (a5 == null) {
                                    return false;
                                }
                                boolean bl3 = c.a().f(a5.getRuleId());
                                if (bl3 && AutomatorRecordKeeper.RuleStatus.CANT_RETRY != a5.getStatus()) continue;
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }

                    public /* synthetic */ boolean apply(Object object) {
                        return this.a((e)object);
                    }
                };
            }
        };
        return new DynamicPopupMenu(dynamicPopupModel);
    }

    private List<AutomatorRecordKeeper.a> e() {
        ArrayList arrayList = Lists.newArrayList();
        for (int n2 : this.table.getSelectedRows()) {
            int n3 = this.table.convertRowIndexToModel(n2);
            arrayList.add(this.tableModel.a(n3));
        }
        return arrayList;
    }

    private void f() {
        this.tableModel.a();
        this.tableModel2.a();
    }

    private MIMFile g() {
        Messages messages = Messages.a("Automator");
        MIMFileDialog mIMFileDialog = MIMFileDialog.a(this.mainFrame.mainFrame, messages.getProperty("EXPORT_CHOOSE_FILE"), MIMFileDialog.FileDialogType.b);
        mIMFileDialog.a(ExtensionsFilter.getNoDescSingleExt("txt"));
        mIMFileDialog.a(true);
        String string = mIMFileDialog.a();
        if (string == null) {
            return null;
        }
        if (!string.endsWith(".txt")) {
            string = string + ".txt";
        }
        return new MIMFile(string);
    }
}

