/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.gui;

import com.mimvista.archive.s;
import com.mimvista.automator.database.AutomatorSerializationUtility;
import com.mimvista.automator.database.c;
import com.mimvista.automator.filter.SeriesFilter;
import com.mimvista.automator.gui.ActionEditorPanel;
import com.mimvista.automator.gui.RuleEditorPanelRenderers;
import com.mimvista.automator.gui.RuleSettingsPanel;
import com.mimvista.automator.gui.parameter.Lightboxable;
import com.mimvista.automator.gui.parameter.SeriesFilterEditorPanel;
import com.mimvista.automator.logging.a;
import com.mimvista.automator.message.AutomatorConfigurationChangedMessage;
import com.mimvista.automator.rule.AutomatorAction;
import com.mimvista.automator.rule.AutomatorRule;
import com.mimvista.automator.rule.EventBasedRule;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.mui.UnselectableListSelectionModel;
import com.mimvista.swing.g;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mongodb.BasicDBObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class RuleEditorPanel
extends Lightboxable {
    private static final long serialVersionUID = 1L;
    private AutomatorRule rule;
    private JTextField ruleNameField;
    private JTextArea ruleDescriptionField;
    private JRadioButton reactToSeries;
    private JRadioButton reactToStudy;
    private Lightboxable parent;
    private final boolean isNewRule;
    private DefaultListModel<AutomatorAction> actionListModel;
    private DefaultListModel filtersListModel;
    private BasicDBObject serializedInitialRule;
    private JLabel errorLabel = new JLabel("");
    private JPanel initialFiltersMainPanel;
    private JLabel reactToStudyInfo;

    public RuleEditorPanel(AutomatorRule automatorRule, Lightboxable lightboxable, boolean bl2) {
        this.rule = bl2 ? automatorRule : automatorRule.o();
        this.parent = lightboxable;
        this.b();
        this.pane.setPreferredSize(this.getBounds().getSize());
        this.pane.add((Component)this, JLayeredPane.DEFAULT_LAYER);
        this.isNewRule = bl2;
        this.serializedInitialRule = bl2 ? null : AutomatorSerializationUtility.a(automatorRule);
    }

    private void b() {
        this.setBounds(this.b(this.parent));
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = this.e();
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = this.f();
        this.add((Component)jPanel2, "Center");
        JPanel jPanel3 = this.l();
        this.add((Component)jPanel3, "South");
        this.setBorder(RuleEditorPanel.k());
    }

    private JPanel e() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.ruleNameField = new JTextField();
        this.ruleNameField.setText(this.rule.j());
        jPanel2.add(new JLabel(Messages.a("Automator", "RULE_EDITOR_NAME")));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.ruleNameField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.ruleDescriptionField = new JTextArea();
        this.ruleDescriptionField.setText(this.rule.p());
        jPanel3.add(new JLabel(Messages.a("Automator", "DESCRIPTION_LABEL")));
        jPanel3.add(Box.createHorizontalStrut(5));
        jPanel3.add(this.ruleDescriptionField);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel f() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (this.rule instanceof EventBasedRule) {
            EventBasedRule eventBasedRule = (EventBasedRule)this.rule;
            if (eventBasedRule.v() != EventBasedRule.AutomatorEventSource.c) {
                jPanel.add(this.g());
                jPanel.add(this.j());
            }
        } else {
            jPanel.add(this.h());
        }
        jPanel.add(this.i());
        this.n();
        return jPanel;
    }

    private JPanel g() {
        Messages messages = Messages.a("Automator");
        this.reactToSeries = new JRadioButton(messages.getProperty("AUTOMATOR_REACT_SERIES"));
        this.reactToStudy = new JRadioButton(messages.getProperty("AUTOMATOR_REACT_STUDY"));
        String string = MIMFormat.a(messages.getProperty("AUTOMATOR_REACT_STUDY_INFO"), TagUtils.getTagName(s.c()), s.a());
        this.reactToStudyInfo = new JLabel("<html>" + string + "</html>");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.reactToSeries);
        buttonGroup.add(this.reactToStudy);
        this.reactToSeries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((EventBasedRule)RuleEditorPanel.this.rule).a(EventBasedRule.AutomatorEventSource.a);
                RuleEditorPanel.this.initialFiltersMainPanel.setVisible(true);
                RuleEditorPanel.this.reactToStudyInfo.setVisible(false);
            }
        });
        this.reactToStudy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((EventBasedRule)RuleEditorPanel.this.rule).a(EventBasedRule.AutomatorEventSource.b);
                RuleEditorPanel.this.initialFiltersMainPanel.setVisible(false);
                RuleEditorPanel.this.reactToStudyInfo.setVisible(true);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Box box = Box.createHorizontalBox();
        box.add(this.reactToSeries);
        box.add(this.reactToStudy);
        box.add(this.h());
        box.add(Box.createHorizontalGlue());
        jPanel.add(box);
        Box box2 = Box.createHorizontalBox();
        box2.add(this.reactToStudyInfo);
        jPanel.add(box2);
        this.reactToStudyInfo.setAlignmentX(2.0f);
        this.reactToStudyInfo.setBorder(new EmptyBorder(0, 30, 0, 0));
        box.setAlignmentX(2.0f);
        this.reactToStudyInfo.setBorder(Lightboxable.k());
        return jPanel;
    }

    private Component h() {
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton(Messages.a("Automator", "AUTOMATOR_RULE_SETTINGS"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RuleSettingsPanel ruleSettingsPanel = new RuleSettingsPanel(RuleEditorPanel.this.rule, RuleEditorPanel.this);
                RuleEditorPanel.this.a(ruleSettingsPanel);
            }
        });
        box.add(jButton);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private JPanel i() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JList<Object> jList = new JList<Object>();
        this.actionListModel = new DefaultListModel();
        jList.setModel(this.actionListModel);
        jList.setCellRenderer(new RuleEditorPanelRenderers.ActionListCellRenderer());
        jPanel.add(new JScrollPane(jList));
        String string = Messages.a("Automator", "RULE_EDITOR_ACTIONS");
        Icon icon = ImageManipulator.a("action", 40);
        Font font = new JLabel().getFont().deriveFont(16.0f).deriveFont(1);
        g g2 = Lightboxable.a(string, font, icon, jPanel);
        jPanel.setBorder(g2);
        jList.setSelectionMode(0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JButton jButton = com.mimvista.gui.util.c.a(actionEvent -> this.a(new ActionEditorPanel(this.rule, this.rule.f().size(), this)), Messages.a("Automator", "RULE_EDITOR_ADD_ACTION_TIP"), false);
        JButton jButton2 = new JButton(ImageManipulator.a("subtract", 25));
        jButton2.addActionListener(actionEvent -> {
            AutomatorAction automatorAction = (AutomatorAction)jList.getSelectedValue();
            if (automatorAction != null) {
                this.rule.a(automatorAction.a());
                this.p();
                this.m();
            }
        });
        JButton jButton3 = new JButton(ImageManipulator.a("pencil", 25));
        jButton3.addActionListener(actionEvent -> {
            AutomatorAction automatorAction = (AutomatorAction)jList.getSelectedValue();
            if (automatorAction != null) {
                this.a(new ActionEditorPanel(automatorAction, this));
            }
        });
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel2.add(jButton3);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 1)));
        jPanel2.add(jButton2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jPanel2);
        jList.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            AutomatorAction automatorAction = (AutomatorAction)jList.getSelectedValue();
            jButton2.setEnabled(automatorAction != null);
            jButton3.setEnabled(automatorAction != null);
        });
        jPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 500));
        jPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 500));
        jButton2.setToolTipText(Messages.a("Automator", "DELETE_ACTION_TIP"));
        jButton3.setToolTipText(Messages.a("Automator", "EDIT_ACTION_TIP"));
        jButton2.setEnabled(false);
        jButton3.setEnabled(false);
        return jPanel;
    }

    private JPanel j() {
        this.initialFiltersMainPanel = new JPanel();
        this.initialFiltersMainPanel.setLayout(new BoxLayout(this.initialFiltersMainPanel, 1));
        String string = Messages.a("Automator", "PARAM_INITIAL_FILTERS");
        Font font = new JLabel().getFont().deriveFont(16.0f).deriveFont(1);
        Icon icon = ImageManipulator.c("filter", 30);
        g g2 = Lightboxable.a(string, font, icon, this.initialFiltersMainPanel);
        this.initialFiltersMainPanel.setBorder(g2);
        this.filtersListModel = new DefaultListModel();
        JList jList = new JList();
        jList.setModel(this.filtersListModel);
        jList.setSelectionModel(new UnselectableListSelectionModel());
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.initialFiltersMainPanel.add(jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(Messages.a("Automator", "RULE_LIST_CONFIGURE_FILTERS"));
        jButton.setToolTipText(Messages.a("Automator", "RULE_LIST_CONFIGURE_FILTERS_TIP"));
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SeriesFilterEditorPanel seriesFilterEditorPanel = new SeriesFilterEditorPanel(RuleEditorPanel.this.rule, ((EventBasedRule)RuleEditorPanel.this.rule).I(), (Lightboxable)RuleEditorPanel.this, false);
                seriesFilterEditorPanel.a(new Runnable(){

                    @Override
                    public void run() {
                        RuleEditorPanel.this.a(true);
                        RuleEditorPanel.this.o();
                    }
                });
                RuleEditorPanel.this.a(seriesFilterEditorPanel);
            }
        });
        this.initialFiltersMainPanel.add(Box.createVerticalStrut(5));
        this.initialFiltersMainPanel.add(jPanel);
        return this.initialFiltersMainPanel;
    }

    private JPanel l() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.errorLabel.setForeground(Color.red);
        JButton jButton = com.mimvista.gui.util.c.b(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RuleEditorPanel.this.rule.a(RuleEditorPanel.this.ruleNameField.getText());
                RuleEditorPanel.this.rule.b(RuleEditorPanel.this.ruleDescriptionField.getText());
                if (RuleEditorPanel.this.m()) {
                    RuleEditorPanel.this.rule.s();
                    c.a().b(RuleEditorPanel.this.rule);
                    new AutomatorConfigurationChangedMessage().sendAsync();
                    RuleEditorPanel.this.parent.a(true);
                    RuleEditorPanel.this.a();
                }
                MIMSwingUtils.e(new Runnable(){

                    @Override
                    public void run() {
                        for (AutomatorAction automatorAction : RuleEditorPanel.this.rule.f()) {
                            automatorAction.e();
                        }
                    }
                });
            }
        }, "");
        JButton jButton2 = com.mimvista.gui.util.c.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RuleEditorPanel.this.parent.a(false);
            }
        }, "");
        jPanel.add(this.errorLabel);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jButton2);
        return jPanel;
    }

    protected void a() {
        if (this.isNewRule) {
            a.a().a(this.rule);
        } else {
            a.a().a(this.serializedInitialRule, AutomatorSerializationUtility.a(this.rule));
        }
    }

    private boolean m() {
        if (this.rule.r()) {
            this.errorLabel.setText("");
            return true;
        }
        this.errorLabel.setText(Messages.a("Automator", "INVALID_RULE_WARN"));
        return false;
    }

    private void n() {
        this.o();
        this.p();
        this.m();
    }

    private void o() {
        if (this.rule.t() || this.rule.v() == EventBasedRule.AutomatorEventSource.c) {
            return;
        }
        if (this.rule.v() == EventBasedRule.AutomatorEventSource.b) {
            this.reactToStudy.setSelected(true);
            this.initialFiltersMainPanel.setVisible(false);
            this.reactToStudyInfo.setVisible(true);
            return;
        }
        this.reactToSeries.setSelected(true);
        this.initialFiltersMainPanel.setVisible(true);
        this.reactToStudyInfo.setVisible(false);
        this.filtersListModel.clear();
        Set<SeriesFilter> set = ((EventBasedRule)this.rule).H();
        for (SeriesFilter seriesFilter : set) {
            this.filtersListModel.addElement(seriesFilter);
        }
        if (set.isEmpty()) {
            this.filtersListModel.addElement(Messages.a("Automator", "RULE_LIST_NO_INITIAL_FILTERS"));
        }
    }

    private void p() {
        this.actionListModel.clear();
        List<AutomatorAction> list = this.rule.f();
        for (AutomatorAction automatorAction : list) {
            this.actionListModel.addElement(automatorAction);
        }
    }

    @Override
    public JComponent c() {
        return this.pane;
    }

    @Override
    public void a(Lightboxable lightboxable, boolean bl2) {
        this.n();
    }

    @Override
    public String d() {
        if (this.isNewRule) {
            if (this.rule.v() == EventBasedRule.AutomatorEventSource.c) {
                return Messages.a("Automator", "CREATE_NEW_RULE_MESSAGE_TITLE");
            }
            return Messages.a("Automator", "CREATE_NEW_RULE_" + (this.rule.t() ? "TIME" : "EVENT") + "_TITLE");
        }
        return this.rule.j();
    }
}

