/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.gui;

import com.mimvista.automator.gui.parameter.Lightboxable;
import com.mimvista.automator.rule.AutomatorRule;
import com.mimvista.gui.util.c;
import com.mimvista.util.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RuleSettingsPanel
extends Lightboxable {
    private static final long serialVersionUID = 1L;
    private JPanel panel;
    private AutomatorRule rule;
    private Lightboxable parent;
    private JCheckBox retryCheckbox;
    private JCheckBox timeoutCheckbox;
    private JCheckBox searchEmbeddedCheckbox;
    private JTextField timeoutTextField;
    private JLabel errorLabel;

    public RuleSettingsPanel(AutomatorRule automatorRule, Lightboxable lightboxable) {
        this.parent = lightboxable;
        this.panel = new JPanel();
        this.rule = automatorRule;
        this.errorLabel = new JLabel("");
        this.errorLabel.setForeground(Color.red);
    }

    @Override
    public void a(Lightboxable lightboxable, boolean bl2) {
        System.out.println("");
    }

    @Override
    public JComponent c() {
        this.panel.removeAll();
        this.panel.setBorder(RuleSettingsPanel.k());
        Box box = this.e();
        JPanel jPanel = this.b();
        Box box2 = Box.createHorizontalBox();
        box2.add(box);
        box2.add(Box.createHorizontalGlue());
        box2.setBorder(BorderFactory.createEtchedBorder());
        Box box3 = Box.createHorizontalBox();
        box3.add(Box.createVerticalStrut(25));
        box3.add(this.errorLabel);
        box3.add(Box.createHorizontalGlue());
        Box box4 = Box.createVerticalBox();
        box4.add(box2);
        box4.add(box3);
        box4.add(jPanel);
        this.panel.add(box4);
        return this.panel;
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = c.b(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RuleSettingsPanel.this.a()) {
                    RuleSettingsPanel.this.f();
                    RuleSettingsPanel.this.parent.a(true);
                }
            }
        }, "");
        JButton jButton2 = c.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RuleSettingsPanel.this.parent.a(false);
            }
        }, "");
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add(jButton2);
        return jPanel;
    }

    private Box e() {
        Box box = Box.createVerticalBox();
        box.add(this.h());
        box.add(this.i());
        box.add(this.g());
        return box;
    }

    private void f() {
        this.rule.a(this.retryCheckbox.isSelected());
        if (this.timeoutCheckbox.isSelected() && this.a()) {
            this.rule.a(Double.parseDouble(this.timeoutTextField.getText().trim()));
        } else {
            this.rule.a(-1.0);
        }
        this.rule.b(this.searchEmbeddedCheckbox.isSelected());
    }

    private Component g() {
        this.searchEmbeddedCheckbox = new JCheckBox(Messages.a("Automator", "AUTOMATOR_INCLUDE_EMBEDDED"));
        this.searchEmbeddedCheckbox.setSelected(this.rule.B());
        Box box = Box.createHorizontalBox();
        box.add(this.searchEmbeddedCheckbox);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    @Override
    public String d() {
        return Messages.a("Automator", "AUTOMATOR_RULE_SETTINGS");
    }

    private Component h() {
        Box box = Box.createHorizontalBox();
        this.retryCheckbox = new JCheckBox(Messages.a("Automator", "AUTOMATOR_RULE_RETRY_CHECKBOX"));
        this.retryCheckbox.setSelected(this.rule.A());
        box.add(this.retryCheckbox);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private Component i() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(2.0f);
        this.timeoutCheckbox = new JCheckBox(Messages.a("Automator", "AUTOMATOR_RULE_TIMEOUT_CHECKBOX"));
        this.timeoutTextField = new JTextField(5);
        Dimension dimension = this.timeoutTextField.getMinimumSize();
        this.timeoutTextField.setMaximumSize(dimension);
        this.timeoutTextField.setEnabled(this.timeoutCheckbox.isSelected());
        final JLabel jLabel = new JLabel(Messages.a("Util", "DATEFRMT_MINS"));
        box.add(this.timeoutCheckbox);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.timeoutTextField);
        box.add(Box.createHorizontalStrut(2));
        box.add(jLabel);
        jLabel.setEnabled(this.timeoutCheckbox.isSelected());
        box.add(Box.createHorizontalGlue());
        jPanel.add(box);
        this.timeoutCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RuleSettingsPanel.this.timeoutTextField.setEnabled(RuleSettingsPanel.this.timeoutCheckbox.isSelected());
                jLabel.setEnabled(RuleSettingsPanel.this.timeoutCheckbox.isSelected());
            }
        });
        if (this.rule.l()) {
            this.timeoutCheckbox.doClick();
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            this.timeoutTextField.setText(numberFormat.format(this.rule.k()));
        }
        return jPanel;
    }

    protected boolean a() {
        if (!this.timeoutCheckbox.isSelected()) {
            return true;
        }
        try {
            double d2 = Double.parseDouble(this.timeoutTextField.getText().trim());
            if (d2 > 0.0) {
                return true;
            }
            this.errorLabel.setText(Messages.a("Automator", "INVALID_RULE_TIME_NEGATIVE"));
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            this.errorLabel.setText(Messages.a("Automator", "INVALID_RULE_TIME_NON_NUMBER"));
        }
        catch (NullPointerException nullPointerException) {
            this.errorLabel.setText(Messages.a("Automator", "INVALID_RULE_NULL_TIME"));
        }
        return false;
    }
}

