/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.managed;

import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.fractions.FractionGrade;
import com.mimvista.archive.gui.fractions.FractionStatus;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.automator.database.b;
import com.mimvista.automator.managed.ArtAssistReplanTask;
import com.mimvista.automator.message.ProcessReplanMessage;
import com.mimvista.automator.rule.c;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.metabase.DbWriteResult;
import com.mimvista.report.automated.service.ArtAssistExceptions;
import com.mimvista.report.automated.service.AutomatedWorkflowSandbox;
import com.mimvista.report.automated.service.AutomatedWorkflowStatus;
import com.mimvista.report.automated.service.a;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.FractionUpdate;
import com.mimvista.report.cbct.config.h;
import com.mimvista.report.cbct.config.l;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMDateFormat;
import com.mimvista.util.ag;
import com.mimvista.util.ay;
import com.mimvista.util.az;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class ArtAssistTask
implements Serializable,
Runnable {
    private static final long serialVersionUID = 1L;
    @Deprecated
    static final String e = "source";
    static final String f = "patientList";
    static final String g = "_id";
    static final String h = "status";
    static final String i = "patientId";
    static final String j = "receivedDate";
    static final String k = "lastAttemptDate";
    static final String l = "configId";
    static final String m = "fractionNum";
    static final String n = "fractionDeliveryNum";
    static final String o = "taskType";
    protected final UUID id;
    private final Date receivedDate;
    private DcmSeries series;
    protected AutomatedWorkflowStatus status;
    private Date lastAttemptedDate;
    private final ArtAssistConfig config;
    private final FractionInformation fraction;
    private final transient List<c> a = Collections.synchronizedList(new ArrayList());
    protected final transient AutomatedWorkflowSandbox p;
    private final transient h b;
    protected TaskType taskType = TaskType.a;

    public ArtAssistTask(DcmSeries dcmSeries, ArtAssistConfig artAssistConfig, FractionInformation fractionInformation) {
        this(UUID.randomUUID(), dcmSeries, artAssistConfig, fractionInformation, AutomatedWorkflowStatus.n, new Date());
    }

    protected ArtAssistTask(UUID uUID, DcmSeries dcmSeries, ArtAssistConfig artAssistConfig, FractionInformation fractionInformation, AutomatedWorkflowStatus automatedWorkflowStatus, Date date) {
        this.id = uUID;
        this.series = dcmSeries;
        this.config = artAssistConfig;
        this.fraction = fractionInformation;
        this.status = automatedWorkflowStatus;
        this.receivedDate = date;
        this.p = new AutomatedWorkflowSandbox(true);
        this.b = (h)((Object)dcmSeries.getSearchSource());
    }

    public DcmSeries c() {
        return this.series;
    }

    public String d() {
        return this.series.getPatientID();
    }

    public Date e() {
        return this.receivedDate;
    }

    public FractionInformation f() {
        return this.fraction;
    }

    public ArtAssistConfig g() {
        return this.config;
    }

    public boolean h() {
        return this.taskType == TaskType.b;
    }

    public String i() {
        String string = this.series.getSeriesInstanceUID() + " [no fraction info!]";
        FractionInformation fractionInformation = this.f();
        if (fractionInformation != null) {
            MIMDateFormat mIMDateFormat = DateUtils.a("yyyy-MM-dd HH:mm:ss");
            string = fractionInformation.getFractionNumber() + "-" + fractionInformation.getFractionDeliveryNumber() + ": " + mIMDateFormat.format(fractionInformation.getSeriesDate());
        }
        return this.config.E() + " " + string + " Task type: " + (Object)((Object)this.taskType);
    }

    public void a() {
        DbWriteResult dbWriteResult;
        FractionUpdate fractionUpdate = new FractionUpdate(this.config, this.fraction).a(this.n()).a(FractionStatus.getFractionStatusFromWorkflowStatus(this.n()));
        if (!fractionUpdate.a() && (dbWriteResult = this.b.a(fractionUpdate)).b()) {
            this.fraction.setWorkflowStatus(fractionUpdate.h());
            this.fraction.setStatus(fractionUpdate.g());
        }
    }

    public void j() {
        DbWriteResult dbWriteResult;
        FractionUpdate fractionUpdate = new FractionUpdate(this.config, this.fraction).a(this.o());
        if (!fractionUpdate.a() && (dbWriteResult = this.b.a(fractionUpdate)).b()) {
            this.fraction.setLastAttemptedDate(fractionUpdate.j());
        }
    }

    @Override
    public void run() {
        try {
            if (this.n() != AutomatedWorkflowStatus.b) {
                ay.d((Object)"ART Assist Task is running which does not have expected status of QUEUED", (Throwable)new RuntimeException(), this);
            }
            ay.b((Object)("ART Assist Processing starting on fraction: " + this.series), this);
            this.a(AutomatedWorkflowStatus.l);
            this.a(new Date());
            FractionInformation fractionInformation = this.f();
            com.mimvista.report.automated.service.a.a(this.p, this.series, this.config, fractionInformation, this.id);
            if (!this.p.b()) {
                this.a(AutomatedWorkflowStatus.p);
            }
        }
        catch (ArtAssistExceptions.ArtAssistException artAssistException) {
            ay.d((Object)artAssistException, this);
            this.a(artAssistException.d());
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
            this.a(AutomatedWorkflowStatus.c);
        }
    }

    public void k() {
        if (this.p.a()) {
            this.p.c();
        }
        this.a(AutomatedWorkflowStatus.o);
        FractionUpdate fractionUpdate = new FractionUpdate(this.config, this.fraction).a(FractionGrade.NOT_CALCULATED).a(FractionStatus.NOT_PROCESSED).a(AutomatedWorkflowStatus.o);
        DbWriteResult dbWriteResult = this.b.a(fractionUpdate);
        if (dbWriteResult.b()) {
            this.fraction.setGrade(fractionUpdate.i());
            this.fraction.setStatus(fractionUpdate.g());
            this.fraction.setWorkflowStatus(fractionUpdate.h());
        }
    }

    public void l() {
        if (!this.p.a()) {
            return;
        }
        this.p.c();
        this.a(AutomatedWorkflowStatus.q);
    }

    public UUID m() {
        return this.id;
    }

    public void a(c c2) {
        this.a.add(c2);
    }

    public void b(c c2) {
        this.a.remove(c2);
    }

    public AutomatedWorkflowStatus n() {
        return this.status;
    }

    public void a(AutomatedWorkflowStatus automatedWorkflowStatus) {
        boolean bl2 = automatedWorkflowStatus != this.status;
        this.status = automatedWorkflowStatus;
        if (bl2) {
            for (c c2 : this.a) {
                c2.a(this);
            }
        }
    }

    public Date o() {
        return this.lastAttemptedDate;
    }

    public void a(Date date) {
        this.lastAttemptedDate = date;
        for (c c2 : this.a) {
            c2.b(this);
        }
    }

    public String toString() {
        return "ART Assist for Fraction: " + this.series.getSeriesInstanceUID();
    }

    public DBObject b() {
        DBObject dBObject = new BasicDBObjectBuilder().add(g, (Object)this.id.toString()).add(i, (Object)this.series.getPatientID()).add(f, (Object)com.mimvista.automator.database.b.a(this.b.u())).add(h, (Object)this.status.name()).add(k, (Object)this.o()).add(j, (Object)this.e()).add(l, (Object)this.config.b()).add(m, (Object)(this.fraction == null ? -1 : this.fraction.getFractionNumber())).add(n, (Object)(this.fraction == null ? -1 : this.fraction.getFractionDeliveryNumber())).add(o, (Object)this.taskType.name()).get();
        return dBObject;
    }

    public static ArtAssistTask a(DBObject dBObject) {
        DcmSeries dcmSeries;
        Object object;
        h h2;
        ArtAssistConfig artAssistConfig;
        ag ag2;
        UUID uUID = UUID.fromString((String)dBObject.get(g));
        SearchSource searchSource = null;
        if (dBObject.containsField(e) && (searchSource = com.mimvista.automator.database.b.a((String)dBObject.get(e), false, false)) == null) {
            ay.d((Object)("Deserialized source is null: " + String.valueOf(dBObject.get(e))), ArtAssistTask.class);
        }
        if (searchSource == null && dBObject.containsField(f)) {
            ag2 = com.mimvista.automator.database.b.b((String)dBObject.get(f), false, false);
            if (ag2 != null) {
                searchSource = com.mimvista.archive.a.a((SendToDestination)ag2);
            } else {
                ay.d((Object)("Deserialized destination is null: " + String.valueOf(dBObject.get(f))), ArtAssistTask.class);
            }
        }
        if (searchSource == null || !searchSource.s()) {
            ay.d((Object)("No valid patient list associated with task, or does not support ART Assist: " + String.valueOf(searchSource)), ArtAssistTask.class);
            return null;
        }
        ag2 = AutomatedWorkflowStatus.valueOf((String)dBObject.get(h));
        Date date = (Date)dBObject.get(j);
        Date date2 = (Date)dBObject.get(k);
        String string = (String)dBObject.get(l);
        int n2 = ArtAssistTask.a(dBObject, m, -1);
        int n3 = com.mimvista.archive.a.d() ? -1 : 0;
        int n4 = ArtAssistTask.a(dBObject, n, n3);
        TaskType taskType = TaskType.a;
        if (dBObject.containsField(o)) {
            taskType = TaskType.valueOf((String)dBObject.get(o));
        }
        if ((artAssistConfig = com.mimvista.report.cbct.config.l.a(h2 = (h)((Object)searchSource), string)) == null) {
            ay.d((Object)("Unable to resolve config for task: " + uUID.toString() + ", config: " + string), ArtAssistTask.class);
            return null;
        }
        FractionInformation fractionInformation = artAssistConfig.a(n2, n4);
        if (fractionInformation == null) {
            ay.d((Object)("Unable to resolve fraction for task: " + uUID.toString() + ", config: " + string + ", fraction" + n2 + "." + n4), ArtAssistTask.class);
            return null;
        }
        try {
            object = searchSource.a(fractionInformation.getFractionSeries()).get();
            dcmSeries = ((az)object).b();
        }
        catch (Exception exception) {
            ay.d((Object)("Unable to locate series referenced by ArtAssistTask pointer for task: " + uUID.toString() + ", pointer; " + fractionInformation.getFractionSeries().toString()), (Throwable)exception, ArtAssistTask.class);
            return null;
        }
        if (taskType == TaskType.b) {
            ArtAssistConfig artAssistConfig2 = com.mimvista.report.cbct.config.l.a(h2, (String)dBObject.get("replanConfig"));
            String string2 = (String)dBObject.get("replanWorkflowName");
            String string3 = (String)dBObject.get("originalPlanTargetName");
            String string4 = (String)dBObject.get("replanTargetName");
            ProcessReplanMessage.ReplanWorkflowTargets replanWorkflowTargets = new ProcessReplanMessage.ReplanWorkflowTargets(string2, string3, string4);
            object = new ArtAssistReplanTask(uUID, (AutomatedWorkflowStatus)ag2, date, artAssistConfig, fractionInformation, dcmSeries, artAssistConfig2, replanWorkflowTargets);
        } else {
            object = new ArtAssistTask(uUID, dcmSeries, artAssistConfig, fractionInformation, (AutomatedWorkflowStatus)ag2, date);
        }
        ((ArtAssistTask)object).lastAttemptedDate = date2;
        return object;
    }

    private static int a(DBObject dBObject, String string, int n2) {
        int n3 = n2;
        if (dBObject.containsField(string)) {
            try {
                n3 = (Integer)dBObject.get(string);
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, ArtAssistTask.class);
            }
        }
        return n3;
    }

    static enum TaskType {
        a,
        b;

    }
}

