/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.message;

import com.mimvista.archive.search.SearchSource;
import com.mimvista.automator.message.ArchiveHappenedMessage;
import com.mimvista.automator.message.AutomatorMessage;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.h;
import com.mimvista.report.cbct.config.l;
import java.util.Collections;
import java.util.UUID;

public abstract class AbstractArtFractionMessage
extends AutomatorMessage {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_REPLAN = -1;
    private UUID id;
    private SearchSource source;
    private String configUid;
    private UniqueSeriesPointer series;
    private int fractionNum;
    private int deliveryNum;

    public AbstractArtFractionMessage(SearchSource searchSource, String string, UniqueSeriesPointer uniqueSeriesPointer, int n2, int n3) {
        this.source = searchSource;
        this.configUid = string;
        this.series = uniqueSeriesPointer;
        this.fractionNum = n2;
        this.deliveryNum = n3;
    }

    public AbstractArtFractionMessage(UUID uUID) {
        this.id = uUID;
    }

    public UUID getId() {
        return this.id;
    }

    public SearchSource getSource() {
        return this.source;
    }

    public String getConfigUID() {
        return this.configUid;
    }

    public ArtAssistConfig getConfig() {
        return this.a(this.configUid);
    }

    public int getFractionNum() {
        return this.fractionNum;
    }

    public int getDeliveryNum() {
        return this.deliveryNum;
    }

    public DcmSeries getSeries() {
        if (this.series == null) {
            return null;
        }
        return ArchiveHappenedMessage.fetchAndWaitOnSeries(Collections.singletonList(this.series), this.source).stream().findFirst().orElse(null);
    }

    public boolean isUnknownReplan() {
        return this.fractionNum == -1;
    }

    protected ArtAssistConfig a(String string) {
        h h2 = (h)((Object)this.source);
        return l.a(h2, string);
    }

    protected String a() {
        if (this.getId() != null) {
            return this.getId().toString();
        }
        ArtAssistConfig artAssistConfig = this.getConfig();
        return this.getFractionNum() + "." + this.getDeliveryNum() + " on config: " + (artAssistConfig == null ? null : artAssistConfig.J());
    }
}

