/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.message;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.automator.database.b;
import com.mimvista.automator.message.AutomatorMessage;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.factories.DcmSeriesFactory;
import com.mimvista.dicom.factories.SuperDcmSeriesFactory;
import com.mimvista.util.ay;
import com.mimvista.util.az;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;

public abstract class ArchiveHappenedMessage
extends AutomatorMessage {
    private static final long serialVersionUID = 8286709231273661982L;
    protected String destinationIdentifier;
    protected String sourceIdentifier;
    protected String studyKey;

    public ArchiveHappenedMessage(SearchSource searchSource, SendToDestination sendToDestination, String string) {
        this.destinationIdentifier = sendToDestination == null ? null : sendToDestination.getIdentifier();
        this.sourceIdentifier = b.a(searchSource);
        this.studyKey = string;
    }

    public static List<DcmSeries> fetchAndWaitOnSeries(Collection<UniqueSeriesPointer> collection, SearchSource searchSource) {
        Future<List<az<DcmSeries>>> future = searchSource.a(collection);
        ArrayList<DcmSeries> arrayList = new ArrayList<DcmSeries>();
        try {
            List<az<DcmSeries>> list = future.get();
            list.stream().forEach(az2 -> {
                if (az2.a()) {
                    arrayList.add((DcmSeries)az2.b());
                }
            });
        }
        catch (Throwable throwable) {
            ay.d((Object)"Couldn't fetch series properly: ", throwable, ArchiveHappenedMessage.class);
        }
        return arrayList;
    }

    public abstract List<DcmSeries> getSeries();

    public String getStudyKey() {
        return this.studyKey;
    }

    public String getDestinationIdentifierString() {
        return this.destinationIdentifier;
    }

    public SearchSource getSearchSource() {
        return b.a(this.sourceIdentifier, true, true);
    }

    @Deprecated
    public static DcmSeries getSingleSeriesFromPath(String string, SearchSource searchSource) {
        DcmSeries dcmSeries = null;
        if (searchSource != null && searchSource.r()) {
            dcmSeries = SuperDcmSeriesFactory.getDcmSeriesFromArchiveDirectoryUseMetabase(string);
        }
        if (dcmSeries == null) {
            dcmSeries = DcmSeriesFactory.getDcmSeriesFromArchiveDirectory(string);
        }
        if (dcmSeries == null) {
            ay.d((Object)("couldn't recreate DCMSeries!! " + string), ArchiveHappenedMessage.class);
            return null;
        }
        dcmSeries.setSearchSource(searchSource);
        dcmSeries.setLocalDir(string);
        return dcmSeries;
    }

    @AutomatorMessage.a(a="STUDY_ARCHIVE")
    public static class StudyArchiveCompleteMessage
    extends ArchiveHappenedMessage {
        private final Collection<UniqueSeriesPointer> seriesPointers;

        public StudyArchiveCompleteMessage(SearchSource searchSource, SendToDestination sendToDestination, Collection<UniqueSeriesPointer> collection, String string) {
            super(searchSource, sendToDestination, string);
            this.seriesPointers = collection;
        }

        @Override
        public String getPrettyPayloadString() {
            return "Study Archive Complete: " + this.destinationIdentifier + " " + this.studyKey;
        }

        @Override
        public List<DcmSeries> getSeries() {
            return StudyArchiveCompleteMessage.fetchAndWaitOnSeries(this.seriesPointers, this.getSearchSource());
        }
    }

    @AutomatorMessage.a(a="SERIES_ARCHIVE")
    public static class SeriesArchiveHappenedMessage
    extends ArchiveHappenedMessage {
        private UniqueSeriesPointer seriesPointer;

        public SeriesArchiveHappenedMessage(SearchSource searchSource, SendToDestination sendToDestination, UniqueSeriesPointer uniqueSeriesPointer, String string) {
            super(searchSource, sendToDestination, string);
            this.seriesPointer = uniqueSeriesPointer;
        }

        @Override
        public String getPrettyPayloadString() {
            return "Series Archive Happened: " + this.destinationIdentifier + " - " + this.seriesPointer;
        }

        @Override
        public List<DcmSeries> getSeries() {
            return SeriesArchiveHappenedMessage.fetchAndWaitOnSeries(Lists.newArrayList((Object[])new UniqueSeriesPointer[]{this.seriesPointer}), this.getSearchSource());
        }
    }
}

