/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.message;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.IndirectlyInstantiated;
import com.mimvista.MimJsonSerializable;
import com.mimvista.automator.Automator;
import com.mimvista.automator.d;
import com.mimvista.automator.database.b;
import com.mimvista.preferencesNew.AutomatorPrefs;
import com.mimvista.util.au;
import com.mimvista.util.ay;
import com.mimvista.util.ca;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.reflections.Reflections;

@MimJsonSerializable
@IndirectlyInstantiated
public abstract class AutomatorMessage
implements au<AutomatorMessage>,
Serializable {
    private static final long serialVersionUID = -6594196760077835105L;
    private transient ClientMessage originalMessage;
    private transient AtomicInteger numAcksRequired = new AtomicInteger(1);
    private static final String MessageTypeKey = "AutomatorMessageType";
    private static final String MessageKey = "AutomatorMessage";
    private static final ThreadPoolExecutor messageSendExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "Assistant Message Handling Thread");
            thread.setPriority(5);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    ay.d((Object)("Uncaught exception in " + thread.getName()), throwable, Automator.class);
                }
            });
            return thread;
        }
    });

    public abstract String getPrettyPayloadString();

    public String toString() {
        return this.getPrettyPayloadString();
    }

    public ClientMessage createMessage() {
        int n2 = AutomatorPrefs.messageTimeoutInHours.getValue();
        long l2 = (long)n2 * 60L * 60L * 1000L;
        ClientMessageImpl clientMessageImpl = new ClientMessageImpl(2, true, System.currentTimeMillis() + l2, System.currentTimeMillis(), 4, 1500);
        a a2 = this.getClass().getAnnotation(a.class);
        clientMessageImpl.putStringProperty(MessageTypeKey, a2.a());
        clientMessageImpl.putStringProperty(MessageKey, b.a().toJson((Object)this));
        return clientMessageImpl;
    }

    public final boolean sendSynchronously() {
        return this.sendSynchronously(0L);
    }

    public final boolean sendSynchronously(long l2) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return d.a(this, l2);
        }
        ay.c((Object)"sending a message synchronously on the event thread...?  seems like a bad idea", this.getClass());
        this.sendAsync(l2);
        return false;
    }

    public final Future<Boolean> sendAsync() {
        return this.sendAsync(0L);
    }

    @Override
    public AutomatorMessage clone() {
        try {
            AutomatorMessage automatorMessage = (AutomatorMessage)super.clone();
            automatorMessage.originalMessage = null;
            return automatorMessage;
        }
        catch (Exception exception) {
            ay.d((Object)"error cloning Automator message", (Throwable)exception, this);
            return null;
        }
    }

    public final Future<Boolean> sendAsync(final long l2) {
        return messageSendExecutor.submit(new Callable<Boolean>(){

            public Boolean a() {
                boolean bl2 = AutomatorMessage.this.sendSynchronously(l2);
                if (!bl2) {
                    ArrayList arrayList = Lists.newArrayList();
                    messageSendExecutor.getQueue().drainTo(arrayList);
                    for (Runnable runnable : arrayList) {
                        messageSendExecutor.remove(runnable);
                    }
                }
                return bl2;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.a();
            }
        });
    }

    public static AutomatorMessage asAutomatorMessage(ClientMessage clientMessage) {
        if (!clientMessage.containsProperty(MessageTypeKey) || !clientMessage.containsProperty(MessageKey)) {
            return null;
        }
        Collection<Class<? extends AutomatorMessage>> collection = AutomatorMessage.getAllMessageTypes();
        String string = clientMessage.getStringProperty(MessageTypeKey);
        String string2 = clientMessage.getStringProperty(MessageKey);
        for (Class<? extends AutomatorMessage> clazz : collection) {
            if (!clazz.getAnnotation(a.class).a().equals(string)) continue;
            try {
                AutomatorMessage automatorMessage = (AutomatorMessage)b.a().fromJson(string2, clazz);
                automatorMessage.originalMessage = clientMessage;
                automatorMessage.numAcksRequired = new AtomicInteger(1);
                return automatorMessage;
            }
            catch (Exception exception) {
                ay.d((Object)("cannot deserialize Message of type " + string), (Throwable)exception, AutomatorMessage.class);
                return null;
            }
        }
        return null;
    }

    public synchronized void acknowledgeMessage() {
        int n2 = this.numAcksRequired.decrementAndGet();
        if (n2 == 0) {
            try {
                this.originalMessage.acknowledge();
            }
            catch (Exception exception) {}
        } else if (n2 < 0) {
            ay.c((Object)"more acknowledgements than expected", this);
        }
    }

    public synchronized void setRequiredAcknowledgements(int n2) {
        this.numAcksRequired.set(n2);
    }

    public static Collection<Class<? extends AutomatorMessage>> getAllMessageTypes() {
        Set set;
        Reflections reflections = ca.b();
        Set set2 = reflections.getTypesAnnotatedWith(a.class);
        if (set2 == null) {
            set2 = Sets.newHashSet();
        }
        if ((set = reflections.getSubTypesOf(AutomatorMessage.class)) == null) {
            set = Sets.newHashSet();
        }
        HashSet hashSet = Sets.newHashSet((Iterable)set);
        hashSet.retainAll(set2);
        return hashSet;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface a {
        public String a();
    }
}

