/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.message;

import com.mimvista.archive.search.SearchSource;
import com.mimvista.automator.message.ArchiveHappenedMessage;
import com.mimvista.automator.message.AutomatorMessage;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.dicom.DcmSeries;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@AutomatorMessage.a(a="RUN_ART_ASSIST")
public class RunARTAssistMessage
extends AutomatorMessage {
    private static final long serialVersionUID = 5452135930786219331L;
    SearchSource source;
    Collection<UniqueSeriesPointer> series;

    public RunARTAssistMessage(SearchSource searchSource, Collection<UniqueSeriesPointer> collection) {
        this.source = searchSource;
        this.series = collection;
    }

    @Override
    public String getPrettyPayloadString() {
        return "Start ART Assist for source " + this.source.j() + " on " + (this.series.size() == 1 ? (Serializable)this.series.iterator().next() : this.series.size() + " series");
    }

    public SearchSource getSource() {
        return this.source;
    }

    public Set<DcmSeries> getSeries() {
        List<DcmSeries> list = ArchiveHappenedMessage.fetchAndWaitOnSeries(this.series, this.source);
        return new HashSet<DcmSeries>(list);
    }
}

