/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.rule.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.mimvista.archive.search.RemoteSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.g;
import com.mimvista.automator.rule.AutomatorAction;
import com.mimvista.automator.rule.AutomatorException;
import com.mimvista.automator.rule.AutomatorParameter;
import com.mimvista.automator.rule.AutomatorRule;
import com.mimvista.automator.rule.ListWrapper;
import com.mimvista.automator.rule.actions.AutomatorCopyAction;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.mimcloud.mirror.DataMirrorLink;
import com.mimvista.mimcloud.mirror.b;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.util.Collection;
import java.util.List;

@AutomatorAction.a(a=a.class)
public class AutomatorDeleteAction
extends AutomatorAction {
    private static final long serialVersionUID = -1281560727840373364L;
    @com.mimvista.automator.rule.a(a=ListWrapper.SeriesGroupableList.class, d="SERIES_TO_DELETE", c=false, e=3)
    AutomatorParameter<ListWrapper.SeriesGroupableList> seriesToDeleteParam;
    @com.mimvista.automator.rule.a(a=SearchSource.class, d="SOURCE_TO_DELETE_FROM", e=2)
    AutomatorParameter<SearchSource> sourceToDeleteFromParam;
    @com.mimvista.automator.rule.a(a=Boolean.class, d="AVOID_PROPAGATE_TO_MIRRORS", c=false, b=false)
    AutomatorParameter<Boolean> shouldAvoidPropagate;

    public AutomatorDeleteAction(AutomatorRule automatorRule) {
        super(automatorRule);
    }

    @Override
    public boolean a(String string, Class<?> clazz) {
        if (string.equals("shouldAvoidPropagate")) {
            if (this.sourceToDeleteFromParam == null) {
                return false;
            }
            SearchSource searchSource = this.sourceToDeleteFromParam.a(this.parent);
            if (searchSource == null) {
                return false;
            }
            List<DataMirrorLink> list = b.a().b();
            long l2 = list.stream().filter(dataMirrorLink -> {
                RemoteSearchSource remoteSearchSource = g.a(dataMirrorLink.c().a());
                return searchSource.equals(remoteSearchSource);
            }).count();
            return l2 > 0L;
        }
        return super.a(string, clazz);
    }

    @Override
    protected void j() throws AutomatorException {
        SearchSource searchSource = this.sourceToDeleteFromParam.a(this.parent);
        List<DcmSeries> list = this.seriesToDeleteParam.a(this.parent).c();
        boolean bl2 = false;
        if (this.shouldAvoidPropagate != null) {
            bl2 = this.shouldAvoidPropagate.a(this.parent);
        }
        AutomatorDeleteAction.a(searchSource, list, this.b().y(), bl2);
    }

    @Override
    protected boolean k() throws AutomatorException {
        SearchSource searchSource = this.sourceToDeleteFromParam.a(this.parent);
        AutomatorDeleteAction.a(searchSource);
        return true;
    }

    protected static void a(SearchSource searchSource) throws AutomatorException {
        if (searchSource == null) {
            throw new AutomatorException(true, "I have no idea where to get this series ", Messages.a("Automator", "AUTOMATOR_EXCEPTION_UNKNOWN_SOURCE_FOR_SERIES"));
        }
        if (!searchSource.q()) {
            throw new AutomatorException(false, "", MIMFormat.a(Messages.a("Automator", "AUTOMATOR_EXCEPTION_DELETION_UNSUPPORTED"), searchSource.j()));
        }
    }

    protected static void a(Collection<SearchSource> collection) throws AutomatorException {
        for (SearchSource searchSource : collection) {
            AutomatorDeleteAction.a(searchSource);
        }
    }

    protected static void a(Collection<DcmSeries> collection, Searchable.a a2, boolean bl2) throws AutomatorException {
        Multimap<SearchSource, DcmSeries> multimap = AutomatorCopyAction.a(collection);
        for (SearchSource searchSource : multimap.keySet()) {
            AutomatorDeleteAction.a(searchSource, multimap.get((Object)searchSource), a2, bl2);
        }
    }

    protected static void a(SearchSource searchSource, Collection<DcmSeries> collection, Searchable.a a2, boolean bl2) throws AutomatorException {
        boolean bl3;
        try {
            bl3 = searchSource.a(Lists.newArrayList(collection), !bl2);
        }
        catch (Exception exception) {
            throw new AutomatorException(exception, true, "error deleting series as a result of move action", null);
        }
        if (!bl3) {
            throw new AutomatorException(true, "some series may not have been deleted as a result of move action", null);
        }
    }

    @Override
    protected void l() {
    }

    @Override
    protected boolean b(AutomatorParameter<?> automatorParameter) {
        return automatorParameter != this.seriesToDeleteParam;
    }

    public static class a
    extends AutomatorAction.b {
        public a() {
            super(AutomatorDeleteAction.class);
        }

        @Override
        public String a() {
            return "DELETE";
        }

        @Override
        public boolean a(AutomatorRule automatorRule, int n2) {
            for (AutomatorParameter<ListWrapper.SeriesGroupableList> automatorParameter : automatorRule.a(n2)) {
                if (!automatorParameter.a(ListWrapper.SeriesGroupableList.class)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected String c() {
            return "delete";
        }

        @Override
        public AutomatorAction.AutomatorActionCategory b() {
            return AutomatorAction.AutomatorActionCategory.a;
        }
    }
}

