/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.rule.actions;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.archive.search.DicomSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.automator.gui.parameter.ConstantParameterEditorProvider;
import com.mimvista.automator.gui.parameter.Lightboxable;
import com.mimvista.automator.gui.parameter.TagPathParameterEditor;
import com.mimvista.automator.rule.AutomatorAction;
import com.mimvista.automator.rule.AutomatorException;
import com.mimvista.automator.rule.AutomatorParameter;
import com.mimvista.automator.rule.AutomatorRule;
import com.mimvista.automator.rule.ListWrapper;
import com.mimvista.automator.rule.actions.AutomatorCopyAction;
import com.mimvista.automator.rule.actions.AutomatorFilterAction;
import com.mimvista.automator.rule.f;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesGroup;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.dicom.util.TagPathComponent;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.dicom.util.VRUtils;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.dcm4che2.data.VR;

@AutomatorAction.a(a=a.class)
public class MostRecentAction
extends AutomatorAction {
    @com.mimvista.automator.rule.a(a=TagPath.class, d="TAG_TO_USE")
    private AutomatorParameter<TagPath> tagToUse;
    @com.mimvista.automator.rule.a(a=Integer.class, d="NUMBER_TO_KEEP", e=2)
    private AutomatorParameter<Integer> numberToKeep;
    @com.mimvista.automator.rule.a(a=ListWrapper.SeriesGroupableList.class, d="SERIES_GROUPS", c=false, e=3)
    private AutomatorParameter<ListWrapper.SeriesGroupableList> groups;
    @f(a=ListWrapper.SeriesGroupableList.class, b=3)
    private AutomatorParameter<ListWrapper.SeriesGroupableList> mostRecent = new AutomatorParameter<ListWrapper.SeriesGroupableList>(ListWrapper.SeriesGroupableList.class, "");
    @f(a=ListWrapper.SeriesGroupableList.class, b=2)
    private AutomatorParameter<ListWrapper.SeriesGroupableList> notRecent;
    @f(a=ListWrapper.SeriesGroupableList.class, b=1)
    private AutomatorParameter<ListWrapper.SeriesGroupableList> dontHaveTag;
    private static final List<TagPath> b = Lists.newArrayList((Object[])new TagPath[]{new TagPath(524321), new TagPath(524320)});

    public MostRecentAction(AutomatorRule automatorRule) {
        super(automatorRule);
        this.mostRecent.b("MOST_RECENT_RESULTS");
        this.notRecent = new AutomatorParameter<ListWrapper.SeriesGroupableList>(ListWrapper.SeriesGroupableList.class, "");
        this.notRecent.b("OTHER_GROUPS_RESULTS");
        this.dontHaveTag = new AutomatorParameter<ListWrapper.SeriesGroupableList>(ListWrapper.SeriesGroupableList.class, "");
        this.dontHaveTag.b("INVALID_TAG_VALUE");
    }

    @Override
    protected void j() throws AutomatorException {
        TagPath tagPath = this.tagToUse.a(this.parent);
        int n2 = this.numberToKeep.a(this.parent);
        List<SeriesGroup> list = this.groups.a(this.parent).b();
        HashSet<SeriesGroup> hashSet = new HashSet<SeriesGroup>();
        for (SeriesGroup object2 : list) {
            Date date = object2.getOldestDate(tagPath);
            if (date != null && !date.equals(new Date(0L))) continue;
            hashSet.add(object2);
        }
        Set<SeriesGroup> set = MostRecentAction.a(list, n2, tagPath);
        HashSet<SeriesGroup> hashSet2 = new HashSet<SeriesGroup>(list);
        hashSet2.removeAll(set);
        hashSet2.removeAll(hashSet);
        this.mostRecent.a(this.parent, new ListWrapper.SeriesGroupList((Collection<SeriesGroup>)set));
        this.notRecent.a(this.parent, new ListWrapper.SeriesGroupList((Collection<SeriesGroup>)hashSet2));
        this.dontHaveTag.a(this.parent, new ListWrapper.SeriesGroupList((Collection<SeriesGroup>)hashSet));
    }

    public static Set<SeriesGroup> a(Collection<SeriesGroup> collection, int n2, TagPath tagPath) {
        HashMultimap hashMultimap = HashMultimap.create();
        for (SeriesGroup object2 : collection) {
            Date i2 = object2.getOldestDate(tagPath);
            if (i2 == null) {
                i2 = new Date(0L);
            }
            i2 = DateUtils.f(i2);
            hashMultimap.put((Object)i2, (Object)object2);
        }
        TreeSet treeSet = new TreeSet(hashMultimap.keySet());
        HashSet hashSet = Sets.newHashSet();
        for (int i2 = 0; i2 < n2 && !treeSet.isEmpty(); ++i2) {
            Date date = (Date)treeSet.last();
            treeSet.remove(date);
            hashSet.addAll(hashMultimap.get((Object)date));
        }
        return hashSet;
    }

    @Override
    protected boolean k() throws AutomatorException {
        if (this.numberToKeep.a(this.parent) < 1) {
            throw new AutomatorException(true, "number of series groups to keep must be greater than 0", null);
        }
        if (VRUtils.getParseResultType(TagUtils.vrOfTag(this.tagToUse.a(this.parent))) != Date.class) {
            throw new AutomatorException(true, "tag must be a date type tag to be considered for recent-ness", null);
        }
        List<DcmSeries> list = this.groups.a(this.parent).c();
        Set<SearchSource> set = AutomatorCopyAction.b(list);
        HashSet<DicomSearchSource> hashSet = new HashSet<DicomSearchSource>();
        for (SearchSource serializable2 : set) {
            if (!(serializable2 instanceof DicomSearchSource)) continue;
            hashSet.add((DicomSearchSource)serializable2);
        }
        TagPath tagPath = this.tagToUse.a(this.parent);
        TagPathComponent tagPathComponent = tagPath.getTag(tagPath.size() - 1);
        if (!tagPathComponent.isStringTag() && !AutomatorFilterAction.a(hashSet, tagPathComponent.getTagInt())) {
            throw new AutomatorException(true, null, MIMFormat.a(Messages.a("Automator", "AUTOMATOR_EXCEPTION_UNSUPPORTED_TAG"), TagUtils.getTagName(tagPathComponent)));
        }
        return true;
    }

    @Override
    protected void l() {
    }

    @Override
    public <T> ConstantParameterEditorProvider<T> a(AutomatorParameter<T> automatorParameter, String string, Class<T> clazz, Lightboxable lightboxable, boolean bl2) {
        ConstantParameterEditorProvider<T> constantParameterEditorProvider = super.a(automatorParameter, string, clazz, lightboxable, bl2);
        if ("tagToUse".equals(string) && TagPath.class.equals(clazz) && constantParameterEditorProvider instanceof TagPathParameterEditor) {
            TagPathParameterEditor tagPathParameterEditor = (TagPathParameterEditor)constantParameterEditorProvider;
            tagPathParameterEditor.a(b);
            tagPathParameterEditor.a(new Function<TagPath, ConstantParameterEditorProvider.a>(){

                public ConstantParameterEditorProvider.a a(TagPath tagPath) {
                    boolean bl2;
                    if (tagPath == null) {
                        return new ConstantParameterEditorProvider.a(false);
                    }
                    VR vR = TagUtils.vrOfTag(tagPath);
                    boolean bl3 = bl2 = VRUtils.isAnyDateTypeVR(vR) && !VRUtils.isTimeTypeVR(vR);
                    if (bl2) {
                        return new ConstantParameterEditorProvider.a(true);
                    }
                    return new ConstantParameterEditorProvider.a(false, Messages.a("Automator", "PARAM_VALIDATION_TAG_MUST_BE_DATE"));
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((TagPath)object);
                }
            });
        }
        return constantParameterEditorProvider;
    }

    public static class a
    extends AutomatorAction.b {
        public a() {
            super(MostRecentAction.class);
        }

        @Override
        public String a() {
            return "MOST_RECENT";
        }

        @Override
        public boolean a(AutomatorRule automatorRule, int n2) {
            for (AutomatorParameter<ListWrapper.SeriesGroupableList> automatorParameter : automatorRule.a(n2)) {
                if (!automatorParameter.a(ListWrapper.SeriesGroupableList.class)) continue;
                return true;
            }
            return false;
        }

        @Override
        public AutomatorAction.AutomatorActionCategory b() {
            return AutomatorAction.AutomatorActionCategory.a;
        }

        @Override
        protected String c() {
            return "most_recent";
        }
    }
}

