/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.automator.status;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mimvista.ExternallyVisible;
import com.mimvista.automator.logging.AutomatorRecordKeeper;
import com.mimvista.automator.rule.AutomatorAction;
import com.mimvista.automator.rule.AutomatorRule;
import com.mimvista.automator.status.b;
import com.mimvista.preferences.PrefParsers;
import com.mimvista.util.au;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@ExternallyVisible
public class AssistantStatus
implements au<AssistantStatus>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper a = PrefParsers.a();
    private Map<String, RuleProgress> rulesInProgress = new HashMap<String, RuleProgress>();

    public synchronized void ruleStarted(AutomatorRule automatorRule) {
        RuleProgress ruleProgress = new RuleProgress();
        ruleProgress.b(automatorRule.q().toString());
        ruleProgress.a(automatorRule.m().toString());
        ruleProgress.c(automatorRule.j());
        ruleProgress.a(automatorRule.h());
        ruleProgress.b(-1);
        ruleProgress.d("");
        ruleProgress.c(-1);
        ruleProgress.d(-1);
        ruleProgress.a(AutomatorRecordKeeper.RuleStatus.RUNNING);
        this.rulesInProgress.put(automatorRule.q().toString(), ruleProgress);
    }

    public synchronized void nextAction(AutomatorAction automatorAction) {
        UUID uUID = automatorAction.b().q();
        RuleProgress ruleProgress = this.rulesInProgress.get(uUID.toString());
        if (ruleProgress != null) {
            int n2 = ruleProgress.e();
            ruleProgress.b(n2++);
            ruleProgress.d(automatorAction.n().a());
        }
    }

    public synchronized void ruleSubprogress(AutomatorAction automatorAction, int n2, int n3) {
        UUID uUID = automatorAction.b().q();
        RuleProgress ruleProgress = this.rulesInProgress.get(uUID.toString());
        if (ruleProgress != null) {
            ruleProgress.c(n2);
            ruleProgress.d(n3);
        }
    }

    public void removeRule(AutomatorRule automatorRule) {
        this.rulesInProgress.remove(automatorRule.q().toString());
    }

    public void ruleFinished(AutomatorRule automatorRule) {
        this.a(automatorRule, AutomatorRecordKeeper.RuleStatus.FINISHED);
    }

    public void ruleFailed(AutomatorRule automatorRule) {
        this.a(automatorRule, AutomatorRecordKeeper.RuleStatus.FAILED);
    }

    public void ruleCancelled(AutomatorRule automatorRule) {
        this.a(automatorRule, AutomatorRecordKeeper.RuleStatus.CANCELLED);
    }

    private synchronized void a(AutomatorRule automatorRule, AutomatorRecordKeeper.RuleStatus ruleStatus) {
        UUID uUID = automatorRule.q();
        RuleProgress ruleProgress = this.rulesInProgress.get(uUID.toString());
        if (ruleProgress != null) {
            ruleProgress.c(-1);
            ruleProgress.d(-1);
            ruleProgress.a(ruleStatus);
        }
    }

    public List<RuleProgress> getRulesInProgress() {
        ArrayList<RuleProgress> arrayList = new ArrayList<RuleProgress>();
        arrayList.addAll(this.rulesInProgress.values());
        return arrayList;
    }

    @Override
    public AssistantStatus clone() {
        AssistantStatus assistantStatus = new AssistantStatus();
        assistantStatus.rulesInProgress = new HashMap<String, RuleProgress>(this.rulesInProgress);
        return assistantStatus;
    }

    public AssistantStatus cloneForObserver(b b2) {
        AssistantStatus assistantStatus = new AssistantStatus();
        assistantStatus.rulesInProgress = new HashMap<String, RuleProgress>();
        for (Map.Entry<String, RuleProgress> entry : this.rulesInProgress.entrySet()) {
            if (!b2.a(entry.getValue())) continue;
            assistantStatus.rulesInProgress.put(entry.getKey(), entry.getValue());
        }
        return assistantStatus;
    }

    public static String serialize(AssistantStatus assistantStatus) throws JsonProcessingException {
        String string = a.writeValueAsString((Object)assistantStatus);
        return string;
    }

    public static AssistantStatus deserialize(String string) throws JsonParseException, JsonMappingException, IOException {
        AssistantStatus assistantStatus = (AssistantStatus)a.readValue(string, AssistantStatus.class);
        return assistantStatus;
    }

    public static class RuleProgress
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String ruleId;
        private String ruleInstanceId;
        private String ruleName;
        private int totalNumberOfActions;
        private int currentAction;
        private String nameOfCurrentAction;
        private int totalProgressOfAction;
        private int currentProgressOfAction;
        private AutomatorRecordKeeper.RuleStatus status;

        public String a() {
            return this.ruleId;
        }

        public void a(String string) {
            this.ruleId = string;
        }

        public String b() {
            return this.ruleInstanceId;
        }

        public void b(String string) {
            this.ruleInstanceId = string;
        }

        public String c() {
            return this.ruleName;
        }

        public void c(String string) {
            this.ruleName = string;
        }

        public int d() {
            return this.totalNumberOfActions;
        }

        public void a(int n2) {
            this.totalNumberOfActions = n2;
        }

        public int e() {
            return this.currentAction;
        }

        public void b(int n2) {
            this.currentAction = n2;
        }

        public String f() {
            return this.nameOfCurrentAction;
        }

        public void d(String string) {
            this.nameOfCurrentAction = string;
        }

        public int g() {
            return this.totalProgressOfAction;
        }

        public void c(int n2) {
            this.totalProgressOfAction = n2;
        }

        public int h() {
            return this.currentProgressOfAction;
        }

        public void d(int n2) {
            this.currentProgressOfAction = n2;
        }

        public AutomatorRecordKeeper.RuleStatus i() {
            return this.status;
        }

        public void a(AutomatorRecordKeeper.RuleStatus ruleStatus) {
            this.status = ruleStatus;
        }
    }
}

