/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.biopsy.prostatescoring.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.mimvista.mui.Session;
import com.mimvista.state.SerializedSessionStateObject;
import com.mimvista.state.SessionStateObject;
import com.mimvista.util.MIMSerializable;
import com.mimvista.util.as;
import com.mimvista.util.ay;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;

public class PiradsScoringModel
implements SerializedSessionStateObject<PiradsScoringModel>,
SessionStateObject<PiradsScoringModel>,
MIMSerializable {
    private static final long serialVersionUID = 1L;
    public static final Range<Integer> SCORE_RANGE = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5));
    private Map<PiradsSector, Integer> scores = Maps.newEnumMap(PiradsSector.class);
    private PiradsSector selectedSector;
    private transient List<a> modelListeners = Lists.newArrayList();

    public PiradsScoringModel() {
        for (PiradsSector piradsSector : PiradsSector.values()) {
            this.scores.put(piradsSector, piradsSector.a());
        }
    }

    public PiradsScoringModel(Session session) {
        this();
    }

    public int getNumSectors() {
        return PiradsSector.values().length;
    }

    public int getMinScore() {
        return (Integer)SCORE_RANGE.lowerEndpoint();
    }

    public int getMaxScore() {
        return (Integer)SCORE_RANGE.upperEndpoint();
    }

    @Override
    public void preventLambdas() {
    }

    public List<PiradsSector> getSectors() {
        return Lists.newArrayList((Object[])PiradsSector.values());
    }

    public int getScore(PiradsSector piradsSector) {
        return this.scores.get((Object)piradsSector);
    }

    public void setScore(PiradsSector piradsSector, int n2) {
        if (!SCORE_RANGE.contains((Comparable)Integer.valueOf(n2))) {
            throw new IllegalArgumentException(String.format("Score for sector %s is not in the valid range %s: %d", piradsSector.name(), SCORE_RANGE, n2));
        }
        int n3 = this.scores.get((Object)piradsSector);
        if (n2 != n3) {
            this.scores.put(piradsSector, n2);
            this.fireScoreChange(new b(piradsSector, n3, n2));
        }
    }

    public void setScores(Map<PiradsSector, Integer> map) {
        for (PiradsSector piradsSector : map.keySet()) {
            this.setScore(piradsSector, map.get((Object)piradsSector));
        }
    }

    public Map<PiradsSector, Integer> getScores() {
        return Maps.newEnumMap(this.scores);
    }

    public PiradsSector getSelectedSector() {
        return this.selectedSector;
    }

    public void setSelectedSector(PiradsSector piradsSector) {
        if (this.selectedSector != piradsSector) {
            c c2 = new c(this.selectedSector, piradsSector);
            this.selectedSector = piradsSector;
            this.fireSectorSelectionChange(c2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(a a2) {
        if (a2 != null) {
            List<a> list = this.modelListeners;
            synchronized (list) {
                this.modelListeners.add(a2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(a a2) {
        if (a2 != null) {
            List<a> list = this.modelListeners;
            synchronized (list) {
                this.modelListeners.remove(a2);
            }
        }
    }

    private void fireScoreChange(b b2) {
        for (a a2 : as.c(this.modelListeners)) {
            try {
                a2.a(b2);
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error during score changed listener", throwable, this);
            }
        }
    }

    private void fireSectorSelectionChange(c c2) {
        for (a a2 : as.c(this.modelListeners)) {
            try {
                a2.a(c2);
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error during selection changed listener", throwable, this);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.modelListeners = Lists.newArrayList();
    }

    @Override
    public SerializedSessionStateObject<PiradsScoringModel> serialize() {
        return this;
    }

    @Override
    public PiradsScoringModel deserialize(Session session) {
        return this;
    }

    public static enum PiradsSector {
        a(1, "axial_sv_fill_left.svg"),
        b(1, "axial_sv_fill_right.svg"),
        c(2, "axial_base_fill_6.svg"),
        d(2, "axial_base_fill_5.svg"),
        e(2, "axial_base_fill_1.svg"),
        f(2, "axial_base_fill_3.svg"),
        g(2, "axial_base_fill_4.svg"),
        h(2, "axial_base_fill_2.svg"),
        i(2, "axial_mid_fill_6.svg"),
        j(2, "axial_mid_fill_5.svg"),
        k(2, "axial_mid_fill_1.svg"),
        l(2, "axial_mid_fill_3.svg"),
        m(2, "axial_mid_fill_4.svg"),
        n(2, "axial_mid_fill_2.svg"),
        o(2, "axial_apex_fill_4.svg"),
        p(2, "axial_apex_fill_1.svg"),
        q(2, "axial_apex_fill_3.svg"),
        r(2, "axial_apex_fill_2.svg"),
        s(1, "axial_sphincter_left.svg"),
        t(1, "axial_sphincter_right.svg");

        private int defaultScore;
        private String svgFilename;

        private PiradsSector(int n3, String string2) {
            this.defaultScore = n3;
            this.svgFilename = string2;
        }

        public int a() {
            return this.defaultScore;
        }

        public String b() {
            return this.svgFilename;
        }
    }

    public static interface a {
        public void a(b var1);

        public void a(c var1);
    }

    public static class c {
        private PiradsSector a;
        private PiradsSector b;

        public c(PiradsSector piradsSector, PiradsSector piradsSector2) {
            this.a = piradsSector;
            this.b = piradsSector2;
        }

        public PiradsSector a() {
            return this.a;
        }

        public PiradsSector b() {
            return this.b;
        }
    }

    public static class b {
        private PiradsSector a;
        private int b;
        private int c;

        public b(PiradsSector piradsSector, int n2, int n3) {
            this.a = piradsSector;
            this.b = n2;
            this.c = n3;
        }

        public PiradsSector a() {
            return this.a;
        }

        public int b() {
            return this.b;
        }

        public int c() {
            return this.c;
        }
    }
}

