/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.biopsy.trbx.calibration;

import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.Point3d;
import com.mimvista.numerics.Point3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class CrossWireCalibrationProblem
implements DifferentiableMultivariateVectorFunction {
    private List<Point2f> a = Lists.newArrayList();
    private List<Point3d> b = Lists.newArrayList();
    private List<Vector3d> c = Lists.newArrayList();
    private List<RealMatrix> d = Lists.newArrayList();
    private SolveType e;

    public CrossWireCalibrationProblem() {
        this(SolveType.a);
    }

    public CrossWireCalibrationProblem(SolveType solveType) {
        this.e = solveType;
    }

    public void a(List<Point2f> list, List<Point3d> list2, List<Vector3d> list3) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.a.add(new Point2f((Tuple2f)list.get(i2)));
            this.b.add(new Point3d((Tuple3d)list2.get(i2)));
            this.c.add(new Vector3d(list3.get(i2)));
            this.d.add(MathUtils.a(list2.get((int)i2).x, list2.get((int)i2).y, list2.get((int)i2).z, list3.get((int)i2).x, list3.get((int)i2).y, list3.get((int)i2).z));
        }
    }

    public double[] a(Point3f point3f) {
        double[] dArray = new double[this.a.size() * 3];
        for (int i2 = 0; i2 < this.a.size(); i2 += 3) {
            dArray[i2] = point3f.x;
            dArray[i2 + 1] = point3f.y;
            dArray[i2 + 2] = point3f.z;
        }
        return dArray;
    }

    public double[] a() {
        double[] dArray = this.e == SolveType.c ? new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0} : (this.e == SolveType.b ? new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0} : new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
        return dArray;
    }

    public double[] b() {
        double[] dArray = new double[this.a.size() * 3];
        Arrays.fill(dArray, 1.0);
        return dArray;
    }

    public double[][] a(double[] dArray) {
        double[][] dArray2 = new double[this.a.size() * 3][dArray.length];
        double d2 = Math.sin(dArray[3]);
        double d3 = Math.cos(dArray[3]);
        double d4 = Math.sin(dArray[4]);
        double d5 = Math.cos(dArray[4]);
        double d6 = Math.sin(dArray[5]);
        double d7 = Math.cos(dArray[5]);
        double d8 = 1.0;
        double d9 = 1.0;
        double d10 = 1.0;
        if (this.e == SolveType.b) {
            d8 = dArray[9];
        } else if (this.e == SolveType.c) {
            d9 = dArray[9];
            d10 = dArray[10];
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            float f2 = this.a.get((int)i2).x;
            float f3 = this.a.get((int)i2).y;
            double d11 = Math.sin(this.c.get((int)i2).x);
            double d12 = Math.cos(this.c.get((int)i2).x);
            double d13 = Math.sin(this.c.get((int)i2).y);
            double d14 = Math.cos(this.c.get((int)i2).y);
            double d15 = Math.sin(this.c.get((int)i2).z);
            double d16 = Math.cos(this.c.get((int)i2).z);
            if (this.e == SolveType.a) {
                dArray2[i2 * 3] = new double[]{d16 * d14, d16 * d13 * d11 - d12 * d15, d15 * d11 + d16 * d12 * d13, (double)f3 * ((d7 * d2 - d3 * d6 * d4) * (d12 * d15 - d16 * d13 * d11) + d16 * d14 * (d6 * d2 + d7 * d3 * d4) + d5 * d3 * (d15 * d11 + d16 * d12 * d13)), (double)(-f3) * (d4 * d2 * (d15 * d11 + d16 * d12 * d13) + d5 * d6 * d2 * (d12 * d15 - d16 * d13 * d11) - d7 * d5 * d16 * d14 * d2) - (double)f2 * (d5 * (d15 * d11 + d16 * d12 * d13) - d6 * d4 * (d12 * d15 - d16 * d13 * d11) + d7 * d16 * d14 * d4), (double)f3 * ((d3 * d6 - d7 * d4 * d2) * (d12 * d15 - d16 * d13 * d11) - d16 * d14 * (d7 * d3 + d6 * d4 * d2)) - (double)f2 * (d7 * d5 * (d12 * d15 - d16 * d13 * d11) + d5 * d16 * d14 * d6), 1.0, 0.0, 0.0};
                dArray2[i2 * 3 + 1] = new double[]{d14 * d15, d16 * d12 + d15 * d13 * d11, d12 * d15 * d13 - d16 * d11, (double)(-f3) * ((d7 * d2 - d3 * d6 * d4) * (d16 * d12 + d15 * d13 * d11) + d5 * d3 * (d16 * d11 - d12 * d15 * d13) - d14 * d15 * (d6 * d2 + d7 * d3 * d4)), (double)f3 * (d4 * d2 * (d16 * d11 - d12 * d15 * d13) + d5 * d6 * d2 * (d16 * d12 + d15 * d13 * d11) + d7 * d5 * d14 * d2 * d15) - (double)f2 * (d6 * d4 * (d16 * d12 + d15 * d13 * d11) - d5 * (d16 * d11 - d12 * d15 * d13) + d7 * d14 * d4 * d15), (double)f2 * (d7 * d5 * (d16 * d12 + d15 * d13 * d11) - d5 * d14 * d6 * d15) - (double)f3 * ((d3 * d6 - d7 * d4 * d2) * (d16 * d12 + d15 * d13 * d11) + d14 * d15 * (d7 * d3 + d6 * d4 * d2)), 0.0, 1.0, 0.0};
                dArray2[i2 * 3 + 2] = new double[]{-d13, d14 * d11, d14 * d12, (double)(-f3) * (d13 * (d6 * d2 + d7 * d3 * d4) + d14 * d11 * (d7 * d2 - d3 * d6 * d4) - d5 * d3 * d14 * d12), (double)(-f2) * (d5 * d14 * d12 - d7 * d4 * d13 + d14 * d6 * d4 * d11) - (double)f3 * (d7 * d5 * d2 * d13 + d14 * d12 * d4 * d2 - d5 * d14 * d6 * d2 * d11), (double)f2 * (d5 * d6 * d13 + d7 * d5 * d14 * d11) + (double)f3 * (d13 * (d7 * d3 + d6 * d4 * d2) - d14 * d11 * (d3 * d6 - d7 * d4 * d2)), 0.0, 0.0, 1.0};
                continue;
            }
            if (this.e == SolveType.b) {
                dArray2[i2 * 3] = new double[]{d16 * d14, d16 * d13 * d11 - d12 * d15, d15 * d11 + d16 * d12 * d13, d8 * (double)f3 * ((d7 * d2 - d3 * d6 * d4) * (d12 * d15 - d16 * d13 * d11) + d16 * d14 * (d6 * d2 + d7 * d3 * d4) + d5 * d3 * (d15 * d11 + d16 * d12 * d13)), -d8 * (double)f3 * (d4 * d2 * (d15 * d11 + d16 * d12 * d13) + d5 * d6 * d2 * (d12 * d15 - d16 * d13 * d11) - d7 * d5 * d16 * d14 * d2) - d8 * (double)f2 * (d5 * (d15 * d11 + d16 * d12 * d13) - d6 * d4 * (d12 * d15 - d16 * d13 * d11) + d7 * d16 * d14 * d4), d8 * (double)f3 * ((d3 * d6 - d7 * d4 * d2) * (d12 * d15 - d16 * d13 * d11) - d16 * d14 * (d7 * d3 + d6 * d4 * d2)) - d8 * (double)f2 * (d7 * d5 * (d12 * d15 - d16 * d13 * d11) + d5 * d16 * d14 * d6), 1.0, 0.0, 0.0, (double)(-f2) * (d4 * (d15 * d11 + d16 * d12 * d13) + d5 * d6 * (d12 * d15 - d16 * d13 * d11) - d7 * d5 * d16 * d14) - (double)f3 * ((d7 * d3 + d6 * d4 * d2) * (d12 * d15 - d16 * d13 * d11) + d16 * d14 * (d3 * d6 - d7 * d4 * d2) - d5 * d2 * (d15 * d11 + d16 * d12 * d13))};
                dArray2[i2 * 3 + 1] = new double[]{d14 * d15, d16 * d12 + d15 * d13 * d11, d12 * d15 * d13 - d16 * d11, -d8 * (double)f3 * ((d7 * d2 - d3 * d6 * d4) * (d16 * d12 + d15 * d13 * d11) + d5 * d3 * (d16 * d11 - d12 * d15 * d13) - d14 * d15 * (d6 * d2 + d7 * d3 * d4)), d8 * (double)f3 * (d4 * d2 * (d16 * d11 - d12 * d15 * d13) + d5 * d6 * d2 * (d16 * d12 + d15 * d13 * d11) + d7 * d5 * d14 * d2 * d15) - d8 * (double)f2 * (d6 * d4 * (d16 * d12 + d15 * d13 * d11) - d5 * (d16 * d11 - d12 * d15 * d13) + d7 * d14 * d4 * d15), d8 * (double)f2 * (d7 * d5 * (d16 * d12 + d15 * d13 * d11) - d5 * d14 * d6 * d15) - d8 * (double)f3 * ((d3 * d6 - d7 * d4 * d2) * (d16 * d12 + d15 * d13 * d11) + d14 * d15 * (d7 * d3 + d6 * d4 * d2)), 0.0, 1.0, 0.0, (double)f2 * (d4 * (d16 * d11 - d12 * d15 * d13) + d5 * d6 * (d16 * d12 + d15 * d13 * d11) + d7 * d5 * d14 * d15) - (double)f3 * (d14 * d15 * (d3 * d6 - d7 * d4 * d2) - (d7 * d3 + d6 * d4 * d2) * (d16 * d12 + d15 * d13 * d11) + d5 * d2 * (d16 * d11 - d12 * d15 * d13))};
                dArray2[i2 * 3 + 2] = new double[]{-d13, d14 * d11, d14 * d12, -d8 * (double)f3 * (d13 * (d6 * d2 + d7 * d3 * d4) + d14 * d11 * (d7 * d2 - d3 * d6 * d4) - d5 * d3 * d14 * d12), -d8 * (double)f3 * (d7 * d5 * d2 * d13 + d14 * d12 * d4 * d2 - d5 * d14 * d6 * d2 * d11) - d8 * (double)f2 * (d5 * d14 * d12 - d7 * d4 * d13 + d14 * d6 * d4 * d11), d8 * (double)f3 * (d13 * (d7 * d3 + d6 * d4 * d2) - d14 * d11 * (d3 * d6 - d7 * d4 * d2)) + d8 * (double)f2 * (d5 * d6 * d13 + d7 * d5 * d14 * d11), 0.0, 0.0, 1.0, (double)f3 * (d13 * (d3 * d6 - d7 * d4 * d2) + d14 * d11 * (d7 * d3 + d6 * d4 * d2) + d5 * d14 * d12 * d2) - (double)f2 * (d7 * d5 * d13 + d14 * d12 * d4 - d5 * d14 * d6 * d11)};
                continue;
            }
            if (this.e != SolveType.c) continue;
            dArray2[i2 * 3] = new double[]{d16 * d14, d16 * d13 * d11 - d12 * d15, d15 * d11 + d16 * d12 * d13, d10 * (double)f3 * ((d7 * d2 - d3 * d6 * d4) * (d12 * d15 - d16 * d13 * d11) + d16 * d14 * (d6 * d2 + d7 * d3 * d4) + d5 * d3 * (d15 * d11 + d16 * d12 * d13)), -d10 * (double)f3 * (d4 * d2 * (d15 * d11 + d16 * d12 * d13) + d5 * d6 * d2 * (d12 * d15 - d16 * d13 * d11) - d7 * d5 * d16 * d14 * d2) - d9 * (double)f2 * (d5 * (d15 * d11 + d16 * d12 * d13) - d6 * d4 * (d12 * d15 - d16 * d13 * d11) + d7 * d16 * d14 * d4), d10 * (double)f3 * ((d3 * d6 - d7 * d4 * d2) * (d12 * d15 - d16 * d13 * d11) - d16 * d14 * (d7 * d3 + d6 * d4 * d2)) - d9 * (double)f2 * (d7 * d5 * (d12 * d15 - d16 * d13 * d11) + d5 * d16 * d14 * d6), 1.0, 0.0, 0.0, (double)(-f2) * (d4 * (d15 * d11 + d16 * d12 * d13) + d5 * d6 * (d12 * d15 - d16 * d13 * d11) - d7 * d5 * d16 * d14), (double)(-f3) * ((d7 * d3 + d6 * d4 * d2) * (d12 * d15 - d16 * d13 * d11) + d16 * d14 * (d3 * d6 - d7 * d4 * d2) - d5 * d2 * (d15 * d11 + d16 * d12 * d13))};
            dArray2[i2 * 3 + 1] = new double[]{d14 * d15, d16 * d12 + d15 * d13 * d11, d12 * d15 * d13 - d16 * d11, -d10 * (double)f3 * ((d7 * d2 - d3 * d6 * d4) * (d16 * d12 + d15 * d13 * d11) + d5 * d3 * (d16 * d11 - d12 * d15 * d13) - d14 * d15 * (d6 * d2 + d7 * d3 * d4)), d10 * (double)f3 * (d4 * d2 * (d16 * d11 - d12 * d15 * d13) + d5 * d6 * d2 * (d16 * d12 + d15 * d13 * d11) + d7 * d5 * d14 * d2 * d15) - d9 * (double)f2 * (d6 * d4 * (d16 * d12 + d15 * d13 * d11) - d5 * (d16 * d11 - d12 * d15 * d13) + d7 * d14 * d4 * d15), d9 * (double)f2 * (d7 * d5 * (d16 * d12 + d15 * d13 * d11) - d5 * d14 * d6 * d15) - d10 * (double)f3 * ((d3 * d6 - d7 * d4 * d2) * (d16 * d12 + d15 * d13 * d11) + d14 * d15 * (d7 * d3 + d6 * d4 * d2)), 0.0, 1.0, 0.0, (double)f2 * (d4 * (d16 * d11 - d12 * d15 * d13) + d5 * d6 * (d16 * d12 + d15 * d13 * d11) + d7 * d5 * d14 * d15), (double)(-f3) * (d14 * d15 * (d3 * d6 - d7 * d4 * d2) - (d7 * d3 + d6 * d4 * d2) * (d16 * d12 + d15 * d13 * d11) + d5 * d2 * (d16 * d11 - d12 * d15 * d13))};
            dArray2[i2 * 3 + 2] = new double[]{-d13, d14 * d11, d14 * d12, -d10 * (double)f3 * (d13 * (d6 * d2 + d7 * d3 * d4) + d14 * d11 * (d7 * d2 - d3 * d6 * d4) - d5 * d3 * d14 * d12), -d10 * (double)f3 * (d7 * d5 * d2 * d13 + d14 * d12 * d4 * d2 - d5 * d14 * d6 * d2 * d11) - d9 * (double)f2 * (d5 * d14 * d12 - d7 * d4 * d13 + d14 * d6 * d4 * d11), d10 * (double)f3 * (d13 * (d7 * d3 + d6 * d4 * d2) - d14 * d11 * (d3 * d6 - d7 * d4 * d2)) + d9 * (double)f2 * (d5 * d6 * d13 + d7 * d5 * d14 * d11), 0.0, 0.0, 1.0, (double)(-f2) * (d7 * d5 * d13 + d14 * d12 * d4 - d5 * d14 * d6 * d11), (double)f3 * (d13 * (d3 * d6 - d7 * d4 * d2) + d14 * d11 * (d7 * d3 + d6 * d4 * d2) + d5 * d14 * d12 * d2)};
        }
        return dArray2;
    }

    public double[] value(double[] dArray) {
        RealMatrix realMatrix = MathUtils.a(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        RealMatrix realMatrix2 = MathUtils.a(dArray[6], dArray[7], dArray[8], 0.0, 0.0, 0.0);
        if (this.e == SolveType.c) {
            return this.a(realMatrix, realMatrix2, dArray[9], dArray[10]);
        }
        if (this.e == SolveType.b) {
            return this.a(realMatrix, realMatrix2, dArray[9], dArray[9]);
        }
        return this.a(realMatrix, realMatrix2, 1.0, 1.0);
    }

    public double[] a(RealMatrix realMatrix, RealMatrix realMatrix2, double d2, double d3) {
        double[] dArray = new double[this.a.size() * 3];
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            RealMatrix realMatrix3 = this.d.get(i2);
            Point2f point2f = this.a.get(i2);
            double[][] dArrayArray = new double[][]{{(double)point2f.x * d2}, {(double)point2f.y * d3}, {0.0}, {1.0}};
            RealMatrix realMatrix4 = MatrixUtils.createRealMatrix((double[][])dArrayArray);
            RealMatrix realMatrix5 = realMatrix2.multiply(realMatrix3).multiply(realMatrix).multiply(realMatrix4);
            dArray[i2 * 3] = realMatrix5.getEntry(0, 0);
            dArray[i2 * 3 + 1] = realMatrix5.getEntry(1, 0);
            dArray[i2 * 3 + 2] = realMatrix5.getEntry(2, 0);
        }
        return dArray;
    }

    public MultivariateMatrixFunction jacobian() {
        return new MultivariateMatrixFunction(){

            public double[][] value(double[] dArray) {
                return CrossWireCalibrationProblem.this.a(dArray);
            }
        };
    }

    public double[] b(double[] dArray) {
        double d2 = 1.0;
        double d3 = 1.0;
        if (this.e == SolveType.b) {
            d2 = dArray[9];
            d3 = dArray[9];
        } else if (this.e == SolveType.c) {
            d2 = dArray[9];
            d3 = dArray[10];
        }
        RealMatrix realMatrix = MathUtils.a(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            RealMatrix realMatrix2 = MatrixUtils.createColumnRealMatrix((double[])new double[]{d2 * (double)this.a.get((int)i2).x, d3 * (double)this.a.get((int)i2).y, 0.0, 1.0});
            arrayList.add(this.d.get(i2).multiply(realMatrix).multiply(realMatrix2).getSubMatrix(0, 2, 0, 0).getColumnVector(0));
        }
        double[] dArray2 = new double[IntMath.binomial((int)arrayList.size(), (int)2)];
        int n2 = 0;
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            for (int i4 = i3 + 1; i4 < arrayList.size(); ++i4) {
                dArray2[n2] = ((RealVector)arrayList.get(i3)).getDistance((RealVector)arrayList.get(i4));
                ++n2;
            }
        }
        return dArray2;
    }

    public static enum SolveType {
        a,
        b,
        c;

    }
}

