/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.biopsy.trbx.calibration;

import com.google.common.primitives.Doubles;
import com.mimvista.biopsy.trbx.calibration.CrossWireCalibrationProblem;
import com.mimvista.biopsy.trbx.calibration.c;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.Point3d;
import com.mimvista.numerics.Point3f;
import com.mimvista.util.ay;
import java.util.List;
import java.util.stream.Collectors;
import javax.vecmath.Vector3d;
import org.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.general.LevenbergMarquardtOptimizer;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class a
implements c {
    CrossWireCalibrationProblem.SolveType a;
    boolean b;
    int c;

    public a(CrossWireCalibrationProblem.SolveType solveType, boolean bl2) {
        this.a = solveType;
        this.b = bl2;
    }

    @Override
    public RealMatrix a(List<Point2f> list, List<Point3d> list2, List<Vector3d> list3, Point3f point3f) {
        PointVectorValuePair pointVectorValuePair;
        LevenbergMarquardtOptimizer levenbergMarquardtOptimizer;
        if (list.size() <= 3) {
            ay.c((Object)"not enough samples provided for calibration.", a.class);
            return null;
        }
        CrossWireCalibrationProblem crossWireCalibrationProblem = new CrossWireCalibrationProblem(this.a);
        if (this.b) {
            levenbergMarquardtOptimizer = list.stream().map(point2f -> new Point2f(point2f.x / 10.0f, point2f.y / 10.0f)).collect(Collectors.toList());
            pointVectorValuePair = list2.stream().map(point3d -> new Point3d(point3d.x / 10.0, point3d.y / 10.0, point3d.z / 10.0)).collect(Collectors.toList());
            crossWireCalibrationProblem.a((List<Point2f>)levenbergMarquardtOptimizer, (List<Point3d>)pointVectorValuePair, list3);
        } else {
            crossWireCalibrationProblem.a(list, list2, list3);
        }
        levenbergMarquardtOptimizer = new LevenbergMarquardtOptimizer();
        pointVectorValuePair = levenbergMarquardtOptimizer.optimize(1000, (DifferentiableMultivariateVectorFunction)crossWireCalibrationProblem, crossWireCalibrationProblem.a(point3f), crossWireCalibrationProblem.b(), crossWireCalibrationProblem.a());
        double[] dArray = pointVectorValuePair.getPoint();
        if (this.a == CrossWireCalibrationProblem.SolveType.b && dArray[9] < 0.0) {
            dArray[3] = -dArray[3];
            dArray[4] = -dArray[4];
            dArray[5] = dArray[5] - Math.PI;
            dArray[9] = -dArray[9];
        } else if (this.a == CrossWireCalibrationProblem.SolveType.c && dArray[9] < 0.0 && dArray[10] > 0.0) {
            dArray[3] = -dArray[3] - Math.PI;
            dArray[4] = -dArray[4];
            dArray[5] = dArray[5] - Math.PI;
            dArray[9] = -dArray[9];
        } else if (this.a == CrossWireCalibrationProblem.SolveType.c && dArray[9] > 0.0 && dArray[10] < 0.0) {
            dArray[3] = dArray[3] - Math.PI;
            dArray[10] = -dArray[10];
        } else if (this.a == CrossWireCalibrationProblem.SolveType.c && dArray[9] < 0.0 && dArray[10] < 0.0) {
            dArray[3] = -dArray[3];
            dArray[4] = -dArray[4];
            dArray[5] = dArray[5] - Math.PI;
            dArray[9] = -dArray[9];
            dArray[10] = -dArray[10];
        }
        double[][] dArray2 = crossWireCalibrationProblem.a(dArray);
        RealMatrix realMatrix = MatrixUtils.createRealMatrix((double[][])dArray2);
        double[] dArray3 = new SingularValueDecomposition(realMatrix).getSingularValues();
        double d2 = Doubles.max((double[])dArray3) / Doubles.min((double[])dArray3);
        ay.b((Object)("kappa: " + d2), a.class);
        if (this.b) {
            crossWireCalibrationProblem = new CrossWireCalibrationProblem(this.a);
            crossWireCalibrationProblem.a(list, list2, list3);
            dArray[0] = dArray[0] * 10.0;
            dArray[1] = dArray[1] * 10.0;
            dArray[2] = dArray[2] * 10.0;
            dArray[6] = dArray[6] * 10.0;
            dArray[7] = dArray[7] * 10.0;
            dArray[8] = dArray[8] * 10.0;
        }
        RealMatrix realMatrix2 = MathUtils.a(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        this.a(crossWireCalibrationProblem, dArray);
        return realMatrix2;
    }

    private void a(CrossWireCalibrationProblem crossWireCalibrationProblem, double[] dArray) {
        double[] dArray2 = crossWireCalibrationProblem.value(dArray);
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d(1000.0, 1000.0, 1000.0);
        Point3d point3d3 = new Point3d();
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray2.length; i2 += 3) {
            Point3d point3d4 = new Point3d(dArray2[i2], dArray2[i2 + 1], dArray2[i2 + 2]);
            double d3 = point3d4.distance(point3d3);
            if (d3 > point3d.distance(point3d3)) {
                point3d = point3d4;
                this.c = i2 / 3;
            }
            if (d3 < point3d2.distance(point3d3)) {
                point3d2 = point3d4;
            }
            d2 += d3;
        }
        ay.b((Object)("minPoint: " + point3d2.distance(point3d3) + " mm " + (Object)((Object)point3d2)), a.class);
        ay.b((Object)("maxPoint: " + point3d.distance(point3d3) + " mm " + (Object)((Object)point3d)), a.class);
        ay.b((Object)("distanceMean: " + (d2 /= (double)(dArray2.length / 3)) + " mm"), a.class);
        double[] dArray3 = crossWireCalibrationProblem.b(dArray);
        ay.b((Object)("Delta Tx Mean: " + new Mean().evaluate(dArray3) + " mm"), a.class);
        ay.b((Object)("Delta Tx Max: " + Doubles.max((double[])dArray3) + " mm"), a.class);
    }

    public int a() {
        return this.c;
    }
}

