/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.alg;

import com.mimvista.brachytherapy.mui.sidepanel.BrachySidePanel;
import com.mimvista.brachytherapy.seeds.PrescribedSeed;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.numerics.ArrayListImageCubeFloat;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferences.al;
import com.mimvista.preferencesNew.BrachytherapyPrefs;
import com.mimvista.util.Messages;
import com.mimvista.util.work.m;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.Icon;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class DoseKernel {
    public static final float a = DoseKernel.g();
    public static final float b = 10.0f;
    public static final double c = 1.5707963267948966;
    private final ArrayListImageCubeFloat d;
    private ImageVolumeShort e;
    private PrescribedSeed f;
    private SimpleImageVolume<ImageCube.ImageCubeFloat> g;
    private SourceModel h = SourceModel.a();
    private static SourceModel i = SourceModel.a();

    public static int[] a(float[] fArray) {
        return new int[]{2 * Math.round(a / fArray[0]) + 1, 2 * Math.round(a / fArray[1]) + 1, 2 * Math.round(a / fArray[2]) + 1};
    }

    private static int g() {
        int n2 = 80;
        int n3 = BrachytherapyPrefs.doseKernelRadius.getValue();
        if (n3 <= 0) {
            n3 = n2;
        }
        return n3;
    }

    public DoseKernel(ImageVolumeShort imageVolumeShort, PrescribedSeed prescribedSeed) {
        this(imageVolumeShort, prescribedSeed, i);
    }

    public DoseKernel(ImageVolumeShort imageVolumeShort, PrescribedSeed prescribedSeed, SourceModel sourceModel) {
        this.d = new ArrayListImageCubeFloat(DoseKernel.a(imageVolumeShort.b()));
        int[] nArray = this.d.d();
        for (int i2 = 0; i2 < nArray[2]; ++i2) {
            this.d.a(new float[nArray[0] * nArray[1]]);
        }
        this.e = imageVolumeShort;
        this.f = prescribedSeed;
        this.h = sourceModel;
        this.h();
    }

    public int a() {
        return this.d.e();
    }

    public List<float[]> b() {
        return this.d.b();
    }

    public int[] c() {
        return this.d.d();
    }

    public float a(int n2, int n3, int n4) {
        return this.d.a_(n2, n3, n4);
    }

    public DoseKernel(DoseKernel doseKernel) {
        this.d = new ArrayListImageCubeFloat(DoseKernel.a(doseKernel.e.b()));
        this.f = doseKernel.f;
        this.g = SimpleImageVolume.aF();
        this.g.a(this.d);
        this.h = doseKernel.h;
        for (int i2 = 0; i2 < doseKernel.a(); ++i2) {
            float[] fArray = new float[doseKernel.b().get(i2).length];
            System.arraycopy(doseKernel.b().get(i2), 0, fArray, 0, doseKernel.b().get(i2).length);
            this.b().add(fArray);
        }
        this.e = doseKernel.e;
    }

    public static void a(SourceModel sourceModel) {
        i = sourceModel;
    }

    public static SourceModel d() {
        return i;
    }

    public void b(SourceModel sourceModel) {
        this.h = sourceModel;
        this.h();
    }

    public SourceModel e() {
        return this.h;
    }

    public PrescribedSeed f() {
        return this.f;
    }

    public float a(float f2, float f3, float f4, float f5) {
        return this.g.a(f2, f3, f4, f5);
    }

    private void h() {
        final float[] fArray = this.e.b();
        final Vector3f vector3f = new Vector3f(0.0f, 0.0f, 1.0f);
        int[] nArray = this.d.d();
        final Point3f point3f = new Point3f((float)nArray[0] * fArray[0] / 2.0f, (float)nArray[1] * fArray[1] / 2.0f, (float)nArray[2] * fArray[2] / 2.0f);
        final float f2 = DoseKernel.a(10.0f, 1.5707963267948966, this.f);
        final int n2 = (nArray[0] - 1) / 2;
        final int n3 = (nArray[1] - 1) / 2;
        final int n4 = (nArray[2] - 1) / 2;
        FuncUtils.a((ThreadPoolExecutor)m.c, n4 + 1, new FuncUtils.aa(){

            @Override
            public void f(int n22, int n32) throws FuncUtils.MIMInterruptedException {
                Vector3f vector3f2 = new Vector3f();
                for (int i2 = 0; i2 <= n3; ++i2) {
                    for (int i3 = 0; i3 <= n2; ++i3) {
                        vector3f2.z = ((float)(n22 + n4) + 0.5f) * fArray[2];
                        vector3f2.y = ((float)(i2 + n3) + 0.5f) * fArray[1];
                        vector3f2.x = ((float)(i3 + n2) + 0.5f) * fArray[0];
                        float f22 = DoseKernel.this.h == SourceModel.a ? DoseKernel.d(vector3f2, point3f, vector3f, fArray, f2, DoseKernel.this.f) : DoseKernel.c(vector3f2, point3f, vector3f, fArray, f2, DoseKernel.this.f);
                        float f3 = ((DoseKernel)DoseKernel.this).e.getUncopiedMutableInfo().rescale.removeRaw(f22);
                        for (int i4 = 1; i4 >= -1; i4 -= 2) {
                            for (int i5 = 1; i5 >= -1; i5 -= 2) {
                                for (int i6 = 1; i6 >= -1; i6 -= 2) {
                                    DoseKernel.this.d.a(n2 + i3 * i4, n3 + i2 * i5, n4 + n22 * i6, f3);
                                }
                            }
                        }
                    }
                }
            }
        });
        this.g = SimpleImageVolume.aF();
        this.g.a(this.d);
    }

    private static float c(Vector3f vector3f, Point3f point3f, Vector3f vector3f2, float[] fArray, float f2, PrescribedSeed prescribedSeed) {
        if (prescribedSeed.d().a()) {
            float f3;
            vector3f.sub((Tuple3f)point3f);
            float f4 = vector3f.length();
            if ((double)f4 < 1.0E-4) {
                f4 = Math.min(fArray[0], fArray[1]);
            }
            if ((f3 = DoseKernel.a(f4, 1.5707963267948966, prescribedSeed)) <= 0.0f) {
                System.err.println("Attention geometry function <= zero; bad state.");
            }
            float f5 = prescribedSeed.d(f4 / 10.0f);
            float f6 = prescribedSeed.e(f4 / 10.0f);
            float f7 = prescribedSeed.c() * prescribedSeed.j() * f3 * f5 * f6 / f2;
            f7 /= 100.0f;
            float f8 = DoseKernel.a(prescribedSeed);
            float f9 = (f7 *= 24.0f) * f8;
            return f9;
        }
        throw new UnsupportedOperationException("Current seed doesn't support point source model for TG-43 computation");
    }

    private static float d(Vector3f vector3f, Point3f point3f, Vector3f vector3f2, float[] fArray, float f2, PrescribedSeed prescribedSeed) {
        float f3;
        vector3f.sub((Tuple3f)point3f);
        float f4 = vector3f.length();
        if ((double)f4 < 1.0E-4) {
            f3 = 1.5707964f;
            f4 = Math.min(fArray[0], fArray[1]);
        } else {
            f3 = vector3f.angle(vector3f2);
        }
        float f5 = (float)((double)(f3 * 180.0f) / Math.PI);
        float f6 = DoseKernel.a(f4, f3, prescribedSeed);
        if (f6 <= 0.0f) {
            System.err.println("Attention, geometry function <= zero.  Not valid.");
        }
        float f7 = prescribedSeed.d(f4 / 10.0f);
        float f8 = prescribedSeed.a(f5, f4 / 10.0f);
        float f9 = prescribedSeed.c() * prescribedSeed.j() * f6 * f7 * f8 / f2;
        f9 /= 100.0f;
        float f10 = DoseKernel.a(prescribedSeed);
        float f11 = (f9 *= 24.0f) * f10;
        return f11;
    }

    public static float a(PrescribedSeed prescribedSeed) {
        float f2;
        if (prescribedSeed.a()) {
            f2 = (float)((double)prescribedSeed.i() / Math.log(2.0));
        } else {
            double d2 = Math.log(2.0) / (double)prescribedSeed.i();
            f2 = (float)((1.0 - Math.pow(Math.E, -d2 * (double)prescribedSeed.b())) / d2);
        }
        return f2;
    }

    private static float a(float f2, double d2, PrescribedSeed prescribedSeed) {
        float f3 = prescribedSeed.k() * 10.0f;
        if (Math.abs(d2) < 1.0E-4) {
            float f4 = 1.0f / (f2 * f2 - f3 * f3 / 4.0f);
            if (f4 > 0.0f) {
                return f4;
            }
            return 1.0f / (f2 * f2);
        }
        float f5 = f3 / 2.0f;
        double d3 = Math.sqrt((double)(f2 * f2 + f5 * f5) - (double)(2.0f * f2 * f5) * Math.cos(Math.PI - d2));
        double d4 = Math.sqrt((double)(f2 * f2 + f5 * f5) - (double)(2.0f * f2 * f5) * Math.cos(d2));
        double d5 = Math.acos((d3 * d3 + d4 * d4 - (double)(f3 * f3)) / (2.0 * d3 * d4));
        return (float)(d5 / ((double)(f3 * f2) * Math.sin(d2)));
    }

    public String toString() {
        return "[Dose Kernel voxel=" + Arrays.toString(this.g.b()) + "seed=" + this.f + " model=" + this.h + " ]";
    }

    public static enum SourceModel implements al<SourceModel>
    {
        a("LINE_DOSE_MODEL", "seed_line_mode"),
        b("POINT_DOSE_MODEL", "seed_point_mode");

        private final String name;
        private Icon icon;
        private static final Messages c;
        private static final int d = 20;

        private SourceModel(String string2) {
            this(string2, null);
        }

        private SourceModel(String string2, String string3) {
            this.name = string2;
            this.icon = ImageManipulator.c(string3, 20);
        }

        public static SourceModel a() {
            SourceModel sourceModel = BrachytherapyPrefs.doseModelType.getValue();
            if (sourceModel == null) {
                return a;
            }
            return sourceModel;
        }

        public String b() {
            return this.name;
        }

        public Icon c() {
            return this.icon;
        }

        @Override
        public String getExternalizedString() {
            return c.getProperty(this.name);
        }

        public String toString() {
            return this.getExternalizedString();
        }

        @Override
        public String getStringForPrefs() {
            return this.name();
        }

        static {
            c = BrachySidePanel.a;
        }
    }
}

