/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.alg;

import com.google.common.collect.Lists;
import com.mimvista.brachytherapy.alg.SegmentalDataFitter;
import com.mimvista.numerics.Regression;
import com.mimvista.util.ay;
import java.util.List;
import javax.vecmath.Point2d;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;

public class HCDAttenuationFitter
extends SegmentalDataFitter {
    private static final long serialVersionUID = 1L;

    public HCDAttenuationFitter(List<Point2d> list, float[] fArray) {
        super(list, fArray);
    }

    @Override
    protected void a() {
        List<Point2d>[] listArray = this.b();
        this.a = this.a(listArray);
    }

    private List<Point2d>[] b() {
        List[] listArray = new List[this.markers.length + 1];
        for (int i2 = 0; i2 < listArray.length; ++i2) {
            listArray[i2] = Lists.newArrayList();
        }
        for (Point2d point2d : this.data) {
            for (int i3 = 0; i3 < this.markers.length; ++i3) {
                if (!(point2d.x < (double)this.markers[i3])) continue;
                listArray[i3].add(point2d);
                break;
            }
            if (!(point2d.x >= (double)this.markers[this.markers.length - 1])) continue;
            listArray[this.markers.length].add(point2d);
        }
        return listArray;
    }

    private UnivariateFunction[] a(List<Point2d>[] listArray) {
        int n2;
        UnivariateFunction[] univariateFunctionArray = new UnivariateFunction[listArray.length];
        PolynomialFunction polynomialFunction = null;
        for (n2 = 0; n2 < listArray.length; ++n2) {
            if (listArray[n2].isEmpty()) continue;
            try {
                polynomialFunction = Regression.a(listArray[n2], 1);
                univariateFunctionArray[n2] = polynomialFunction;
                continue;
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error in fitting HCD attenuation coefficients.", throwable, this.getClass());
                univariateFunctionArray[n2] = null;
            }
        }
        if (polynomialFunction != null) {
            for (n2 = univariateFunctionArray.length - 1; n2 >= 0; --n2) {
                if (univariateFunctionArray[n2] == null) {
                    univariateFunctionArray[n2] = polynomialFunction;
                    continue;
                }
                polynomialFunction = univariateFunctionArray[n2];
            }
        } else {
            ay.c((Object)"We couldn't get any fitting functions for HCD attenuation coefficients.", this.getClass());
        }
        return univariateFunctionArray;
    }
}

