/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.alg;

import com.google.common.collect.Lists;
import com.mimvista.brachytherapy.alg.HCDAttenuationFitter;
import com.mimvista.brachytherapy.alg.HCDMassEnergyRatioFitter;
import com.mimvista.brachytherapy.alg.TissueType;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.numerics.MathUtils;
import com.mimvista.util.ay;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.vecmath.Point2d;

public class HCDCoefficientConverter
implements Serializable,
Cloneable {
    public static final TissueType[] a = new TissueType[]{TissueType.a, TissueType.b, TissueType.c, TissueType.d, TissueType.e, TissueType.f, TissueType.g, TissueType.h, TissueType.i, TissueType.j, TissueType.k, TissueType.l, TissueType.m, TissueType.n};
    private static final long serialVersionUID = 1L;
    private HCDTissueCoefficient tissueCoefficient;
    private float ka;
    private float kb;
    private String isotope;
    private String name;
    private String uid = UIDGenerator.generateUID();
    private HCDAttenuationFitter attenFitter = null;
    private HCDMassEnergyRatioFitter massEnergyFitter = null;

    public HCDCoefficientConverter() {
        this.tissueCoefficient = new HCDTissueCoefficient();
        this.ka = Float.NaN;
        this.kb = Float.NaN;
    }

    public boolean a() {
        return this.tissueCoefficient.a();
    }

    public void a(String string) {
        this.isotope = string;
    }

    public void a(float f2, int n2) {
        this.tissueCoefficient.a(f2, n2);
        this.attenFitter = null;
        this.massEnergyFitter = null;
    }

    public void b(float f2, int n2) {
        this.tissueCoefficient.b(f2, n2);
        this.attenFitter = null;
    }

    public void c(float f2, int n2) {
        this.tissueCoefficient.c(f2, n2);
        this.massEnergyFitter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float a(float f2) {
        if (this.attenFitter == null) {
            HCDCoefficientConverter hCDCoefficientConverter = this;
            synchronized (hCDCoefficientConverter) {
                if (this.attenFitter == null) {
                    this.k();
                }
            }
        }
        return this.attenFitter.a(f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float b(float f2) {
        if (this.massEnergyFitter == null) {
            HCDCoefficientConverter hCDCoefficientConverter = this;
            synchronized (hCDCoefficientConverter) {
                if (this.massEnergyFitter == null) {
                    this.l();
                }
            }
        }
        return this.massEnergyFitter.a(f2) / this.tissueCoefficient.massEnergy[this.a(TissueType.a)];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float c(float f2) {
        if (this.massEnergyFitter == null) {
            HCDCoefficientConverter hCDCoefficientConverter = this;
            synchronized (hCDCoefficientConverter) {
                if (this.massEnergyFitter == null) {
                    this.l();
                }
            }
        }
        return this.massEnergyFitter.a(f2);
    }

    public float b() {
        return this.tissueCoefficient.atten[this.a(TissueType.a)];
    }

    public float[] c() {
        return this.tissueCoefficient.b();
    }

    public float[] d() {
        return this.tissueCoefficient.c();
    }

    public float[] e() {
        return this.tissueCoefficient.d();
    }

    public float f() {
        if ("I-125".equalsIgnoreCase(this.isotope)) {
            return 1.2141f;
        }
        if ("Pd-103".equalsIgnoreCase(this.isotope)) {
            return 0.4465f;
        }
        return -100.0f;
    }

    public float g() {
        if ("I-125".equalsIgnoreCase(this.isotope)) {
            return 1.007f;
        }
        if ("Pd-103".equalsIgnoreCase(this.isotope)) {
            return 1.0734f;
        }
        return -100.0f;
    }

    public String h() {
        return this.name;
    }

    public void b(String string) {
        this.name = string;
    }

    public String i() {
        return this.uid;
    }

    public void c(String string) {
        this.uid = string;
    }

    public String toString() {
        return "<html><b>" + this.name + "</b></html>";
    }

    public HCDCoefficientConverter j() {
        try {
            HCDCoefficientConverter hCDCoefficientConverter = (HCDCoefficientConverter)super.clone();
            hCDCoefficientConverter.tissueCoefficient = this.tissueCoefficient.e();
            hCDCoefficientConverter.ka = this.ka;
            hCDCoefficientConverter.kb = this.kb;
            return hCDCoefficientConverter;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ay.d((Object)"Error cloning HUED Profile", (Throwable)cloneNotSupportedException, this);
            return null;
        }
    }

    private int a(TissueType tissueType) {
        return Arrays.binarySearch((Object[])a, (Object)tissueType);
    }

    private void k() {
        ArrayList arrayList = Lists.newArrayList();
        int n2 = this.a(TissueType.a);
        for (int i2 = 0; i2 < this.tissueCoefficient.hus.length; ++i2) {
            if (i2 == n2) continue;
            Point2d point2d = new Point2d((double)this.tissueCoefficient.hus[i2], (double)this.tissueCoefficient.atten[i2]);
            arrayList.add(point2d);
        }
        float[] fArray = new float[]{this.tissueCoefficient.hus[this.a(TissueType.d)], this.tissueCoefficient.hus[this.a(TissueType.k)]};
        this.attenFitter = new HCDAttenuationFitter(arrayList, fArray);
    }

    private void l() {
        ArrayList arrayList = Lists.newArrayList();
        int n2 = Arrays.binarySearch((Object[])a, (Object)TissueType.a);
        for (int i2 = 0; i2 < this.tissueCoefficient.hus.length; ++i2) {
            if (i2 == n2) continue;
            Point2d point2d = new Point2d((double)this.tissueCoefficient.hus[i2], (double)this.tissueCoefficient.massEnergy[i2]);
            arrayList.add(point2d);
        }
        float[] fArray = new float[]{this.tissueCoefficient.hus[this.a(TissueType.d)], this.tissueCoefficient.hus[this.a(TissueType.k)]};
        this.massEnergyFitter = new HCDMassEnergyRatioFitter(arrayList, fArray);
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.j();
    }

    private class HCDTissueCoefficient
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        private float[] hus = new float[a.length];
        private float[] atten = new float[a.length];
        private float[] massEnergy = new float[a.length];

        public HCDTissueCoefficient() {
            Arrays.fill(this.hus, Float.NaN);
            Arrays.fill(this.atten, Float.NaN);
            Arrays.fill(this.massEnergy, Float.NaN);
        }

        public boolean a() {
            for (float f2 : this.hus) {
                if (!Float.isNaN(f2)) continue;
                return false;
            }
            for (float f2 : this.atten) {
                if (!Float.isNaN(f2)) continue;
                return false;
            }
            for (float f2 : this.massEnergy) {
                if (!Float.isNaN(f2)) continue;
                return false;
            }
            return true;
        }

        public void a(float f2, int n2) {
            if (MathUtils.a(n2, this.hus.length)) {
                this.hus[n2] = f2;
            } else {
                ay.d((Object)"The index is out of bound for HU array.", this);
            }
        }

        public void b(float f2, int n2) {
            if (MathUtils.a(n2, this.atten.length)) {
                this.atten[n2] = f2;
            } else {
                ay.d((Object)"The index is out of bound for attenuation coefficient array.", this);
            }
        }

        public void c(float f2, int n2) {
            if (MathUtils.a(n2, this.massEnergy.length)) {
                this.massEnergy[n2] = f2;
            } else {
                ay.d((Object)"The index is out of bound for mass energy absorption coefficient array.", this);
            }
        }

        public float[] b() {
            return (float[])this.hus.clone();
        }

        public float[] c() {
            return (float[])this.atten.clone();
        }

        public float[] d() {
            return (float[])this.massEnergy.clone();
        }

        public HCDTissueCoefficient e() {
            try {
                HCDTissueCoefficient hCDTissueCoefficient = (HCDTissueCoefficient)super.clone();
                hCDTissueCoefficient.hus = (float[])this.hus.clone();
                hCDTissueCoefficient.atten = (float[])this.atten.clone();
                hCDTissueCoefficient.massEnergy = (float[])this.massEnergy.clone();
                return hCDTissueCoefficient;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                ay.d((Object)"Error cloning HUED Tissue Coefficient", (Throwable)cloneNotSupportedException, this);
                return null;
            }
        }

        public /* synthetic */ Object clone() throws CloneNotSupportedException {
            return this.e();
        }
    }
}

