/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.grids;

import com.google.common.collect.Lists;
import com.mimvista.brachytherapy.BrachyReportPlanState;
import com.mimvista.brachytherapy.grids.b;
import com.mimvista.brachytherapy.mui.sidepanel.BrachyTemplateGridSection;
import com.mimvista.preferencesNew.BrachytherapyPrefs;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.preferencesNew.cascade.c;
import com.mimvista.util.XMLUtils;
import com.mimvista.util.ay;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BrachyTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String a = "SystemTemplates.xml";
    public static final String b = "/xml/BrachyTherapy/SystemTemplates.xml";
    public static final String c = "UserTemplates.xml";
    private static List<BrachyTemplate> d = Lists.newArrayList();
    private static List<BrachyTemplate> e = Lists.newArrayList();
    private String manu = "";
    private String name = "";
    private String[] hLabels = new String[0];
    private String[] vLabels = new String[0];
    private float[] spacing = new float[0];
    private float[] fiducialPos = null;
    private List<int[]> excPoints = new ArrayList<int[]>();

    public static void main(String[] stringArray) {
        BrachyTemplate.c();
        BrachyTemplate.d();
    }

    public static BrachyTemplate a(BrachyReportPlanState.BrachyContext brachyContext) {
        String string = brachyContext == BrachyReportPlanState.BrachyContext.b ? BrachytherapyPrefs.defaultTemplateProstate.getValue() : BrachytherapyPrefs.defaultTemplate.getValue();
        if ("".equals(string)) {
            return null;
        }
        try {
            return BrachyTemplate.a(string);
        }
        catch (RuntimeException runtimeException) {
            ay.a((Object)runtimeException, BrachyTemplate.class);
            if (string == null || string.isEmpty()) {
                return null;
            }
            return BrachyTemplate.a(string);
        }
        catch (Exception exception) {
            ay.a((Object)exception, BrachyTemplate.class);
            BrachytherapyPrefs.defaultTemplate.setValue(BrachyTemplate.a().f());
            return BrachyTemplate.a();
        }
    }

    public static BrachyTemplate a() {
        for (BrachyTemplate brachyTemplate : d) {
            if (!brachyTemplate.manu.equalsIgnoreCase("Hitachi, Siemens Alternate") || !brachyTemplate.name.equalsIgnoreCase("B&K Standard, EZ Grid Type I")) continue;
            return brachyTemplate;
        }
        return d.get(0);
    }

    public static BrachyTemplate b() {
        String string = "B&K";
        List<BrachyTemplate> list = BrachyTemplate.c();
        for (BrachyTemplate brachyTemplate : list) {
            if (!brachyTemplate.f().contains(string)) continue;
            return brachyTemplate;
        }
        return list.get(0);
    }

    public static BrachyTemplate a(String string) {
        b b2 = com.mimvista.brachytherapy.grids.b.a(string);
        BrachyTemplate brachyTemplate = BrachyTemplate.a(b2);
        if (brachyTemplate == null) {
            throw new RuntimeException("Couldn't find template for config string: " + string);
        }
        return brachyTemplate;
    }

    private static InputStream q() throws FileNotFoundException {
        File file = com.mimvista.preferencesNew.cascade.c.e().a(CascadeSubfolder.a, a);
        if (file == null || !file.exists()) {
            return BrachyTemplate.class.getResourceAsStream(b);
        }
        return new FileInputStream(file);
    }

    private static void r() {
        try (InputStream inputStream = BrachyTemplate.q();){
            Document document = XMLUtils.a(inputStream);
            if (XMLUtils.b(document)) {
                List<BrachyTemplate> list = BrachyTemplate.a(document);
                BrachyTemplateGridSection.a(list);
                d.addAll(list);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ay.d((Object)("Template file not found: " + fileNotFoundException), BrachyTemplate.class);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ay.d((Object)"Error parsing Template file. ", (Throwable)parserConfigurationException, BrachyTemplate.class);
        }
        catch (SAXException sAXException) {
            ay.d((Object)"Error parsing Template file. ", (Throwable)sAXException, BrachyTemplate.class);
        }
        catch (IOException iOException) {
            ay.d((Object)"Error parsing Template file. ", (Throwable)iOException, BrachyTemplate.class);
        }
    }

    private static void s() {
        File file = com.mimvista.preferencesNew.cascade.c.e().a(CascadeSubfolder.a, c);
        List<BrachyTemplate> list = new ArrayList<BrachyTemplate>();
        if (file != null && file.exists()) {
            try {
                list = BrachyTemplate.a(XMLUtils.a(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                ay.d((Object)("User Template file not found: " + fileNotFoundException), BrachyTemplate.class);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ay.d((Object)("Error parsing User Template file. " + parserConfigurationException), BrachyTemplate.class);
            }
            catch (SAXException sAXException) {
                ay.d((Object)("Error parsing User Template file. " + sAXException), BrachyTemplate.class);
            }
            catch (IOException iOException) {
                ay.d((Object)("Error parsing User Template file. " + iOException), BrachyTemplate.class);
            }
        }
        BrachyTemplateGridSection.a(list);
        e.addAll(list);
    }

    private static synchronized List<BrachyTemplate> t() {
        ArrayList arrayList = Lists.newArrayList(d);
        arrayList.addAll(e);
        return arrayList;
    }

    public static synchronized List<BrachyTemplate> c() {
        return Lists.newArrayList(d);
    }

    public static synchronized List<BrachyTemplate> d() {
        return Lists.newArrayList(e);
    }

    public static synchronized void e() {
        e.clear();
        BrachyTemplate.s();
    }

    public static void a(String string, String[] stringArray, String[] stringArray2, float[] fArray, float[] fArray2, List<int[]> list) {
        File file = com.mimvista.preferencesNew.cascade.c.e().b(CascadeSubfolder.a, c);
        try {
            Document document;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (!file.exists()) {
                document = documentBuilder.newDocument();
                document.appendChild(document.createElement("AllTemplates"));
                XMLUtils.b(document, file);
            }
            document = documentBuilder.parse(file);
            Element element = document.createElement("Template");
            element.setAttribute("name", string);
            Node node = element.appendChild(document.createElement("HLabels"));
            StringBuilder stringBuilder = new StringBuilder("");
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                stringBuilder.append(stringArray2[i2]);
                if (i2 >= stringArray2.length - 1) continue;
                stringBuilder.append(",");
            }
            node.setTextContent(stringBuilder.toString());
            Node node2 = element.appendChild(document.createElement("VLabels"));
            stringBuilder = new StringBuilder("");
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                stringBuilder.append(stringArray[i3]);
                if (i3 >= stringArray.length - 1) continue;
                stringBuilder.append(",");
            }
            node2.setTextContent(stringBuilder.toString());
            Node node3 = element.appendChild(document.createElement("Spacing"));
            stringBuilder = new StringBuilder("");
            for (int i4 = 0; i4 < fArray.length; ++i4) {
                stringBuilder.append(fArray[i4]);
                if (i4 >= fArray.length - 1) continue;
                stringBuilder.append(",");
            }
            node3.setTextContent(stringBuilder.toString());
            if (fArray2 != null) {
                Node node4 = element.appendChild(document.createElement("Fiducial"));
                stringBuilder = new StringBuilder("");
                for (int i5 = 0; i5 < fArray2.length; ++i5) {
                    stringBuilder.append(fArray2[i5]);
                    if (i5 >= fArray2.length - 1) continue;
                    stringBuilder.append(",");
                }
                node4.setTextContent(stringBuilder.toString());
            }
            if (list != null && list.size() > 0) {
                Node node5 = element.appendChild(document.createElement("Excluded"));
                for (int[] nArray : list) {
                    Node node6 = node5.appendChild(document.createElement("Point"));
                    stringBuilder = new StringBuilder("");
                    for (int i6 = 0; i6 < nArray.length; ++i6) {
                        stringBuilder.append(nArray[i6]);
                        if (i6 >= nArray.length - 1) continue;
                        stringBuilder.append(",");
                    }
                    node6.setTextContent(stringBuilder.toString());
                }
            }
            document.getDocumentElement().appendChild(element);
            XMLUtils.b(document, file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static BrachyTemplate a(String string, String string2) {
        return BrachyTemplate.a(new b(string, string2));
    }

    public static BrachyTemplate a(b b2) {
        b b3 = b2.c();
        List<BrachyTemplate> list = BrachyTemplate.t();
        for (BrachyTemplate brachyTemplate : list) {
            if (!b3.a(brachyTemplate)) continue;
            return brachyTemplate;
        }
        if (b3 != b2) {
            ay.c((Object)("Old template " + b2 + " has been renamed to " + b3 + " but we couldn't find the new template, looking for the old one just in case"), BrachyTemplate.class);
            for (BrachyTemplate brachyTemplate : list) {
                if (!b2.a(brachyTemplate)) continue;
                return brachyTemplate;
            }
        }
        ay.c((Object)("Unable to find a BrachyTemplate that matches: " + b2), BrachyTemplate.class);
        return null;
    }

    private BrachyTemplate() {
    }

    public String f() {
        return new b(this.g(), this.h()).d();
    }

    public String toString() {
        return this.f();
    }

    public String g() {
        return this.manu;
    }

    public String h() {
        return this.name;
    }

    public float[] i() {
        return (float[])this.spacing.clone();
    }

    public float[] j() {
        return new float[]{this.spacing[0] * 10.0f, this.spacing[1] * 10.0f};
    }

    public String[] k() {
        return (String[])this.hLabels.clone();
    }

    public String[] l() {
        return (String[])this.vLabels.clone();
    }

    public int[] m() {
        int[] nArray = new int[]{0, 0};
        String[] stringArray = this.k();
        if (stringArray != null) {
            nArray[0] = stringArray.length;
        }
        String[] stringArray2 = this.l();
        if (stringArray != null) {
            nArray[1] = stringArray2.length;
        }
        return nArray;
    }

    public List<int[]> n() {
        ArrayList arrayList = Lists.newArrayList();
        for (int[] nArray : this.excPoints) {
            arrayList.add(nArray.clone());
        }
        return arrayList;
    }

    public float[] o() {
        if (this.fiducialPos == null) {
            return null;
        }
        float[] fArray = (float[])this.fiducialPos.clone();
        fArray[0] = fArray[0] * 10.0f;
        fArray[1] = fArray[1] * 10.0f;
        return fArray;
    }

    public float[] p() {
        float[] fArray = this.j();
        float f2 = (float)(this.k().length - 1) * fArray[0];
        float f3 = (float)(this.l().length - 1) * fArray[1];
        return new float[]{f2, f3};
    }

    private static List<BrachyTemplate> a(Document document) {
        ArrayList<BrachyTemplate> arrayList = new ArrayList<BrachyTemplate>();
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile("//AllTemplates/Template");
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                    Node node;
                    BrachyTemplate brachyTemplate = new BrachyTemplate();
                    Node node2 = nodeList.item(i2);
                    NamedNodeMap namedNodeMap = node2.getAttributes();
                    Node node3 = namedNodeMap.getNamedItem("name");
                    if (node3 != null) {
                        brachyTemplate.name = node3.getNodeValue();
                    }
                    if ((node = namedNodeMap.getNamedItem("manu")) != null) {
                        brachyTemplate.manu = node.getNodeValue();
                    }
                    NodeList nodeList2 = node2.getChildNodes();
                    for (int i3 = 0; i3 < nodeList2.getLength(); ++i3) {
                        int n2;
                        Object object;
                        if (nodeList2.item(i3).getNodeName().equalsIgnoreCase("HLabels")) {
                            brachyTemplate.hLabels = nodeList2.item(i3).getTextContent().split(",");
                            continue;
                        }
                        if (nodeList2.item(i3).getNodeName().equalsIgnoreCase("VLabels")) {
                            brachyTemplate.vLabels = nodeList2.item(i3).getTextContent().split(",");
                            continue;
                        }
                        if (nodeList2.item(i3).getNodeName().equalsIgnoreCase("Spacing")) {
                            object = nodeList2.item(i3).getTextContent().split(",");
                            brachyTemplate.spacing = new float[((String[])object).length];
                            for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                                brachyTemplate.spacing[n2] = Float.parseFloat((String)object[n2]);
                            }
                            continue;
                        }
                        if (nodeList2.item(i3).getNodeName().equalsIgnoreCase("Fiducial")) {
                            object = nodeList2.item(i3).getTextContent().split(",");
                            brachyTemplate.fiducialPos = new float[((String[])object).length];
                            for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                                brachyTemplate.fiducialPos[n2] = Float.parseFloat((String)object[n2]);
                            }
                            continue;
                        }
                        if (!nodeList2.item(i3).getNodeName().equalsIgnoreCase("Excluded") || (object = nodeList2.item(i3).getChildNodes()).getLength() <= 0) continue;
                        for (n2 = 0; n2 < object.getLength(); ++n2) {
                            String[] stringArray = object.item(n2).getTextContent().split(",");
                            if (stringArray.length < 2) continue;
                            int[] nArray = new int[stringArray.length];
                            for (int i4 = 0; i4 < stringArray.length; ++i4) {
                                nArray[i4] = Integer.parseInt(stringArray[i4]);
                            }
                            brachyTemplate.excPoints.add(nArray);
                        }
                    }
                    arrayList.add(brachyTemplate);
                }
            }
            System.out.println(arrayList.size() + " templates loaded!");
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new ArrayList<BrachyTemplate>();
        }
    }

    static {
        BrachyTemplate.r();
        BrachyTemplate.s();
    }
}

