/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.mui.overlays;

import com.google.common.collect.Lists;
import com.mimvista.brachytherapy.grids.BrachyTemplate;
import com.mimvista.brachytherapy.mui.overlays.TemplateGridOverlay;
import com.mimvista.mui.PresentationType;
import com.mimvista.numerics.MetricPoint2f;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.util.Messages;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BrachyNeedle
implements Serializable,
Comparable<BrachyNeedle> {
    private static final long serialVersionUID = 1L;
    protected MetricPoint3f gridOffset;
    protected float[] xyPosition;
    protected float seedThickness;
    protected float paddingLength;
    protected List<Integer> slicesWithSeeds = new ArrayList<Integer>();
    protected float voxToSeedLenRatio;

    static BrachyNeedle a(BrachyNeedle brachyNeedle, BrachyNeedle brachyNeedle2) {
        brachyNeedle2.paddingLength = brachyNeedle.paddingLength;
        for (Integer n2 : brachyNeedle.slicesWithSeeds) {
            brachyNeedle2.slicesWithSeeds.add(n2);
        }
        return brachyNeedle2;
    }

    BrachyNeedle(MetricPoint3f metricPoint3f, float[] fArray, float f2, float f3) {
        this.gridOffset = metricPoint3f;
        this.xyPosition = fArray;
        this.seedThickness = f2;
        this.voxToSeedLenRatio = f3;
    }

    public BrachyNeedle(BrachyNeedle brachyNeedle) {
        this(brachyNeedle.gridOffset.a(), brachyNeedle.xyPosition, brachyNeedle.seedThickness, brachyNeedle.voxToSeedLenRatio);
        BrachyNeedle.a(brachyNeedle, this);
    }

    public BrachyNeedle a() {
        return new BrachyNeedle(this);
    }

    public BrachyNeedle b() {
        return this.a();
    }

    public boolean c() {
        return false;
    }

    public MetricPoint2f d() {
        return new MetricPoint2f(0.0f, 0.0f, PresentationType.a);
    }

    public List<MetricPoint3f> e() {
        ArrayList arrayList = Lists.newArrayList();
        for (Integer n2 : this.slicesWithSeeds) {
            MetricPoint3f metricPoint3f = this.a((double)this.a((float)n2.intValue()));
            arrayList.add(metricPoint3f);
        }
        return arrayList;
    }

    public float a(float f2) {
        return f2;
    }

    public MetricPoint3f a(double d2) {
        MetricPoint3f metricPoint3f = this.gridOffset;
        VoxelIndexPoint3f voxelIndexPoint3f = new VoxelIndexPoint3f(0.0f, 0.0f, this.c(d2), metricPoint3f.i());
        MetricPoint3f metricPoint3f2 = new MetricPoint3f(metricPoint3f.x + this.xyPosition[0], metricPoint3f.y + this.xyPosition[1], voxelIndexPoint3f.d().z, metricPoint3f.i());
        return metricPoint3f2;
    }

    public float f() {
        return this.voxToSeedLenRatio;
    }

    public float[] g() {
        return (float[])this.xyPosition.clone();
    }

    public MetricPoint3f a(TemplateGridOverlay templateGridOverlay) {
        MetricPoint3f metricPoint3f = templateGridOverlay.v_();
        metricPoint3f.x += this.xyPosition[0];
        metricPoint3f.y += this.xyPosition[1];
        VoxelIndexPoint3f voxelIndexPoint3f = metricPoint3f.b().c();
        voxelIndexPoint3f.z = this.c((double)this.m());
        metricPoint3f = voxelIndexPoint3f.d();
        return metricPoint3f;
    }

    public void a(float[] fArray) {
        this.xyPosition = fArray;
    }

    public Integer b(float f2) {
        return this.d(this.c(f2));
    }

    public float c(float f2) {
        return f2 * this.voxToSeedLenRatio;
    }

    public Integer d(float f2) {
        return Math.round(f2);
    }

    public float b(double d2) {
        return (float)((d2 - (double)0.4999999f) / (double)this.voxToSeedLenRatio);
    }

    public float c(double d2) {
        return (float)(d2 / (double)this.voxToSeedLenRatio);
    }

    public float e(float f2) {
        return (f2 + 0.4999f) / this.voxToSeedLenRatio;
    }

    public void a(float f2, boolean bl2) {
        Integer n2 = !bl2 ? this.b(f2) : Integer.valueOf(Math.round(f2));
        if (this.slicesWithSeeds.contains(n2)) {
            this.slicesWithSeeds.remove(n2);
        } else {
            this.slicesWithSeeds.add(n2);
        }
    }

    public void a(int n2) {
        for (int i2 = 0; i2 < this.slicesWithSeeds.size(); ++i2) {
            this.slicesWithSeeds.set(i2, this.slicesWithSeeds.get(i2) + n2);
        }
    }

    public void f(float f2) {
        if (f2 == 0.0f) {
            this.paddingLength = 0.0f;
            return;
        }
        if (f2 < this.seedThickness) {
            throw new RuntimeException("Don't give a lenghtOfSpacers less than seed thickness to setPaddingLength...that's boo!");
        }
        float f3 = f2 / this.seedThickness;
        if ((double)Math.abs(f3 - (float)Math.round(f3)) > 0.001) {
            throw new RuntimeException("Don't pass a lengthOfSpacers that isn't a multiple of seedThickness to setPaddingLength...that's boo!");
        }
        this.paddingLength = f2;
    }

    public float h() {
        return this.paddingLength;
    }

    public float i() {
        return this.seedThickness;
    }

    public String a(BrachyTemplate brachyTemplate) {
        int n2 = Math.round(this.xyPosition[0] / brachyTemplate.j()[0]);
        int n3 = Math.round(this.xyPosition[1] / brachyTemplate.j()[1]);
        return brachyTemplate.k()[n2] + "," + brachyTemplate.l()[brachyTemplate.l().length - 1 - n3];
    }

    public NeedleSegmentType a(Integer n2) {
        if (this.slicesWithSeeds.contains(n2)) {
            return NeedleSegmentType.b;
        }
        if (this.b(n2)) {
            return NeedleSegmentType.a;
        }
        return NeedleSegmentType.c;
    }

    public NeedleSegmentType g(float f2) {
        Integer n2 = this.b(f2);
        return this.a(n2);
    }

    private boolean b(Integer n2) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (int n3 : this.slicesWithSeeds) {
            if (n3 > n2) {
                bl3 = true;
                continue;
            }
            if (n3 >= n2) continue;
            bl2 = true;
        }
        return bl3 && bl2;
    }

    public boolean j() {
        return this.slicesWithSeeds.isEmpty();
    }

    public void k() {
        this.slicesWithSeeds.clear();
    }

    public int l() {
        if (this.slicesWithSeeds.size() == 0) {
            return -1;
        }
        Collections.sort(this.slicesWithSeeds);
        Integer n2 = this.slicesWithSeeds.get(0);
        int n3 = Math.round(this.a((double)((double)n2.intValue())).b().c().z);
        return n3;
    }

    public int m() {
        return this.b((float)this.l());
    }

    public int n() {
        return this.b((float)this.o());
    }

    public int o() {
        if (this.slicesWithSeeds.size() == 0) {
            return -1;
        }
        Collections.sort(this.slicesWithSeeds);
        Integer n2 = this.slicesWithSeeds.get(this.slicesWithSeeds.size() - 1);
        int n3 = Math.round(this.a((double)((double)n2.intValue())).b().c().z);
        return n3;
    }

    public boolean b(float[] fArray) {
        return (double)Math.abs(this.xyPosition[0] - fArray[0]) < 0.001 && (double)Math.abs(this.xyPosition[1] - fArray[1]) < 0.001;
    }

    public float[] p() {
        return this.a(false);
    }

    public float[] a(boolean bl2) {
        if (this.slicesWithSeeds.size() == 0) {
            return new float[]{0.0f, 0.0f};
        }
        Collections.sort(this.slicesWithSeeds);
        float f2 = this.m();
        float f3 = this.n();
        f2 -= this.paddingLength / this.seedThickness;
        if (Math.abs(this.voxToSeedLenRatio - 1.0f) > 1.0E-4f && !bl2) {
            f2 = this.b((double)f2);
            f3 = this.e(f3);
        }
        return new float[]{f2, f3};
    }

    public float b(boolean bl2) {
        float[] fArray = this.a(bl2);
        return fArray[1] - fArray[0] + 1.0f;
    }

    public float q() {
        return this.b(false);
    }

    public NeedleSegmentType[] r() {
        float[] fArray = this.a(true);
        NeedleSegmentType[] needleSegmentTypeArray = new NeedleSegmentType[Math.round(fArray[1] - fArray[0] + 1.0f)];
        for (int i2 = 0; i2 < needleSegmentTypeArray.length; ++i2) {
            needleSegmentTypeArray[i2] = this.g((float)i2 + fArray[0]);
        }
        return needleSegmentTypeArray;
    }

    public float s() {
        float[] fArray = this.a(true);
        return (fArray[1] - fArray[0] + 1.0f) * this.seedThickness;
    }

    public int t() {
        return this.slicesWithSeeds.size();
    }

    public int a(BrachyNeedle brachyNeedle) {
        BrachyNeedle brachyNeedle2 = brachyNeedle;
        if ((double)Math.abs(this.xyPosition[1] - brachyNeedle2.xyPosition[1]) < 0.001) {
            return Float.compare(this.xyPosition[0], brachyNeedle2.xyPosition[0]);
        }
        return Float.compare(this.xyPosition[1], brachyNeedle2.xyPosition[1]);
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.b();
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.a((BrachyNeedle)object);
    }

    public static enum SeedSearchDirection {
        a,
        b;

    }

    public static enum NeedleSegmentType {
        a("TABLE_LEGEND_SPACER_DESC"),
        b("TABLE_LEGEND_SEED_DESC"),
        c;

        private String description;

        private NeedleSegmentType(String string2) {
            this.description = Messages.a("BrachytherapyReports", string2);
        }

        private NeedleSegmentType() {
            this.description = "";
        }

        public String a() {
            return this.description;
        }
    }
}

