/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.mui.overlays;

import com.mimvista.brachytherapy.mui.overlays.BrachyNeedle;
import com.mimvista.mui.PresentationType;
import com.mimvista.numerics.MetricPoint2f;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelIndexPoint3f;
import javax.vecmath.Matrix4f;

public class IntraopBrachyNeedle
extends BrachyNeedle {
    private static final long serialVersionUID = -1411732853740622256L;
    MetricPoint2f needleOffset;
    float deflectionAngleTheta;
    float deflectionRotationPhi;
    float seedSpaceTemplateZPos;

    public static boolean b(BrachyNeedle brachyNeedle, BrachyNeedle brachyNeedle2) {
        return brachyNeedle2 instanceof IntraopBrachyNeedle && brachyNeedle instanceof IntraopBrachyNeedle && (((IntraopBrachyNeedle)brachyNeedle2).deflectionAngleTheta != ((IntraopBrachyNeedle)brachyNeedle).deflectionAngleTheta || ((IntraopBrachyNeedle)brachyNeedle2).deflectionRotationPhi != ((IntraopBrachyNeedle)brachyNeedle).deflectionRotationPhi);
    }

    public IntraopBrachyNeedle(MetricPoint3f metricPoint3f, float[] fArray, float f2, float f3, MetricPoint2f metricPoint2f, float f4, float f5, float f6) {
        super(metricPoint3f, fArray, f2, f3);
        this.needleOffset = metricPoint2f;
        this.deflectionAngleTheta = f4;
        this.deflectionRotationPhi = f5;
        this.seedSpaceTemplateZPos = f6;
    }

    public IntraopBrachyNeedle(BrachyNeedle brachyNeedle) {
        this(brachyNeedle.gridOffset, brachyNeedle.xyPosition, brachyNeedle.seedThickness, brachyNeedle.voxToSeedLenRatio, new MetricPoint2f(0.0f, 0.0f, PresentationType.a), (float)Math.PI, 0.0f, 0.0f);
        IntraopBrachyNeedle.a(brachyNeedle, this);
    }

    public IntraopBrachyNeedle(IntraopBrachyNeedle intraopBrachyNeedle) {
        this((BrachyNeedle)intraopBrachyNeedle);
        this.needleOffset = intraopBrachyNeedle.needleOffset.a();
        this.deflectionAngleTheta = intraopBrachyNeedle.deflectionAngleTheta;
        this.deflectionRotationPhi = intraopBrachyNeedle.deflectionRotationPhi;
        this.seedSpaceTemplateZPos = intraopBrachyNeedle.seedSpaceTemplateZPos;
    }

    @Override
    public BrachyNeedle a() {
        return new IntraopBrachyNeedle(this);
    }

    @Override
    public boolean c() {
        return Math.abs((double)this.deflectionAngleTheta - Math.PI) > 0.001;
    }

    @Override
    public MetricPoint2f d() {
        return this.needleOffset;
    }

    public void a(MetricPoint2f metricPoint2f) {
        this.needleOffset = metricPoint2f;
    }

    public float u() {
        return this.deflectionAngleTheta;
    }

    public float v() {
        return this.deflectionRotationPhi;
    }

    public float w() {
        return this.seedSpaceTemplateZPos;
    }

    public float x() {
        float f2 = Math.abs(this.seedSpaceTemplateZPos - (float)this.m());
        return f2 * this.voxToSeedLenRatio;
    }

    @Override
    public float a(float f2) {
        double d2 = this.seedSpaceTemplateZPos - f2;
        float f3 = (float)(Math.cos(Math.PI - (double)this.deflectionAngleTheta) * d2);
        return (float)((double)f2 + (d2 - (double)f3));
    }

    @Override
    public MetricPoint3f a(double d2) {
        double d3 = ((double)this.seedSpaceTemplateZPos - d2) * (double)this.seedThickness;
        double d4 = Math.sin(Math.PI - (double)this.deflectionAngleTheta) * d3;
        double d5 = Math.cos(Math.PI - (double)this.deflectionAngleTheta) * d3;
        float f2 = (float)(d2 + (d3 - d5) / (double)this.seedThickness);
        VoxelIndexPoint3f voxelIndexPoint3f = new VoxelIndexPoint3f(0.0f, 0.0f, this.c((double)f2), this.gridOffset.i());
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.rotZ(this.deflectionRotationPhi);
        Point3f point3f = new Point3f((float)d4, 0.0f, 0.0f);
        Point3f point3f2 = point3f.e();
        matrix4f.transform((javax.vecmath.Point3f)point3f, (javax.vecmath.Point3f)point3f2);
        MetricPoint3f metricPoint3f = super.a(d2);
        metricPoint3f.x += point3f2.x;
        metricPoint3f.y += point3f2.y;
        metricPoint3f.z = voxelIndexPoint3f.d().z;
        metricPoint3f.x += this.needleOffset.x;
        metricPoint3f.y += this.needleOffset.y;
        return metricPoint3f;
    }

    public void a(double d2, double d3, Integer n2) {
        double d4 = Math.atan2(d3, d2);
        if (d4 < 0.0) {
            d4 += Math.PI * 2;
        }
        double d5 = Math.sqrt(d2 * d2 + d3 * d3);
        double d6 = (this.seedSpaceTemplateZPos - (float)n2.intValue()) * this.seedThickness;
        double d7 = Math.PI - Math.asin(d5 / d6);
        this.deflectionAngleTheta = (float)d7;
        this.deflectionRotationPhi = (float)d4;
    }
}

