/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.mui.sidepanel;

import com.google.common.base.Throwables;
import com.mimvista.archive.NameFormatter;
import com.mimvista.archive.gui.PatientListSidePanel;
import com.mimvista.archive.gui.SeriesResultPanel;
import com.mimvista.archive.gui.SwingPatientList;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.brachytherapy.BrachyReportPlanState;
import com.mimvista.brachytherapy.intraautocomplete.BrachyIntraopContentAutocompleter;
import com.mimvista.brachytherapy.mui.AbstractBrachyIntraopSidePanelContents;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.gui.util.q;
import com.mimvista.mui.toolbar.f;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.proui.ProButtonUI;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.video.d;
import com.mimvista.viewer.SeriesInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXDatePicker;

public class BrachyIntraOpSidePanel
extends PatientListSidePanel {
    private static final long serialVersionUID = 1L;
    private static final int a = 30;
    private static final int b = 5;
    private static final int c = 250;
    private BrachyIntraopSidePanelContents infoPanel;

    public BrachyIntraOpSidePanel(f f2) {
        super(f2);
        this.setLayout(new BoxLayout(this, 1));
        this.setName(Messages.a("Brachytherapy", "PL_SIDE_PANEL_TITLE"));
        this.setShowTitle(true);
        this.setIcon(ImageManipulator.c("intra_op_plan", 18));
        this.infoPanel = new BrachyIntraopSidePanelContents();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable runnable = () -> {
            int n2 = MIMSwingUtils.b(this.infoPanel, 250) + 25;
            this.infoPanel.setPreferredSize(new Dimension(250, n2));
            countDownLatch.countDown();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
            try {
                countDownLatch.await();
            }
            catch (Throwable throwable) {
                Throwables.propagate((Throwable)throwable);
            }
        }
        JScrollPane jScrollPane = new JScrollPane(this.infoPanel, 20, 31);
        this.add(jScrollPane);
    }

    @Override
    public String getConfigIdentifier() {
        return "BrachyIntraOpSidePanel";
    }

    @Override
    public void g() {
        this.infoPanel.copyButton.setEnabled(this.b() != null && this.b().size() == 1);
    }

    public class BrachyIntraopSidePanelContents
    extends AbstractBrachyIntraopSidePanelContents
    implements q {
        private static final long serialVersionUID = 1L;
        private JLabel errorMessageText;

        public BrachyIntraopSidePanelContents() {
            super(30, 5, new Insets(3, 3, 3, 3), 1.0);
        }

        @Override
        protected JPanel a() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            JLabel jLabel = new JLabel("<html>" + this.msgProps.getProperty("PL_SIDE_PANEL_EXPLANATION") + "</html>");
            jPanel.add(jLabel);
            jPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
            return jPanel;
        }

        @Override
        protected JPanel b() {
            JButton jButton = BrachyIntraOpSidePanel.buildCompanionButton(this.msgProps.getProperty("PL_SIDE_PANEL_START"), null, "start_brachy", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BrachyIntraopSidePanelContents.this.e();
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(jButton);
            return jPanel;
        }

        @Override
        protected void a(GridBagConstraints gridBagConstraints, JPanel jPanel) {
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            this.errorMessageText = new JLabel();
            jPanel.add((Component)this.errorMessageText, gridBagConstraints);
            this.errorMessageText.setForeground(MIMLookAndFeel.p().brighter().brighter());
        }

        private void e() {
            Object object;
            Object object2;
            this.g();
            if (!this.f()) {
                return;
            }
            SeriesInfo seriesInfo = new SeriesInfo();
            seriesInfo.patientNameRaw = this.txtPatientName.b();
            seriesInfo.patientName = NameFormatter.a(seriesInfo.patientNameRaw);
            seriesInfo.patientId = this.txtPatientId.b();
            seriesInfo.seriesDesc = this.txtSeriesDescription.getText();
            seriesInfo.sex = this.txtSex.getText();
            seriesInfo.b(this.txtAge.getText());
            if (this.dateBirthdate.getDate() != null) {
                seriesInfo.birthDate = DateUtils.a(this.dateBirthdate.getDate(), "yyyyMMdd");
            }
            if (this.txtWeight.getText().trim().length() > 0) {
                seriesInfo.weight = Float.parseFloat(this.txtWeight.getText());
            }
            SearchSource searchSource = null;
            if (BrachyIntraOpSidePanel.this.a() instanceof SwingPatientList && (object2 = ((SwingPatientList)(object = (SwingPatientList)BrachyIntraOpSidePanel.this.a())).k().j()) instanceof SearchSource) {
                searchSource = (SearchSource)object2;
            }
            object = null;
            if (this.bxButton != null && this.bxButton.isSelected()) {
                object = BrachyReportPlanState.SymphonyContext.b;
            }
            if (this.brachyButton != null && this.brachyButton.isSelected()) {
                object = BrachyReportPlanState.SymphonyContext.a;
            }
            if (this.trButton != null && this.trButton.isSelected()) {
                object = BrachyReportPlanState.SymphonyContext.c;
            }
            if (object == null) {
                object2 = Messages.a("Biopsy");
                this.a(((Messages)object2).getProperty("SIDEPANEL_INTRAOP_NO_CHOSEN_CONTEXT"), (JComponent)this.symphContextBox);
                return;
            }
            d.a(seriesInfo, searchSource, (BrachyReportPlanState.SymphonyContext)object);
            if (BrachyIntraOpSidePanel.this.a() instanceof SwingPatientList) {
                object2 = (SwingPatientList)BrachyIntraOpSidePanel.this.a();
                ((SwingPatientList)object2).i();
            }
        }

        private boolean f() {
            Messages messages = Messages.a("Brachytherapy");
            if (this.dateBirthdate.getEditor().getText().trim().length() > 0 && this.dateBirthdate.getDate() == null) {
                this.a(messages.getProperty("PL_SIDE_PANEL_ERROR_BIRTHDATE"), (JComponent)this.dateBirthdate);
                return false;
            }
            boolean bl2 = true;
            bl2 &= this.a(this.txtAge, Messages.a("Brachytherapy", "PL_SIDE_PANEL_ERROR_AGE"));
            bl2 &= this.a(this.txtWeight, Messages.a("Brachytherapy", "PL_SIDE_PANEL_ERROR_WEIGHT"));
            bl2 &= this.b(this.txtPatientName.a());
            return bl2 &= this.c(this.txtPatientId.a());
        }

        private boolean a(JTextField jTextField, String string) {
            try {
                float f2;
                if (jTextField.getText().trim().length() > 0 && (f2 = Float.parseFloat(jTextField.getText())) < 0.0f) {
                    this.a(string, jTextField);
                    return false;
                }
            }
            catch (Exception exception) {
                this.a(string, jTextField);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean b(JTextField jTextField) {
            String string;
            if (this.c(jTextField)) {
                Object object;
                string = this.txtPatientName.b();
                string = SeriesIdentifier.sanitizeName(NameFormatter.d(string));
                List list = null;
                try {
                    object = SwingPatientList.c().s();
                    list = ((SeriesResultPanel)object).getSelectedSeries();
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error getting selected series.", throwable, this.getClass());
                }
                finally {
                    if (list == null) {
                        list = BrachyIntraOpSidePanel.this.b();
                    }
                }
                if (list.size() == 0) {
                    return true;
                }
                object = list.iterator();
                while (object.hasNext()) {
                    if (!string.equals(SeriesIdentifier.sanitizeName(NameFormatter.d(((DcmSeries)object.next()).getPatientName())))) continue;
                    return true;
                }
            }
            string = this.msgProps.getProperty("PL_SIDE_PANEL_PATIENT_NAME_MISMATCH");
            this.a(string, jTextField);
            return false;
        }

        private boolean c(JTextField jTextField) {
            String string = jTextField.getText();
            if (cn.g(string)) {
                String string2 = Messages.a("Dicom", "DCM_FIX_INVALID");
                this.a(string2, jTextField);
                return false;
            }
            return true;
        }

        private void a(String string, final JComponent jComponent) {
            this.errorMessageText.setText("<html>" + string + "</html>");
            if (jComponent != null) {
                jComponent.requestFocusInWindow();
                final Color color = jComponent.getBackground();
                if (color == null || !color.equals(MIMLookAndFeel.p().darker())) {
                    jComponent.setBackground(MIMLookAndFeel.p().darker());
                    jComponent.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent keyEvent) {
                            jComponent.setBackground(color);
                            jComponent.removeKeyListener(this);
                        }
                    });
                }
            }
            this.invalidate();
            this.revalidate();
            this.repaint();
        }

        private void g() {
            this.errorMessageText.setText("");
        }

        @Override
        protected void b(GridBagConstraints gridBagConstraints, JPanel jPanel) {
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            this.copyButton = new JButton(new CopySeriesMetadataAction());
            this.copyButton.putClientProperty(ProButtonUI.a, true);
            this.copyButton.setEnabled(false);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            JPanel jPanel2 = MIMLookAndFeel.I();
            jPanel2.setLayout(new GridLayout(0, 1, 0, 0));
            jPanel2.add(this.copyButton);
            jPanel.add((Component)jPanel2, gridBagConstraints);
        }

        @Override
        protected void a(JRadioButton jRadioButton) {
        }

        @Override
        protected void a(JTextField jTextField) {
        }

        @Override
        protected void a(JXDatePicker jXDatePicker) {
        }

        @Override
        protected void a(BrachyIntraopContentAutocompleter brachyIntraopContentAutocompleter) {
        }

        private class CopySeriesMetadataAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            public CopySeriesMetadataAction() {
                super(BrachyIntraopSidePanelContents.this.msgProps.getProperty("PL_SIDE_PANEL_COPY_METADATA_FROM_SERIES"), ImageManipulator.c("clipboard_item", 18));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DcmSeries dcmSeries = (DcmSeries)BrachyIntraOpSidePanel.this.b().get(0);
                SeriesInfo seriesInfo = dcmSeries.getDataProvider().getUncopiedMutableInfo();
                BrachyIntraopSidePanelContents.this.txtPatientId.a(seriesInfo.patientId);
                BrachyIntraopSidePanelContents.this.txtAge.setText(seriesInfo.B());
                Date date = DateUtils.c(seriesInfo.birthDate);
                if (date != null) {
                    BrachyIntraopSidePanelContents.this.dateBirthdate.setDate(date);
                }
                if (seriesInfo.weight > 0.0f) {
                    BrachyIntraopSidePanelContents.this.txtWeight.setText("" + seriesInfo.weight);
                }
                BrachyIntraopSidePanelContents.this.txtPatientName.a(seriesInfo.patientNameRaw);
                BrachyIntraopSidePanelContents.this.txtSex.setText(seriesInfo.sex);
            }
        }
    }
}

