/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.optimization;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.brachytherapy.BrachyReportPlanState;
import com.mimvista.brachytherapy.f;
import com.mimvista.brachytherapy.mui.overlays.RandomBrachyNeedle;
import com.mimvista.brachytherapy.mui.overlays.TemplateGridOverlay;
import com.mimvista.brachytherapy.mui.overlays.TemplateGridOverlayState;
import com.mimvista.brachytherapy.mui.sidepanel.BrachySidePanel;
import com.mimvista.brachytherapy.optimization.BrachyAtlasViewer;
import com.mimvista.brachytherapy.optimization.BrachyLibDialog;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.file.MIMFile;
import com.mimvista.file.TarInputStream;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.af;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.e;
import com.mimvista.internals.linking.AffineTransform;
import com.mimvista.internals.linking.AffineTransformImpl;
import com.mimvista.internals.linking.PositionTransform;
import com.mimvista.internals.statistics.DiceJaccardDeriver;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.numerics.DataContour;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.MultipliedVoxelPoint3f;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.preferencesNew.BrachytherapyPrefs;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.XMLUtils;
import com.mimvista.util.ay;
import com.mimvista.util.ck;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import javax.vecmath.Tuple3f;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BrachyAtlasManager {
    public static Messages a = Messages.a("Atlas");
    private static final String b = "brachy-libs.xml";
    private static final SimpleDateFormat c = new SimpleDateFormat("yyyy_MM_dd");

    public static File a() {
        return com.mimvista.preferencesNew.cascade.c.e().b(CascadeSubfolder.a, b);
    }

    public static void main(String[] stringArray) {
        BrachyAtlasManager.a(null, "", (Progress)new o());
    }

    private BrachyAtlasManager() {
    }

    public static void a(List<Map<String, String>> list, BrachyReportPlanState.BrachyContext brachyContext) {
        String[] stringArray = new String[]{"name", "path"};
        File file = BrachyAtlasManager.a();
        if (!file.exists()) {
            BrachyAtlasManager.d();
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            String string = "//libs/library[@type=\"" + brachyContext.name() + "\"]";
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                    document.getDocumentElement().removeChild(nodeList.item(i2));
                }
            }
            for (Map<String, String> map : list) {
                Element element = (Element)document.getDocumentElement().appendChild(document.createElement("library"));
                element.setAttribute("type", brachyContext.name());
                for (String string2 : stringArray) {
                    Node node = element.appendChild(document.createElement(string2));
                    node.setTextContent(String.valueOf(map.get(string2.toUpperCase())));
                }
            }
            XMLUtils.b(document, file);
        }
        catch (Exception exception) {
            ay.d((Object)"Error saving brachy library list file", (Throwable)exception, BrachyAtlasManager.class);
        }
    }

    public static void a(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && file.getName().startsWith("2.16.840.1.114362.1");
            }
        });
        if (fileArray != null) {
            for (File file2 : fileArray) {
                new MIMFile(file2).delete();
            }
        }
        file.delete();
    }

    public static List<Map<String, String>> a(BrachyReportPlanState.BrachyContext brachyContext) {
        ArrayList arrayList = Lists.newArrayList();
        File file = BrachyAtlasManager.a();
        if (!file.exists()) {
            BrachyAtlasManager.d();
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            String string = "//libs/library[@type=\"" + brachyContext.name() + "\"]";
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                    Object object;
                    Node node = nodeList.item(i2);
                    NodeList nodeList2 = node.getChildNodes();
                    HashMap hashMap = Maps.newHashMap();
                    for (int i3 = 0; i3 < nodeList2.getLength(); ++i3) {
                        object = nodeList2.item(i3);
                        hashMap.put(object.getNodeName().trim().toUpperCase(), object.getTextContent().trim());
                    }
                    String string2 = (String)hashMap.get(BrachyLibDialog.a[0]);
                    object = (String)hashMap.get(BrachyLibDialog.a[3]);
                    if (StringUtils.isEmpty((CharSequence)string2) || StringUtils.isEmpty((CharSequence)object)) continue;
                    hashMap.put(BrachyLibDialog.a[1], String.valueOf(BrachyAtlasManager.c((String)object)));
                    hashMap.put(BrachyLibDialog.a[2], BrachyAtlasManager.d((String)object));
                    arrayList.add(hashMap);
                }
            }
        }
        catch (Exception exception) {
            ay.d((Object)"Error parsing brachy library list file", (Throwable)exception, BrachyAtlasManager.class);
        }
        return arrayList;
    }

    public static int b() {
        return BrachytherapyPrefs.atlasMatchNum.getValue();
    }

    private static void d() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.appendChild(document.createElement("libs"));
            XMLUtils.b(document, BrachyAtlasManager.a());
        }
        catch (Exception exception) {
            ay.d((Object)"Error creating brachy library list file", (Throwable)exception, BrachyAtlasManager.class);
        }
    }

    private static int c(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return 0;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        return fileArray.length;
    }

    private static String d(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return "N/A";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtils.b() + " 'at' HH:mm");
        String string2 = simpleDateFormat.format(new Date(file.lastModified()));
        return string2;
    }

    public static boolean a(ViewController viewController, String string) {
        try {
            Object object;
            Object object2;
            File file;
            OverlayCollection overlayCollection = viewController.ba();
            List<VolumetricContourOverlay> list = f.c(overlayCollection);
            if (list == null || list.isEmpty()) {
                ay.e("No planning contour is available to save this plan to brachy atlas.");
                return false;
            }
            BrachyReportPlanState brachyReportPlanState = BrachySidePanel.v(viewController.g());
            if (brachyReportPlanState.G() != BrachyReportPlanState.BrachyChronology.a && brachyReportPlanState.G() != BrachyReportPlanState.BrachyChronology.b) {
                ay.e("The plan has to be pre-op or intra-op to be saved to brachy atlas.");
                return false;
            }
            String string2 = BrachyAtlasManager.a(viewController);
            if (string2 == null) {
                return false;
            }
            String string3 = new File(string, UIDGenerator.generateUID()).getAbsolutePath();
            if (!string3.endsWith(File.separator)) {
                string3 = string3 + File.separator;
            }
            if (!(file = new File(string3)).exists()) {
                file.mkdirs();
            }
            BrachyAtlasManager.a(file, list.get(0));
            for (VolumetricContourOverlay object42 : list) {
                File file2 = new File(string3 + cn.t(object42.getName()) + File.separator);
                BrachyAtlasManager.a(file2, object42);
            }
            int n2 = 0;
            for (RandomBrachyNeedle randomBrachyNeedle : brachyReportPlanState.p().N()) {
                object2 = new ObjectOutputStream(new FileOutputStream(string3 + String.valueOf(++n2) + ".needle"));
                object = null;
                try {
                    ((ObjectOutputStream)object2).writeObject(randomBrachyNeedle);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (object2 == null) continue;
                    if (object != null) {
                        try {
                            ((ObjectOutputStream)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        continue;
                    }
                    ((ObjectOutputStream)object2).close();
                }
            }
            Point3f.PointVolumeInfo pointVolumeInfo = new Point3f.PointVolumeInfo(viewController.aw());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string3 + "pvi.dat"));
            object2 = null;
            try {
                objectOutputStream.writeObject(pointVolumeInfo);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (objectOutputStream != null) {
                    if (object2 != null) {
                        try {
                            objectOutputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        objectOutputStream.close();
                    }
                }
            }
            ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(new FileOutputStream(string3 + "gridPos.dat"));
            object2 = null;
            try {
                objectOutputStream2.writeObject((Object)brachyReportPlanState.p().l().h());
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (objectOutputStream2 != null) {
                    if (object2 != null) {
                        try {
                            objectOutputStream2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        objectOutputStream2.close();
                    }
                }
            }
            String string4 = c.format(new Date());
            object2 = new File(string3 + string4 + ".txt");
            object = new PrintWriter((File)object2);
            Throwable throwable = null;
            try {
                ((PrintWriter)object).println(list.get(0).getName());
                ((PrintWriter)object).println(string2);
                ((PrintWriter)object).println(brachyReportPlanState.f() + 1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((PrintWriter)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((PrintWriter)object).close();
                    }
                }
            }
            ay.b((Object)"Saving to brachy atlas complete!", BrachyAtlasManager.class);
            return true;
        }
        catch (Exception exception) {
            ay.d((Object)exception.getMessage(), BrachyAtlasManager.class);
            return false;
        }
    }

    private static void a(File file, VolumetricContourOverlay volumetricContourOverlay) throws FileNotFoundException, IOException {
        String string;
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(string = file.getAbsolutePath()).endsWith(File.separator)) {
            string = string + File.separator;
        }
        for (ContourSlice contourSlice : volumetricContourOverlay.aq().t()) {
            if (contourSlice.n()) continue;
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string + String.valueOf(contourSlice.zPosition) + ".slice"));
            Throwable throwable = null;
            try {
                objectOutputStream.writeObject(contourSlice);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (objectOutputStream == null) continue;
                if (throwable != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                objectOutputStream.close();
            }
        }
    }

    private static String a(ViewController viewController) {
        final String[] stringArray = new String[]{""};
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Notification.a a2 = new Notification.a(viewController);
        InputNotification inputNotification = new InputNotification(a2, a.getProperty("BRACHY_ATLAS_TITLE"), "save");
        final af af2 = inputNotification.addStringField(a.getProperty("BRACHY_ATLAS_PLAN_NAME") + " ");
        inputNotification.setShowReset(false);
        inputNotification.setIsDismissable(false);
        inputNotification.setOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                stringArray[0] = (String)af2.b();
                countDownLatch.countDown();
            }
        });
        inputNotification.setCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                stringArray[0] = null;
                countDownLatch.countDown();
            }
        });
        inputNotification.addToGrandNotifier();
        try {
            countDownLatch.await();
            return stringArray[0];
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return null;
        }
    }

    public static void a(File file, String string) {
        File file2 = new File(string);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        try (TarInputStream tarInputStream = new TarInputStream(new FileInputStream(file));){
            String string2 = null;
            byte[] byArray = new byte[1024];
            int n2 = 0;
            while ((string2 = tarInputStream.h()) != null) {
                string2 = string2.replace("\\", File.separator);
                string2 = string2.replace("/", File.separator);
                ay.e(string2 + ": " + tarInputStream.i());
                MIMFile mIMFile = new MIMFile(file2.getAbsolutePath(), string2);
                if (!((File)mIMFile).getParentFile().exists()) {
                    ((File)mIMFile).getParentFile().mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(mIMFile);
                Throwable throwable = null;
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    Throwable throwable2 = null;
                    try {
                        while ((n2 = tarInputStream.read(byArray)) > 0) {
                            bufferedOutputStream.write(byArray, 0, n2);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bufferedOutputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                bufferedOutputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bufferedOutputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (fileOutputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    fileOutputStream.close();
                }
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception.getMessage(), BrachyAtlasManager.class);
            BrachyAtlasViewer.a("<html>" + a.getProperty("BRACHY_ATLAS_IMPORT_ERROR") + "</html>", BasicNotification.NotificationType.a);
        }
    }

    public static List<a> a(c c2, String string, Progress progress) {
        List<Object> list = Lists.newArrayList();
        if (progress == null) {
            progress = o.o();
        }
        progress.a(BrachyAtlasViewer.a.getProperty("BRACHY_ATLAS_PARSE"));
        File[] fileArray = BrachyAtlasManager.e(string);
        if (fileArray == null || fileArray.length == 0) {
            progress.b();
            return list;
        }
        if (c2.a != null && !c2.a.Q()) {
            fileArray = BrachyAtlasManager.a(fileArray, c2.a.t().size());
        }
        if (c2.a != null && !c2.a.Q()) {
            progress.a(fileArray.length * 2);
        } else {
            progress.a(fileArray.length);
        }
        progress.a();
        for (File file : fileArray) {
            a a2 = BrachyAtlasManager.a(file);
            if (a2 != null) {
                list.add(a2);
            }
            progress.N_();
        }
        if (c2.a != null && !c2.a.Q()) {
            list = BrachyAtlasManager.a(list, c2, progress);
        }
        progress.b();
        return list;
    }

    private static File[] a(File[] fileArray, int n2) {
        File[] fileArray2;
        int[] nArray = new int[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            try {
                fileArray2 = fileArray[i2].listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isFile() && file.getAbsolutePath().toLowerCase().endsWith(".slice");
                    }
                });
                nArray[i2] = Math.abs(fileArray2.length - n2);
                continue;
            }
            catch (Exception exception) {
                ay.d((Object)exception.getMessage(), BrachyAtlasManager.class);
                nArray[i2] = n2;
            }
        }
        int[] nArray2 = ck.a(nArray, true);
        fileArray2 = Lists.newArrayList();
        int n3 = BrachyAtlasManager.b();
        for (int i3 = 0; i3 < nArray2.length; ++i3) {
            if (nArray[nArray2[i3]] != 0 && i3 >= 4 * n3) continue;
            fileArray2.add(fileArray[nArray2[i3]]);
        }
        ay.e(fileArray2.size() + " plans after filtering the number of slices.");
        return fileArray2.toArray(new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static a a(File file) {
        ObjectInputStream objectInputStream = null;
        try {
            File[] fileArray;
            a a2 = new a();
            a2.k = file.getParentFile().getAbsolutePath();
            a2.b = file.getName();
            objectInputStream = new ObjectInputStream(new FileInputStream(new File(file.getAbsolutePath(), "gridPos.dat")));
            a2.g = (MetricPoint3f)((Object)objectInputStream.readObject());
            objectInputStream.close();
            objectInputStream = new ObjectInputStream(new FileInputStream(new File(file.getAbsolutePath(), "pvi.dat")));
            a2.f = (Point3f.PointVolumeInfo)objectInputStream.readObject();
            objectInputStream.close();
            File[] fileArray2 = fileArray = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getAbsolutePath().toLowerCase().endsWith(".needle");
                }
            });
            int n2 = fileArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                File file2 = fileArray2[i2];
                objectInputStream = new ObjectInputStream(new FileInputStream(file2));
                RandomBrachyNeedle serializable = (RandomBrachyNeedle)objectInputStream.readObject();
                objectInputStream.close();
                a2.h.add(serializable);
            }
            if (!BrachyAtlasManager.a(file, a2)) {
                for (File file2 : fileArray2 = file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory();
                    }
                })) {
                    BrachyAtlasManager.a(file2, a2);
                }
            }
            if (!a2.e.isEmpty()) {
                a2.d = (DataContour)a2.e.get((int)0).y;
            }
            if ((fileArray2 = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isFile() && file.getName().endsWith(".txt")) {
                        try {
                            String string = file.getName().replace(".txt", "");
                            c.parse(string);
                            return true;
                        }
                        catch (ParseException parseException) {
                            return false;
                        }
                    }
                    return false;
                }
            })).length == 1) {
                String string = fileArray2[0].getName().replace(".txt", "");
                a2.a = c.parse(string);
                try (Scanner scanner = new Scanner(fileArray2[0]);){
                    if (scanner.hasNext()) {
                        a2.j = scanner.nextLine().trim();
                    }
                    if (scanner.hasNext()) {
                        a2.c = scanner.nextLine().trim();
                    }
                    if (scanner.hasNext()) {
                        a2.l = Integer.parseInt(scanner.nextLine().trim());
                    }
                }
            }
            ay.e("Atlas contour vol: " + BrachyAtlasManager.b(a2.d, a2.f));
            a a3 = a2;
            return a3;
        }
        catch (Exception exception) {
            ay.d((Object)("Exception when loading brachy atlas at " + file.getAbsolutePath()), BrachyAtlasManager.class);
            ay.d((Object)exception.getMessage(), BrachyAtlasManager.class);
            a a4 = null;
            return a4;
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static boolean a(File file, a a2) throws FileNotFoundException, IOException, ClassNotFoundException {
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getAbsolutePath().toLowerCase().endsWith(".slice");
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            return false;
        }
        a2.d = null;
        for (File file2 : fileArray) {
            try (ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file2));){
                ContourSlice contourSlice = (ContourSlice)objectInputStream.readObject();
                if (a2.d == null) {
                    a2.d = new DataContour(MathUtils.f(BrachyAtlasManager.a(a2.f), contourSlice.f()));
                    a2.d.d(contourSlice.f());
                    Pair<String, DataContour> pair = Pair.get(cn.u(file.getName()), a2.d);
                    a2.e.add(pair);
                }
                a2.d.d(contourSlice);
            }
        }
        return true;
    }

    private static File[] e(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        return fileArray;
    }

    private static List<a> a(List<a> list, c c2, Progress progress) {
        float f2 = (float)c2.a.t().size() / (float)c2.a.v()[2];
        int n2 = BrachyAtlasManager.b();
        ArrayList arrayList = Lists.newArrayList();
        float[] fArray = new float[n2];
        for (a a2 : list) {
            int n3;
            float f3 = BrachyAtlasManager.b(a2, c2);
            float f4 = (float)a2.d.t().size() / (float)a2.d.v()[2];
            if (Float.compare(f4, f2) != 0) {
                f3 *= 0.9f;
            }
            a2.i = Float.valueOf(f3);
            if (arrayList.size() < n2) {
                n3 = arrayList.size();
                arrayList.add(n3, a2);
                fArray[n3] = f3;
            } else {
                n3 = MathUtils.t(fArray);
                if (f3 > fArray[n3]) {
                    fArray[n3] = f3;
                    arrayList.set(n3, a2);
                }
            }
            progress.N_();
        }
        Collections.sort(arrayList, new Comparator<a>(){

            public int a(a a2, a a3) {
                if (a2.i.isNaN() || a3.i.isNaN()) {
                    return 0;
                }
                return Float.compare(a3.i.floatValue(), a2.i.floatValue());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((a)object, (a)object2);
            }
        });
        return arrayList;
    }

    private static float b(a a2, c c2) {
        Object object;
        Object object2;
        MetricPoint3f metricPoint3f = c2.a != null && !c2.a.Q() ? c2.a.n() : new MetricPoint3f(0.0f, 0.0f, 0.0f, c2.a.e());
        MetricPoint3f metricPoint3f2 = a2.d.a(a2.f);
        MetricPoint3f metricPoint3f3 = metricPoint3f.a();
        metricPoint3f3.sub((Tuple3f)metricPoint3f2);
        float[] fArray = BrachyAtlasManager.a(a2, c2);
        metricPoint3f3.x -= fArray[0];
        metricPoint3f3.y -= fArray[1];
        BrachyReportPlanState brachyReportPlanState = BrachySidePanel.v(c2.a.a.aD());
        if (brachyReportPlanState.e()) {
            int n2 = com.mimvista.brachytherapy.optimization.a.a(a2);
            object2 = new VoxelIndexPoint3f(0.0f, 0.0f, (float)n2, a2.f).d();
            int n3 = brachyReportPlanState.f();
            object = new VoxelIndexPoint3f(0.0f, 0.0f, (float)n3, c2.a.e()).d();
            metricPoint3f3.z = object.z - ((MetricPoint3f)((Object)object2)).z;
        }
        ImageVolumeShort imageVolumeShort = new ImageVolumeShort();
        imageVolumeShort.a(a2.f.voxel);
        imageVolumeShort.a(new int[]{Math.round(a2.f.originOffsetMM[0] * 2.0f / a2.f.voxel[0]), Math.round(a2.f.originOffsetMM[1] * 2.0f / a2.f.voxel[1]), Math.round(a2.f.originOffsetMM[2] * 2.0f / a2.f.voxel[2])});
        a2.d.a(imageVolumeShort);
        object2 = new AffineTransformImpl(imageVolumeShort, c2.a.a());
        ((AffineTransform)object2).a((Tuple3f)metricPoint3f3);
        Contour contour = ((PositionTransform)object2).b(a2.d);
        ay.e("Transformed contour volume: " + contour.M());
        object = DiceJaccardDeriver.a(c2.a, contour);
        return ((DiceJaccardDeriver.a)object).a;
    }

    public static float[] a(a a2, c c2) {
        if (c2.a == null) {
            return new float[]{0.0f, 0.0f};
        }
        ContourSlice contourSlice = e.b(a2.d);
        ContourSlice contourSlice2 = e.b(c2.a);
        Point2f point2f = contourSlice.r();
        Point2f point2f2 = contourSlice2.r();
        MetricPoint3f metricPoint3f = new MultipliedVoxelPoint3f(point2f.x + 0.5f, point2f.y + 0.5f, 0.5f, contourSlice.f(), a2.f).d().b();
        MetricPoint3f metricPoint3f2 = new MultipliedVoxelPoint3f(point2f2.x + 0.5f, point2f2.y + 0.5f, 0.5f, contourSlice2.f(), new Point3f.PointVolumeInfo(c2.a.a())).d().b();
        float[] fArray = c2.b.template.j();
        metricPoint3f.sub((Tuple3f)a2.g);
        metricPoint3f.x /= fArray[0];
        metricPoint3f.y /= fArray[1];
        metricPoint3f.x = (float)((double)metricPoint3f.x - Math.floor(metricPoint3f.x));
        metricPoint3f.y = (float)((double)metricPoint3f.y - Math.floor(metricPoint3f.y));
        metricPoint3f2.sub((Tuple3f)c2.b.h());
        metricPoint3f2.x /= fArray[0];
        metricPoint3f2.y /= fArray[1];
        metricPoint3f2.x = (float)((double)metricPoint3f2.x - Math.floor(metricPoint3f2.x));
        metricPoint3f2.y = (float)((double)metricPoint3f2.y - Math.floor(metricPoint3f2.y));
        metricPoint3f2.sub((Tuple3f)metricPoint3f);
        float f2 = metricPoint3f2.x;
        float f3 = metricPoint3f2.y;
        f2 -= (float)Math.round(f2);
        f3 -= (float)Math.round(f3);
        return new float[]{f2 *= fArray[0], f3 *= fArray[1]};
    }

    private static int[] a(Point3f.PointVolumeInfo pointVolumeInfo) {
        int[] nArray = new int[pointVolumeInfo.originOffsetMM.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = Math.round(pointVolumeInfo.originOffsetMM[i2] * 2.0f / pointVolumeInfo.voxel[i2]);
        }
        return nArray;
    }

    private static float b(DataContour dataContour, Point3f.PointVolumeInfo pointVolumeInfo) {
        float f2 = pointVolumeInfo.voxel[0] * pointVolumeInfo.voxel[1] * pointVolumeInfo.voxel[2];
        int n2 = dataContour.L();
        return f2 * (float)n2 / (float)MathUtils.d(dataContour.v()) / 1000.0f;
    }

    public static class b {
        public String a;
        public String b;
    }

    public static class c {
        public Contour a;
        public TemplateGridOverlayState b;

        public c(Contour contour, TemplateGridOverlayState templateGridOverlayState) {
            this.a = contour;
            this.b = templateGridOverlayState;
        }

        public c(Contour contour, TemplateGridOverlay templateGridOverlay) {
            this.a = contour;
            this.b = templateGridOverlay != null ? templateGridOverlay.l() : null;
        }
    }

    public static class a {
        public Date a;
        public String b = "";
        public String c = "";
        public DataContour d = null;
        public List<Pair<String, DataContour>> e = Lists.newArrayList();
        public Point3f.PointVolumeInfo f;
        public MetricPoint3f g;
        public List<RandomBrachyNeedle> h = Lists.newArrayList();
        public Float i = Float.valueOf(Float.NaN);
        public String j = "";
        public String k = null;
        public Integer l = null;

        public String toString() {
            String string = this.c;
            if (StringUtils.isEmpty((CharSequence)string)) {
                string = "N/A";
            }
            String string2 = "   ";
            string = string + "   -";
            if (this.a != null) {
                String string3 = DateUtils.a(this.a, "yyyy-MM-dd");
                string = string + "   " + string3;
            }
            int n2 = this.c();
            string = string + "   " + Messages.a("Brachytherapy", "SIDE_PANEL_NEEDLES") + (n2 >= 10 ? Integer.valueOf(n2) : "0" + n2);
            string = string + "   " + MIMFormat.a(Messages.a("Atlas", "BRACHY_ATLAS_CONTOUR_VOL"), this.j, Float.valueOf(this.d()));
            if (!this.i.isNaN()) {
                string = string + "   (" + this.i + ")";
            }
            return string;
        }

        public void a() {
            for (File file : BrachyAtlasManager.e(this.k)) {
                if (!file.getName().equals(this.b)) continue;
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (IOException iOException) {
                    ay.d((Object)"Error in deleting the brachy plan folder.", (Throwable)iOException, this.getClass());
                }
                return;
            }
        }

        public File b() {
            for (File file : BrachyAtlasManager.e(this.k)) {
                if (!file.getName().equals(this.b)) continue;
                return file;
            }
            return null;
        }

        public int c() {
            return this.h.size();
        }

        public float d() {
            return (float)Math.round(BrachyAtlasManager.b(this.d, this.f) * 100.0f) / 100.0f;
        }

        public int e() {
            if (this.d == null) {
                return 0;
            }
            this.d.A();
            return this.d.w();
        }

        public int f() {
            int n2 = 0;
            for (RandomBrachyNeedle randomBrachyNeedle : this.h) {
                n2 += randomBrachyNeedle.h().size();
            }
            return n2;
        }
    }
}

