/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.optimization;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.brachytherapy.BrachyReportPlanState;
import com.mimvista.brachytherapy.f;
import com.mimvista.brachytherapy.mui.overlays.RandomBrachyNeedle;
import com.mimvista.brachytherapy.mui.overlays.TemplateGridOverlay;
import com.mimvista.brachytherapy.mui.overlays.TemplateGridOverlayState;
import com.mimvista.brachytherapy.mui.seedviewer.NumericRenderer;
import com.mimvista.brachytherapy.mui.sidepanel.BrachyNeedleSection;
import com.mimvista.brachytherapy.optimization.BrachyAtlasManager;
import com.mimvista.brachytherapy.optimization.BrachyLibDialog;
import com.mimvista.brachytherapy.optimization.a;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.file.TarOutputStream;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.gui.util.MockDialogPanel;
import com.mimvista.gui.util.c;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.e;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.mui.MIMJDialog;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.MultipliedVoxelPoint3f;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.Polylines;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.az;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.m;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import javax.vecmath.Tuple3f;
import net.tomahawk.ExtensionsFilter;
import org.apache.commons.lang3.StringUtils;

public class BrachyAtlasViewer
extends MIMJDialog {
    public static Messages a = Messages.a("Atlas");
    private final String[] COL_KEYS = new String[]{"NAME", "DATE", "NEEDLES", "CONTOUR_NAME", "CONTOUR_SLICES", "CONTOUR_VOL", "SCORE"};
    private final int[] COL_WIDTHS = new int[]{50, 100, 50, 70, 70, 70, 50};
    private BrachyReportPlanState brps;
    private List<BrachyAtlasManager.a> dataList;
    private ViewController brachyVC;
    private BrachyAtlasManager.c pmp;
    private JTable planTable;
    private JLabel volume;
    private JLabel seedCount;
    private JLabel needleCount;
    private JButton transferBut;
    private JButton removeBut;
    private JButton exportBut;
    private ImagePanel viewPanel;
    private Map<BrachyAtlasManager.a, BufferedImage> imgCache = Maps.newHashMap();
    private Point2f imgSizeInMM = null;

    public BrachyAtlasViewer(Window window, List<BrachyAtlasManager.a> list, BrachyAtlasManager.c c2, BrachyReportPlanState brachyReportPlanState, String string) {
        super(window, "", false, false);
        String string2 = a.getProperty("BRACHY_ATLAS_TITLE");
        if (!StringUtils.isEmpty((CharSequence)string)) {
            string2 = string2 + " - " + string;
        }
        this.setTitle(string2);
        this.dataList = list;
        this.brachyVC = brachyReportPlanState != null ? brachyReportPlanState.g() : null;
        this.pmp = c2;
        this.brps = brachyReportPlanState;
        this.a();
        this.b();
    }

    private void a() {
        this.setMinimumSize(new Dimension(500, 500));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.planTable = new JTable();
        this.planTable.setModel(new PlanTableModel());
        this.planTable.setColumnModel(new PlanTableColModel());
        this.planTable.setAlignmentX(0.0f);
        this.planTable.setShowHorizontalLines(true);
        this.planTable.setShowVerticalLines(true);
        this.planTable.setSelectionMode(2);
        TableRowSorter<PlanTableModel> tableRowSorter = new TableRowSorter<PlanTableModel>((PlanTableModel)this.planTable.getModel());
        this.planTable.setRowSorter(tableRowSorter);
        this.planTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n2 = BrachyAtlasViewer.this.planTable.getSelectedRowCount();
                    BrachyAtlasViewer.this.removeBut.setEnabled(n2 > 0);
                    BrachyAtlasViewer.this.exportBut.setEnabled(n2 > 0);
                    BrachyAtlasViewer.this.transferBut.setEnabled(n2 == 1 && BrachyAtlasViewer.this.brachyVC != null);
                    if (n2 == 1) {
                        Object e2 = BrachyAtlasViewer.this.dataList.get(BrachyAtlasViewer.this.planTable.convertRowIndexToModel(BrachyAtlasViewer.this.planTable.getSelectedRow()));
                        if (e2 instanceof BrachyAtlasManager.a) {
                            BrachyAtlasManager.a a2 = (BrachyAtlasManager.a)e2;
                            BrachyAtlasViewer.this.viewPanel.a(BrachyAtlasViewer.this.a(a2));
                            Messages messages = Messages.a("Brachytherapy");
                            BrachyAtlasViewer.this.needleCount.setText(messages.getProperty("SIDE_PANEL_NEEDLES") + " " + a2.c());
                            BrachyAtlasViewer.this.seedCount.setText(messages.getProperty("SIDE_PANEL_SEEDS") + " " + a2.f());
                            BrachyAtlasViewer.this.volume.setText(MIMFormat.a(a.getProperty("BRACHY_ATLAS_CONTOUR_VOL"), a2.j, Float.valueOf(a2.d())).trim());
                        }
                    } else {
                        BrachyAtlasViewer.this.viewPanel.a(null);
                        BrachyAtlasViewer.this.volume.setText("");
                        BrachyAtlasViewer.this.seedCount.setText("");
                        BrachyAtlasViewer.this.needleCount.setText("");
                    }
                }
            }
        });
        this.planTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (BrachyAtlasViewer.this.transferBut.isEnabled() && mouseEvent.getClickCount() == 2) {
                    BrachyAtlasViewer.this.d().actionPerformed(null);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.planTable);
        jScrollPane.setPreferredSize(new Dimension(250, 200));
        this.getContentPane().add(jScrollPane);
        this.getContentPane().add(Box.createVerticalStrut(8));
        Box box = Box.createHorizontalBox();
        this.getContentPane().add(box);
        this.getContentPane().add(Box.createVerticalStrut(8));
        this.volume = new JLabel();
        this.seedCount = new JLabel();
        this.needleCount = new JLabel();
        box.add(this.seedCount);
        box.add(Box.createHorizontalStrut(25));
        box.add(this.needleCount);
        box.add(Box.createHorizontalStrut(25));
        box.add(this.volume);
        this.viewPanel = new ImagePanel();
        this.viewPanel.setPreferredSize(new Dimension(500, 500));
        this.getContentPane().add(this.viewPanel);
        this.getContentPane().add(Box.createVerticalStrut(8));
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        this.transferBut = c.c(this.d(), a.getProperty("BRACHY_ATLAS_TRANSFER_TIP"));
        this.transferBut.setText(Messages.a("Util", "TRANSFER_PROG_TRANSFER"));
        this.transferBut.setEnabled(this.planTable.getSelectedRow() != -1 && this.brachyVC != null);
        this.removeBut = c.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = BrachyAtlasViewer.this.planTable.getSelectedRows();
                final ArrayList arrayList = Lists.newArrayList();
                for (int n2 : nArray) {
                    BrachyAtlasManager.a a2 = (BrachyAtlasManager.a)BrachyAtlasViewer.this.dataList.get(BrachyAtlasViewer.this.planTable.convertRowIndexToModel(n2));
                    arrayList.add(a2);
                }
                BrachyAtlasViewer.this.dataList.removeAll(arrayList);
                BrachyAtlasViewer.this.volume.setText("");
                BrachyAtlasViewer.this.seedCount.setText("");
                BrachyAtlasViewer.this.needleCount.setText("");
                BrachyAtlasViewer.this.b();
                com.mimvista.util.work.m.e.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (BrachyAtlasManager.a a2 : arrayList) {
                            a2.a();
                        }
                        if (BrachyAtlasViewer.this.getParent() instanceof BrachyLibDialog) {
                            BrachyLibDialog brachyLibDialog = (BrachyLibDialog)BrachyAtlasViewer.this.getParent();
                            brachyLibDialog.b();
                        }
                    }
                });
            }
        }, Messages.a("Workflow", "IMPMGR_IMPORTED_REMOVE_SELECTED"));
        this.removeBut.setIcon(ImageManipulator.c("subtract", 18));
        this.removeBut.setText(Messages.a("ButtonFactory", "DELETE_BUTTON"));
        this.removeBut.setEnabled(this.planTable.getSelectedRow() != -1);
        this.exportBut = c.b(this.e(), a.getProperty("BRACHY_ATLAS_EXPORT_TIP"));
        this.exportBut.setIcon(ImageManipulator.c("folder_quicksave", 18));
        this.exportBut.setText(a.getProperty("BRACHY_ATLAS_EXPORT"));
        this.exportBut.setEnabled(this.planTable.getSelectedRow() != -1);
        box2.add(this.transferBut);
        box2.add(Box.createRigidArea(new Dimension(5, 0)));
        box2.add(this.removeBut);
        box2.add(Box.createRigidArea(new Dimension(5, 0)));
        box2.add(this.exportBut);
        box2.add(Box.createRigidArea(new Dimension(5, 0)));
        JButton jButton = c.d(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrachyAtlasViewer.this.dispose();
            }
        }, null);
        box2.add(this.transferBut);
        box2.add(Box.createRigidArea(new Dimension(5, 0)));
        box2.add(this.removeBut);
        box2.add(Box.createRigidArea(new Dimension(5, 0)));
        box2.add(this.exportBut);
        box2.add(Box.createRigidArea(new Dimension(5, 0)));
        box2.add(jButton);
        box2.add(Box.createRigidArea(new Dimension(5, 0)));
        this.getContentPane().add(box2);
        this.getContentPane().add(Box.createVerticalStrut(8));
        this.pack();
    }

    private void b() {
        ((PlanTableModel)this.planTable.getModel()).setRowCount(this.dataList.size());
        this.planTable.getSelectionModel().clearSelection();
        this.planTable.repaint();
        this.c();
    }

    private void c() {
        int n2 = this.planTable.getSelectedRowCount();
        this.removeBut.setEnabled(n2 > 0);
        this.exportBut.setEnabled(n2 > 0);
        this.transferBut.setEnabled(n2 == 1 && this.brachyVC != null);
    }

    private ActionListener d() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                com.mimvista.util.work.m.e.submit(new Runnable(){

                    @Override
                    public void run() {
                        Object e2 = BrachyAtlasViewer.this.dataList.get(BrachyAtlasViewer.this.planTable.convertRowIndexToModel(BrachyAtlasViewer.this.planTable.getSelectedRow()));
                        if (e2 instanceof BrachyAtlasManager.a) {
                            BrachyAtlasViewer.this.b((BrachyAtlasManager.a)e2);
                        }
                    }
                });
            }
        };
    }

    private ActionListener e() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MIMFile mIMFile;
                String string = "atlas";
                MIMFileDialog mIMFileDialog = MIMFileDialog.a(BrachyAtlasViewer.this, a.getProperty("BRACHY_ATLAS_EXPORT"), MIMFileDialog.FileDialogType.b);
                mIMFileDialog.a(new ExtensionsFilter(Messages.a("Atlas", "ATLASLIST_ATLAS_FILES"), string));
                mIMFileDialog.a(true);
                String string2 = mIMFileDialog.a();
                if (string2 == null) {
                    return;
                }
                if (!string2.endsWith("." + string)) {
                    string2 = string2 + "." + string;
                }
                if (!new MIMFile((mIMFile = new MIMFile(string2)).getParent()).canWrite()) {
                    JOptionPane.showMessageDialog(BrachyAtlasViewer.this, a.getProperty("ATLASLIST_LOCATION_DENIED"), a.getProperty("ATLASLIST_WARNING"), 2);
                    return;
                }
                try (TarOutputStream tarOutputStream = new TarOutputStream(new FileOutputStream(mIMFile));){
                    int[] nArray;
                    byte[] byArray = new byte[1024];
                    for (int n2 : nArray = BrachyAtlasViewer.this.planTable.getSelectedRows()) {
                        BrachyAtlasManager.a a2 = (BrachyAtlasManager.a)BrachyAtlasViewer.this.dataList.get(BrachyAtlasViewer.this.planTable.convertRowIndexToModel(n2));
                        MIMFile mIMFile2 = new MIMFile(a2.b());
                        MIMFile mIMFile3 = mIMFile2.g();
                        Vector<File> vector = mIMFile2.b();
                        for (File file : vector) {
                            if (file.isDirectory()) continue;
                            File file2 = Path.relativize(mIMFile3, file);
                            tarOutputStream.b(file2.getPath(), file.length());
                            FileInputStream fileInputStream = new FileInputStream(file);
                            Throwable throwable = null;
                            try {
                                int throwable3;
                                while ((throwable3 = fileInputStream.read(byArray)) > 0) {
                                    tarOutputStream.write(byArray, 0, throwable3);
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (fileInputStream == null) continue;
                                if (throwable != null) {
                                    try {
                                        fileInputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    continue;
                                }
                                fileInputStream.close();
                            }
                        }
                    }
                    String string3 = MIMFormat.a(a.getProperty("BRACHY_ATLAS_EXPORT_COMPLETED"), string2);
                    BrachyAtlasViewer.a("<html>" + string3 + "</html>", BasicNotification.NotificationType.c);
                }
                catch (Exception exception) {
                    ay.d((Object)exception.getMessage(), BrachyAtlasViewer.this);
                    BrachyAtlasViewer.a("<html>" + a.getProperty("BRACHY_ATLAS_EXPORT_ERROR") + "</html>", BasicNotification.NotificationType.a);
                }
            }
        };
    }

    private BufferedImage a(BrachyAtlasManager.a a2) {
        BufferedImage bufferedImage = this.imgCache.get(a2);
        if (bufferedImage == null) {
            Object object2;
            int n2;
            ContourSlice contourSlice = e.b(a2.d);
            az az2 = new az(Integer.MAX_VALUE, Integer.MAX_VALUE);
            az az3 = new az(Integer.MIN_VALUE, Integer.MIN_VALUE);
            for (int i2 = 0; i2 < contourSlice.i(); ++i2) {
                ContourSlice.ScanLine scanLine = contourSlice.c((short)i2);
                if (scanLine == null || scanLine.f()) continue;
                if (az2.b > i2) {
                    az2.b = i2;
                }
                if (az3.b < i2) {
                    az3.b = i2;
                }
                for (short n3 : scanLine.invPoints) {
                    if (az2.a > n3) {
                        az2.a = n3;
                    }
                    if (az3.a >= n3) continue;
                    az3.a = n3;
                }
            }
            float f2 = a2.f.voxel[0] / (float)a2.d.v()[0];
            float f3 = a2.f.voxel[1] / (float)a2.d.v()[1];
            if (this.imgSizeInMM == null) {
                int n4 = az3.a - az2.a + 1;
                int f4 = az3.b - az2.b + 1;
                n2 = 20;
                this.imgSizeInMM = new Point2f((float)n4 * f2 + (float)(n2 * 2), (float)f4 * f3 + (float)(n2 * 2));
            }
            int n5 = 500;
            float f4 = Math.max(this.imgSizeInMM.x, this.imgSizeInMM.y) / 500.0f;
            n2 = Math.round(this.imgSizeInMM.x / f4);
            int n3 = Math.round(this.imgSizeInMM.y / f4);
            bufferedImage = new BufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Point2f point2f = new Point2f((float)(az2.a + az3.a) / 2.0f, (float)(az2.b + az3.b) / 2.0f);
            graphics2D.setColor(SystemColor.WHITE);
            List<Polylines.MultipliedVoxelPolyline2f> list = contourSlice.b(a2.f, PresentationType.a);
            for (Object object2 : list) {
                int[] f7 = new int[object2.h()];
                int[] n7 = new int[object2.h()];
                for (int contourSlice2 = 0; contourSlice2 < object2.h(); ++contourSlice2) {
                    Point2f point2f2 = object2.a(contourSlice2);
                    float f5 = (point2f2.x - point2f.x) * f2;
                    float f6 = (point2f2.y - point2f.y) * f3;
                    f7[contourSlice2] = Math.round((float)n2 / 2.0f + f5 / f4);
                    n7[contourSlice2] = Math.round((float)n3 / 2.0f + f6 / f4);
                }
                graphics2D.drawPolygon(f7, n7, f7.length);
            }
            Object object3 = a2.d.v();
            object2 = new MultipliedVoxelPoint3f(new VoxelPoint3f(point2f.x / (float)object3[0], point2f.y / (float)object3[1], 0.0f, a2.f), a2.d.v()).d().b();
            float f7 = 4.0f;
            int n4 = Math.round(f7 / f4);
            graphics2D.setColor(SystemColor.GREEN);
            for (RandomBrachyNeedle randomBrachyNeedle : a2.h) {
                MetricPoint3f metricPoint3f = randomBrachyNeedle.f();
                metricPoint3f.sub((Tuple3f)object2);
                int n6 = Math.round((float)n2 / 2.0f + metricPoint3f.x / f4 - (float)n4 / 2.0f);
                int n7 = Math.round((float)n3 / 2.0f + metricPoint3f.y / f4 - (float)n4 / 2.0f);
                graphics2D.drawOval(n6, n7, n4, n4);
            }
            if (this.pmp.a != null) {
                graphics2D.setColor(SystemColor.YELLOW);
                ContourSlice contourSlice2 = e.b(this.pmp.a);
                Point2f point2f3 = contourSlice.r();
                Point2f point2f4 = contourSlice2.r();
                float[] fArray = BrachyAtlasManager.a(a2, this.pmp);
                list = contourSlice2.b(a2.f, PresentationType.a);
                for (Polylines.MultipliedVoxelPolyline2f multipliedVoxelPolyline2f : list) {
                    int[] nArray = new int[multipliedVoxelPolyline2f.h()];
                    int[] nArray2 = new int[multipliedVoxelPolyline2f.h()];
                    for (int i2 = 0; i2 < multipliedVoxelPolyline2f.h(); ++i2) {
                        Point2f point2f5 = multipliedVoxelPolyline2f.a(i2);
                        float f8 = (point2f5.x - point2f4.x) * this.pmp.a.a().b()[0] / (float)this.pmp.a.v()[0] + fArray[0];
                        float f9 = (point2f5.y - point2f4.y) * this.pmp.a.a().b()[1] / (float)this.pmp.a.v()[1] + fArray[1];
                        int n8 = Math.round(point2f3.x + f8 / a2.f.voxel[0] * (float)contourSlice.f()[0]);
                        int n9 = Math.round(point2f3.y + f9 / a2.f.voxel[1] * (float)contourSlice.f()[1]);
                        float f10 = ((float)n8 - point2f.x) * f2;
                        float f11 = ((float)n9 - point2f.y) * f3;
                        nArray[i2] = Math.round((float)n2 / 2.0f + f10 / f4);
                        nArray2[i2] = Math.round((float)n3 / 2.0f + f11 / f4);
                    }
                    graphics2D.drawPolygon(nArray, nArray2, nArray.length);
                }
            }
            this.imgCache.put(a2, bufferedImage);
        }
        return bufferedImage;
    }

    private void b(BrachyAtlasManager.a a2) {
        OverlayCollection overlayCollection = this.brachyVC.ba();
        VolumetricContourOverlay volumetricContourOverlay = f.d(overlayCollection);
        if (!(volumetricContourOverlay == null || volumetricContourOverlay.f() || this.brps.e() || BrachyNeedleSection.a(this.brps, Messages.a("Brachytherapy").b("SELECT_REF_PLANE_FOR_LIBRARY")))) {
            return;
        }
        final TemplateGridOverlay templateGridOverlay = this.brachyVC.ba().M();
        TemplateGridOverlayState templateGridOverlayState = com.mimvista.brachytherapy.optimization.a.a(this.brachyVC, a2, templateGridOverlay.l());
        templateGridOverlay.a(templateGridOverlayState);
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                templateGridOverlay.m();
                templateGridOverlay.n();
            }
        });
    }

    public static void a(String string, BasicNotification.NotificationType notificationType) {
        MockDialogPanel mockDialogPanel = new MockDialogPanel(string, notificationType);
        m m2 = new m(mockDialogPanel);
        u.b().c(m2);
    }

    public static class ImagePanel
    extends JPanel {
        private BufferedImage image;

        public void a(BufferedImage bufferedImage) {
            this.image = bufferedImage;
            this.repaint();
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.image != null) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                float f2;
                int n8;
                int n9 = this.image.getWidth();
                float f3 = (float)n9 / (float)(n8 = this.image.getHeight());
                if (f3 > (f2 = (float)(n7 = this.getWidth()) / (float)(n6 = this.getHeight()))) {
                    n5 = n7;
                    n4 = Math.round((float)n5 / f3);
                    n3 = 0;
                    n2 = (n6 - n4) / 2;
                } else {
                    n4 = n6;
                    n5 = Math.round((float)n4 * f3);
                    n2 = 0;
                    n3 = (n7 - n5) / 2;
                }
                graphics.drawImage(this.image, n3, n2, n5, n4, null);
            }
        }
    }

    private class PlanTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getRowCount() {
            return BrachyAtlasViewer.this.dataList == null ? 0 : BrachyAtlasViewer.this.dataList.size();
        }

        @Override
        public int getColumnCount() {
            return BrachyAtlasViewer.this.COL_KEYS.length;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            if (BrachyAtlasViewer.this.dataList == null) {
                return null;
            }
            if (n2 >= this.getRowCount() || n2 < 0 || n3 < 0 || n3 >= this.getColumnCount()) {
                return null;
            }
            BrachyAtlasManager.a a2 = (BrachyAtlasManager.a)BrachyAtlasViewer.this.dataList.get(n2);
            switch (n3) {
                case 0: {
                    if (StringUtils.isEmpty((CharSequence)a2.c)) {
                        return "N/A";
                    }
                    return a2.c;
                }
                case 1: {
                    return a2.a;
                }
                case 2: {
                    return a2.c();
                }
                case 3: {
                    return a2.j;
                }
                case 4: {
                    return a2.e();
                }
                case 5: {
                    return Float.valueOf(a2.d());
                }
                case 6: {
                    return a2.i;
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n2) {
            switch (n2) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Date.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return String.class;
                }
                case 4: {
                    return Integer.class;
                }
                case 5: {
                    return Float.class;
                }
                case 6: {
                    return Float.class;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return false;
        }
    }

    private class PlanTableColModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 1L;

        public PlanTableColModel() {
            for (int i2 = 0; i2 < BrachyAtlasViewer.this.COL_KEYS.length; ++i2) {
                TableColumn tableColumn = new TableColumn(i2);
                tableColumn.setHeaderValue(a.getProperty("BRACHY_ATLAS_COL_" + BrachyAtlasViewer.this.COL_KEYS[i2]));
                tableColumn.setPreferredWidth(BrachyAtlasViewer.this.COL_WIDTHS[i2]);
                if (i2 >= 2) {
                    tableColumn.setCellRenderer(new NumericRenderer());
                }
                this.addColumn(tableColumn);
            }
        }
    }
}

