/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.report;

import com.mimvista.brachytherapy.grids.BrachyTemplate;
import com.mimvista.brachytherapy.mui.overlays.RandomBrachyNeedle;
import com.mimvista.brachytherapy.mui.overlays.TemplateGridOverlay;
import com.mimvista.brachytherapy.mui.overlays.TemplateGridOverlayState;
import com.mimvista.brachytherapy.report.e;
import com.mimvista.brachytherapy.report.j;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point2f;
import com.mimvista.report.data.a.b;
import com.mimvista.util.Messages;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;

public class BrachyBattleshipGrid
extends JComponent {
    public static Messages a = Messages.a("BrachytherapyReports");
    private b planState;
    private float offsetRatio;
    private List<RandomBrachyNeedle> indexedNeedles;
    private BasicStroke dotStroke;
    private BasicStroke borderStroke;
    private int[] pixelDimensions;
    private int dotRadiusNeedle = 10;
    private int defaultSpacing = 30;
    private int borderMargin = 15;
    private int dotRadiusEmpty = 4;
    private float DOT_STROKE_WIDTH = 2.0f;
    private float BORDER_STROKE_WIDTH = 4.0f;
    private float fontSizeInside = 14.0f;
    private float fontSizeOutside = 11.0f;
    private float fontSizeLabel = 14.0f;
    private int legendHeight;
    private static final int b = 50;
    private final Color GRID_TEXT = Color.BLACK;
    private final Color GRID_BORDER = Color.BLACK;
    private final Color GRID_NEEDLE = Color.BLACK;
    private final Color GRID_DOTS = Color.BLACK;
    private final Color GRID_FIDUCIAL_NEEDLE = new Color(TemplateGridOverlay.j.getRGB() | 0xFF000000);

    public BrachyBattleshipGrid(b b2, float f2) {
        this.planState = b2;
        BrachyTemplate brachyTemplate = b2.d().a().template;
        this.offsetRatio = brachyTemplate.j()[1] / brachyTemplate.j()[0];
        this.indexedNeedles = j.a(b2.d().a().needles, brachyTemplate);
        this.pixelDimensions = this.a(f2);
        this.dotStroke = new BasicStroke(this.DOT_STROKE_WIDTH);
        this.borderStroke = new BasicStroke(this.BORDER_STROKE_WIDTH);
    }

    public float a() {
        return this.dotRadiusNeedle;
    }

    public BufferedImage b() {
        Object object;
        BufferedImage bufferedImage = new BufferedImage(this.pixelDimensions[0], this.pixelDimensions[1], 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(new Font("Serif", 0, 12));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BrachyTemplate brachyTemplate = this.planState.d().a().template;
        String[] stringArray = brachyTemplate.k();
        String[] stringArray2 = brachyTemplate.l();
        this.a(graphics2D);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                Point2f point2f = this.a(i2, i3, stringArray2.length - 1);
                if (this.a(i2, i3)) {
                    object = this.b(i2, i3);
                    if (object != null) {
                        this.a(graphics2D, point2f, (RandomBrachyNeedle)object);
                    } else {
                        this.a(graphics2D, point2f);
                    }
                }
                if (i2 == 0) {
                    this.a(graphics2D, stringArray2[i3], point2f, LabelDirection.a);
                }
                if (i3 != 0) continue;
                this.a(graphics2D, stringArray[i2], point2f, LabelDirection.b);
            }
        }
        float[] fArray = brachyTemplate.o();
        if (fArray != null) {
            float f2 = fArray[0] / brachyTemplate.j()[0];
            float f3 = fArray[1] / brachyTemplate.j()[1];
            object = this.a(f2, f3, stringArray2.length - 1);
            graphics2D = (Graphics2D)graphics2D.create();
            AffineTransform affineTransform = graphics2D.getTransform();
            affineTransform.concatenate(AffineTransform.getTranslateInstance(((Point2f)((Object)object)).x, ((Point2f)((Object)object)).y));
            graphics2D.setTransform(affineTransform);
            graphics2D.setStroke(this.dotStroke);
            graphics2D.setColor(this.GRID_FIDUCIAL_NEEDLE);
            e.b(graphics2D, (float)this.dotRadiusNeedle * 0.5f);
        }
        return bufferedImage;
    }

    private void a(Graphics2D graphics2D) {
        graphics2D.setColor(this.GRID_BORDER);
        graphics2D.setStroke(this.borderStroke);
        int[] nArray = this.planState.d().a().template.m();
        Point2f point2f = this.a(0.0f, nArray[1] - 1, nArray[1] - 1);
        point2f.x = (float)((double)point2f.x - (double)this.borderMargin * 1.1);
        point2f.y -= (float)this.borderMargin;
        Point2f point2f2 = this.a(nArray[0] - 1, 0.0f, nArray[1] - 1);
        point2f2.x += (float)this.borderMargin;
        point2f2.y = (float)((double)point2f2.y + (double)this.borderMargin * 1.25);
        Path2D.Float float_ = new Path2D.Float();
        float_.moveTo(point2f.x, point2f.y);
        float_.lineTo(point2f2.x, point2f.y);
        float_.lineTo(point2f2.x, point2f2.y);
        float_.lineTo(point2f.x, point2f2.y);
        float_.lineTo(point2f.x, point2f.y);
        graphics2D.draw(float_);
    }

    private void a(Graphics2D graphics2D, Point2f point2f, float f2) {
        graphics2D.draw(new Ellipse2D.Float(point2f.x - f2, point2f.y - f2, f2 * 2.0f, f2 * 2.0f));
    }

    private void a(Graphics2D graphics2D, Point2f point2f) {
        graphics2D.setStroke(this.dotStroke);
        graphics2D.setColor(this.GRID_DOTS);
        this.a(graphics2D, point2f, (float)this.dotRadiusEmpty);
    }

    private void a(Graphics2D graphics2D, Point2f point2f, RandomBrachyNeedle randomBrachyNeedle) {
        graphics2D.setStroke(this.dotStroke);
        graphics2D.setColor(this.GRID_NEEDLE);
        BrachyTemplate brachyTemplate = this.planState.d().a().template;
        new e(randomBrachyNeedle, this.planState.d()).a(graphics2D, point2f, this.dotRadiusNeedle);
        String string = Integer.toString(randomBrachyNeedle.l());
        String string2 = j.b(this.indexedNeedles, randomBrachyNeedle, brachyTemplate);
        String string3 = randomBrachyNeedle.a(brachyTemplate);
        graphics2D.setColor(this.GRID_TEXT);
        graphics2D.setFont(graphics2D.getFont().deriveFont(0, this.fontSizeInside));
        FontMetrics fontMetrics = MIMSwingUtils.a(graphics2D);
        graphics2D.drawString(string, point2f.x - (float)(fontMetrics.stringWidth(string) / 2), point2f.y + this.fontSizeInside / 2.0f);
        graphics2D.setFont(graphics2D.getFont().deriveFont(0, this.fontSizeOutside));
        fontMetrics = MIMSwingUtils.a(graphics2D);
        graphics2D.drawString(string2, (float)((double)point2f.x - Math.cos(Math.toRadians(35.0)) * (double)this.dotRadiusNeedle - (double)fontMetrics.stringWidth(string2)), (float)((double)point2f.y - Math.sin(Math.toRadians(35.0)) * (double)this.dotRadiusNeedle));
        graphics2D.drawString(string3, point2f.x - (float)(fontMetrics.stringWidth(string3) / 2), point2f.y + (float)this.dotRadiusNeedle + this.fontSizeOutside * 0.9f);
    }

    private void a(Graphics2D graphics2D, String string, Point2f point2f, LabelDirection labelDirection) {
        graphics2D.setFont(graphics2D.getFont().deriveFont(1, this.fontSizeLabel));
        graphics2D.setColor(this.GRID_TEXT);
        FontMetrics fontMetrics = MIMSwingUtils.a(graphics2D);
        if (labelDirection == LabelDirection.a) {
            graphics2D.drawString(string, (float)((double)point2f.x - (double)this.borderMargin * 1.4 - (double)fontMetrics.stringWidth(string)), point2f.y + this.fontSizeLabel * 0.7f / 2.0f);
        } else if (labelDirection == LabelDirection.b) {
            graphics2D.drawString(string, point2f.x - (float)(fontMetrics.stringWidth(string) / 2), point2f.y + this.fontSizeLabel + (float)this.borderMargin * 1.3f);
        }
    }

    private RandomBrachyNeedle a(List<RandomBrachyNeedle> list) {
        float f2 = 0.0f;
        RandomBrachyNeedle randomBrachyNeedle = null;
        for (RandomBrachyNeedle randomBrachyNeedle2 : list) {
            float f3 = randomBrachyNeedle2.k();
            if (!(f3 > f2)) continue;
            randomBrachyNeedle = randomBrachyNeedle2;
            f2 = f3;
        }
        return randomBrachyNeedle;
    }

    public BufferedImage c() {
        String string;
        String string2;
        float f2;
        TemplateGridOverlayState templateGridOverlayState = this.planState.d().a();
        BrachyTemplate brachyTemplate = templateGridOverlayState.template;
        RandomBrachyNeedle randomBrachyNeedle = this.a(templateGridOverlayState.needles);
        if (randomBrachyNeedle == null) {
            float f3 = templateGridOverlayState.b();
            MetricPoint3f metricPoint3f = templateGridOverlayState.h();
            f2 = templateGridOverlayState.h().i().voxel[2] / f3;
            randomBrachyNeedle = new RandomBrachyNeedle(metricPoint3f, new float[]{0.0f, 0.0f}, f3, f2, TemplateGridOverlay.c(templateGridOverlayState));
            string2 = "1";
            string = "5";
        } else {
            string2 = j.b(this.indexedNeedles, randomBrachyNeedle, brachyTemplate);
            string = Integer.toString(randomBrachyNeedle.l());
        }
        String string3 = randomBrachyNeedle.a(brachyTemplate);
        float f4 = this.legendHeight / 3;
        f2 = this.legendHeight / 3;
        float f5 = f4;
        float f6 = f4 * 0.8f;
        Graphics graphics = new BufferedImage(1, 1, 2).getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont().deriveFont(f2));
        String string4 = a.getProperty("TABLE_TITLE_SEED_COUNT");
        String string5 = a.getProperty("TABLE_TITLE_NEEDLE_NUMBER");
        String string6 = a.getProperty("TABLE_TITLE_HOLE_LOCATION");
        int n2 = Math.max(Math.max(fontMetrics.stringWidth(string5), fontMetrics.stringWidth(string6)), fontMetrics.stringWidth(string4));
        int n3 = (int)(f4 * 5.0f + (float)n2);
        BufferedImage bufferedImage = new BufferedImage(n3, (int)((double)this.legendHeight * 1.5), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setStroke(this.dotStroke);
        graphics2D.setColor(this.GRID_NEEDLE);
        graphics2D.setFont(graphics2D.getFont().deriveFont(0));
        Point2f point2f = new Point2f(f4 * 2.0f, (float)this.legendHeight / 1.5f);
        this.a(graphics2D, point2f, f4);
        graphics2D.setFont(graphics2D.getFont().deriveFont(f2));
        FontMetrics fontMetrics2 = MIMSwingUtils.a(graphics2D);
        Point2f point2f2 = new Point2f(new float[]{point2f.x, point2f.y});
        point2f2.x += f4 * 2.0f;
        graphics2D.drawString(string4, point2f2.x, point2f2.y + (float)(graphics2D.getFont().getSize() / 2));
        graphics2D.setFont(graphics2D.getFont().deriveFont(f5));
        fontMetrics2 = MIMSwingUtils.a(graphics2D);
        graphics2D.drawString(string, point2f.x - (float)(fontMetrics2.stringWidth(string) / 2), point2f.y + (float)(graphics2D.getFont().getSize() / 2));
        Point2f point2f3 = new Point2f(new float[]{point2f.x, point2f.y});
        point2f3.x += (float)(fontMetrics2.stringWidth(string) / 2);
        int n4 = 5;
        graphics2D.drawLine((int)point2f3.x + n4, (int)point2f3.y, (int)point2f2.x - n4, (int)point2f2.y);
        graphics2D.setFont(graphics2D.getFont().deriveFont(f5));
        fontMetrics2 = MIMSwingUtils.a(graphics2D);
        graphics2D.setFont(graphics2D.getFont().deriveFont(f6));
        fontMetrics2 = MIMSwingUtils.a(graphics2D);
        point2f3.x = (float)((double)(point2f.x - (float)fontMetrics2.stringWidth(string2)) - Math.cos(Math.toRadians(35.0)) * (double)f4);
        point2f3.y = (float)((double)point2f.y - Math.sin(Math.toRadians(35.0)) * (double)f4);
        graphics2D.drawString(string2, point2f3.x, point2f3.y);
        point2f3.x += (float)fontMetrics2.stringWidth(string2);
        point2f3.y -= (float)(graphics2D.getFont().getSize() / 2);
        graphics2D.setFont(graphics2D.getFont().deriveFont(f2));
        fontMetrics2 = MIMSwingUtils.a(graphics2D);
        point2f2.y -= (float)graphics2D.getFont().getSize() * 1.25f;
        graphics2D.drawString(string5, point2f2.x, point2f2.y + (float)(graphics2D.getFont().getSize() / 2));
        graphics2D.drawLine((int)point2f3.x + n4, (int)point2f3.y, (int)point2f2.x - n4, (int)point2f2.y);
        graphics2D.setFont(graphics2D.getFont().deriveFont(f6));
        fontMetrics2 = MIMSwingUtils.a(graphics2D);
        point2f3.x = point2f.x - (float)(fontMetrics2.stringWidth(string3) / 2);
        point2f3.y = point2f.y + f4 + (float)graphics2D.getFont().getSize();
        graphics2D.drawString(string3, point2f3.x, point2f3.y);
        point2f3.x += (float)fontMetrics2.stringWidth(string3);
        point2f3.y -= (float)(graphics2D.getFont().getSize() / 2);
        graphics2D.setFont(graphics2D.getFont().deriveFont(f2));
        fontMetrics2 = MIMSwingUtils.a(graphics2D);
        point2f2.y += 2.5f * (float)graphics2D.getFont().getSize();
        graphics2D.drawString(string6, point2f2.x, point2f2.y + (float)(graphics2D.getFont().getSize() / 2));
        graphics2D.drawLine((int)point2f3.x + n4, (int)point2f3.y, (int)point2f2.x - n4, (int)point2f2.y);
        return bufferedImage;
    }

    private Point2f a(float f2, float f3, int n2) {
        float f4 = f2 * (float)this.defaultSpacing + 2.25f * (float)this.defaultSpacing;
        float f5 = ((float)n2 - f3) * ((float)this.defaultSpacing * this.offsetRatio) + (float)(2 * this.borderMargin);
        return new Point2f(f4, f5);
    }

    private int[] a(float f2) {
        BrachyTemplate brachyTemplate = this.planState.d().a().template;
        float[] fArray = brachyTemplate.p();
        int[] nArray = brachyTemplate.m();
        float f3 = fArray[1] / fArray[0] * f2;
        this.defaultSpacing = (int)((double)(f2 - 2.0f) / (2.0 + (double)nArray[0]));
        this.borderMargin = this.defaultSpacing / 2;
        this.fontSizeLabel = (float)this.defaultSpacing / 1.5f;
        this.dotRadiusEmpty = this.defaultSpacing / 10;
        this.dotRadiusNeedle = this.defaultSpacing / 3;
        this.fontSizeInside = (float)this.dotRadiusNeedle * 1.0f;
        this.fontSizeOutside = (float)this.dotRadiusNeedle * 0.8f;
        this.legendHeight = (int)(50.0f * f2 / 640.0f);
        return new int[]{(int)f2, (int)f3};
    }

    private boolean a(int n2, int n3) {
        List<int[]> list = this.planState.d().a().template.n();
        for (int[] nArray : list) {
            if (nArray[0] != n2 || nArray[1] != n3) continue;
            return false;
        }
        return true;
    }

    private RandomBrachyNeedle b(int n2, int n3) {
        BrachyTemplate brachyTemplate = this.planState.d().a().template;
        float[] fArray = new float[]{(float)n2 * brachyTemplate.j()[0], (float)(brachyTemplate.m()[1] - 1) * brachyTemplate.j()[1] - (float)n3 * brachyTemplate.j()[1]};
        for (RandomBrachyNeedle randomBrachyNeedle : this.indexedNeedles) {
            if (!randomBrachyNeedle.b(fArray)) continue;
            return randomBrachyNeedle;
        }
        return null;
    }

    private static enum LabelDirection {
        a,
        b;

    }
}

