/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.seedconstraints;

import com.mimvista.brachytherapy.mui.overlays.RandomSeedLocation;
import com.mimvista.brachytherapy.mui.overlays.RandomSeedsOverlay;
import com.mimvista.brachytherapy.seedconstraints.SeedConstraint;
import com.mimvista.brachytherapy.seedconstraints.SeedUnit;
import com.mimvista.dicom.rtdose.gui.constraint.FulfilledCellObject;
import com.mimvista.dose.constraints.ComparisonType;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.numerics.MultipliedIndexPoint3i;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.Pair;
import java.text.NumberFormat;
import javax.vecmath.Point3i;

public class SeedConstraintImpl
implements SeedConstraint {
    private static final long serialVersionUID = 1L;
    private double target;
    private SeedUnit units;
    private ComparisonType comparisonType;

    public SeedConstraintImpl(double d2, SeedUnit seedUnit, ComparisonType comparisonType) {
        this.target = d2;
        this.units = seedUnit;
        this.comparisonType = comparisonType;
    }

    @Override
    public FulfilledCellObject.FulfilledState a(RandomSeedsOverlay randomSeedsOverlay, VolumetricContourOverlayish volumetricContourOverlayish) {
        Double d2 = this.b(randomSeedsOverlay, volumetricContourOverlayish);
        if (d2 == null) {
            return null;
        }
        return this.comparisonType.a(d2, this.a(), Pair.get(0.0, 0.0));
    }

    @Override
    public FulfilledCellObject.FulfilledState a(int n2, int n3) {
        Double d2 = this.b(n2, n3);
        if (d2 == null) {
            return null;
        }
        return this.comparisonType.a(d2, this.a(), Pair.get(0.0, 0.0));
    }

    @Override
    public Double b(RandomSeedsOverlay randomSeedsOverlay, VolumetricContourOverlayish volumetricContourOverlayish) {
        if (volumetricContourOverlayish.A_()) {
            return Double.NaN;
        }
        int n2 = this.c(randomSeedsOverlay, volumetricContourOverlayish);
        int n3 = randomSeedsOverlay.w().size();
        return this.b(n2, n3);
    }

    @Override
    public Double b(int n2, int n3) {
        switch (this.units) {
            case a: {
                return n2;
            }
            case b: {
                return (double)n2 / (double)n3 * 100.0;
            }
        }
        return null;
    }

    private int c(RandomSeedsOverlay randomSeedsOverlay, VolumetricContourOverlayish volumetricContourOverlayish) {
        int n2 = 0;
        int[] nArray = volumetricContourOverlayish.aq().v();
        for (RandomSeedLocation randomSeedLocation : randomSeedsOverlay.w()) {
            MultipliedIndexPoint3i multipliedIndexPoint3i = randomSeedLocation.c().a(nArray);
            if (!volumetricContourOverlayish.aq().a((Point3i)multipliedIndexPoint3i)) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public Double a() {
        return this.target;
    }

    @Override
    public SeedUnit b() {
        return this.units;
    }

    @Override
    public ComparisonType c() {
        return this.comparisonType;
    }

    @Override
    public String d() {
        String string = "";
        if (this.comparisonType != ComparisonType.c) {
            string = string + this.comparisonType.getExternalizedString() + " ";
        }
        String string2 = this.units != SeedUnit.b ? NumberFormat.getIntegerInstance().format(this.target) : NumberFormatFactory.a().format(this.target);
        string = string + string2 + " " + this.units.getExternalizedString();
        return string;
    }
}

