/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.seeds;

import com.google.common.collect.Lists;
import com.mimvista.brachytherapy.seeds.DoseFunctionFitter;
import com.mimvista.numerics.MathUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class Linear1DDataFitter
extends DoseFunctionFitter
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;

    Linear1DDataFitter(int n2) {
        super(n2);
    }

    public Linear1DDataFitter g() {
        return (Linear1DDataFitter)super.b();
    }

    @Override
    public void a(int[] nArray) {
        this.radius = this.a(this.radius, nArray);
        this.value = this.a(this.value, nArray);
        this.f();
    }

    @Override
    public float b(float f2) {
        float f3;
        float f4 = MathUtils.u(this.radius);
        float f5 = MathUtils.s(this.radius);
        if (f2 > f4) {
            f2 = f4;
        }
        if (f2 < f5) {
            f2 = f5;
        }
        int[] nArray = new int[]{-1, this.radius.length};
        for (int i2 = 0; i2 < this.radius.length; ++i2) {
            if (f2 >= this.radius[i2] && (nArray[0] == -1 || this.radius[i2] > this.radius[nArray[0]])) {
                nArray[0] = i2;
            }
            if (!(f2 < this.radius[i2]) || nArray[1] != this.radius.length && !(this.radius[i2] < this.radius[nArray[1]])) continue;
            nArray[1] = i2;
        }
        float f6 = nArray[0] == -1 ? f2 : this.radius[nArray[0]];
        float f7 = nArray[1] == this.radius.length ? f2 : this.radius[nArray[1]];
        float[] fArray = new float[2];
        for (int i3 = 0; i3 < 2; ++i3) {
            fArray[i3] = this.c(nArray[i3], f2);
        }
        if (f7 != f6) {
            float f8 = (f2 - f6) / (f7 - f6);
            f3 = fArray[0] + (fArray[1] - fArray[0]) * f8;
        } else {
            f3 = fArray[0];
        }
        return f3;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Linear1DDataFitter) {
            float[][] fArray;
            Linear1DDataFitter linear1DDataFitter = (Linear1DDataFitter)object;
            float[][] fArray2 = this.h();
            if (fArray2.length != (fArray = linear1DDataFitter.h()).length) {
                return false;
            }
            for (int i2 = 0; i2 < fArray2.length; ++i2) {
                if ((fArray2[i2] == null || fArray[i2] == null || Arrays.equals(fArray2[i2], fArray[i2])) && !(fArray2[i2] == null ^ fArray[i2] == null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        float[][] fArray = this.h();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (fArray[i2] == null) continue;
            for (float f2 : fArray[i2]) {
                n2 += (int)(f2 * 1000.0f);
            }
        }
        return n2;
    }

    private float[] a(float[] fArray, int[] nArray) {
        Arrays.sort(nArray);
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (Arrays.binarySearch(nArray, i2) >= 0) continue;
            arrayList.add(Float.valueOf(fArray[i2]));
        }
        float[] fArray2 = new float[arrayList.size()];
        for (int i3 = 0; i3 < arrayList.size(); ++i3) {
            fArray2[i3] = ((Float)arrayList.get(i3)).floatValue();
        }
        return fArray2;
    }

    private float[][] h() {
        float[][] fArrayArray = new float[][]{this.radius, this.value};
        return fArrayArray;
    }

    private float c(int n2, float f2) {
        if (n2 < 0) {
            float f3 = this.c(0, f2);
            float f4 = this.c(1, f2);
            return f3 + (f3 - f4) * (this.radius[0] - f2) / (this.radius[1] - this.radius[0]);
        }
        if (n2 >= this.radius.length) {
            float f5 = this.c(this.radius.length - 1, f2);
            float f6 = this.c(this.radius.length - 2, f2);
            return f5 + (f5 - f6) * (this.radius[this.radius.length - 1] - f2) / (this.radius[this.radius.length - 2] - this.radius[this.radius.length - 1]);
        }
        return this.value[n2];
    }

    @Override
    public /* synthetic */ DoseFunctionFitter b() {
        return this.g();
    }

    @Override
    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.g();
    }
}

