/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.seeds;

import com.mimvista.brachytherapy.seeds.DoseFunctionFitter;
import com.mimvista.numerics.MathUtils;

public class Linear2DDataFitter
extends DoseFunctionFitter {
    private static final long serialVersionUID = 1L;

    Linear2DDataFitter(int n2) {
        super(n2);
    }

    @Override
    public float b(float f2) {
        float f3 = MathUtils.u(this.radius);
        float f4 = MathUtils.s(this.radius);
        if (f2 > f3) {
            f2 = f3;
        }
        if (f2 < f4) {
            f2 = f4;
        }
        int[] nArray = new int[]{-1, this.radius.length};
        for (int i2 = 0; i2 < this.radius.length; ++i2) {
            if (f2 >= this.radius[i2] && (nArray[0] == -1 || this.radius[i2] > this.radius[nArray[0]])) {
                nArray[0] = i2;
            }
            if (!(f2 < this.radius[i2]) || nArray[1] != this.radius.length && !(this.radius[i2] < this.radius[nArray[1]])) continue;
            nArray[1] = i2;
        }
        float f5 = this.radius[nArray[1]];
        float f6 = this.radius[nArray[0]];
        if (f5 != f6) {
            float f7 = (f2 - f6) / (f5 - f6);
            return this.value[nArray[0]] + (this.value[nArray[1]] - this.value[nArray[0]]) * f7;
        }
        return this.value[nArray[0]];
    }
}

