/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.seeds;

import com.mimvista.brachytherapy.seeds.DiscretePolarFunction;
import com.mimvista.brachytherapy.seeds.DoseFunctionFitter;
import com.mimvista.brachytherapy.seeds.Linear1DDataFitter;
import com.mimvista.brachytherapy.seeds.Seed;
import java.io.Serializable;

public class ManufacturedSeed
implements Seed,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String a = "(MIM)";
    public static final String b = "(User)";
    DoseFunctionFitter lineModelRadialDose;
    DiscretePolarFunction anisotropicFunction2D;
    Linear1DDataFitter anisotropicFunction1D;
    private String seedName;
    private String modelNumber;
    private String manufacturer;
    private String sourceType;
    private float lambda;
    private float length;
    private float halflife;
    private boolean mimDefault = false;

    public ManufacturedSeed(a a2, int n2, int n3, int n4, int n5) {
        this.seedName = a2.a;
        this.modelNumber = a2.b;
        this.manufacturer = a2.c;
        this.sourceType = a2.d;
        this.halflife = a2.e;
        this.lambda = a2.f;
        this.length = a2.g;
        this.lineModelRadialDose = com.mimvista.brachytherapy.seeds.a.a(n2, a2);
        this.anisotropicFunction2D = new DiscretePolarFunction(n3, n4);
        this.anisotropicFunction1D = new Linear1DDataFitter(n5);
    }

    public boolean a() {
        return this.anisotropicFunction1D != null && this.anisotropicFunction1D.c() > 0;
    }

    public boolean b() {
        return this.anisotropicFunction2D != null && this.anisotropicFunction2D.i().length > 0 && this.anisotropicFunction2D.a().length > 0;
    }

    public float c() {
        if ("I-125".equalsIgnoreCase(this.sourceType)) {
            return 1.27f;
        }
        if ("Pd-103".equalsIgnoreCase(this.sourceType)) {
            return 1.293f;
        }
        if ("Cs-131".equalsIgnoreCase(this.sourceType)) {
            return 0.637f;
        }
        return -100.0f;
    }

    public String d() {
        String string = this.l() ? a : b;
        return string + this.modelNumber + "~!~" + this.manufacturer + "~!~" + this.halflife + "~!~" + this.sourceType;
    }

    @Override
    public String e() {
        return this.seedName;
    }

    @Override
    public String f() {
        return this.modelNumber;
    }

    public void a(String string) {
        if (!this.mimDefault) {
            this.modelNumber = string;
        }
    }

    @Override
    public String g() {
        return this.manufacturer;
    }

    public void b(String string) {
        if (!this.mimDefault) {
            this.manufacturer = string;
        }
    }

    public String h() {
        return this.sourceType;
    }

    public void c(String string) {
        if (!this.mimDefault) {
            this.sourceType = string;
        }
    }

    @Override
    public float i() {
        return this.halflife;
    }

    public void a(float f2) {
        if (!this.mimDefault) {
            this.halflife = f2;
        }
    }

    @Override
    public float j() {
        return this.lambda;
    }

    public void b(float f2) {
        if (!this.mimDefault) {
            this.lambda = f2;
        }
    }

    @Override
    public float k() {
        return this.length;
    }

    public void c(float f2) {
        if (!this.mimDefault) {
            this.length = f2;
        }
    }

    public boolean l() {
        return this.mimDefault;
    }

    @Override
    public float d(float f2) {
        return this.lineModelRadialDose.b(f2);
    }

    @Override
    public float a(float f2, float f3) {
        return this.anisotropicFunction2D.a(f2, f3);
    }

    public DiscretePolarFunction m() {
        return this.anisotropicFunction2D;
    }

    public DoseFunctionFitter n() {
        return this.lineModelRadialDose;
    }

    public void a(DiscretePolarFunction discretePolarFunction) {
        this.anisotropicFunction2D = discretePolarFunction.b();
    }

    public void a(DoseFunctionFitter doseFunctionFitter) {
        this.lineModelRadialDose = doseFunctionFitter.b();
    }

    @Override
    public float e(float f2) {
        return this.anisotropicFunction1D.b(f2);
    }

    public Linear1DDataFitter o() {
        return this.anisotropicFunction1D;
    }

    public void a(Linear1DDataFitter linear1DDataFitter) {
        this.anisotropicFunction1D = linear1DDataFitter.g();
    }

    public boolean equals(Object object) {
        if (object instanceof ManufacturedSeed) {
            ManufacturedSeed manufacturedSeed = (ManufacturedSeed)object;
            return this.lineModelRadialDose.equals(manufacturedSeed.lineModelRadialDose) && this.anisotropicFunction2D.equals(manufacturedSeed.anisotropicFunction2D) && this.anisotropicFunction1D.equals(manufacturedSeed.anisotropicFunction1D) && this.modelNumber.equals(manufacturedSeed.modelNumber) && this.manufacturer.equals(manufacturedSeed.manufacturer) && this.sourceType.equals(manufacturedSeed.sourceType) && Float.compare(this.lambda, manufacturedSeed.lambda) == 0 && this.mimDefault == manufacturedSeed.mimDefault;
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray;
        int n2 = 0;
        for (Object object : objectArray = new Object[]{this.lineModelRadialDose, this.anisotropicFunction2D, this.anisotropicFunction1D, this.modelNumber, this.manufacturer, this.sourceType, Float.valueOf(this.lambda), this.mimDefault}) {
            if (object != null) {
                n2 += object.hashCode();
            }
            n2 *= 13;
        }
        return n2;
    }

    public String toString() {
        return "[" + this.g() + " " + this.f() + " source=" + this.h() + " lambda=" + this.j() + " length=" + this.k() + "]";
    }

    public void p() {
        for (int i2 = 0; i2 < this.lineModelRadialDose.c(); ++i2) {
            System.out.printf("%.3f\t%.4f\n", Float.valueOf(this.lineModelRadialDose.radius[i2]), Float.valueOf(this.lineModelRadialDose.value[i2]));
        }
    }

    public void q() {
        System.out.print("\t");
        float[] fArray = this.anisotropicFunction2D.radius;
        int n2 = fArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2 = fArray[i2];
            System.out.printf("%.3f\t", Float.valueOf(f2));
        }
        System.out.println("");
        for (int i3 = 0; i3 < this.anisotropicFunction2D.angle.length; ++i3) {
            System.out.printf("%.3f\t", Float.valueOf(this.anisotropicFunction2D.angle[i3]));
            for (n2 = 0; n2 < this.anisotropicFunction2D.radius.length; ++n2) {
                System.out.printf("%.3f\t", Float.valueOf(this.anisotropicFunction2D.value[i3][n2]));
            }
            System.out.println();
        }
        System.out.print("\t");
    }

    void r() {
        this.mimDefault = true;
    }

    public static class a {
        public String a;
        public String b;
        public String c;
        public String d;
        public float e;
        public float f;
        public float g;
        public double[] h;
    }
}

