/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.seeds;

import com.mimvista.brachytherapy.seeds.ManufacturedSeed;
import com.mimvista.brachytherapy.seeds.Seed;

public class PrescribedSeed
implements Seed {
    private static final long serialVersionUID = 1L;
    private final ManufacturedSeed seedType;
    private final float airKermaStrength;
    private final float implantTime;

    public PrescribedSeed(ManufacturedSeed manufacturedSeed, float f2) {
        this(manufacturedSeed, f2, Float.POSITIVE_INFINITY);
    }

    public PrescribedSeed(ManufacturedSeed manufacturedSeed, float f2, float f3) {
        this.seedType = manufacturedSeed;
        this.airKermaStrength = f2;
        this.implantTime = f3;
    }

    public boolean a() {
        return Float.isInfinite(this.implantTime);
    }

    public float b() {
        return this.implantTime;
    }

    public float c() {
        return this.airKermaStrength;
    }

    @Override
    public String e() {
        return this.seedType.e();
    }

    @Override
    public float a(float f2, float f3) {
        return this.seedType.a(f2, f3);
    }

    @Override
    public float d(float f2) {
        return this.seedType.d(f2);
    }

    @Override
    public float j() {
        return this.seedType.j();
    }

    @Override
    public float k() {
        return this.seedType.k();
    }

    @Override
    public String g() {
        return this.seedType.g();
    }

    @Override
    public String f() {
        return this.seedType.f();
    }

    @Override
    public float i() {
        return this.seedType.i();
    }

    public boolean equals(Object object) {
        if (object instanceof PrescribedSeed) {
            PrescribedSeed prescribedSeed = (PrescribedSeed)object;
            return this.seedType.equals(prescribedSeed.seedType) && Float.compare(this.airKermaStrength, prescribedSeed.airKermaStrength) == 0 && Float.compare(this.implantTime, prescribedSeed.implantTime) == 0;
        }
        return false;
    }

    public int hashCode() {
        int n2 = 17;
        int n3 = 31;
        n2 = n2 * n3 + this.seedType.hashCode();
        n2 = n2 * n3 + Float.floatToIntBits(this.airKermaStrength);
        n2 = n2 * n3 + Float.floatToIntBits(this.implantTime);
        return n2;
    }

    public ManufacturedSeed d() {
        return this.seedType;
    }

    public String toString() {
        return "[Prescribed Seed airKermaStrength=" + this.airKermaStrength + " type=" + this.seedType + "]";
    }

    @Override
    public float e(float f2) {
        return this.seedType.e(f2);
    }
}

