/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.seeds;

import com.mimvista.brachytherapy.seeds.DoseFunctionFitter;
import com.mimvista.numerics.MathUtils;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.util.BigReal;

public class RadialDoseExpFitter
extends DoseFunctionFitter {
    private static final long serialVersionUID = 1L;
    double[] interpCoef = null;

    RadialDoseExpFitter(int n2, double[] dArray) {
        super(n2);
        this.interpCoef = dArray;
    }

    @Override
    public float b(float f2) {
        if (this.interpCoef == null || this.interpCoef.length != 7) {
            throw new NullPointerException("Interpolation coefficients are invalid.");
        }
        float f3 = MathUtils.u(this.radius);
        float f4 = MathUtils.s(this.radius);
        if (f2 > f3) {
            f2 = f3;
        }
        if (f2 < f4) {
            f2 = f4;
        }
        if (Float.compare(f2, 0.0f) == 0) {
            int n2 = MathUtils.t(this.radius);
            return Math.max(0.0f, this.value[n2]);
        }
        return Math.max(0.0f, (float)this.h(this.interpCoef, f2));
    }

    private void g() {
        if (this.radius.length != this.value.length) {
            throw new IllegalStateException("Distance and dose arrays must be the same length");
        }
        double[] dArray = new double[this.radius.length];
        double[] dArray2 = new double[this.radius.length];
        for (int i2 = 0; i2 < this.radius.length; ++i2) {
            dArray[i2] = this.radius[i2];
            dArray2[i2] = this.value[i2];
        }
        this.interpCoef = this.a(dArray, dArray2);
    }

    private double[] a(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            return null;
        }
        double[] dArray3 = new double[]{-0.001, -0.01, 1.0, -0.1, 0.01, 1.0E-11, 0.1};
        int n2 = dArray.length;
        int n3 = dArray3.length;
        BigReal[][] bigRealArrayArray = new BigReal[n2][];
        int n4 = 100;
        for (int i2 = 0; i2 < n4; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                bigRealArrayArray[i3] = new BigReal[n3];
                bigRealArrayArray[i3][0] = new BigReal(this.a(dArray3, dArray[i3]));
                bigRealArrayArray[i3][1] = new BigReal(this.b(dArray3, dArray[i3]));
                bigRealArrayArray[i3][2] = new BigReal(this.c(dArray3, dArray[i3]));
                bigRealArrayArray[i3][3] = new BigReal(this.d(dArray3, dArray[i3]));
                bigRealArrayArray[i3][4] = new BigReal(this.e(dArray3, dArray[i3]));
                bigRealArrayArray[i3][5] = new BigReal(this.f(dArray3, dArray[i3]));
                bigRealArrayArray[i3][6] = new BigReal(this.g(dArray3, dArray[i3]));
            }
            FieldMatrix fieldMatrix = MatrixUtils.createFieldMatrix((FieldElement[][])bigRealArrayArray);
            BigReal[] bigRealArray = new BigReal[n2];
            for (int i4 = 0; i4 < n2; ++i4) {
                bigRealArray[i4] = new BigReal(dArray2[i4] - this.h(dArray3, dArray[i4]));
            }
            FieldMatrix fieldMatrix2 = MatrixUtils.createColumnFieldMatrix((FieldElement[])bigRealArray);
            FieldMatrix fieldMatrix3 = fieldMatrix.transpose();
            FieldMatrix fieldMatrix4 = fieldMatrix3.multiply(fieldMatrix);
            FieldLUDecomposition fieldLUDecomposition = new FieldLUDecomposition(fieldMatrix4);
            fieldMatrix4 = fieldLUDecomposition.getSolver().getInverse();
            fieldMatrix4 = fieldMatrix4.multiply(fieldMatrix3.multiply(fieldMatrix2));
            BigReal[] bigRealArray2 = (BigReal[])fieldMatrix4.getColumn(0);
            for (int i5 = 0; i5 < n3; ++i5) {
                int n5 = i5;
                dArray3[n5] = dArray3[n5] + bigRealArray2[i5].doubleValue();
            }
        }
        return dArray3;
    }

    private double a(double[] dArray, double d2) {
        return Math.pow(Math.E, -dArray[6] * d2) / (d2 * d2);
    }

    private double b(double[] dArray, double d2) {
        return Math.pow(Math.E, -dArray[6] * d2) / d2;
    }

    private double c(double[] dArray, double d2) {
        return Math.pow(Math.E, -dArray[6] * d2);
    }

    private double d(double[] dArray, double d2) {
        return Math.pow(Math.E, -dArray[6] * d2) * d2;
    }

    private double e(double[] dArray, double d2) {
        return Math.pow(Math.E, -dArray[6] * d2) * d2 * d2;
    }

    private double f(double[] dArray, double d2) {
        return Math.pow(Math.E, -dArray[6] * d2) * d2 * d2 * d2;
    }

    private double g(double[] dArray, double d2) {
        return this.h(dArray, d2) * -d2;
    }

    private double h(double[] dArray, double d2) {
        double d3 = 0.0;
        double d4 = 1.0 / (d2 * d2);
        for (int i2 = 0; i2 < dArray.length - 1; ++i2) {
            d3 += dArray[i2] * d4;
            d4 *= d2;
        }
        return d3 *= Math.pow(Math.E, -dArray[6] * d2);
    }
}

