/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.seeds;

import com.mimvista.brachytherapy.seeds.DoseFunctionFitter;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.Regression;

public class RadialDosePolynomialFitter
extends DoseFunctionFitter {
    private static final long serialVersionUID = 1L;
    private double[] interpCoef = null;
    private final int ORDER = 5;

    RadialDosePolynomialFitter(int n2) {
        super(n2);
    }

    @Override
    public float b(float f2) {
        if (this.interpCoef == null) {
            this.g();
        }
        float f3 = MathUtils.u(this.radius);
        float f4 = MathUtils.s(this.radius);
        if (f2 > f3) {
            f2 = f3;
        }
        if (f2 < f4) {
            f2 = f4;
        }
        double d2 = 0.0;
        double d3 = 1.0;
        for (int i2 = 0; i2 < this.interpCoef.length; ++i2) {
            d2 += this.interpCoef[i2] * d3;
            d3 *= (double)f2;
        }
        return Math.max(0.0f, (float)d2);
    }

    private void g() {
        if (this.radius.length != this.value.length) {
            throw new IllegalStateException("Distance and dose arrays must be the same length");
        }
        double[] dArray = new double[this.radius.length];
        double[] dArray2 = new double[this.radius.length];
        for (int i2 = 0; i2 < this.radius.length; ++i2) {
            dArray[i2] = this.radius[i2];
            dArray2[i2] = this.value[i2];
        }
        this.interpCoef = Regression.a(dArray, dArray2, 5);
    }
}

