/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.brachytherapy.seeds;

import com.google.common.collect.Lists;
import com.mimvista.brachytherapy.seeds.DoseFunctionFitter;
import com.mimvista.brachytherapy.seeds.ManufacturedSeed;
import com.mimvista.brachytherapy.seeds.RadialDoseExpFitter;
import com.mimvista.file.Path;
import com.mimvista.preferencesNew.BrachyHiddenSeedPref;
import com.mimvista.preferencesNew.BrachytherapyPrefs;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.preferencesNew.cascade.c;
import com.mimvista.util.XMLUtils;
import com.mimvista.util.ay;
import com.sun.corba.se.spi.orb.StringPair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SeedFactory {
    private static final String a = "seeds";
    private static final String b = "value";
    private static final String c = "dose";
    private static final String d = "radius";
    private static final String e = "cell";
    private static final String f = "angle";
    private static final String g = "index";
    private static final String h = "row";
    private static final String i = "FIT_COEFFICIENTS";
    private static final String j = "num_radii";
    private static final String k = "num_angles";
    private static final String l = "size";
    private static final String m = "polar_dose";
    private static final String n = "anisotropy_2D";
    private static final String o = "anisotropy_1D";
    private static final String p = "radial_dose";
    private static final String q = "radial_dose_line_source";
    private static final String r = "halflife";
    private static final String s = "length";
    private static final String t = "lambda";
    private static final String u = "source";
    private static final String v = "model";
    private static final String w = "manufacturer";
    private static final String x = "seed";
    private static final String y = "version";
    private static final String z = "SeedDB";
    private static final String A = "name";
    private static final String B = "1.0";
    private static final String C = "user_seed_backup.sdb";
    private static final String D = "seed-db.xml";
    private static List<ManufacturedSeed> E;

    public static void a() {
        E = Lists.newArrayList();
        InputStream inputStream = null;
        File file = com.mimvista.preferencesNew.cascade.c.d().a(CascadeSubfolder.a, D);
        if (file != null && file.exists()) {
            try {
                inputStream = new FileInputStream(file);
                E.addAll(SeedFactory.a(inputStream, false));
            }
            catch (FileNotFoundException fileNotFoundException) {
                ay.d((Object)"Database file exists but could not be found?", (Throwable)fileNotFoundException, SeedFactory.class);
            }
        }
        inputStream = SeedFactory.i();
        E.addAll(SeedFactory.a(inputStream, true));
        SeedFactory.b(E);
    }

    public static ManufacturedSeed b() {
        return SeedFactory.b(BrachytherapyPrefs.defaultSeed.getValue());
    }

    public static void a(ManufacturedSeed manufacturedSeed) {
        BrachytherapyPrefs.defaultSeed.setValue(manufacturedSeed.d());
    }

    public static ManufacturedSeed c() {
        List<ManufacturedSeed> list = SeedFactory.g();
        for (ManufacturedSeed manufacturedSeed : list) {
            if (!manufacturedSeed.g().equalsIgnoreCase("Core Oncology") || !manufacturedSeed.f().equalsIgnoreCase("125SL")) continue;
            return manufacturedSeed;
        }
        return list.get(0);
    }

    private static ManufacturedSeed b(String string) {
        boolean bl2;
        String[] stringArray = string.split("~!~");
        if (stringArray[0].startsWith("(MIM)")) {
            stringArray[0] = stringArray[0].substring("(MIM)".length());
            bl2 = true;
        } else if (stringArray[0].startsWith("(User)")) {
            stringArray[0] = stringArray[0].substring("(User)".length());
            bl2 = false;
        } else {
            bl2 = true;
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        for (ManufacturedSeed manufacturedSeed : SeedFactory.d()) {
            boolean bl3 = manufacturedSeed.l() == bl2 && manufacturedSeed.f().equalsIgnoreCase(string2) && manufacturedSeed.g().equalsIgnoreCase(string3) && String.valueOf(manufacturedSeed.i()).equals(string4);
            if (!bl3) continue;
            return manufacturedSeed;
        }
        throw new RuntimeException("couldn't match seed with config: " + string);
    }

    public static List<ManufacturedSeed> d() {
        return Lists.newArrayList(E);
    }

    public static List<ManufacturedSeed> e() {
        ArrayList<ManufacturedSeed> arrayList = new ArrayList<ManufacturedSeed>();
        for (ManufacturedSeed manufacturedSeed : E) {
            if (!manufacturedSeed.l()) continue;
            arrayList.add(manufacturedSeed);
        }
        return arrayList;
    }

    public static List<ManufacturedSeed> f() {
        ArrayList<ManufacturedSeed> arrayList = new ArrayList<ManufacturedSeed>();
        for (ManufacturedSeed manufacturedSeed : E) {
            if (manufacturedSeed.l()) continue;
            arrayList.add(manufacturedSeed);
        }
        return arrayList;
    }

    public static List<ManufacturedSeed> g() {
        ArrayList<ManufacturedSeed> arrayList = new ArrayList<ManufacturedSeed>();
        for (ManufacturedSeed manufacturedSeed : E) {
            if (SeedFactory.b(manufacturedSeed)) continue;
            arrayList.add(manufacturedSeed);
        }
        return arrayList;
    }

    public static boolean b(ManufacturedSeed manufacturedSeed) {
        return SeedFactory.a(manufacturedSeed.d());
    }

    public static boolean a(String string) {
        Object object = BrachytherapyPrefs.hiddenSeeds.getValue();
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            BrachyHiddenSeedPref.a a2 = (BrachyHiddenSeedPref.a)iterator.next();
            if (!string.equalsIgnoreCase(a2.json)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(List<ManufacturedSeed> list) {
        List<ManufacturedSeed> list2 = E;
        synchronized (list2) {
            List<ManufacturedSeed> list3 = SeedFactory.e();
            for (ManufacturedSeed manufacturedSeed : list) {
                list3.add(manufacturedSeed);
            }
            E = list3;
        }
    }

    public static void b(List<ManufacturedSeed> list) {
        Collections.sort(list, new Comparator<ManufacturedSeed>(){

            public int a(ManufacturedSeed manufacturedSeed, ManufacturedSeed manufacturedSeed2) {
                int n2 = manufacturedSeed.h().compareTo(manufacturedSeed2.h());
                if (n2 == 0) {
                    n2 = manufacturedSeed.g().compareTo(manufacturedSeed2.g());
                }
                return n2;
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((ManufacturedSeed)object, (ManufacturedSeed)object2);
            }
        });
    }

    private static InputStream i() {
        return SeedFactory.class.getResourceAsStream("/xml/BrachyTherapy/SeedDB.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(File file) {
        System.out.print("Importing: " + file.getName());
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            int n2;
            String[] stringArray;
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            String string = "";
            int n3 = 0;
            ManufacturedSeed.a a2 = new ManufacturedSeed.a();
            Object[] objectArray = new String[]{};
            String[] stringArray2 = new String[]{};
            float[] fArray = null;
            float[] fArray2 = null;
            float[] fArray3 = new float[]{};
            float[] fArray4 = null;
            ArrayList arrayList = Lists.newArrayList();
            while ((string = bufferedReader.readLine()) != null) {
                stringArray = SeedFactory.c(string);
                switch (n3) {
                    case 0: {
                        objectArray = stringArray;
                        if (Arrays.equals(objectArray, new String[]{"MANUFACTURER", "SEED NAME", "MODEL", "ISOTOPE", "LAMBDA", "EFFECTIVE LENGTH"})) break;
                        throw new IllegalStateException("The first row is not the right titles: " + Arrays.toString(objectArray));
                    }
                    case 1: {
                        if (stringArray.length != objectArray.length) {
                            throw new IllegalStateException("There are " + objectArray.length + " column titles and " + stringArray.length + " columns.");
                        }
                        a2.c = stringArray[0].trim();
                        a2.a = stringArray[1].trim();
                        a2.b = stringArray[2].trim();
                        a2.d = stringArray[3].trim();
                        a2.f = Float.parseFloat(stringArray[4]);
                        a2.g = Float.parseFloat(stringArray[5]);
                        a2.d = a2.d.replaceAll("_", "-");
                        a2.a = a2.a.replaceAll(Pattern.quote("(R)"), "\u00ae");
                        a2.a = a2.a.replaceAll(Pattern.quote("(TM)"), "\u2122");
                        if ("I-125".equalsIgnoreCase(a2.d)) {
                            a2.e = 59.399f;
                            break;
                        }
                        if ("Pd-103".equalsIgnoreCase(a2.d)) {
                            a2.e = 16.991f;
                            break;
                        }
                        if ("Cs-131".equalsIgnoreCase(a2.d)) {
                            a2.e = 9.689f;
                            break;
                        }
                        if ("Ir-192".equalsIgnoreCase(a2.d)) {
                            a2.e = 73.826f;
                            break;
                        }
                        throw new IllegalArgumentException(a2.d + " is not a valid source type");
                    }
                    case 2: {
                        stringArray2 = stringArray;
                        if ("RADIAL DOSE RADII".equalsIgnoreCase(stringArray2[0])) break;
                        throw new IllegalStateException("Expected the third row to be the radial dose radii");
                    }
                    case 3: {
                        int n4;
                        if (!"RADIAL DOSE VALUE".equalsIgnoreCase(stringArray[0])) {
                            throw new IllegalStateException("Excepted fourth row to be the radial dose value");
                        }
                        n2 = 0;
                        for (n4 = 1; n4 < stringArray.length; ++n4) {
                            if ("BLANK".equalsIgnoreCase(stringArray[n4])) continue;
                            ++n2;
                        }
                        fArray = new float[n2];
                        fArray2 = new float[n2];
                        n4 = 0;
                        for (int i2 = 1; i2 < stringArray.length; ++i2) {
                            if ("BLANK".equalsIgnoreCase(stringArray[i2])) continue;
                            fArray[n4] = Float.parseFloat(stringArray2[i2]);
                            fArray2[n4++] = Float.parseFloat(stringArray[i2]);
                        }
                        break;
                    }
                    case 4: {
                        if (!"2D ANISOTROPY".equalsIgnoreCase(stringArray[0])) {
                            throw new IllegalStateException("Expected row 5 to be the start of the 2D anisotropy function");
                        }
                        fArray3 = new float[stringArray.length - 1];
                        for (int i3 = 1; i3 < stringArray.length; ++i3) {
                            fArray3[i3 - 1] = Float.parseFloat(stringArray[i3]);
                        }
                        break;
                    }
                    default: {
                        if (!"1D ANISOTROPY".equalsIgnoreCase(stringArray[0]) && !"COEFFICIENTS".equalsIgnoreCase(stringArray[0])) {
                            if (stringArray.length != fArray3.length + 1) {
                                throw new IllegalStateException("Row " + arrayList.size() + " of 2D function doesn't have enough values");
                            }
                            float[] fArray5 = SeedFactory.a(stringArray, 0);
                            arrayList.add(fArray5);
                            break;
                        }
                        if ("COEFFICIENTS".equalsIgnoreCase(stringArray[0])) {
                            if (stringArray.length != 8) {
                                throw new IllegalStateException("There should be 6 coefficients");
                            }
                            a2.h = SeedFactory.b(stringArray, 1);
                            break;
                        }
                        if (!"1D ANISOTROPY".equalsIgnoreCase(stringArray[0])) break;
                        if (stringArray.length != fArray3.length + 1) {
                            throw new IllegalStateException("Row " + arrayList.size() + " of 2D function doesn't have enough values");
                        }
                        fArray4 = SeedFactory.a(stringArray, 1);
                    }
                }
                ++n3;
            }
            if (fArray == null || fArray2 == null || fArray4 == null) {
                throw new IllegalStateException("table values were null");
            }
            stringArray = new ManufacturedSeed(a2, fArray.length, arrayList.size(), fArray3.length, fArray3.length);
            for (n2 = 0; n2 < fArray.length; ++n2) {
                stringArray.lineModelRadialDose.a(n2, fArray[n2]);
                stringArray.lineModelRadialDose.b(n2, fArray2[n2]);
            }
            for (n2 = 0; n2 < fArray3.length; ++n2) {
                stringArray.anisotropicFunction2D.b(n2, fArray3[n2]);
                stringArray.anisotropicFunction1D.a(n2, fArray3[n2]);
                stringArray.anisotropicFunction1D.b(n2, fArray4[n2]);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                float[] fArray6 = (float[])arrayList.get(n2);
                stringArray.anisotropicFunction2D.a(n2, fArray6[0]);
                for (int i4 = 1; i4 < fArray6.length; ++i4) {
                    stringArray.anisotropicFunction2D.b(n2, i4 - 1, fArray6[i4]);
                }
            }
            stringArray.anisotropicFunction2D.k();
            E.add((ManufacturedSeed)stringArray);
            System.out.println(" OK");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(" FAIL");
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println(" FAIL");
            iOException.printStackTrace();
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static float[] a(String[] stringArray, int n2) {
        float[] fArray = new float[stringArray.length - n2];
        for (int i2 = n2; i2 < stringArray.length; ++i2) {
            try {
                fArray[i2 - n2] = Float.parseFloat(stringArray[i2]);
                continue;
            }
            catch (Exception exception) {
                ay.d((Object)"Error parsing value", (Throwable)exception, SeedFactory.class);
                fArray[i2 - n2] = Float.NaN;
            }
        }
        return fArray;
    }

    private static double[] b(String[] stringArray, int n2) {
        double[] dArray = new double[stringArray.length - n2];
        for (int i2 = n2; i2 < stringArray.length; ++i2) {
            dArray[i2 - n2] = Double.parseDouble(stringArray[i2]);
        }
        return dArray;
    }

    private static String[] c(String string) {
        String[] stringArray = string.split(",");
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2;
            stringArray2[i2] = string2 = stringArray[i2];
            if (string2.startsWith("\"")) {
                stringArray2[i2] = string2.substring(1);
            }
            if (!string2.endsWith("\"")) continue;
            stringArray2[i2] = stringArray2[i2].substring(0, stringArray2[i2].length() - 1);
        }
        return stringArray2;
    }

    private static List<ManufacturedSeed> a(InputStream inputStream, boolean bl2) {
        ArrayList arrayList = Lists.newArrayList();
        try {
            Document document = XMLUtils.a(inputStream);
            if (!XMLUtils.b(document)) {
                arrayList.clear();
                ay.d((Object)"Couldn't validate the seed file's signature.", SeedFactory.class);
                return arrayList;
            }
            Node node = document.getElementsByTagName(z).item(0);
            String string = node.getAttributes().getNamedItem(y).getTextContent();
            if (B.equals(string)) {
                Element element = XMLUtils.a(node).get(0);
                List<Element> list = XMLUtils.a((Node)element, new String[]{x});
                for (Element element2 : list) {
                    Object object;
                    Object object2;
                    ManufacturedSeed.a a2 = new ManufacturedSeed.a();
                    a2.a = element2.getAttribute(A);
                    a2.c = element2.getAttribute(w);
                    a2.b = element2.getAttribute(v);
                    a2.d = element2.getAttribute(u);
                    a2.f = Float.valueOf(element2.getAttribute(t)).floatValue();
                    a2.g = Float.valueOf(element2.getAttribute(s)).floatValue();
                    a2.e = Float.valueOf(element2.getAttribute(r)).floatValue();
                    Element element3 = XMLUtils.a((Node)element2, p, q).get(0);
                    Element element4 = XMLUtils.a((Node)element2, n, m).get(0);
                    int n2 = Integer.valueOf(element3.getAttribute(l));
                    int n3 = Integer.valueOf(element4.getAttribute(k));
                    int n4 = Integer.valueOf(element4.getAttribute(j));
                    List<Element> list2 = XMLUtils.a((Node)element2, new String[]{i});
                    if (list2 != null && list2.size() > 0) {
                        a2.h = SeedFactory.a(list2.get(0));
                    }
                    List<Element> list3 = XMLUtils.a((Node)element2, new String[]{o});
                    int n5 = 0;
                    if (!list3.isEmpty()) {
                        object2 = list3.get(0);
                        n5 = Integer.valueOf(object2.getAttribute(l));
                    }
                    object2 = new ManufacturedSeed(a2, n2, n3, n4, n5);
                    if (bl2) {
                        ((ManufacturedSeed)object2).r();
                    }
                    arrayList.add(object2);
                    SeedFactory.a(((ManufacturedSeed)object2).lineModelRadialDose, element3);
                    if (!list3.isEmpty()) {
                        object = list3.get(0);
                        SeedFactory.a(((ManufacturedSeed)object2).anisotropicFunction1D, (Element)object);
                    }
                    object = XMLUtils.a((Node)element4, new String[]{h});
                    for (int i2 = 0; i2 < object.size(); ++i2) {
                        Element element5 = (Element)object.get(i2);
                        int n6 = Integer.valueOf(element5.getAttribute(g));
                        float f2 = Float.valueOf(element5.getAttribute(f)).floatValue();
                        ((ManufacturedSeed)object2).anisotropicFunction2D.a(n6, f2);
                        List<Element> list4 = XMLUtils.a((Node)element5, new String[]{e});
                        for (int i3 = 0; i3 < list4.size(); ++i3) {
                            Element element6 = list4.get(i3);
                            int n7 = Integer.valueOf(element6.getAttribute(g));
                            float f3 = Float.valueOf(element6.getAttribute(d)).floatValue();
                            if (n6 == 0) {
                                ((ManufacturedSeed)object2).anisotropicFunction2D.b(n7, f3);
                            } else if ((double)(((ManufacturedSeed)object2).anisotropicFunction2D.radius[n7] - f3) > 1.0E-4) {
                                throw new IllegalStateException("Distances for cells in the same column must be equal");
                            }
                            float f4 = Float.valueOf(XMLUtils.a(element6, b, c)).floatValue();
                            ((ManufacturedSeed)object2).anisotropicFunction2D.b(n6, n7, f4);
                        }
                    }
                    ((ManufacturedSeed)object2).anisotropicFunction2D.k();
                    ((ManufacturedSeed)object2).anisotropicFunction2D.e();
                }
            } else {
                arrayList.clear();
                ay.d((Object)"SeedDB was written with an older seed version", SeedFactory.class);
            }
        }
        catch (SAXException sAXException) {
            arrayList.clear();
            ay.d((Object)"Error parsing seed database", (Throwable)sAXException, SeedFactory.class);
        }
        catch (IOException iOException) {
            arrayList.clear();
            ay.d((Object)"Error opening seed database for reading", (Throwable)iOException, SeedFactory.class);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            arrayList.clear();
            ay.d((Object)"Error setting up seed database parser", (Throwable)parserConfigurationException, SeedFactory.class);
        }
        catch (Exception exception) {
            arrayList.clear();
            ay.d((Object)"Error loading seed database", (Throwable)exception, SeedFactory.class);
        }
        return arrayList;
    }

    private static double[] a(Element element) {
        double[] dArray = new double[7];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = Double.parseDouble(XMLUtils.a((Node)element, new String[]{"a" + i2}).get(0).getAttribute(b));
        }
        return dArray;
    }

    private static void a(DoseFunctionFitter doseFunctionFitter, Element element) {
        List<Element> list = XMLUtils.a((Node)element, new String[]{e});
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Element element2 = list.get(i2);
            int n2 = Integer.valueOf(element2.getAttribute(g));
            doseFunctionFitter.a(n2, Float.valueOf(element2.getAttribute(d)).floatValue());
            doseFunctionFitter.b(n2, Float.valueOf(element2.getAttribute(b)).floatValue());
        }
        doseFunctionFitter.f();
    }

    public static void h() {
        List<ManufacturedSeed> list = SeedFactory.f();
        try {
            DOMImplementation dOMImplementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
            Document document = dOMImplementation.createDocument(null, z, null);
            Element element = document.getDocumentElement();
            element.setAttribute(y, B);
            Element element2 = XMLUtils.a(element, a, new StringPair[0]);
            for (ManufacturedSeed manufacturedSeed : list) {
                Element element3 = XMLUtils.a(element2, x, new StringPair(A, manufacturedSeed.e()), new StringPair(w, manufacturedSeed.g()), new StringPair(v, manufacturedSeed.f()), new StringPair(u, manufacturedSeed.h()), new StringPair(t, Float.toString(manufacturedSeed.j())), new StringPair(s, Float.toString(manufacturedSeed.k())), new StringPair(r, Float.toString(manufacturedSeed.i())));
                SeedFactory.a(q, manufacturedSeed.lineModelRadialDose, element3);
                SeedFactory.a(o, manufacturedSeed.anisotropicFunction1D, element3);
                if (manufacturedSeed.lineModelRadialDose instanceof RadialDoseExpFitter) {
                    SeedFactory.a((RadialDoseExpFitter)manufacturedSeed.lineModelRadialDose, element3);
                }
                Element element4 = XMLUtils.a(element3, n, new StringPair(k, Integer.toString(manufacturedSeed.anisotropicFunction2D.angle.length)), new StringPair(j, Integer.toString(manufacturedSeed.anisotropicFunction2D.radius.length)));
                for (int i2 = 0; i2 < manufacturedSeed.anisotropicFunction2D.angle.length; ++i2) {
                    Element element5 = XMLUtils.a(element4, h, new StringPair(g, Integer.toString(i2)), new StringPair(f, Float.toString(manufacturedSeed.anisotropicFunction2D.angle[i2])));
                    for (int i3 = 0; i3 < manufacturedSeed.anisotropicFunction2D.radius.length; ++i3) {
                        XMLUtils.a(element5, e, new StringPair(g, Integer.toString(i3)), new StringPair(d, Float.toString(manufacturedSeed.anisotropicFunction2D.radius[i3])), new StringPair(b, Float.toString(manufacturedSeed.anisotropicFunction2D.value[i2][i3])));
                    }
                }
            }
            document = XMLUtils.c(document);
            File file = com.mimvista.preferencesNew.cascade.c.d().b(CascadeSubfolder.a, D);
            XMLUtils.a(document, file);
        }
        catch (Exception exception) {
            ay.d((Object)"Error trying to write user's seed database", (Throwable)exception, SeedFactory.class);
            SeedFactory.a(list);
            return;
        }
    }

    private static void a(RadialDoseExpFitter radialDoseExpFitter, Element element) {
        Element element2 = XMLUtils.a(element, i, new StringPair[0]);
        for (int i2 = 0; i2 < 7; ++i2) {
            XMLUtils.a(element2, "a" + i2, new StringPair(b, Double.toString(radialDoseExpFitter.interpCoef[i2])));
        }
    }

    private static void a(String string, DoseFunctionFitter doseFunctionFitter, Element element) {
        Element element2 = XMLUtils.a(element, string, new StringPair(l, Integer.toString(doseFunctionFitter.c())));
        for (int i2 = 0; i2 < doseFunctionFitter.c(); ++i2) {
            XMLUtils.a(element2, e, new StringPair(g, Integer.toString(i2)), new StringPair(d, Float.toString(doseFunctionFitter.radius[i2])), new StringPair(b, Float.toString(doseFunctionFitter.value[i2])));
        }
    }

    private static void a(Collection<ManufacturedSeed> collection) {
        ObjectOutputStream objectOutputStream = null;
        try {
            File file = new File(Path.getMIMTempPath(), C);
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(collection);
        }
        catch (Exception exception) {
            ay.d((Object)"Error dumping user defined seeds for recovery", (Throwable)exception, SeedFactory.class);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    ay.d((Object)"Error closing stream for seed dump", (Throwable)iOException, SeedFactory.class);
                }
            }
        }
    }

    private static void j() {
        block4: {
            ObjectInputStream objectInputStream = null;
            try {
                objectInputStream = new ObjectInputStream(new FileInputStream(new File(Path.getMIMTempPath(), C)));
                Collection collection = (Collection)objectInputStream.readObject();
                E.addAll(collection);
            }
            catch (Exception exception) {
                if (objectInputStream == null) break block4;
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    ay.d((Object)"Error closing stream for auto recovery", (Throwable)iOException, SeedFactory.class);
                }
            }
        }
    }

    public static ManufacturedSeed a(String string, String string2) {
        for (ManufacturedSeed manufacturedSeed : E) {
            if (!manufacturedSeed.g().equalsIgnoreCase(string) || !manufacturedSeed.f().equalsIgnoreCase(string2)) continue;
            return manufacturedSeed;
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        List<ManufacturedSeed> list = SeedFactory.e();
        for (ManufacturedSeed manufacturedSeed : list) {
            ay.e(manufacturedSeed.toString());
            DoseFunctionFitter doseFunctionFitter = manufacturedSeed.n();
            float[] fArray = doseFunctionFitter.a();
            float[] fArray2 = doseFunctionFitter.e();
            float f2 = 0.0f;
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                float f3 = doseFunctionFitter.b(fArray[i2]);
                f2 += Math.abs(f3 - fArray2[i2]) * 100.0f / fArray2[i2];
            }
            ay.e("Average fitting error: " + (f2 /= (float)fArray.length) + "%");
        }
    }

    private static void b(File file) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                SeedFactory.b(file2);
                continue;
            }
            if (!file2.getName().endsWith("csv")) continue;
            SeedFactory.a(file2);
        }
    }

    static {
        SeedFactory.a();
    }
}

