/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.cardiac.CardiacAnalysisState;
import com.mimvista.cardiac.CardiacMistress;
import com.mimvista.cardiac.CardiacNormalPatient;
import com.mimvista.cardiac.CardiacNormalization;
import com.mimvista.cardiac.CardiacNormaliztionType;
import com.mimvista.cardiac.CardiacReversibilityAnalysisState;
import com.mimvista.cardiac.CardiacZScoreCalculator;
import com.mimvista.cardiac.SampledCardiacTransform;
import com.mimvista.cardiac.SegmentalScores;
import com.mimvista.cardiac.ZScoreModel;
import com.mimvista.cardiac.a;
import com.mimvista.cardiac.b;
import com.mimvista.cardiac.e;
import com.mimvista.cardiac.gui.CardiacSegments;
import com.mimvista.cardiac.gui.PolarPlotSectionation;
import com.mimvista.cardiac.gui.b;
import com.mimvista.file.PathUtils;
import com.mimvista.internals.ViewController;
import com.mimvista.mui.Session;
import com.mimvista.mui.bm;
import com.mimvista.neuro.ComparisonSet;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.CardiacPrefs;
import com.mimvista.preferencesNew.NagPrefs;
import com.mimvista.state.SerializedSessionStateObject;
import com.mimvista.state.SessionStateObject;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.i;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.work.f;
import com.mimvista.util.work.m;
import com.mimvista.workflow.backend.t;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import javax.swing.Icon;

public class CardiacAnalysisController
implements SerializedSessionStateObject<CardiacAnalysisController>,
SessionStateObject<CardiacAnalysisController> {
    private static final long serialVersionUID = -9100020563331437798L;
    private HashMap<CardiacSeriesType, CardiacAnalysisState> analyses = Maps.newHashMap();
    private transient Set<a> listeners = new CopyOnWriteArraySet<a>();
    private CardiacReversibilityAnalysisState reversibilityState = null;
    private Monitor reversibilityLock = new Monitor();
    private static boolean DEBUG_VERBOSE = false;
    private transient i noNormalsNote = this.buildNoNormalsNote();
    private transient ComparisonSet cs;

    public CardiacAnalysisController(ComparisonSet comparisonSet) {
        this.cs = comparisonSet;
        this.checkForObsolescence();
    }

    @Override
    public void preventLambdas() {
    }

    private boolean hasRest() {
        return this.analyses.containsKey(CardiacSeriesType.b);
    }

    private boolean hasStress() {
        return this.analyses.containsKey(CardiacSeriesType.a);
    }

    private boolean hasPerfusion() {
        return this.analyses.containsKey(CardiacSeriesType.c);
    }

    @Deprecated
    void removeSeries(CardiacSeriesType cardiacSeriesType) {
        this.analyses.remove(cardiacSeriesType);
    }

    public CardiacAnalysisState setSeries(CardiacSeriesType cardiacSeriesType, ViewController viewController, CardiacNormalization cardiacNormalization) {
        if (viewController == null) {
            this.removeSeries(cardiacSeriesType);
            return null;
        }
        ViewController viewController2 = viewController.aS();
        CardiacAnalysisState cardiacAnalysisState = this.getAnalysis(cardiacSeriesType);
        if (cardiacAnalysisState == null || cardiacAnalysisState.c() != viewController2.aV()) {
            cardiacAnalysisState = new CardiacAnalysisState(this, viewController2, cardiacSeriesType, cardiacNormalization, this.cs);
            this.setAnalysis(cardiacSeriesType, cardiacAnalysisState);
        }
        return cardiacAnalysisState;
    }

    public void comparisonSetsUpdated() {
        for (CardiacAnalysisState cardiacAnalysisState : this.getAllAnalyses()) {
            if (cardiacAnalysisState == null) continue;
            cardiacAnalysisState.b();
        }
    }

    private List<CardiacAnalysisState> getAllAnalyses() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(this.analyses.values());
        arrayList.add(this.reversibilityState);
        return arrayList;
    }

    private void setAnalysis(CardiacSeriesType cardiacSeriesType, final CardiacAnalysisState cardiacAnalysisState) {
        this.analyses.put(cardiacSeriesType, cardiacAnalysisState);
        if (cardiacSeriesType == CardiacSeriesType.a || cardiacSeriesType == CardiacSeriesType.b) {
            cardiacAnalysisState.b(new b.a(){

                @Override
                public void a(SampledCardiacTransform sampledCardiacTransform) {
                    cardiacAnalysisState.b.updateReversibilityState();
                }
            });
        }
    }

    public ViewController getRestSeries() {
        return this.getSeries(CardiacSeriesType.b);
    }

    public ViewController getStressSeries() {
        return this.getSeries(CardiacSeriesType.a);
    }

    public ViewController getPerfusionSeries() {
        return this.getSeries(CardiacSeriesType.c);
    }

    public ViewController getSeries(CardiacSeriesType cardiacSeriesType) {
        CardiacAnalysisState cardiacAnalysisState = this.getAnalysis(cardiacSeriesType);
        if (cardiacAnalysisState == null) {
            return null;
        }
        return cardiacAnalysisState.d();
    }

    public CardiacAnalysisState getAnalysis(ViewController viewController) {
        if (viewController == null) {
            return null;
        }
        for (CardiacAnalysisState cardiacAnalysisState : this.analyses.values()) {
            ViewController viewController2 = viewController.aS();
            if (cardiacAnalysisState.c() != viewController2.aV()) continue;
            return cardiacAnalysisState;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardiacReversibilityAnalysisState getReversibilityAnalysis() {
        Monitor monitor = this.reversibilityLock;
        synchronized (monitor) {
            if (this.reversibilityState == null) {
                this.reversibilityState = new CardiacReversibilityAnalysisState(this, this.cs);
            }
        }
        return this.reversibilityState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateReversibilityState() {
        if (!this.hasReversibility()) {
            return;
        }
        Monitor monitor = this.reversibilityLock;
        synchronized (monitor) {
            this.reversibilityState = new CardiacReversibilityAnalysisState(this, this.cs);
            this.fireReversability();
        }
    }

    public CardiacAnalysisState getAnalysis(CardiacSeriesType cardiacSeriesType) {
        return this.analyses.get(cardiacSeriesType);
    }

    public Set<CardiacSeriesType> getAvailableSeriesTypes() {
        return Sets.newTreeSet(this.analyses.keySet());
    }

    public Set<PolarPlotType> getAvailablePlotTypes(ViewController viewController) {
        if (!this.controls(viewController)) {
            return Collections.emptySet();
        }
        TreeSet treeSet = Sets.newTreeSet();
        treeSet.add(PolarPlotType.a);
        boolean bl2 = this.hasMatchingNormals(this.getSeriesType(viewController));
        if (this.hasReversibility() && bl2) {
            treeSet.add(PolarPlotType.b);
        }
        if (this.hasZScores(this.getSeriesType(viewController))) {
            treeSet.add(PolarPlotType.c);
        }
        if (viewController.bl() && this.hasPerfusion()) {
            treeSet.add(PolarPlotType.d);
            treeSet.add(PolarPlotType.f);
            treeSet.add(PolarPlotType.e);
        }
        return treeSet;
    }

    private boolean hasReversibility() {
        return this.hasRest() && this.hasStress();
    }

    private boolean hasZScores(CardiacSeriesType cardiacSeriesType) {
        if (cardiacSeriesType.equals(CardiacSeriesType.b) || cardiacSeriesType.equals(CardiacSeriesType.a)) {
            return this.hasMatchingNormals(cardiacSeriesType);
        }
        return false;
    }

    boolean hasMatchingNormals(CardiacSeriesType cardiacSeriesType) {
        CardiacZScoreCalculator.AppliedCardiacComparisonSet appliedCardiacComparisonSet = this.getAnalysis((CardiacSeriesType)cardiacSeriesType).appliedComparisonSet;
        return appliedCardiacComparisonSet != null && appliedCardiacComparisonSet.a();
    }

    public SegmentalScores.ScoreMap getScores(PolarPlotScoreType polarPlotScoreType, PolarPlotSectionation.SectionationType sectionationType) {
        try {
            switch (polarPlotScoreType) {
                case a: {
                    return this.getAnalysis(CardiacSeriesType.a).a(sectionationType);
                }
                case b: {
                    return this.getAnalysis(CardiacSeriesType.b).a(sectionationType);
                }
                case c: {
                    SegmentalScores.ScoreMap scoreMap = this.getAnalysis(CardiacSeriesType.b).a(sectionationType);
                    SegmentalScores.ScoreMap scoreMap2 = this.getAnalysis(CardiacSeriesType.a).a(sectionationType);
                    return scoreMap2.b(scoreMap);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            ay.c((Object)"Scores cannot be retrieved because the analysis is missing a required series.", this);
        }
        return SegmentalScores.ScoreMap.b();
    }

    protected synchronized void postProcessScores(PolarPlotSectionation.SectionationType sectionationType) {
        if (!this.hasReversibility()) {
            return;
        }
        SegmentalScores.ScoreMap scoreMap = this.getAnalysis(CardiacSeriesType.a).a(sectionationType);
        SegmentalScores.ScoreMap scoreMap2 = this.getAnalysis(CardiacSeriesType.b).a(sectionationType);
        if (this.getAnalysis((CardiacSeriesType)CardiacSeriesType.a).scores.d(sectionationType) || this.getAnalysis((CardiacSeriesType)CardiacSeriesType.b).scores.d(sectionationType)) {
            ay.a((Object)"Post-processing already happened. Aborting post-processing", CardiacAnalysisController.class);
            return;
        }
        if (scoreMap.isEmpty() || scoreMap2.isEmpty()) {
            ay.a((Object)"Empty scores. Continuing is futile", CardiacAnalysisController.class);
            return;
        }
        PolarPlotSectionation polarPlotSectionation = PolarPlotSectionation.a(sectionationType);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = CardiacPrefs.cedarsClassicScoring.getValue();
        for (CardiacSegments.CardiacSegment cardiacSegment : Lists.transform(polarPlotSectionation.b(), b::d)) {
            if (bl4 && (Integer)scoreMap.get(cardiacSegment) == 1 && (Integer)scoreMap2.get(cardiacSegment) == 1) {
                scoreMap.a(cardiacSegment, 0);
                bl2 = true;
                scoreMap2.a(cardiacSegment, 0);
                bl3 = true;
            }
            if ((Integer)scoreMap2.get(cardiacSegment) <= (Integer)scoreMap.get(cardiacSegment)) continue;
            scoreMap2.a(cardiacSegment, (Integer)scoreMap.get(cardiacSegment));
            bl3 = true;
        }
        this.getAnalysis((CardiacSeriesType)CardiacSeriesType.b).scores.e(sectionationType);
        this.getAnalysis((CardiacSeriesType)CardiacSeriesType.a).scores.e(sectionationType);
        if (bl2) {
            this.getAnalysis(CardiacSeriesType.a).b(sectionationType);
        }
        if (bl3) {
            this.getAnalysis(CardiacSeriesType.b).b(sectionationType);
        }
    }

    public float getTransientIschemicDilation() {
        ViewController viewController = this.getRestSeries();
        ViewController viewController2 = this.getPerfusionSeries();
        if (viewController2 == null) {
            viewController2 = this.getStressSeries();
        }
        if (viewController != null && viewController2 != null) {
            e e2 = this.getCardiacStatsForVC(viewController);
            e e3 = this.getCardiacStatsForVC(viewController2);
            if (e2 != null && e3 != null) {
                float f2 = e.a(e2);
                float f3 = e.a(e3);
                if (!Float.isNaN(f2) && !Float.isNaN(f3)) {
                    return f3 / f2;
                }
            }
        }
        return Float.NaN;
    }

    private e getCardiacStatsForVC(ViewController viewController) {
        return CardiacMistress.getCardiacMistressForSession(viewController.g()).getCardiacStatCacheFor(viewController);
    }

    public boolean controls(ViewController viewController) {
        ViewController viewController2 = viewController.aS();
        return this.controlsSeries(viewController2.aV());
    }

    public boolean controlsSeries(long l2) {
        for (CardiacAnalysisState cardiacAnalysisState : this.analyses.values()) {
            if (cardiacAnalysisState.c() != l2) continue;
            return true;
        }
        return false;
    }

    public List<ViewController> getControlledSeries() {
        LinkedList linkedList = Lists.newLinkedList();
        for (CardiacAnalysisState cardiacAnalysisState : this.analyses.values()) {
            linkedList.add(cardiacAnalysisState.d());
        }
        return linkedList;
    }

    public CardiacSeriesType getSeriesType(ViewController viewController) {
        if (!this.controls(viewController)) {
            return null;
        }
        return this.getAnalysis(viewController).n();
    }

    public Future<SampledCardiacTransform> getTransform(CardiacSeriesType cardiacSeriesType, PolarPlotType polarPlotType) {
        return this.getTransform(cardiacSeriesType, polarPlotType, false);
    }

    public Future<ZScoreModel> getZScoreTransform(CardiacSeriesType cardiacSeriesType, PolarPlotType polarPlotType) {
        return this.getZScoreTransform(cardiacSeriesType, polarPlotType, false);
    }

    public Future<SampledCardiacTransform> updateTransform(CardiacSeriesType cardiacSeriesType, PolarPlotType polarPlotType) {
        return this.getTransform(cardiacSeriesType, polarPlotType, true);
    }

    private Future<SampledCardiacTransform> getTransform(final CardiacSeriesType cardiacSeriesType, final PolarPlotType polarPlotType, boolean bl2) {
        Callable<SampledCardiacTransform> callable = new Callable<SampledCardiacTransform>(){

            public SampledCardiacTransform a() {
                CardiacAnalysisState cardiacAnalysisState = CardiacAnalysisController.this.getAnalysis(cardiacSeriesType);
                if (cardiacAnalysisState == null) {
                    return null;
                }
                switch (polarPlotType) {
                    case a: {
                        return cardiacAnalysisState.e();
                    }
                    case b: {
                        return CardiacAnalysisController.this.getReversibilityAnalysis().e();
                    }
                    case c: {
                        return cardiacAnalysisState.g();
                    }
                    case d: {
                        return cardiacAnalysisState.h();
                    }
                    case f: {
                        return cardiacAnalysisState.i();
                    }
                    case e: {
                        return cardiacAnalysisState.j();
                    }
                }
                return SampledCardiacTransform.b();
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.a();
            }
        };
        return new FuncUtils.l<SampledCardiacTransform>(m.e.submit(callable));
    }

    private Future<ZScoreModel> getZScoreTransform(final CardiacSeriesType cardiacSeriesType, final PolarPlotType polarPlotType, boolean bl2) {
        Callable<ZScoreModel> callable = new Callable<ZScoreModel>(){

            public ZScoreModel a() {
                CardiacAnalysisState cardiacAnalysisState = CardiacAnalysisController.this.getAnalysis(cardiacSeriesType);
                if (cardiacAnalysisState == null) {
                    return null;
                }
                switch (polarPlotType) {
                    case a: {
                        return cardiacAnalysisState.g();
                    }
                    case b: {
                        return CardiacAnalysisController.this.getReversibilityAnalysis().g();
                    }
                    case c: {
                        return cardiacAnalysisState.g();
                    }
                    case d: {
                        return cardiacAnalysisState.g();
                    }
                }
                return ZScoreModel.c();
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.a();
            }
        };
        return new FuncUtils.l<ZScoreModel>(m.e.submit(callable));
    }

    private synchronized void fireReversability() {
        for (a a2 : this.listeners) {
            a2.a(this.getReversibilityAnalysis());
        }
    }

    public synchronized void removeListener(a a2) {
        this.listeners.remove(a2);
    }

    public synchronized void addListener(a a2) {
        if (a2 != null) {
            this.listeners.add(a2);
        }
    }

    public void changeComparisonSet(ComparisonSet comparisonSet) {
        this.cs = comparisonSet;
        long l2 = System.currentTimeMillis();
        for (Map.Entry<CardiacSeriesType, CardiacAnalysisState> entry : this.analyses.entrySet()) {
            entry.getValue().a(comparisonSet);
        }
        if (this.reversibilityState != null) {
            this.reversibilityState.a(comparisonSet);
        }
        this.checkForObsolescence();
        CardiacAnalysisController.printDebug("changed CS in " + (System.currentTimeMillis() - l2) + " on " + Thread.currentThread().getName());
    }

    protected void warnAboutLackOfNormals() {
        if (this.noNormalsNote == null) {
            this.noNormalsNote = this.buildNoNormalsNote();
        }
        if (!u.b().a(this.noNormalsNote) && this.noNormalsNote.a()) {
            u.b().c(this.noNormalsNote);
        }
    }

    private i buildNoNormalsNote() {
        i i2 = new i(BasicNotification.NotificationType.b, Messages.a("Cardiac", "NO_NORMALS_WARNING"), com.mimvista.util.f.a.a(), NagPrefs.NagKey.m, new Notification.a(bm.b()));
        return i2;
    }

    private i buildObsoleteComparisonSetNote(boolean bl2) {
        i i2 = new i(BasicNotification.NotificationType.b, Messages.a("Cardiac", bl2 ? "OBSOLETE_USER_CS" : "OBSOLETE_BUILTIN_CS"), com.mimvista.util.f.a.a(), NagPrefs.NagKey.p, new Notification.a(bm.b()));
        return i2;
    }

    private void checkForObsolescence() {
        File file;
        String string;
        boolean bl2;
        i i2;
        CardiacNormalPatient cardiacNormalPatient = (CardiacNormalPatient)Iterables.getFirst(this.cs.getAllPatients(), null);
        if (cardiacNormalPatient != null && !cardiacNormalPatient.d() && (i2 = this.buildObsoleteComparisonSetNote(bl2 = PathUtils.isParentOf(new File(string = com.mimvista.neuro.b.q().e()), file = cardiacNormalPatient.n().getParentFile()))).a()) {
            u.b().c(i2);
        }
    }

    @Override
    public CardiacAnalysisController deserialize(Session session) {
        this.listeners = new CopyOnWriteArraySet<a>();
        for (CardiacSeriesType cardiacSeriesType : this.analyses.keySet()) {
            CardiacAnalysisState cardiacAnalysisState = this.getAnalysis(cardiacSeriesType);
            if (this.cs == null) {
                CardiacZScoreCalculator.AppliedCardiacComparisonSet appliedCardiacComparisonSet;
                this.cs = cardiacAnalysisState.d;
                if (this.cs == null && (appliedCardiacComparisonSet = cardiacAnalysisState.o()) != null) {
                    this.cs = appliedCardiacComparisonSet.cs;
                }
            }
            cardiacAnalysisState.b = this;
            this.setAnalysis(cardiacSeriesType, cardiacAnalysisState);
            if (cardiacAnalysisState.d != null) {
                cardiacAnalysisState.appliedComparisonSet = CardiacZScoreCalculator.AppliedCardiacComparisonSet.a(cardiacAnalysisState.d, cardiacAnalysisState.d());
            }
            cardiacAnalysisState.a(cardiacAnalysisState.appliedComparisonSet);
        }
        if (this.reversibilityState != null) {
            this.reversibilityState.b = this;
        }
        this.checkForObsolescence();
        return this;
    }

    @Override
    public SerializedSessionStateObject<CardiacAnalysisController> serialize() {
        return this;
    }

    public static void printDebug(String string) {
        if (DEBUG_VERBOSE) {
            System.out.println(string);
        }
    }

    public static void prefetchNormals(CardiacSeriesType cardiacSeriesType, ViewController viewController, CardiacNormaliztionType cardiacNormaliztionType) {
        if (cardiacSeriesType == CardiacSeriesType.b || cardiacSeriesType == CardiacSeriesType.a) {
            f.e.submit(() -> {
                Class<CardiacZScoreCalculator> clazz = CardiacZScoreCalculator.class;
                synchronized (CardiacZScoreCalculator.class) {
                    CardiacZScoreCalculator.AppliedCardiacComparisonSet appliedCardiacComparisonSet = CardiacZScoreCalculator.AppliedCardiacComparisonSet.a(CardiacAnalysisState.a(), viewController);
                    appliedCardiacComparisonSet.a(cardiacSeriesType, cardiacNormaliztionType);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            });
        }
    }

    public static enum CardiacSeriesType implements t
    {
        a("CARDIAC_SERIES_TYPE_STRESS"),
        b("CARDIAC_SERIES_TYPE_REST"),
        c("CARDIAC_SERIES_TYPE_PERFUSION"),
        d("POLAR_PLOT_TYPE_REVERSIBILITY");

        private final String displayKey;

        private CardiacSeriesType(String string2) {
            this.displayKey = string2;
        }

        @Override
        public String getExternalizedString() {
            return Messages.a("Cardiac", this.displayKey);
        }

        @Override
        public Icon getIcon(int n2) {
            return null;
        }

        public static CardiacSeriesType a(String string) {
            try {
                return CardiacSeriesType.valueOf(string);
            }
            catch (Throwable throwable) {
                for (CardiacSeriesType cardiacSeriesType : CardiacSeriesType.values()) {
                    if (!cardiacSeriesType.name().equalsIgnoreCase(string) && !cardiacSeriesType.getExternalizedString().equalsIgnoreCase(string)) continue;
                    return cardiacSeriesType;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    public static enum PolarPlotType implements t
    {
        a("POLAR_PLOT_TYPE_ACTIVITY"),
        b("POLAR_PLOT_TYPE_REVERSIBILITY"),
        c("POLAR_PLOT_TYPE_ZSCORE"),
        d("POLAR_PLOT_TYPE_WALL_THICKENING"),
        e("POLAR_PLOT_TYPE_ES_ACTIVITY"),
        f("POLAR_PLOT_TYPE_ED_ACTIVITY");

        private final String displayKey;

        private PolarPlotType(String string2) {
            this.displayKey = string2;
        }

        @Override
        public String getExternalizedString() {
            return Messages.a("Cardiac", this.displayKey);
        }

        @Override
        public Icon getIcon(int n2) {
            return null;
        }

        public static PolarPlotType a(String string) {
            try {
                return PolarPlotType.valueOf(string);
            }
            catch (Throwable throwable) {
                for (PolarPlotType polarPlotType : PolarPlotType.values()) {
                    if (!polarPlotType.name().equalsIgnoreCase(string) && !polarPlotType.getExternalizedString().equalsIgnoreCase(string)) continue;
                    return polarPlotType;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    public static enum PolarPlotScoreType implements t
    {
        a("POLAR_PLOT_SCORE_TYPE_STRESS"),
        b("POLAR_PLOT_SCORE_TYPE_REST"),
        c("POLAR_PLOT_SCORE_TYPE_DIFFERENCE");

        private final String displayKey;

        private PolarPlotScoreType(String string2) {
            this.displayKey = string2;
        }

        @Override
        public String getExternalizedString() {
            return Messages.a("Cardiac", this.displayKey);
        }

        @Override
        public Icon getIcon(int n2) {
            return null;
        }

        public static PolarPlotScoreType a(String string) {
            try {
                return PolarPlotScoreType.valueOf(string);
            }
            catch (Throwable throwable) {
                for (PolarPlotScoreType polarPlotScoreType : PolarPlotScoreType.values()) {
                    if (!polarPlotScoreType.name().equalsIgnoreCase(string) && !polarPlotScoreType.getExternalizedString().equalsIgnoreCase(string)) continue;
                    return polarPlotScoreType;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    public static class Monitor
    implements Serializable {
        private static final long serialVersionUID = 1L;
    }
}

