/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.cardiac.CardiacAnalysisController;
import com.mimvista.cardiac.CardiacAnalysisControllerManager;
import com.mimvista.cardiac.CardiacAnalysisState;
import com.mimvista.cardiac.CardiacNormalization;
import com.mimvista.cardiac.CardiacNormaliztionType;
import com.mimvista.cardiac.CardiacSidebar;
import com.mimvista.cardiac.GatedInfoDialog;
import com.mimvista.cardiac.algorithm.f;
import com.mimvista.cardiac.algorithm.h;
import com.mimvista.cardiac.e;
import com.mimvista.cardiac.gui.PolarPlotGraph;
import com.mimvista.commands.workflow.CardiacAutoRoiCommand;
import com.mimvista.commands.workflow.FourDeeFrameSelection;
import com.mimvista.commands.workflow.PropagateCardiacROICommand;
import com.mimvista.d;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.DynamicVolumeRef;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.linking.AffineTransform;
import com.mimvista.internals.linking.TransformEdge;
import com.mimvista.internals.linking.ViewLink;
import com.mimvista.internals.linking.ViewLinker;
import com.mimvista.internals.linking.WarpTransform;
import com.mimvista.internals.linking.c;
import com.mimvista.internals.statistics.OverlayStatistician;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.Session;
import com.mimvista.mui.ak;
import com.mimvista.mui.bi;
import com.mimvista.mui.bm;
import com.mimvista.mui.layout.CustomView;
import com.mimvista.mui.layout.HangingProtocol;
import com.mimvista.mui.mouse.mode.s;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.OverlayishBase;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.mui.presenters.ViewPort;
import com.mimvista.mui.presenters.display.DisplaySidePanel;
import com.mimvista.mui.presenters.f;
import com.mimvista.mui.presenters.protocol.AddPageGroupState;
import com.mimvista.mui.widget.MIMWidgetDrawable;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.state.SerializedSessionStateObject;
import com.mimvista.state.SessionStateObject;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.ag;
import com.mimvista.util.ay;
import com.mimvista.util.extents.VolumeExtent;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.state.ViewLoadState;
import com.mimvista.util.w;
import com.mimvista.viewer.NMSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class CardiacMistress
implements SessionStateObject<CardiacMistress> {
    private static CardiacSidebar guiMinion = null;
    private Session mySession;
    private WeakHashMap<ViewController, e> cardiacStatCache = new WeakHashMap();

    public static CardiacMistress getCardiacMistressForSession(Session session) {
        return session.a(CardiacMistress.class);
    }

    public static boolean shouldAllowCardiacAnalysis() {
        return CardiacMistress.shouldAllowCardiacAnalysis(bm.b());
    }

    public static boolean shouldAllowCardiacAnalysis(Session session) {
        return CardiacAnalysisControllerManager.getForSession(session).getAnalysisControllers().isEmpty();
    }

    public void demandRecalculate(ViewController viewController) {
        e e2 = this.cardiacStatCache.get(viewController);
        if (e2 != null) {
            e2.a(true);
            e2.q();
        }
    }

    public void demandRecalculate(ViewController viewController, e e2) {
        guiMinion.e();
        this.cardiacStatCache.put(viewController, e2);
        this.demandRecalculate(viewController);
    }

    public e getCardiacStatCacheFor(ViewController viewController) {
        return this.cardiacStatCache.get(viewController);
    }

    public TableModel getCurrentTableModelForVC(ViewController viewController) {
        e e2;
        if (viewController != null && (e2 = this.cardiacStatCache.get(viewController.aT())) != null) {
            if (viewController.bl()) {
                return new CardiacStatMultiFrameTableModel(e2);
            }
            return new CardiacStatSingleFrameTableModel(e2);
        }
        return new DefaultTableModel();
    }

    public static void registerSidebarAsMinion(CardiacSidebar cardiacSidebar) {
        guiMinion = cardiacSidebar;
    }

    public static CardiacSidebar getGUIMinion() {
        return guiMinion;
    }

    public void fullRefresh() {
        if (this.mySession == bm.b() && guiMinion != null) {
            guiMinion.c();
        }
    }

    public void chooseSeriesAndAnalyze(List<CardiacAnalysisController.CardiacSeriesType> list, CardiacNormaliztionType cardiacNormaliztionType) {
        if (list.isEmpty()) {
            return;
        }
        List<ViewController> list2 = this.potentialCardiacVolumes();
        CardiacAnalysisControllerManager cardiacAnalysisControllerManager = CardiacAnalysisControllerManager.getForSession(bm.b());
        CardiacAnalysisController cardiacAnalysisController = (CardiacAnalysisController)Iterables.getFirst(cardiacAnalysisControllerManager.getAnalysisControllers(), (Object)new CardiacAnalysisController(CardiacAnalysisState.a()));
        if (list2.size() > 0) {
            list2.removeAll(cardiacAnalysisController.getControlledSeries());
            for (CardiacAnalysisController.CardiacSeriesType cardiacSeriesType : list) {
                if (!cardiacAnalysisController.getAvailableSeriesTypes().contains(cardiacSeriesType)) {
                    FuncUtils.f f2 = new FuncUtils.f();
                    s.a(this.getSeriesCallback(cardiacSeriesType, cardiacAnalysisController, f2, cardiacNormaliztionType), this.getSegmentPredicate(list2), false);
                    f2.a();
                }
                list2.remove(cardiacAnalysisController.getSeries(cardiacSeriesType));
            }
            for (CardiacAnalysisController.CardiacSeriesType cardiacSeriesType : list) {
                if (cardiacAnalysisController.getAnalysis(cardiacSeriesType) != null) continue;
                return;
            }
            cardiacAnalysisControllerManager.addAnalysisController(cardiacAnalysisController);
            DisplaySidePanel displaySidePanel = DisplaySidePanel.b();
            if (displaySidePanel != null) {
                displaySidePanel.c();
            }
            this.applyHangingProtocol(cardiacAnalysisController);
        }
    }

    private void applyHangingProtocol(CardiacAnalysisController cardiacAnalysisController) {
        if (cardiacAnalysisController.getAvailableSeriesTypes().isEmpty()) {
            return;
        }
        HangingProtocol hangingProtocol = this.getHangingProtocol(cardiacAnalysisController);
        if (hangingProtocol != null) {
            this.updateCustomViews(hangingProtocol, cardiacAnalysisController);
            this.mapProtocol(hangingProtocol, cardiacAnalysisController);
            Session session = bm.b();
            new AddPageGroupState(hangingProtocol, session).stamp();
        }
    }

    private HangingProtocol getHangingProtocol(CardiacAnalysisController cardiacAnalysisController) {
        Set<CardiacAnalysisController.CardiacSeriesType> set = cardiacAnalysisController.getAvailableSeriesTypes();
        String string = com.mimvista.mui.layout.c.t() + "Cardiac_Polar_";
        if (set.size() == 1 && set.contains(CardiacAnalysisController.CardiacSeriesType.c)) {
            string = string + "gated.mhp";
        } else {
            if (!cardiacAnalysisController.hasMatchingNormals((CardiacAnalysisController.CardiacSeriesType)Sets.newTreeSet(cardiacAnalysisController.getAvailableSeriesTypes()).first())) {
                string = string + "NoZ_";
            }
            if (set.size() == 1 && (set.contains(CardiacAnalysisController.CardiacSeriesType.a) || set.contains(CardiacAnalysisController.CardiacSeriesType.b))) {
                string = string + "stress.mhp";
            } else if (set.size() == 2 && set.contains(CardiacAnalysisController.CardiacSeriesType.a) && set.contains(CardiacAnalysisController.CardiacSeriesType.b)) {
                string = string + "stress_rest.mhp";
            } else if (set.size() == 2 && set.contains(CardiacAnalysisController.CardiacSeriesType.c)) {
                string = string + "stress_gated.mhp";
            } else if (set.size() == 3) {
                string = string + "stress_rest_gated.mhp";
            }
        }
        try {
            return com.mimvista.mui.layout.c.d(string);
        }
        catch (Exception exception) {
            ay.d((Object)"Failed to load hanging protocol for polar plots", (Throwable)exception, this);
            return null;
        }
    }

    private void updateCustomViews(HangingProtocol hangingProtocol, CardiacAnalysisController cardiacAnalysisController) {
        List<CustomView> list = hangingProtocol.e();
        LinkedList linkedList = Lists.newLinkedList(cardiacAnalysisController.getAvailableSeriesTypes());
        for (CustomView customView : list) {
            Map map = (Map)customView.e();
            PolarPlotGraph polarPlotGraph = PolarPlotGraph.a(map, customView.t());
            CardiacAnalysisController.CardiacSeriesType cardiacSeriesType = polarPlotGraph.i();
            if (!linkedList.contains(cardiacSeriesType)) {
                if (cardiacSeriesType == CardiacAnalysisController.CardiacSeriesType.b) {
                    cardiacSeriesType = CardiacAnalysisController.CardiacSeriesType.a;
                } else if (cardiacSeriesType == CardiacAnalysisController.CardiacSeriesType.a) {
                    cardiacSeriesType = CardiacAnalysisController.CardiacSeriesType.b;
                } else {
                    ay.c((Object)("Cardiac Analysis missing type for plot (" + cardiacSeriesType + ").  Using " + linkedList.get(0)), this);
                    cardiacSeriesType = (CardiacAnalysisController.CardiacSeriesType)linkedList.get(0);
                }
            }
            if (cardiacSeriesType == CardiacAnalysisController.CardiacSeriesType.a || cardiacSeriesType == CardiacAnalysisController.CardiacSeriesType.b) {
                polarPlotGraph.a(cardiacSeriesType == CardiacAnalysisController.CardiacSeriesType.a ? CardiacAnalysisController.PolarPlotScoreType.a : CardiacAnalysisController.PolarPlotScoreType.b);
            }
            polarPlotGraph.a(cardiacSeriesType);
            polarPlotGraph.b(map);
        }
    }

    private void mapProtocol(HangingProtocol hangingProtocol, CardiacAnalysisController cardiacAnalysisController) {
    }

    public CardiacAnalysisState initCardiacAnalysisState(final ViewController viewController, CardiacAnalysisController.CardiacSeriesType cardiacSeriesType, CardiacAnalysisController cardiacAnalysisController, CardiacNormaliztionType cardiacNormaliztionType) {
        Object object;
        Object object2;
        CardiacAnalysisController.prefetchNormals(cardiacSeriesType, viewController, cardiacNormaliztionType);
        CardiacNormalization cardiacNormalization = CardiacNormalization.a;
        if (CardiacMistress.vcIsSegmentedCardiac(viewController)) {
            object2 = w.a(bm.a(viewController.g()), viewController.bh(), false);
            object = this.segmentHeartInCurrentThread((ViewController)object2, null, false);
            cardiacNormalization = this.normalize(viewController, (f)object, cardiacNormaliztionType);
        } else {
            object2 = this.segmentHeartInCurrentThread(viewController, null, false);
            cardiacNormalization = this.normalize(viewController, (f)object2, cardiacNormaliztionType);
        }
        object2 = cardiacAnalysisController.setSeries(cardiacSeriesType, viewController, cardiacNormalization);
        if (CardiacAnalysisController.CardiacSeriesType.c.equals(cardiacSeriesType)) {
            object = FourDeeFrameSelection.a(viewController, FourDeeFrameSelection.e, 0);
            List<Integer> list = FourDeeFrameSelection.a(viewController, FourDeeFrameSelection.f, 0);
            if ((Integer)object.get(0) < 0 || list.get(0) < 0) {
                PropagateCardiacROICommand propagateCardiacROICommand = new PropagateCardiacROICommand(null, null, viewController, null, true);
                propagateCardiacROICommand.execute();
            }
            MIMSwingUtils.a(new Runnable(){

                @Override
                public void run() {
                    if (guiMinion != null) {
                        guiMinion.a(viewController, true);
                    }
                }
            });
        }
        return object2;
    }

    private static boolean vcIsSegmentedCardiac(ViewController viewController) {
        return viewController.e() && !viewController.ba().a(OverlayishBase.InterpretedType.y, true).isEmpty() && !viewController.ba().a(OverlayishBase.InterpretedType.z, true).isEmpty();
    }

    private MIMWidgetDrawable.a getSeriesCallback(final CardiacAnalysisController.CardiacSeriesType cardiacSeriesType, final CardiacAnalysisController cardiacAnalysisController, final FuncUtils.f f2, final CardiacNormaliztionType cardiacNormaliztionType) {
        return new MIMWidgetDrawable.a(){

            @Override
            public void a(ViewPort viewPort) {
                s.T();
                final DynamicVolumeRef dynamicVolumeRef = DynamicVolumeRef.a(viewPort.M());
                MIMSwingUtils.e(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CardiacMistress.this.initCardiacAnalysisState(dynamicVolumeRef.b(), cardiacSeriesType, cardiacAnalysisController, cardiacNormaliztionType);
                            if (dynamicVolumeRef.b().g().p()) {
                                throw new Exception("The session is being closed");
                            }
                        }
                        catch (Exception exception) {
                            ay.d((Object)"Error during segmentation", (Throwable)exception, this);
                            cardiacAnalysisController.removeSeries(cardiacSeriesType);
                        }
                        finally {
                            f2.b();
                        }
                    }
                });
            }

            @Override
            public String a() {
                String string = "CARDIAC_SERIES_TYPE_";
                switch (cardiacSeriesType) {
                    case c: {
                        string = string + "PERFUSION_ADJECTIVE";
                        break;
                    }
                    case b: {
                        string = string + "REST_ADJECTIVE";
                        break;
                    }
                    default: {
                        string = string + "STRESS_ADJECTIVE";
                    }
                }
                return MIMFormat.a(CardiacSidebar.a.getProperty("SELECT_CARDIAC_SERIES_BY_TYPE"), CardiacSidebar.a.getProperty(string));
            }
        };
    }

    public void chooseHeartAndSegment() {
        List<ViewController> list = this.potentialCardiacVolumes();
        if (list.size() == 1 || bm.b().T()) {
            this.segmentHeart(list.get(0));
        } else if (list.size() > 1) {
            s.a(this.getSegmentCallback(), this.getSegmentPredicate(list), false);
        }
    }

    public void chooseHeartAndDisplayGatedInfo() {
        List<ViewController> list = this.potentialGatedVolumes();
        if (list.size() == 1 || bm.b().T()) {
            this.displayGatedInfo(list.get(0));
        } else if (list.size() > 1) {
            s.a(this.getGatedCallback(), this.getSegmentPredicate(list), false);
        }
    }

    public List<ViewController> potentialGatedVolumes() {
        ArrayList arrayList = Lists.newArrayList();
        List<ViewController> list = this.mySession.af();
        for (ViewController viewController : list) {
            if (!CardiacMistress.hasGatedInfo(viewController) || arrayList.contains(viewController)) continue;
            arrayList.add(viewController);
        }
        return arrayList;
    }

    public static boolean hasGatedInfo(ViewController viewController) {
        return viewController != null && viewController.aP() != null && viewController.aP().modInfo != null && viewController.aP().modInfo.c() && ((NMSeriesInfo)viewController.aP().modInfo).gatedInfoSeq != null;
    }

    private f.a getSegmentPredicate(List<ViewController> list) {
        final ArrayList arrayList = Lists.newArrayList();
        for (ViewController viewController : list) {
            arrayList.add(viewController.aw());
        }
        return new f.a(){

            @Override
            public boolean a(ViewPort viewPort) {
                ImageFrame imageFrame = viewPort.M().aw();
                return !arrayList.contains(imageFrame);
            }
        };
    }

    private MIMWidgetDrawable.a getGatedCallback() {
        return new MIMWidgetDrawable.a(){

            @Override
            public void a(ViewPort viewPort) {
                s.T();
                ViewController viewController = viewPort.M();
                CardiacMistress.this.displayGatedInfo(viewController);
            }

            @Override
            public void b() {
                guiMinion.e();
            }

            @Override
            public String a() {
                return CardiacSidebar.a.getProperty("SELECT_CARDIAC_SERIES_GATED");
            }
        };
    }

    private MIMWidgetDrawable.a getSegmentCallback() {
        return new MIMWidgetDrawable.a(){

            @Override
            public void a(ViewPort viewPort) {
                s.T();
                ViewController viewController = viewPort.M();
                CardiacMistress.this.segmentHeart(viewController);
            }

            @Override
            public void b() {
                guiMinion.e();
            }

            @Override
            public String a() {
                return CardiacSidebar.a.getProperty("SELECT_CARDIAC_SERIES");
            }
        };
    }

    public void segmentHeart(ViewController viewController) {
        this.segmentHeart(viewController, null, false);
    }

    public void segmentHeart(final ViewController viewController, final @d Progress progress, final boolean bl2) {
        MIMSwingUtils.e(new Runnable(){

            @Override
            public void run() {
                CardiacMistress.this.segmentHeartInCurrentThread(viewController, progress, bl2);
            }
        });
    }

    public f segmentHeartInCurrentThread(ViewController viewController, @d Progress progress, boolean bl2) {
        ViewController viewController2 = viewController.aT();
        CardiacAutoRoiCommand cardiacAutoRoiCommand = new CardiacAutoRoiCommand(viewController2);
        cardiacAutoRoiCommand.setBlockSessionActivation(progress, bl2);
        Future<f> future = cardiacAutoRoiCommand.segmentCore();
        f f2 = null;
        try {
            f2 = future.get();
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error warping cardiac scans", throwable, this);
        }
        if (guiMinion != null) {
            guiMinion.e();
        }
        if (this.mySession != null) {
            e e2 = new e(viewController2.aV(), this.mySession);
            this.cardiacStatCache.put(viewController2, e2);
            if (guiMinion != null) {
                guiMinion.a(viewController);
            }
            if (viewController.bl()) {
                ((ViewController3D)viewController).a(CardiacMistress.getVolChangedListener());
            }
            if (guiMinion != null) {
                guiMinion.d();
            }
        }
        return f2;
    }

    private void displayGatedInfo(ViewController viewController) {
        GatedInfoDialog gatedInfoDialog = new GatedInfoDialog(ak.b().O(), viewController);
        gatedInfoDialog.a(true);
    }

    public CardiacNormalization normalize(ViewController viewController, f f2, CardiacNormaliztionType cardiacNormaliztionType) {
        try {
            ViewController3D viewController3D = f2.f().V();
            ViewController viewController2 = CardiacMistress.getDeformedPatientVC(viewController, viewController3D, this.getWarp(viewController, f2));
            viewController3D.getUncopiedMutableInfo().u().a(viewController2.aP());
            h h2 = new h(viewController3D, viewController2, cardiacNormaliztionType, this.mySession);
            ViewController viewController3 = h2.b();
            AffineTransform affineTransform = c.a(viewController.aw(), viewController3.aw());
            viewController.g().q().a(viewController.aw(), viewController3.aw(), affineTransform, true, 5.0f, TransformEdge.TransformEdgeType.i.a());
            ViewLinker.a(viewController, viewController3, false);
            TransformEdge transformEdge = viewController.aG().b(viewController.aw(), viewController3.aw());
            if (transformEdge != null) {
                ViewLinker.a(ViewLink.ViewEvent.w, false, transformEdge, this.mySession);
                ViewLinker.a(ViewLink.ViewEvent.e, false, transformEdge, this.mySession);
            }
            return h2.e();
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error normalizing cardiac series", throwable, this);
            return CardiacNormalization.a;
        }
    }

    public static ViewController getDeformedPatientVC(ViewController viewController, ViewController viewController2, WarpTransform warpTransform) {
        ImageVolumeShort imageVolumeShort = (ImageVolumeShort)viewController.aw();
        ImageCube.ImageCubeShort imageCubeShort = warpTransform.a(imageVolumeShort);
        ImageVolumeShort imageVolumeShort2 = new ImageVolumeShort(imageVolumeShort);
        imageVolumeShort2.a(imageCubeShort);
        imageVolumeShort2.getUncopiedMutableInfo().frameOfRefUID = viewController2.aP().frameOfRefUID;
        imageVolumeShort2.b(viewController2.aw().G());
        imageVolumeShort2.a(viewController2.aw().N());
        imageVolumeShort2.getUncopiedMutableInfo().origPatientPosition = viewController2.aP().origPatientPosition;
        imageVolumeShort2.a(viewController2.ao_());
        imageVolumeShort2.getUncopiedMutableInfo().seriesDesc = imageVolumeShort2.getUncopiedMutableInfo().seriesDesc + "(Deformed)";
        Session session = bm.a(viewController.g());
        ViewLoadState.LoadFromPseudoVolumeState loadFromPseudoVolumeState = new ViewLoadState.LoadFromPseudoVolumeState((SimpleImageVolume<ImageCube.ImageCubeShort>)imageVolumeShort2, session, false);
        loadFromPseudoVolumeState.stamp();
        ViewController viewController3 = session.b(loadFromPseudoVolumeState.b());
        for (VolumetricContourOverlay volumetricContourOverlay : viewController2.ba().E()) {
            VolumetricContourOverlay volumetricContourOverlay2 = com.mimvista.mui.overlays.f.a(viewController3, volumetricContourOverlay.aq().l());
            volumetricContourOverlay2.c(volumetricContourOverlay.getName());
            volumetricContourOverlay2.a(volumetricContourOverlay.z());
            imageVolumeShort2.n().a((Overlayish)volumetricContourOverlay2, false);
        }
        viewController3.f(true);
        return viewController3;
    }

    private WarpTransform getWarp(ViewController viewController, f f2) {
        ViewController3D viewController3D = f2.f().V();
        WarpTransform warpTransform = new WarpTransform(((ViewController)viewController3D).aw(), viewController.aw(), f2.g());
        ImageCube.ImageCubeFloat[] imageCubeFloatArray = f2.e();
        warpTransform.a(new com.mimvista.intensitybasedwarp.s(imageCubeFloatArray[0], imageCubeFloatArray[1], imageCubeFloatArray[2], viewController3D.ao_()));
        warpTransform.a(new VolumeExtent(((ViewController)viewController3D).aw()));
        warpTransform.c(0.125f);
        return warpTransform;
    }

    public static ViewController3D.b getVolChangedListener() {
        return new ViewController3D.b(){

            @Override
            public void d(ImageFrame imageFrame) {
                guiMinion.d();
            }
        };
    }

    public boolean sessionContainsCardiac() {
        return this.cardiacVolumes().size() > 0;
    }

    public boolean sessionContainsMultiframeCardiacVC() {
        List<ViewController> list = this.mySession.af();
        for (ViewController viewController : list) {
            if (!viewController.bl() || !viewController.e()) continue;
            return true;
        }
        return false;
    }

    private void sessionActivated() {
        if (guiMinion != null) {
            guiMinion.c();
        }
    }

    public CardiacMistress(Session session) {
        this.mySession = session;
    }

    public List<ViewController> potentialCardiacVolumes() {
        ArrayList<ViewController> arrayList = new ArrayList<ViewController>();
        List<ViewController> list = this.mySession.af();
        for (ViewController viewController : list) {
            if (!viewController.bM() || arrayList.contains(viewController = viewController.aT())) continue;
            arrayList.add(viewController);
        }
        return arrayList;
    }

    public List<ViewController> cardiacVolumes() {
        ArrayList<ViewController> arrayList = new ArrayList<ViewController>();
        List<ViewController> list = this.mySession.af();
        for (ViewController viewController : list) {
            SeriesInfo seriesInfo = viewController.getUncopiedMutableInfo();
            if (!viewController.e() || com.mimvista.viewer.f.d(seriesInfo) || arrayList.contains(viewController = viewController.aT())) continue;
            arrayList.add(viewController);
        }
        return arrayList;
    }

    public static boolean isPotentialCardiacNormal(ViewController viewController) {
        viewController = viewController.aS();
        CardiacAnalysisController cardiacAnalysisController = CardiacAnalysisControllerManager.getForSession(viewController.g()).getAnalysisController(viewController);
        CardiacMistress cardiacMistress = CardiacMistress.getCardiacMistressForSession(viewController.g());
        if (cardiacAnalysisController == null) {
            return false;
        }
        boolean bl2 = cardiacMistress.cardiacVolumes().contains(viewController);
        return bl2 &= cardiacAnalysisController.getRestSeries() != null && cardiacAnalysisController.getStressSeries() != null;
    }

    public SerializedCardiacMistress serialize() {
        return new SerializedCardiacMistress(this);
    }

    static {
        bm.a(new bi(){

            @Override
            public void activeSessionChanged(Session session, Session session2) {
                session.a(CardiacMistress.class).sessionActivated();
            }

            @Override
            public void sessionRemoved(Session session) {
                CardiacMistress cardiacMistress = session.c(CardiacMistress.class);
                if (cardiacMistress != null) {
                    cardiacMistress.mySession = null;
                }
            }
        });
    }

    public static class SerializedCardiacMistress
    implements SerializedSessionStateObject<CardiacMistress> {
        private static final long serialVersionUID = 2533570161255827082L;
        private Set<Long> cardiacStatCache = Sets.newHashSet();

        public SerializedCardiacMistress(CardiacMistress cardiacMistress) {
            for (ViewController viewController : cardiacMistress.cardiacStatCache.keySet()) {
                this.cardiacStatCache.add(viewController.aV());
            }
        }

        @Override
        public void preventLambdas() {
        }

        public CardiacMistress a(Session session) {
            CardiacMistress cardiacMistress = new CardiacMistress(session);
            ak ak2 = ak.c();
            if (ak2 != null) {
                CardiacMistress.registerSidebarAsMinion(ak2.n());
            }
            for (long l2 : this.cardiacStatCache) {
                ViewController viewController = session.b(l2);
                if (viewController == null) continue;
                cardiacMistress.cardiacStatCache.put(viewController, new e(l2, session));
            }
            return cardiacMistress;
        }

        @Override
        public /* synthetic */ Object deserialize(Session session) {
            return this.a(session);
        }
    }

    static class CardiacStatSingleFrameTableModel
    extends CardiacStatTableModel {
        private static final long serialVersionUID = 1L;

        public CardiacStatSingleFrameTableModel(e e2) {
            super(e2, Lists.newArrayList((Object[])new CardiacStatTableModel.CardiacStat[]{CardiacStatTableModel.CardiacStat.i, CardiacStatTableModel.CardiacStat.j, CardiacStatTableModel.CardiacStat.h}));
        }
    }

    static class CardiacStatMultiFrameTableModel
    extends CardiacStatTableModel {
        private static final long serialVersionUID = 1L;

        public CardiacStatMultiFrameTableModel(e e2) {
            super(e2, Lists.newArrayList((Object[])new CardiacStatTableModel.CardiacStat[]{CardiacStatTableModel.CardiacStat.j, CardiacStatTableModel.CardiacStat.a, CardiacStatTableModel.CardiacStat.b, CardiacStatTableModel.CardiacStat.c, CardiacStatTableModel.CardiacStat.d, CardiacStatTableModel.CardiacStat.e, CardiacStatTableModel.CardiacStat.f, CardiacStatTableModel.CardiacStat.g, CardiacStatTableModel.CardiacStat.h}));
        }
    }

    public static abstract class CardiacStatTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        protected final e stats;
        protected List<CardiacStat> rows;

        protected static NumberFormat a() {
            return NumberFormatFactory.a();
        }

        static String b() {
            return Messages.a("Dose", "SETTING_DIALOG_RADIO_PERCENT");
        }

        static String c() {
            return " - ";
        }

        static String d() {
            return Messages.a("DumpReadable", "MILLILITER");
        }

        public CardiacStatTableModel(e e2, List<CardiacStat> list) {
            this.stats = e2;
            this.rows = list;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int n2) {
            if (n2 == 1) {
                return Float.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int n2) {
            return null;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            if (n3 == 0) {
                return this.rows.get(n2).getExternalizedString();
            }
            if (n3 == 1) {
                return this.rows.get(n2).a(this.stats);
            }
            return this.rows.get(n2).a();
        }

        static enum CardiacStat implements ag
        {
            a("CARDIAC_EJECT_FRACTION", OverlayStatistician.StatUnitCategory.b, null, new Function<e, String>(){

                public String a(e e2) {
                    float f2 = e2.l() * 100.0f;
                    if (!Float.isNaN(f2)) {
                        return CardiacStatTableModel.a().format(f2);
                    }
                    return null;
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((e)object);
                }
            }),
            b("CARDIAC_EDV", OverlayStatistician.StatUnitCategory.f, null, new Function<e, String>(){

                public String a(e e2) {
                    float f2 = e2.n();
                    if (!Float.isNaN(f2)) {
                        return CardiacStatTableModel.a().format(f2);
                    }
                    return null;
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((e)object);
                }
            }),
            c("CARDIAC_ESV", OverlayStatistician.StatUnitCategory.f, null, new Function<e, String>(){

                public String a(e e2) {
                    float f2 = e2.m();
                    if (!Float.isNaN(f2)) {
                        return CardiacStatTableModel.a().format(f2);
                    }
                    return null;
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((e)object);
                }
            }),
            d("CARDIAC_SV", OverlayStatistician.StatUnitCategory.f, null, new Function<e, String>(){

                public String a(e e2) {
                    float f2 = e2.j();
                    if (!Float.isNaN(f2)) {
                        return CardiacStatTableModel.a().format(f2);
                    }
                    return null;
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((e)object);
                }
            }),
            e("CARDIAC_HEART_RATE", null, Messages.a("viewer", "BEATS_PER_MINUTE"), new Function<e, String>(){

                public String a(e e2) {
                    float f2 = e2.i();
                    if (!Float.isNaN(f2)) {
                        return CardiacStatTableModel.a().format(f2);
                    }
                    return null;
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((e)object);
                }
            }),
            f("CARDIAC_WALL_MASS", OverlayStatistician.StatUnitCategory.f, null, new Function<e, String>(){

                public String a(e e2) {
                    float f2 = e2.d();
                    if (!Float.isNaN(f2)) {
                        return CardiacStatTableModel.a().format(f2);
                    }
                    return null;
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((e)object);
                }
            }),
            g("CARDIAC_OUTPUT", null, "L/min", new Function<e, String>(){

                public String a(e e2) {
                    float f2 = e2.c();
                    if (!Float.isNaN(f2)) {
                        return CardiacStatTableModel.a().format(f2);
                    }
                    return null;
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((e)object);
                }
            }),
            h("CARDIAC_TID", null, null, new Function<e, String>(){

                public String a(e e2) {
                    float f2 = e2.k();
                    if (!Float.isNaN(f2)) {
                        return CardiacStatTableModel.a().format(f2);
                    }
                    return null;
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((e)object);
                }
            }),
            i("CARDIAC_EPI_VOL", OverlayStatistician.StatUnitCategory.f, null, new Function<e, String>(){

                public String a(e e2) {
                    float f2 = e2.o();
                    if (!Float.isNaN(f2)) {
                        return CardiacStatTableModel.a().format(f2);
                    }
                    return null;
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((e)object);
                }
            }),
            j("CARDIAC_ENDO_VOL", OverlayStatistician.StatUnitCategory.f, null, new Function<e, String>(){

                public String a(e e2) {
                    float f2 = e2.p();
                    if (!Float.isNaN(f2)) {
                        return CardiacStatTableModel.a().format(f2);
                    }
                    return null;
                }

                public /* synthetic */ Object apply(Object object) {
                    return this.a((e)object);
                }
            });

            private final String extKey;
            private final Function<e, String> valueFunction;
            private final OverlayStatistician.StatUnitCategory unit;
            private final String unitStringOverride;

            private CardiacStat(String string2, OverlayStatistician.StatUnitCategory statUnitCategory, String string3, Function<e, String> function) {
                this.extKey = string2;
                this.valueFunction = function;
                this.unit = statUnitCategory;
                this.unitStringOverride = string3;
            }

            @Override
            public String getExternalizedString() {
                return Messages.a("General", this.extKey);
            }

            String a(e e2) {
                String string = (String)this.valueFunction.apply((Object)e2);
                if (string != null) {
                    return string;
                }
                return CardiacStatTableModel.c();
            }

            String a() {
                if (this.unit != null) {
                    return this.unit.b();
                }
                if (this.unitStringOverride != null) {
                    return this.unitStringOverride;
                }
                return "";
            }
        }
    }
}

