/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac;

import com.google.common.collect.Maps;
import com.mimvista.cardiac.CardiacNormalization;
import com.mimvista.cardiac.CardiacNormaliztionType;
import com.mimvista.cardiac.CylindricalSampling;
import com.mimvista.cardiac.DataModel;
import com.mimvista.cardiac.PolarPoint;
import com.mimvista.cardiac.SampledPolarTransformModel;
import com.mimvista.cardiac.gui.CardiacSegments;
import com.mimvista.cardiac.gui.b;
import com.mimvista.d;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.DynamicVolumeRef3D;
import com.mimvista.internals.SimpleContour;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.linking.WarpTransform;
import com.mimvista.internals.statistics.ContourStatistician;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.OverlayishBase;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.mui.overlays.f;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.MultipliedIndexPoint3i;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.Pair;
import com.mimvista.util.work.m;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;

public class CardiacPolarTransform
extends SampledPolarTransformModel {
    private static final long serialVersionUID = 1L;
    private static boolean b = true;
    private static final int d = 72;
    private static final int e = 15;
    private static final int f = 15;
    private static final int g = 1;
    protected DynamicVolumeRef3D cardiacVcRef = null;
    protected transient WarpTransform a = null;
    VolumetricContourOverlayish epi;
    VolumetricContourOverlayish endo;
    VoxelPoint3f epiCenter;
    Contour basal;
    Contour mid;
    Contour apical;
    Contour apex;
    private Map<PolarPoint, VoxelPoint3f> maxVoxelInSample;
    private Map<PolarPoint, Contour> segmentContours;

    public static CardiacPolarTransform a(ViewController3D viewController3D, CardiacNormaliztionType cardiacNormaliztionType, List<CardiacNormalization> list) {
        return new CardiacPolarTransform(viewController3D, null, null, cardiacNormaliztionType, list);
    }

    public static CardiacPolarTransform a(ViewController3D viewController3D, ViewController3D viewController3D2, WarpTransform warpTransform, CardiacNormaliztionType cardiacNormaliztionType, List<CardiacNormalization> list) {
        return new CardiacPolarTransform(viewController3D, viewController3D2, warpTransform, cardiacNormaliztionType, list);
    }

    public CardiacPolarTransform(CardiacPolarTransform cardiacPolarTransform, DataModel dataModel) {
        this(cardiacPolarTransform);
        this.a((SampledPolarTransformModel.Sample sample) -> Float.valueOf(dataModel.a(sample.point)));
    }

    CardiacPolarTransform(CardiacPolarTransform cardiacPolarTransform) {
        super(cardiacPolarTransform);
        this.maxVoxelInSample = Maps.newHashMap(cardiacPolarTransform.maxVoxelInSample);
        this.segmentContours = Maps.newHashMap(cardiacPolarTransform.segmentContours);
        this.cardiacVcRef = cardiacPolarTransform.cardiacVcRef;
        this.a = cardiacPolarTransform.a;
        this.epi = cardiacPolarTransform.epi;
        this.endo = cardiacPolarTransform.endo;
        this.epiCenter = cardiacPolarTransform.epiCenter;
        this.basal = cardiacPolarTransform.basal;
        this.mid = cardiacPolarTransform.mid;
        this.apical = cardiacPolarTransform.apical;
        this.apex = cardiacPolarTransform.apex;
        for (CardiacNormalization cardiacNormalization : cardiacPolarTransform.normalizationOptions.values()) {
            this.a(cardiacNormalization);
        }
    }

    @Deprecated
    public CardiacPolarTransform(DataModel dataModel) {
        super(dataModel);
        this.maxVoxelInSample = Maps.newHashMap();
        this.segmentContours = Maps.newHashMap();
        this.normalizationOptions = Maps.newHashMap();
    }

    private CardiacPolarTransform(ViewController3D viewController3D, @d ViewController3D viewController3D2, @d WarpTransform warpTransform, CardiacNormaliztionType cardiacNormaliztionType, List<CardiacNormalization> list) {
        this(list, cardiacNormaliztionType);
        this.cardiacVcRef = DynamicVolumeRef3D.a(viewController3D);
        this.a = viewController3D2 == null ? null : warpTransform;
        Map<PolarPoint, Float> map = this.a(viewController3D2 == null ? viewController3D : viewController3D2);
        this.f().a(map);
    }

    protected CardiacPolarTransform(List<CardiacNormalization> list, CardiacNormaliztionType cardiacNormaliztionType) {
        this();
        for (CardiacNormalization cardiacNormalization : list) {
            this.a(cardiacNormalization);
        }
        this.a(cardiacNormaliztionType);
    }

    private CardiacPolarTransform() {
        super(new DataModel(CylindricalSampling.a));
        this.maxVoxelInSample = Maps.newHashMap();
        this.segmentContours = Maps.newHashMap();
        this.normalizationOptions = Maps.newHashMap();
    }

    private Map<PolarPoint, Float> a(final ViewController3D viewController3D) {
        this.c(viewController3D);
        final float f3 = this.b(viewController3D);
        Pair<MultipliedIndexPoint3i, MultipliedIndexPoint3i> pair = this.epi.aq().B();
        final int n2 = ((MultipliedIndexPoint3i)((Object)pair.x)).z;
        final int n3 = ((MultipliedIndexPoint3i)((Object)pair.y)).z;
        RescaleConverter rescaleConverter = viewController3D.cw().I().rescale;
        final float f4 = rescaleConverter.removeRaw(0.0f);
        final boolean bl2 = viewController3D != this.a() && this.a != null;
        final LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (PolarPoint object : this.f().d()) {
            if (b) {
                this.segmentContours.put(object, new Contour(this.a().cw()));
            }
            linkedHashMap.put(object, Float.valueOf(Float.NEGATIVE_INFINITY));
        }
        FuncUtils.a(m.c, n3 - n2 + 1, 1, new FuncUtils.e(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void f(int n22, int n32, int n4) {
                for (int i2 = n22 + n2; i2 < n32 + n2; ++i2) {
                    for (int i3 = 0; i3 < 360; ++i3) {
                        PolarPoint polarPoint = new PolarPoint((1.0 * (double)n3 - (double)i2) / (double)(n3 - n2), Math.toRadians(i3));
                        PolarPoint polarPoint2 = CardiacPolarTransform.this.f().b().b(polarPoint);
                        float f2 = ((Float)linkedHashMap.get(polarPoint2)).floatValue();
                        VoxelPoint3f voxelPoint3f = (VoxelPoint3f)((Object)CardiacPolarTransform.this.maxVoxelInSample.get(polarPoint2));
                        float f32 = 0.0f;
                        VoxelPoint3f voxelPoint3f2 = new VoxelPoint3f(CardiacPolarTransform.this.epiCenter);
                        MultipliedIndexPoint3i multipliedIndexPoint3i = voxelPoint3f2.c().a(CardiacPolarTransform.this.epi.aq().v());
                        multipliedIndexPoint3i.z = i2;
                        voxelPoint3f2.z = multipliedIndexPoint3i.c().j().z;
                        boolean bl22 = false;
                        while (CardiacPolarTransform.this.epi.aq().a((Point3i)multipliedIndexPoint3i) || !bl22) {
                            boolean bl3;
                            boolean bl4 = bl3 = !CardiacPolarTransform.this.epi.aq().a((Point3i)multipliedIndexPoint3i);
                            if (bl3) {
                                voxelPoint3f2.a(0, (float)((double)CardiacPolarTransform.this.epiCenter.x + (double)(f32 -= f3 / 2.0f) * Math.cos(polarPoint.theta)));
                                voxelPoint3f2.a(1, (float)((double)CardiacPolarTransform.this.epiCenter.y - (double)f32 * Math.sin(polarPoint.theta)));
                                multipliedIndexPoint3i = voxelPoint3f2.c().a(CardiacPolarTransform.this.epi.aq().v());
                                multipliedIndexPoint3i.z = i2;
                            }
                            if (!CardiacPolarTransform.this.endo.aq().a((Point3i)multipliedIndexPoint3i) || bl3) {
                                float f42;
                                bl22 = true;
                                if (b) {
                                    if (bl2) {
                                        MetricPoint3f metricPoint3f = new MetricPoint3f((Tuple3f)CardiacPolarTransform.this.a.a(multipliedIndexPoint3i.c().d()), (SimpleImageFrame)CardiacPolarTransform.this.a().cw());
                                        ((Contour)CardiacPolarTransform.this.segmentContours.get(polarPoint2)).a(metricPoint3f.c().a(((Contour)CardiacPolarTransform.this.segmentContours.get(polarPoint2)).v()));
                                    } else {
                                        ((Contour)CardiacPolarTransform.this.segmentContours.get(polarPoint2)).a(multipliedIndexPoint3i);
                                    }
                                }
                                if ((f42 = viewController3D.cw().a(voxelPoint3f2.x, voxelPoint3f2.y, voxelPoint3f2.z)) > f2 && f42 > ((Float)linkedHashMap.get(polarPoint2)).floatValue()) {
                                    f2 = f42;
                                    VoxelPoint3f voxelPoint3f3 = new VoxelPoint3f(voxelPoint3f2);
                                    if (bl2) {
                                        MetricPoint3f metricPoint3f = new MetricPoint3f((Tuple3f)CardiacPolarTransform.this.a.a(voxelPoint3f3.b()), (SimpleImageFrame)CardiacPolarTransform.this.a().cw());
                                        voxelPoint3f3 = metricPoint3f.b();
                                    }
                                    voxelPoint3f = voxelPoint3f3;
                                }
                            }
                            voxelPoint3f2.a(0, (float)((double)CardiacPolarTransform.this.epiCenter.x + (double)(f32 += f3) * Math.cos(polarPoint.theta)));
                            voxelPoint3f2.a(1, (float)((double)CardiacPolarTransform.this.epiCenter.y - (double)f32 * Math.sin(polarPoint.theta)));
                            multipliedIndexPoint3i = voxelPoint3f2.c().a(CardiacPolarTransform.this.epi.aq().v());
                            multipliedIndexPoint3i.z = i2;
                        }
                        if (Float.isInfinite(f2)) {
                            f2 = f4;
                        }
                        Map map = linkedHashMap;
                        synchronized (map) {
                            if (f2 > ((Float)linkedHashMap.get(polarPoint2)).floatValue()) {
                                linkedHashMap.put(polarPoint2, Float.valueOf(f2));
                                CardiacPolarTransform.this.maxVoxelInSample.put(polarPoint2, voxelPoint3f);
                            }
                            continue;
                        }
                    }
                }
            }
        }, "Sampling");
        CardiacNormalization cardiacNormalization = this.h();
        linkedHashMap.replaceAll((polarPoint, f2) -> Float.valueOf(cardiacNormalization.a(rescaleConverter.apply(f2.floatValue()))));
        if (b) {
            for (PolarPoint polarPoint2 : this.segmentContours.keySet()) {
                if (polarPoint2.theta != 0.0) continue;
                VolumetricContourOverlay volumetricContourOverlay = viewController3D.ba().g(false);
                volumetricContourOverlay.aq().d((SimpleContour)this.segmentContours.get(polarPoint2));
                volumetricContourOverlay.c(polarPoint2.toString());
            }
        }
        return linkedHashMap;
    }

    private float b(ViewController3D viewController3D) {
        float[] fArray = viewController3D.ao_();
        int[] nArray = viewController3D.cw().C();
        float[] fArray2 = MathUtils.b(fArray, nArray);
        float f2 = Math.min(fArray2[0], fArray2[1]);
        float f3 = f2 / 2.0f;
        return f3 / Math.min(fArray[0], fArray[1]);
    }

    public VolumetricContourOverlay a(b b2) {
        this.c(this.a());
        Contour contour = this.e(b2);
        ViewController3D viewController3D = this.cardiacVcRef.e();
        VolumetricContourOverlay volumetricContourOverlay = com.mimvista.mui.overlays.f.a((ViewController)viewController3D, contour);
        volumetricContourOverlay.c(b2.d().toString());
        viewController3D.ba().a((Overlayish)volumetricContourOverlay, true);
        viewController3D.bD();
        viewController3D.g().Q();
        volumetricContourOverlay.aZ();
        return volumetricContourOverlay;
    }

    private Contour e(b b2) {
        CardiacSegments.CardiacSegmentType cardiacSegmentType = b2.d().b();
        Contour contour = cardiacSegmentType == CardiacSegments.CardiacSegmentType.a ? this.basal : (cardiacSegmentType == CardiacSegments.CardiacSegmentType.b ? this.mid : (cardiacSegmentType == CardiacSegments.CardiacSegmentType.c ? this.apical : this.apex));
        double d2 = (Double)b2.b().x;
        double d3 = (Double)b2.b().y;
        if (d3 < d2) {
            d3 += Math.PI * 2;
        }
        Contour contour2 = this.a(contour, this.epiCenter, d2, d3);
        return contour2;
    }

    private Contour a(Contour contour, VoxelPoint3f voxelPoint3f, double d2, double d3) {
        Contour contour2 = new Contour(contour);
        VoxelPoint3f voxelPoint3f2 = new VoxelPoint3f(voxelPoint3f);
        voxelPoint3f2.a((Tuple3f)new Point3f(contour.v()[0], contour.v()[1], contour.v()[2]));
        short s2 = (short)Math.round(voxelPoint3f2.x);
        short s3 = (short)Math.round(voxelPoint3f2.y);
        MultipliedIndexPoint3i multipliedIndexPoint3i = contour.C().a(contour.v());
        MultipliedIndexPoint3i multipliedIndexPoint3i2 = contour.D().a(contour.v());
        for (int i2 = multipliedIndexPoint3i.z; i2 <= multipliedIndexPoint3i2.z; ++i2) {
            ContourSlice contourSlice = contour2.c(i2);
            for (short s4 = (short)multipliedIndexPoint3i.y; s4 <= multipliedIndexPoint3i2.y; s4 = (short)(s4 + 1)) {
                ContourSlice.ScanLine scanLine = contourSlice.c(s4);
                for (int i3 = multipliedIndexPoint3i.x; i3 <= multipliedIndexPoint3i2.x; ++i3) {
                    double d4 = Math.atan2(s3 - s4, i3 - s2);
                    if (!(d4 <= d2) && !(d4 > d3) || !scanLine.a(i3)) continue;
                    if (d3 > Math.PI) {
                        if (!(d4 <= d2 - Math.PI * 2) && !(d4 > d3 - Math.PI * 2)) continue;
                        scanLine.f(i3, i3 + 1);
                        continue;
                    }
                    scanLine.f(i3, i3 + 1);
                }
            }
        }
        return contour2;
    }

    private void c(ViewController3D viewController3D) {
        List<AbstractContourOverlayish> list = viewController3D.ba().a(OverlayishBase.InterpretedType.z, true);
        List<AbstractContourOverlayish> list2 = viewController3D.ba().a(OverlayishBase.InterpretedType.y, true);
        if (!viewController3D.e() || list.isEmpty() || list2.isEmpty()) {
            throw new IllegalArgumentException("Must run trasform on cardiac volume with endo and epi contours defined");
        }
        this.epi = (VolumetricContourOverlayish)list.get(0);
        this.endo = (VolumetricContourOverlayish)list2.get(0);
        this.epiCenter = this.a(this.epi);
        Contour contour = new Contour(this.epi.aq());
        contour.e((SimpleContour)this.endo.aq());
        int n2 = contour.C().a((int[])contour.v()).z - 1;
        int n3 = this.endo.aq().D().a((int[])contour.v()).z;
        int n4 = this.endo.aq().D().a((int[])contour.v()).z;
        int n5 = contour.D().a((int[])contour.v()).z + 1;
        this.basal = new Contour(contour.a());
        this.mid = new Contour(contour.a());
        this.apical = new Contour(contour.a());
        this.apex = new Contour(contour.a());
        int n6 = Math.round((float)(n3 - n2) / 3.0f);
        for (int i2 = n2; i2 < n5; ++i2) {
            ContourSlice contourSlice = contour.d(i2);
            if (i2 > n4) {
                this.apex.d(contourSlice);
                continue;
            }
            if (i2 > n2 + n6 * 2) {
                this.apical.d(contourSlice);
                continue;
            }
            if (i2 > n2 + n6 * 1) {
                this.mid.d(contourSlice);
                continue;
            }
            if (i2 <= n2 + n6 * 0) continue;
            this.basal.d(contourSlice);
        }
    }

    private VoxelPoint3f a(VolumetricContourOverlayish volumetricContourOverlayish) {
        ContourStatistician contourStatistician = volumetricContourOverlayish.bF_();
        if (!contourStatistician.h()) {
            contourStatistician.b(false);
            while (contourStatistician.G()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return contourStatistician.m().b();
    }

    public VoxelPoint3f a(PolarPoint polarPoint) {
        return this.maxVoxelInSample.get(this.f().b().b(polarPoint));
    }

    public Contour b(PolarPoint polarPoint) {
        return this.segmentContours.get(this.f().b().b(polarPoint));
    }

    public ViewController3D a() {
        return this.cardiacVcRef.e();
    }

    public static CardiacPolarTransform b() {
        return new EmptyTransform();
    }

    private static class EmptyTransform
    extends CardiacPolarTransform {
        private static final long serialVersionUID = 1L;

        private EmptyTransform() {
        }

        @Override
        public float c(PolarPoint polarPoint) {
            return 1.0f;
        }

        @Override
        public VolumetricContourOverlay a(b b2) {
            return null;
        }

        @Override
        public VoxelPoint3f a(PolarPoint polarPoint) {
            return null;
        }

        @Override
        CardiacNormaliztionType d() {
            return super.d();
        }
    }
}

