/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.cardiac.CardiacAnalysisController;
import com.mimvista.cardiac.CardiacGraphPanel;
import com.mimvista.cardiac.CardiacMistress;
import com.mimvista.cardiac.CardiacNormaliztionType;
import com.mimvista.cardiac.SerializedCardiacStudyList;
import com.mimvista.cardiac.ViewControllerListable;
import com.mimvista.commands.workflow.PropagateCardiacROICommand;
import com.mimvista.dicom.devices.dump.gui.TableColumnAdjuster;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.JCheckboxList;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.gui.util.l;
import com.mimvista.internals.Contour;
import com.mimvista.internals.DynamicSeriesManager;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ViewStateFlag;
import com.mimvista.internals.p;
import com.mimvista.license.j;
import com.mimvista.license.q;
import com.mimvista.mui.Session;
import com.mimvista.mui.UnselectableListSelectionModel;
import com.mimvista.mui.bi;
import com.mimvista.mui.bm;
import com.mimvista.mui.bu;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.ChrontourOverlay;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.OverlayColorPool;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.OverlayishBase;
import com.mimvista.mui.toolbar.SidePanel;
import com.mimvista.neuro.ComparisonSetFactory;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.swing.DelayedActionRunner;
import com.mimvista.swing.DropdownBox;
import com.mimvista.swing.c;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.o;
import com.mimvista.util.work.m;
import com.mimvista.viewer.f;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class CardiacSidebar
extends SidePanel {
    private static final long serialVersionUID = 1L;
    public static Messages a = Messages.a("General");
    private static final int b = 300;
    private static final float c = 0.05f;
    private static final Color d = new Color(216, 16, 16, 150);
    private static final int e = 19;
    private static final int f = 26;
    private static final Dimension g = new Dimension(160, 26);
    private DelayedActionRunner rebuildDelayer;
    private DelayedActionRunner repaintDelayer;
    private p cardiacPlayListener;
    private boolean gatedCardiacInSession;
    private boolean cardiacInSession;
    private JButton segmentButton;
    private AbstractButton showHide;
    private JButton analysisButton;
    private JButton gatedButton;
    private SwingCardiacStudyList cardiacList;
    private DropdownBox graphDropdown;
    private CardiacGraphPanel graph;
    private JTable cardiacStatTable;
    private TableColumnAdjuster cardiacStatAdjuster;
    private JLabel cardiacName;
    private JPanel cardiacInfoPane;
    private JButton playPause;
    private boolean clickStartsPlay = true;
    private ViewController selectedStudy;
    final OverlayCollection.a overlaysListener;

    public static j<CardiacSidebar> a() {
        return new j<CardiacSidebar>(){

            @Override
            @q(b="Cardiac Sidebar", a={LicenseOption.CARDIAC})
            public CardiacSidebar call() {
                return new CardiacSidebar();
            }
        };
    }

    public CardiacSidebar() {
        this.setName(a.getProperty("CARDIAC_TITLE"));
        Dimension dimension = new Dimension(300, 300);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.setLayout(new GridLayout(0, 1, 0, 0));
        CardiacMistress.registerSidebarAsMinion(this);
        this.rebuildDelayer = new DelayedActionRunner(150, new Runnable(){

            @Override
            public void run() {
                CardiacMistress cardiacMistress = bm.b().a(CardiacMistress.class);
                CardiacSidebar.this.gatedCardiacInSession = cardiacMistress.sessionContainsMultiframeCardiacVC();
                CardiacSidebar.this.cardiacInSession = cardiacMistress.sessionContainsCardiac();
                CardiacSidebar.this.j();
            }
        });
        this.repaintDelayer = new DelayedActionRunner(100, new Runnable(){

            @Override
            public void run() {
                if (CardiacSidebar.this.graph != null) {
                    CardiacSidebar.this.graph.a();
                    CardiacSidebar.this.graph.repaint();
                }
                if (CardiacSidebar.this.cardiacStatTable == null) {
                    CardiacSidebar.this.j();
                } else {
                    CardiacSidebar.this.l();
                }
                CardiacSidebar.this.revalidate();
                CardiacSidebar.this.repaint();
            }
        });
        this.rebuildDelayer.b();
        this.cardiacPlayListener = new p(){

            @Override
            public void playStopped() {
                CardiacMistress cardiacMistress = bm.b().a(CardiacMistress.class);
                if (cardiacMistress.sessionContainsCardiac()) {
                    CardiacSidebar.this.h();
                }
            }

            @Override
            public void playStarted() {
                CardiacMistress cardiacMistress = bm.b().a(CardiacMistress.class);
                if (cardiacMistress.sessionContainsCardiac()) {
                    CardiacSidebar.this.i();
                }
            }
        };
        this.overlaysListener = new OverlayCollection.a(){

            @Override
            public void overlayRemoved(Overlayish overlayish) {
                if (this.a(overlayish)) {
                    this.b(overlayish);
                }
            }

            @Override
            public void overlayAdded(Overlayish overlayish) {
                if (this.a(overlayish)) {
                    this.c(overlayish);
                }
            }

            private boolean a(Overlayish overlayish) {
                if (overlayish instanceof AbstractContourOverlayish) {
                    AbstractContourOverlayish abstractContourOverlayish = (AbstractContourOverlayish)overlayish;
                    return abstractContourOverlayish.z() == OverlayishBase.InterpretedType.y || abstractContourOverlayish.z() == OverlayishBase.InterpretedType.z;
                }
                return false;
            }

            private void b(Overlayish overlayish) {
                CardiacMistress.getCardiacMistressForSession(overlayish.au().g()).demandRecalculate(overlayish.au());
            }

            private void c(Overlayish overlayish) {
                CardiacMistress.getCardiacMistressForSession(overlayish.au().g()).demandRecalculate(overlayish.au());
            }
        };
        final bu bu2 = new bu(){

            @Override
            public void viewStateAddedToSession(ViewController viewController) {
                CardiacSidebar.this.b(viewController, true);
                CardiacSidebar.this.b();
            }

            @Override
            public void viewStateRemovedFromSession(ViewController viewController) {
                CardiacSidebar.this.b(viewController, false);
                CardiacSidebar.this.b();
            }

            @Override
            public void viewStateFlagChanged(ViewController viewController, ViewStateFlag viewStateFlag, boolean bl2) {
                if (viewStateFlag == ViewStateFlag.a) {
                    CardiacSidebar.this.b(viewController, bl2);
                }
                CardiacSidebar.this.b();
            }
        };
        bm.b().a(bu2);
        bm.a(new bi(){

            @Override
            public void activeSessionChanged(Session session, Session session2) {
                session2.b(bu2);
                session.a(bu2);
                CardiacSidebar.this.repaint();
            }
        });
    }

    @Override
    public Color getPanelColor() {
        return d;
    }

    public void b() {
        CardiacMistress cardiacMistress = bm.b().a(CardiacMistress.class);
        this.segmentButton.setEnabled(!cardiacMistress.potentialCardiacVolumes().isEmpty());
        this.showHide.setEnabled(this.segmentButton.isEnabled());
        if (this.gatedButton != null) {
            this.gatedButton.setEnabled(!cardiacMistress.potentialGatedVolumes().isEmpty());
        }
        this.analysisButton.setEnabled(CardiacMistress.shouldAllowCardiacAnalysis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(ViewController viewController, boolean bl2) {
        SerializedCardiacStudyList serializedCardiacStudyList;
        ViewControllerListable viewControllerListable = new ViewControllerListable(viewController);
        SerializedCardiacStudyList serializedCardiacStudyList2 = serializedCardiacStudyList = viewController.g().a(SerializedCardiacStudyList.class);
        synchronized (serializedCardiacStudyList2) {
            HashMap<ViewControllerListable, Boolean> hashMap = serializedCardiacStudyList.getListStateCopy();
            hashMap.put(viewControllerListable, bl2);
            serializedCardiacStudyList.setListState(hashMap);
        }
        this.cardiacList.a(viewControllerListable, bl2);
    }

    private void j() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CardiacSidebar.this.k();
            }
        });
        m.e.submit(new Runnable(){

            @Override
            public void run() {
                ComparisonSetFactory.a().b(ComparisonSetFactory.ComparisonSetType.b);
            }
        });
    }

    private void k() {
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        StatScrollerPanel statScrollerPanel = new StatScrollerPanel();
        statScrollerPanel.setMaximumSize(new Dimension(300, Integer.MAX_VALUE));
        statScrollerPanel.setMinimumSize(new Dimension(300, 0));
        statScrollerPanel.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(statScrollerPanel);
        jScrollPane.setMaximumSize(new Dimension(300, Integer.MAX_VALUE));
        jScrollPane.setMinimumSize(new Dimension(300, 0));
        jScrollPane.setViewportBorder(null);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        statScrollerPanel.add((Component)this.m(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        if (this.gatedCardiacInSession) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 1.0;
            statScrollerPanel.add((Component)this.p(), gridBagConstraints);
        } else {
            this.playPause = null;
        }
        if (this.cardiacInSession) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 1;
            statScrollerPanel.add((Component)this.q(), gridBagConstraints);
            if (this.gatedCardiacInSession) {
                this.graphDropdown.setVisible(true);
                this.graph.setVisible(true);
            } else {
                this.graphDropdown.setVisible(false);
                this.graph.setVisible(false);
            }
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            statScrollerPanel.add((Component)this.r(), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.weighty = 1.0;
            statScrollerPanel.add((Component)this.s(), gridBagConstraints);
        } else {
            this.graph = null;
            this.graphDropdown = null;
            this.cardiacName = null;
            this.cardiacList = null;
            this.cardiacStatTable = null;
            this.cardiacStatAdjuster = null;
            this.cardiacInfoPane = null;
        }
        JPanel jPanel = new JPanel();
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        statScrollerPanel.add((Component)jPanel, gridBagConstraints);
        this.revalidate();
        this.repaint();
    }

    public void c() {
        this.rebuildDelayer.b();
    }

    public void d() {
        this.repaintDelayer.b();
    }

    private void e(ViewController viewController) {
        CardiacMistress cardiacMistress = viewController.g().a(CardiacMistress.class);
        if (this.cardiacList == null || this.graph == null || this.gatedCardiacInSession != cardiacMistress.sessionContainsMultiframeCardiacVC()) {
            this.rebuildDelayer.b();
        } else {
            this.graph.a(viewController);
            if (viewController.e() && !viewController.U()) {
                this.cardiacList.a(new ViewControllerListable(viewController), this.graph.c(viewController), true);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void a(ViewController viewController) {
        CardiacMistress cardiacMistress = viewController.g().a(CardiacMistress.class);
        if (this.cardiacList == null || this.graph == null || this.gatedCardiacInSession != cardiacMistress.sessionContainsMultiframeCardiacVC()) {
            this.rebuildDelayer.b();
        } else {
            this.graph.a(viewController);
        }
    }

    private void f(ViewController viewController) {
        CardiacMistress cardiacMistress;
        if (this.cardiacList != null) {
            this.cardiacList.d(new ViewControllerListable(viewController));
            if (this.graph != null) {
                this.graph.b(viewController);
            }
            this.revalidate();
            this.repaint();
        }
        if ((cardiacMistress = viewController.g().a(CardiacMistress.class)).cardiacVolumes().size() < 1 || this.gatedCardiacInSession != cardiacMistress.sessionContainsMultiframeCardiacVC()) {
            this.rebuildDelayer.b();
        }
    }

    private void b(ViewController viewController, boolean bl2) {
        OverlayCollection overlayCollection;
        if (this.cardiacList != null) {
            this.cardiacList.d();
            this.cardiacList.revalidate();
        }
        if ((overlayCollection = viewController.ba()) != null) {
            if (bl2) {
                overlayCollection.a(this.overlaysListener);
            } else {
                overlayCollection.c(this.overlaysListener);
            }
        }
        if (bl2) {
            if (viewController.e()) {
                this.e(viewController);
                if (viewController.bi() && viewController.bl()) {
                    viewController.bh().cE().a(this.cardiacPlayListener);
                }
            }
        } else {
            this.f(viewController);
            if (viewController.bi() && viewController.bl()) {
                viewController.bh().cE().b(this.cardiacPlayListener);
            }
        }
        this.l();
    }

    public void e() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CardiacSidebar.this.segmentButton.setEnabled(true);
            }
        });
    }

    public void f() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CardiacSidebar.this.gatedButton.setEnabled(true);
            }
        });
    }

    private void l() {
        ViewControllerListable viewControllerListable;
        ViewControllerListable viewControllerListable2 = viewControllerListable = this.cardiacList == null ? null : (ViewControllerListable)this.cardiacList.a();
        if (viewControllerListable != null) {
            this.a(viewControllerListable);
        }
    }

    private void a(final ViewControllerListable viewControllerListable) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                if (CardiacSidebar.this.cardiacStatTable != null) {
                    ViewController viewController = viewControllerListable.b();
                    if (viewController == null) {
                        return;
                    }
                    CardiacSidebar.this.g(viewController);
                    Color color = CardiacSidebar.d(viewController);
                    CardiacSidebar.this.cardiacName.setForeground(color);
                    CardiacSidebar.this.cardiacInfoPane.setBackground(MIMSwingUtils.a(color, 0.05f));
                }
            }
        });
    }

    private void g(ViewController viewController) {
        CardiacMistress cardiacMistress = bm.b().a(CardiacMistress.class);
        this.cardiacStatTable.setModel(cardiacMistress.getCurrentTableModelForVC(viewController));
        this.cardiacStatTable.setAutoResizeMode(0);
        this.cardiacStatAdjuster.adjustColumns(true, 0.1f);
        this.cardiacName.setText(cn.p(CardiacSidebar.c(viewController)));
    }

    private JPanel m() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Box box = Box.createHorizontalBox();
        this.segmentButton = new JButton();
        this.segmentButton.setIcon(ImageManipulator.c("cardiac_auto_roi", 19));
        this.segmentButton.setText(a.b("CARDIAC_AUTOROI"));
        this.segmentButton.setToolTipText(a.getProperty("CARDIAC_AUTOROI"));
        this.segmentButton.setMinimumSize(g);
        this.segmentButton.setPreferredSize(g);
        this.segmentButton.setMaximumSize(g);
        this.segmentButton.setHorizontalAlignment(10);
        this.segmentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CardiacMistress cardiacMistress = bm.b().a(CardiacMistress.class);
                cardiacMistress.chooseHeartAndSegment();
            }
        });
        this.showHide = this.u();
        box.add(this.segmentButton);
        box.add(Box.createRigidArea(new Dimension(10, 0)));
        box.add(this.showHide);
        jPanel.add(box);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel.add(this.n());
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel.add(this.o());
        this.b();
        return jPanel;
    }

    private JPanel n() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.analysisButton = new JButton();
        this.analysisButton.setIcon(ImageManipulator.c("cardiac_polar_plot", 19));
        this.analysisButton.setText(Messages.a("Cardiac", "BUTTON_ANALYSIS_TEXT"));
        this.analysisButton.setToolTipText(MIMFormat.a(Messages.a("Cardiac", "BUTTON_ANALYSIS_TIP"), this.analysisButton.getText()));
        this.analysisButton.setHorizontalAlignment(2);
        this.analysisButton.setMinimumSize(g);
        this.analysisButton.setPreferredSize(g);
        this.analysisButton.setMaximumSize(g);
        final LinkedList linkedList = Lists.newLinkedList();
        for (CardiacAnalysisController.CardiacSeriesType cardiacSeriesType : CardiacAnalysisController.CardiacSeriesType.values()) {
            if (CardiacAnalysisController.CardiacSeriesType.d.equals(cardiacSeriesType)) continue;
            linkedList.add(cardiacSeriesType);
        }
        final ArrayList arrayList = Lists.newArrayList();
        for (CardiacNormaliztionType cardiacNormaliztionType : CardiacNormaliztionType.values()) {
            arrayList.add(cardiacNormaliztionType);
        }
        arrayList.remove(CardiacNormaliztionType.a);
        Dimension dimension = new Dimension(26, 26);
        this.analysisButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!CardiacMistress.shouldAllowCardiacAnalysis()) {
                    CardiacSidebar.this.analysisButton.setEnabled(false);
                } else {
                    Notification.a a2 = new Notification.a(bm.b());
                    InputNotification inputNotification = new InputNotification(a2, Messages.a("Cardiac", "BUTTON_ANALYSIS_PARAMS"), "ui_settings");
                    final ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)3);
                    arrayList2.add(inputNotification.addCheckBox(((CardiacAnalysisController.CardiacSeriesType)linkedList.get(0)).getExternalizedString()).a((Boolean)true));
                    arrayList2.add(inputNotification.addCheckBox(((CardiacAnalysisController.CardiacSeriesType)linkedList.get(1)).getExternalizedString()).a((Boolean)true));
                    arrayList2.add(inputNotification.addCheckBox(((CardiacAnalysisController.CardiacSeriesType)linkedList.get(2)).getExternalizedString()).a((Boolean)false));
                    inputNotification.addSeparator();
                    String[] stringArray = new String[arrayList.size()];
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        stringArray[i2] = ((CardiacNormaliztionType)arrayList.get(i2)).getExternalizedString();
                    }
                    final l<Integer> l2 = inputNotification.addRadioButtons("", stringArray).a(1);
                    inputNotification.setIsDismissable(false);
                    inputNotification.setOkActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            final CardiacMistress cardiacMistress = CardiacMistress.getCardiacMistressForSession(bm.b());
                            final ArrayList arrayList = new ArrayList();
                            for (int i2 = 0; i2 < linkedList.size(); ++i2) {
                                if (!((Boolean)((l)arrayList2.get(i2)).b()).booleanValue()) continue;
                                arrayList.add(linkedList.get(i2));
                            }
                            final CardiacNormaliztionType cardiacNormaliztionType = (CardiacNormaliztionType)arrayList.get((Integer)l2.b());
                            m.e.a(new Runnable(){

                                @Override
                                public void run() {
                                    cardiacMistress.chooseSeriesAndAnalyze(arrayList, cardiacNormaliztionType);
                                    if (!CardiacMistress.shouldAllowCardiacAnalysis()) {
                                        CardiacSidebar.this.j();
                                    }
                                }
                            }, "");
                        }
                    });
                    inputNotification.addToGrandNotifier();
                }
            }
        });
        if (!CardiacMistress.shouldAllowCardiacAnalysis()) {
            this.analysisButton.setEnabled(false);
        }
        jPanel.add(this.analysisButton);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(Box.createRigidArea(dimension));
        return jPanel;
    }

    private JPanel o() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Box box = Box.createHorizontalBox();
        this.gatedButton = new JButton();
        this.gatedButton.setIcon(ImageManipulator.c("cardiac_gating", 19));
        this.gatedButton.setText(a.b("CARDIAC_GATEDINFO"));
        this.gatedButton.setToolTipText(a.getProperty("CARDIAC_GATEDINFO"));
        this.gatedButton.setMinimumSize(g);
        this.gatedButton.setPreferredSize(g);
        this.gatedButton.setMaximumSize(g);
        this.gatedButton.setHorizontalAlignment(10);
        this.gatedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CardiacMistress cardiacMistress = bm.b().a(CardiacMistress.class);
                cardiacMistress.chooseHeartAndDisplayGatedInfo();
            }
        });
        this.gatedButton.setEnabled(false);
        box.add(this.gatedButton);
        box.add(Box.createRigidArea(new Dimension(36, 0)));
        jPanel.add(box);
        return jPanel;
    }

    private JPanel p() {
        JPanel jPanel = new JPanel();
        DropdownBox dropdownBox = new DropdownBox(jPanel, a.getProperty("CARDIAC_FOUR_D"), DropdownBox.DropdownBoxStyle.b, false, null);
        dropdownBox.b(20);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JButton jButton = new JButton(ImageManipulator.c("rewind", 19));
        jButton.setToolTipText(Messages.a("mui", "DYNAMIC_CTRL_PREV"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Collection collection = CardiacSidebar.this.t();
                for (ViewController viewController : collection) {
                    if (!viewController.bl()) continue;
                    DynamicSeriesManager.prevFrame(viewController);
                }
            }
        });
        JButton jButton2 = new JButton(ImageManipulator.c("fast_forward", 19));
        jButton2.setToolTipText(Messages.a("mui", "DYNAMIC_CTRL_NEXT"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Collection collection = CardiacSidebar.this.t();
                for (ViewController viewController : collection) {
                    if (!viewController.bl()) continue;
                    DynamicSeriesManager.nextFrame(viewController);
                }
            }
        });
        this.playPause = new JButton();
        boolean bl2 = bm.b().a(DynamicSeriesManager.class).getNumberPlaying() > 0;
        this.a(!bl2);
        this.playPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Iterable<ViewController3D> iterable = bm.b().d(ViewController3D.class);
                if (CardiacSidebar.this.clickStartsPlay) {
                    CardiacSidebar.this.a(false);
                    for (ViewController3D viewController3D : iterable) {
                        if (!viewController3D.bl() || !viewController3D.e()) continue;
                        viewController3D.cE().a(CardiacSidebar.this.cardiacPlayListener);
                        viewController3D.g().a(DynamicSeriesManager.class).startPlaying(viewController3D);
                    }
                } else {
                    CardiacSidebar.this.a(true);
                    for (ViewController3D viewController3D : iterable) {
                        if (!viewController3D.bl() || !viewController3D.e()) continue;
                        viewController3D.cE().b(CardiacSidebar.this.cardiacPlayListener);
                    }
                    bm.b().a(DynamicSeriesManager.class).stopAll();
                }
            }
        });
        int n2 = 8;
        JButton jButton3 = new JButton(ImageManipulator.c("subtract_bronze", n2, n2));
        jButton3.setToolTipText(Messages.a("mui", "DYNAMIC_CTRL_DECR"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicSeriesManager.decreaseRate();
            }
        });
        JButton jButton4 = new JButton(ImageManipulator.c("add_bronze", n2, n2));
        jButton4.setToolTipText(Messages.a("mui", "DYNAMIC_CTRL_INCR"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DynamicSeriesManager.increaseRate();
            }
        });
        Dimension dimension = new Dimension(12, 12);
        jButton3.setMinimumSize(dimension);
        jButton3.setPreferredSize(dimension);
        jButton3.setMaximumSize(dimension);
        jButton4.setMinimumSize(dimension);
        jButton4.setPreferredSize(dimension);
        jButton4.setMaximumSize(dimension);
        Dimension dimension2 = new Dimension(30, 24);
        this.playPause.setMinimumSize(dimension2);
        this.playPause.setPreferredSize(dimension2);
        this.playPause.setMaximumSize(dimension2);
        jButton.setMinimumSize(dimension2);
        jButton.setPreferredSize(dimension2);
        jButton.setMaximumSize(dimension2);
        jButton2.setMinimumSize(dimension2);
        jButton2.setPreferredSize(dimension2);
        jButton2.setMaximumSize(dimension2);
        JButton jButton5 = new JButton(a.getProperty("CARDIAC_PROPAGATE_CONTOURS"));
        Dimension dimension3 = new Dimension(184, 24);
        jButton5.setPreferredSize(dimension3);
        jButton5.setMinimumSize(dimension3);
        jButton5.setMaximumSize(dimension3);
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Session session = bm.b();
                final CardiacMistress cardiacMistress = session.a(CardiacMistress.class);
                List<ViewController> list = cardiacMistress.cardiacVolumes();
                for (final ViewController viewController : list) {
                    if (!viewController.bl()) continue;
                    List<AbstractContourOverlayish> list2 = viewController.aw().n().R();
                    ChrontourOverlay chrontourOverlay = null;
                    for (AbstractContourOverlayish abstractContourOverlayish : list2) {
                        if (!abstractContourOverlayish.z().equals(OverlayishBase.InterpretedType.y)) continue;
                        chrontourOverlay = (ChrontourOverlay)abstractContourOverlayish;
                        break;
                    }
                    if (chrontourOverlay == null) continue;
                    final ArrayList arrayList = Lists.newArrayList();
                    for (int i2 = 0; i2 < chrontourOverlay.ap(); ++i2) {
                        Contour contour = chrontourOverlay.a((Integer)i2);
                        if (!contour.Q()) continue;
                        arrayList.add(i2);
                    }
                    if (arrayList.size() > 0) {
                        MIMSwingUtils.e(new Runnable(){

                            @Override
                            public void run() {
                                PropagateCardiacROICommand propagateCardiacROICommand = new PropagateCardiacROICommand(null, new o(), viewController, arrayList, true);
                                propagateCardiacROICommand.execute();
                                cardiacMistress.demandRecalculate(viewController);
                            }
                        });
                    }
                    CardiacSidebar.this.a(viewController, CardiacSidebar.this.graph.c(viewController));
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jButton4);
        jPanel2.add(jButton3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel.add((Component)jButton5, gridBagConstraints);
        Box box = Box.createHorizontalBox();
        Dimension dimension4 = new Dimension(5, 0);
        box.add(jButton);
        box.add(Box.createRigidArea(dimension4));
        box.add(this.playPause);
        box.add(Box.createRigidArea(dimension4));
        box.add(jButton2);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)box, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return dropdownBox;
    }

    private JPanel q() {
        CardiacMistress cardiacMistress = bm.b().a(CardiacMistress.class);
        this.graph = new CardiacGraphPanel(cardiacMistress);
        for (ViewController viewController : cardiacMistress.cardiacVolumes()) {
            try {
                if (!com.mimvista.viewer.f.d(viewController.getUncopiedMutableInfo())) continue;
                this.graph.a(viewController);
            }
            catch (Exception exception) {
                ay.d((Object)"Error building cardiac graph", exception);
            }
        }
        this.graph.setBorder(new EmptyBorder(10, 10, 10, 10));
        com.mimvista.swing.c.a((Component)this.graph, 296, 200);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.graph, "Center");
        this.graphDropdown = new DropdownBox(jPanel, Messages.a("Dicom", "HUED_EDITOR_GRAPH"), DropdownBox.DropdownBoxStyle.b, false, null);
        this.graphDropdown.b(20);
        return this.graphDropdown;
    }

    private JPanel r() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        DropdownBox dropdownBox = new DropdownBox(jPanel, a.getProperty("CARDIAC_STUDIES"), DropdownBox.DropdownBoxStyle.b, false, null);
        dropdownBox.b(20);
        this.cardiacList = new SwingCardiacStudyList();
        this.cardiacList.setOpaque(false);
        this.cardiacList.setFont(this.getFont().deriveFont(14.0f));
        this.cardiacList.a(30);
        Dimension dimension = new Dimension(274, 60);
        this.cardiacList.setMinimumSize(dimension);
        this.cardiacList.setPreferredSize(new Dimension(274, this.getPreferredSize().height));
        this.cardiacList.a(new JCheckboxList.b<ViewControllerListable>(){

            @Override
            public void a(ViewControllerListable viewControllerListable) {
                CardiacSidebar.this.a(viewControllerListable);
            }

            @Override
            public void b(ViewControllerListable viewControllerListable) {
                if (CardiacSidebar.this.graph != null) {
                    ViewController viewController = viewControllerListable.b();
                    CardiacSidebar.this.graph.a(viewController);
                }
            }

            @Override
            public void c(ViewControllerListable viewControllerListable) {
                if (CardiacSidebar.this.graph != null) {
                    ViewController viewController = viewControllerListable.b();
                    CardiacSidebar.this.graph.b(viewController);
                }
            }

            @Override
            public /* synthetic */ void b(com.mimvista.gui.util.p p2) {
                this.c((ViewControllerListable)p2);
            }

            @Override
            public /* synthetic */ void c(com.mimvista.gui.util.p p2) {
                this.b((ViewControllerListable)p2);
            }
        });
        CardiacMistress cardiacMistress = bm.b().a(CardiacMistress.class);
        List<ViewController> list = cardiacMistress.cardiacVolumes();
        ViewControllerListable viewControllerListable = null;
        Collection collection = this.cardiacList.j();
        for (ViewController object : list) {
            if (!object.e() || object.U()) continue;
            ViewControllerListable viewControllerListable2 = new ViewControllerListable(object);
            this.cardiacList.a(viewControllerListable2, false, true);
            if (this.selectedStudy == object) {
                viewControllerListable = viewControllerListable2;
            }
            if (!this.cardiacList.e(viewControllerListable2)) continue;
            this.graph.a(object);
        }
        this.cardiacList.a(bm.b());
        this.cardiacList.a(new JCheckboxList.a<ViewControllerListable>(){

            @Override
            public void a(ViewControllerListable viewControllerListable) {
                SerializedCardiacStudyList serializedCardiacStudyList = bm.b().a(SerializedCardiacStudyList.class);
                HashMap<ViewControllerListable, Boolean> hashMap = serializedCardiacStudyList.getListStateCopy();
                hashMap.clear();
                for (ViewControllerListable viewControllerListable2 : CardiacSidebar.this.cardiacList.i()) {
                    hashMap.put(viewControllerListable2, false);
                }
                for (ViewControllerListable viewControllerListable2 : CardiacSidebar.this.cardiacList.h()) {
                    hashMap.put(viewControllerListable2, true);
                }
                serializedCardiacStudyList.setListState(hashMap);
            }

            @Override
            public /* synthetic */ void d(com.mimvista.gui.util.p p2) {
                this.a((ViewControllerListable)p2);
            }
        });
        for (ViewControllerListable viewControllerListable3 : collection) {
            if (viewControllerListable3.b() != null) continue;
            this.cardiacList.d(viewControllerListable3);
        }
        if (viewControllerListable != null) {
            this.cardiacList.a(viewControllerListable);
        }
        jPanel.add((Component)this.cardiacList, "Center");
        return dropdownBox;
    }

    private JPanel s() {
        this.cardiacStatTable = new JTable();
        this.cardiacStatAdjuster = new TableColumnAdjuster(this.cardiacStatTable);
        this.cardiacStatTable.setSelectionModel(new UnselectableListSelectionModel());
        this.cardiacStatTable.setBackground(MIMLookAndFeel.getWindowBackground());
        this.cardiacStatTable.setGridColor(MIMLookAndFeel.E());
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(4);
        this.cardiacStatTable.setDefaultRenderer(Float.class, defaultTableCellRenderer);
        JTableHeader jTableHeader = this.cardiacStatTable.getTableHeader();
        jTableHeader.setResizingAllowed(false);
        jTableHeader.setReorderingAllowed(false);
        CardiacMistress cardiacMistress = bm.b().a(CardiacMistress.class);
        List<ViewController> list = cardiacMistress.cardiacVolumes();
        ViewController viewController = list.get(0);
        this.cardiacName = new JLabel();
        this.cardiacName.setForeground(CardiacSidebar.d(viewController));
        this.cardiacName.setHorizontalAlignment(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.cardiacName);
        jPanel.add(Box.createHorizontalGlue());
        this.cardiacInfoPane = new JPanel();
        this.cardiacInfoPane.setLayout(new BoxLayout(this.cardiacInfoPane, 1));
        this.cardiacInfoPane.setBorder(new CompoundBorder(MIMLookAndFeel.H(), new MatteBorder(new Insets(4, 4, 4, 4), MIMLookAndFeel.E())));
        this.cardiacInfoPane.add(this.cardiacStatTable);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel2.add(jPanel);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 10)));
        jPanel2.add(this.cardiacInfoPane);
        this.g(viewController);
        DropdownBox dropdownBox = new DropdownBox(jPanel2, a.getProperty("CARDIAC_STUDY_INFO"), DropdownBox.DropdownBoxStyle.b, false, null);
        dropdownBox.b(20);
        return dropdownBox;
    }

    private Collection<ViewController> t() {
        List<ViewController> list = bm.b().af();
        HashSet<ViewController> hashSet = new HashSet<ViewController>();
        for (ViewController viewController : list) {
            hashSet.add(viewController.aT());
        }
        return hashSet;
    }

    private AbstractButton u() {
        final JToggleButton jToggleButton = new JToggleButton(ImageManipulator.c("view_eyeopen", 19, 19));
        jToggleButton.setSelectedIcon(ImageManipulator.c("view_eyeclosed", 19, 19));
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean bl2 = jToggleButton.isSelected();
                        for (AbstractContourOverlayish abstractContourOverlayish : CardiacSidebar.this.v()) {
                            abstractContourOverlayish.m(bl2);
                            abstractContourOverlayish.aL().d((AbstractContourOverlayish)null);
                        }
                        bm.b().Q();
                    }
                });
            }
        });
        Dimension dimension = new Dimension(26, 26);
        jToggleButton.setMinimumSize(dimension);
        jToggleButton.setPreferredSize(dimension);
        jToggleButton.setMaximumSize(dimension);
        return jToggleButton;
    }

    private List<AbstractContourOverlayish> v() {
        ArrayList arrayList = Lists.newArrayList();
        CardiacMistress cardiacMistress = bm.b().a(CardiacMistress.class);
        List<ViewController> list = cardiacMistress.cardiacVolumes();
        for (ViewController viewController : list) {
            try {
                List<AbstractContourOverlayish> list2 = viewController.ba().R();
                for (AbstractContourOverlayish abstractContourOverlayish : list2) {
                    if (!abstractContourOverlayish.z().equals(OverlayishBase.InterpretedType.y) && !abstractContourOverlayish.z().equals(OverlayishBase.InterpretedType.z)) continue;
                    arrayList.add(abstractContourOverlayish.G());
                }
            }
            catch (Exception exception) {
            }
        }
        return arrayList;
    }

    @Override
    public String getConfigIdentifier() {
        return a.getProperty("CARDIAC_TITLE");
    }

    public ViewController g() {
        if (this.cardiacList == null) {
            return null;
        }
        ViewControllerListable viewControllerListable = (ViewControllerListable)this.cardiacList.a();
        if (viewControllerListable == null) {
            return null;
        }
        return viewControllerListable.b();
    }

    public void b(ViewController viewController) {
        this.selectedStudy = viewController;
    }

    private void a(boolean bl2) {
        this.clickStartsPlay = bl2;
        if (bl2) {
            this.playPause.setIcon(ImageManipulator.c("play", 19));
            this.playPause.setToolTipText(Messages.a("mui", "DYNAMIC_CTRL_PLAY"));
        } else {
            this.playPause.setIcon(ImageManipulator.c("pause", 19));
            this.playPause.setToolTipText(Messages.a("mui", "DYNAMIC_CTRL_PAUSE"));
        }
    }

    public void h() {
        if (bm.b().a(DynamicSeriesManager.class).getNumberPlaying() == 0) {
            this.a(true);
        }
    }

    public void i() {
        this.a(false);
    }

    static String c(ViewController viewController) {
        if (viewController == null) {
            return "";
        }
        String string = null;
        boolean bl2 = false;
        String string2 = null;
        boolean bl3 = false;
        String string3 = null;
        boolean bl4 = false;
        for (ViewController viewController2 : viewController.g().af()) {
            if (string == null) {
                string = viewController2.getUncopiedMutableInfo().patientName;
            } else if (!bl2 && !string.equalsIgnoreCase(viewController2.getUncopiedMutableInfo().patientName)) {
                bl2 = true;
            }
            if (string2 == null) {
                string2 = viewController2.getUncopiedMutableInfo().modality;
            } else if (!bl3 && !string2.equalsIgnoreCase(viewController2.getUncopiedMutableInfo().modality)) {
                bl3 = true;
            }
            if (string3 == null) {
                string3 = viewController2.getUncopiedMutableInfo().d();
            } else if (!bl4 && !string3.equalsIgnoreCase(viewController2.getUncopiedMutableInfo().d())) {
                bl4 = true;
            }
            if (!bl2 || !bl3 || !bl4) continue;
            break;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append(viewController.getUncopiedMutableInfo().patientName);
            stringBuilder.append(" - ");
        }
        if (bl3) {
            stringBuilder.append(viewController.getUncopiedMutableInfo().modality);
            stringBuilder.append(" - ");
        }
        if (bl4) {
            stringBuilder.append(viewController.getUncopiedMutableInfo().d());
            stringBuilder.append(" - ");
        }
        stringBuilder.append(viewController.getUncopiedMutableInfo().seriesDesc);
        return stringBuilder.toString();
    }

    protected static Color d(ViewController viewController) {
        long l2 = viewController.aT().aV();
        return OverlayColorPool.a((int)(l2 %= (long)OverlayColorPool.a()));
    }

    private static class StatScrollerPanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = 1L;

        private StatScrollerPanel() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(274, 300);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
            return 2;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
            return 2;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private static class SwingCardiacStudyList
    extends JCheckboxList<ViewControllerListable> {
        private static final long serialVersionUID = 1L;

        @Override
        void a(Session session) {
            final SerializedCardiacStudyList serializedCardiacStudyList = session.a(SerializedCardiacStudyList.class);
            final boolean[] blArray = new boolean[1];
            Predicate<ViewControllerListable> predicate = new Predicate<ViewControllerListable>(){
                HashMap<ViewControllerListable, Boolean> a;
                {
                    this.a = serializedCardiacStudyList.getListStateCopy();
                }

                public boolean a(ViewControllerListable viewControllerListable) {
                    boolean bl2 = false;
                    if (this.a.containsKey(viewControllerListable)) {
                        bl2 = this.a.get(viewControllerListable);
                    }
                    return bl2 ^= blArray[0];
                }

                public /* synthetic */ boolean apply(Object object) {
                    return this.a((ViewControllerListable)object);
                }
            };
            this.a(predicate);
            blArray[0] = true;
            this.b(predicate);
        }
    }
}

