/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.cardiac;

import com.google.common.collect.Lists;
import com.mimvista.cardiac.PolarPoint;
import com.mimvista.cardiac.UniformSampling;
import java.util.ArrayList;
import java.util.List;

public final class CylindricalSampling
extends UniformSampling {
    private static final long serialVersionUID = 1L;
    public static final CylindricalSampling a = new CylindricalSampling(9, 360);
    public static final CylindricalSampling b = new CylindricalSampling(30, 120);

    public CylindricalSampling() {
    }

    private CylindricalSampling(int n2, int n3) {
        this(n2, n3, 0.0f);
    }

    public CylindricalSampling(int n2, int n3, float f2) {
        super(n2, n3, f2, 1.0f);
    }

    @Override
    public List<PolarPoint> a() {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)(this.angularCount * this.radialCount));
        for (int i2 = 0; i2 < this.angularCount; ++i2) {
            for (int i3 = 0; i3 < this.radialCount; ++i3) {
                arrayList.add(new PolarPoint(this.rMin + this.radialSpacing * (float)i3, this.angularSpacing * (float)i2));
            }
        }
        return arrayList;
    }

    @Override
    double a(PolarPoint polarPoint) {
        int n2 = (int)Math.round(this.c(polarPoint));
        double d2 = this.radialSpacing / (this.rMax - this.rMin) / (float)this.angularCount;
        if (n2 == 0 || n2 == this.radialCount - 1) {
            d2 *= 0.5;
        }
        return d2;
    }

    @Override
    public double a(double d2, double d3) {
        return this.a(d2);
    }

    double a(double d2) {
        return (double)(this.rMax - this.rMin) * d2 + (double)this.rMin;
    }

    @Override
    public float b() {
        return 0.5f;
    }
}

